


   28 May 1995                                                      gforge(1)



   NAME
     gforge - fractal forgery of landscapes and textures

   SYNOPSIS
     gforge [-mesh size] [-dimension dim [-adim dim scale]] [-power factor]
              [-peak xpos ypos] [-seed seed] [-name filename] [-type
              TGA|PGM|PG8] [-version]

   DESCRIPTION
     gforge generates a landscape texture by ``random fractal forgery,''  the
     term  coined  by  Richard  F.  Voss of the IBM Thomas J. Watson Research
     Center for seemingly realistic pictures of natural objects generated  by
     simple algorithms embodying randomness and fractal self-similarity.  The
     techniques used by gforge are essentially those given by  Voss[1],  par-
     ticularly  the  technique of spectral synthesis explained in more detail
     by Dietmar Saupe[2]. The source code (and this man page) was almost  en-
     tirely  taken  from  the  "ppmforge" module[3] in the PBMPLUS package of
     graphics utilities.

     The generation of a landscape begins with the preparation of an array of
     random data in the frequency domain.  The size of this array, the ``mesh
     size,'' can be set with the -mesh option; the larger the mesh  the  more
     realistic  the  pictures but the calculation time and memory requirement
     increases as the square of the mesh size.  The fractal dimension,  which
     you  can specify with the -dimension option, determines the roughness of
     the resulting terrain. As the fractal dimension is increased, more  high
     frequency components are added into the random mesh.

     Once the mesh is generated, an inverse two dimensional Fourier transform
     is  performed  upon  it.   This  converts  the original random frequency
     domain data into spatial amplitudes.  We scale the real components  that
     result  from  the  Fourier transform into numbers from 0 to 1 associated
     with each point on the mesh.  You can further modify this number by  ap-
     plying  a ``power law scale'' to it with the -power option.  Unity scale
     leaves the numbers unmodified; a power scale of  0.5  takes  the  square
     root  of  the numbers in the mesh, while a power scale of 3 replaces the
     numbers in the  mesh  with  their  cubes.   Powers  less  than  1  yield
     landscapes with vertical scarps that look like glacially-carved valleys;
     powers greater than one make fairy-castle spires  (which  require  large
     mesh sizes and high resolution for best results).

     After these calculations, we have an array of the  specified  size  con-
     taining  numbers that range from 0 to 1. These are scaled to 0-65535 for
     output in the 16-bit TGA (a nonstandard 24-bit TGA) format that the Per-
     sistence of Vision raytracer (POV-Ray) uses as a heightfield format. Op-
     tionally output is is 16-bit PGM Ascii, or space-saving 8-bit PGM binary
     for previewing directly in a standard graphics viewer.

     Invoking the program with no options writes a 128x128  TGA  file  called
     "output.tga"  which  looks  like  a somewhat bumpy hillside (in POV any-
     way... being a special format, it will look like green speckled noise in
     a  standard  viewer).  "gforge -help" tells you briefly what options are
     available.  You can abbreviate keywords also. Try


                                                                            1






   gforge(1)                                                      28 May 1995



               gforge -t pg8 -pow 1 -dim 4 -n sand.pgm

     for an image of sand, or

               gforge -type tga -pow 1.8 -dim 2.4 -m 512 -n mountain.tga

     for a mountain range to render with POV. Getting your landscape to  look
     just  right  will  require playing around with the -dimension and -power
     specs.


   OPTIONS

     -mesh meshsize
          The size of the (n x n) IFFT (inverse fast-fourier  transform)  ma-
          trix. To prevent the IFFT from becoming a slow fourier transform,
          the mesh size is always a power of two, but the  program  automati-
          cally  uses  the  next  largest  power of two if what you specified
          wasn't one. Default is 128. Note that a mesh size of 1024 will  re-
          quire just over 8 megabytes of memory, and may take a long time.

     -dimension dim
          Sets the fractal dimension to the specified dim, which may  be  any
          floating  point  value  between 0 and 3.  Higher fractal dimensions
          create more ``chaotic'' images,  which  require  higher  resolution
          output and a larger FFT mesh size to look good.  If no dimension is
          specified, 2.15 is used. To be precise, the initial mesh is  filled
          with gaussian noise of amplitude (1/f)^ (4-dim).

     -adim ad ascale
          Adds an additional component of noise in the frequency domain  with
          the dimension ad and amplitude (scaled relative to the first speci-
          fied dimension) of ascale.  You can add up to nine  additional  di-
          mensions, although one or two is almost certainly enough. Often you
          don't need any at all. An example might be to  have  large  rolling
          hills of dim 1.7, with a touch of higher frequencies for roughness:
          gforge -dim 1.7 -adim 2.0 0.1 -pow 1.8

     -peak xpos ypos
          You can specify the location of the largest value (highest peak) in
          the image as a fraction of the image height and width. For example,
          gforge -dim 1.7 -pow 2 -peak 0.5 0.5 -name lonely.mountain
          puts the highest peak in the center of the image. This is most use-
          ful  for lower values of dim where there is only one or a few broad
          maxima; at -dim 2 or above it tends to make less difference. If you
          don't specify it, it's somewhere random.

     -seed seed
          You can give it a random number  seed,  otherwise  it  chooses  one
          based  on  the  current  time  from the system clock. With the same
          seed, power, dimension, and mesh size, you get the same image every
          time.



   2






   28 May 1995                                                      gforge(1)


     -name filename
          If you don't specify it, it's "output.tga" or "output.pgm", depend-
          ing  on  which file type is being written. Existing files with that
          name are overwritten without warning.

     -type TGA|PGM|PG8
          Three options, default is TGA. TGA and PGM are 16-bit formats,  and
          PG8 is just PGM 8-bit binary format.  PG8 , will produce a standard
          PGM file suitable for viewing in a standard graphic viewer to check
          out what the options are doing to your landscape.

     All flags can be abbreviated to their shortest unique prefix.

   BUGS

     diagonal pixel streaks at high dimension
          As you increase dim beyond 2.5, you begin  to  see  faint  diagonal
          streaks instead of "white noise". I don't know why this occurs, but
          then I don't really understand the algorithm...  anyway,  realistic
          landscapes look best at dim values less than 2.5. If you want to go
          higher, try using a bigger mesh size as well.

     tiling 'feature'
          Because the FFT operates on periodic functions, the opposite  edges
          of the image will always match up. If it turns out you want to cov-
          er a large area by tiling these textures  together,  this  is  just
          what  you  want  (ie, it's a FEATURE... in fact one way to generate
          useful tilable textures is by taking the  FFT  of  any  interesting
          picture,  filtering a bit, and doing the inverse transform.) If you
          don't want periodicity, just generate a larger image than you  need
          and use some smaller fraction of it.

     fixed output sizes
          The output is always a square grid which is a power of two. If  you
          want a different size or aspect ratio, you should use another pack-
          age to crop or rescale as appropriate.

     You may have to reduce the FFT mesh size on machines with 16 bit
          integers and segmented pointer architectures.


   SEE ALSO
     ppmforge(1), ppm(5), povraydocs

     [1]  Voss, Richard F., ``Random Fractal  Forgeries,''  in  Earnshaw  et.
          al.,   Fundamental   Algorithms   for  Computer  Graphics,  Berlin:
          Springer-Verlag, 1985.

     [2]  Peitgen, H.-O., and Saupe, D. eds., The Science Of Fractal  Images,
          New York: Springer Verlag, 1988.

     [3]  Walker, John, "ppmforge.c" in Jef Poskanzer's PBMPLUS raster toolk-




                                                                            3






   gforge(1)                                                      28 May 1995


          it, 1991.  <kelvin@fourmilab.ch>  <http://www.fourmilab.ch/>

   AUTHOR
          John Beale
          P.O. Box 8188
          Stanford, CA 94309-8188 USA
          ---------------------------
          beale@jumpjibe.stanford.edu
          http://www-leland.stanford.edu/~beale

     Permission to use, copy, modify, and distribute this  software  and  its
     documentation for any purpose and without fee is hereby granted, without
     any conditions or restrictions.  This software  is  provided  ``as  is''
     without express or implied warranty.










































   4



