0		# Endpoint A (x variable)
2		# Endpoint B (x variable)
0		# Endpoint C (y variable)
1		# Endpoint D (y variable)
5		# Mesh rows
6		# Mesh columns
0.0000000001	# Tolerance
100		# Maximum Iterations
x*exp(y)	# Function f(x,y)
0		# u(A,y), Endpoint A boundary condition
2*exp(y)	# u(B,y), Endpoint B boundary condition
x		# u(x,C), Endpoint C boundary condition
e*x		# u(x,D), Endpoint D boundary condition

========================================================================

File: POISSON.PDE

Sample input file for the Poisson Equation Finite-Difference Method

This file contains:

 	Endpoint A (x variable)
 	Endpoint B (x variable)
 	Endpoint C (y variable)
 	Endpoint D (y variable)
 	Mesh rows
 	Mesh columns
 	Tolerance
 	Maximum Iterations
 	Function f(x,y)
 	u1(A,y), Endpoint A boundary condition
 	u2(B,y), Endpoint B boundary condition
 	u3(x,C), Endpoint C boundary condition
 	u4(x,D), Endpoint D boundary condition

The input parameters MUST appear at the beginning of the input file
as shown above. Following the input value on a line, the '#' or ';' character
delineates a comment. Note that a space (blank) must precede the '#' or ';'
character. This character and anything after the character on
a line will be ignored.

Anything beyond the data lines is treated as the comment field.

Following execution, all method output will be written to DEFAULT.OUT
on disk. This file will be automatically opened as a editor file for
viewing upon completion. If you wish to save the file, it is recommended
that you use the Save As function to save the file under the
desired filename. This will prevent the file from being overwritten.

Function f(x,y)

This method requires that the two variables in the differential function
are x and y (or X and Y). Any other variable names will result in errors.
For example:

 Valid function's

 cos(x)+(y*tan(y^2))
 pi*(ln(y*x)/(y-x+6.789))

 Invalid function's

 pi*ln(t)             - t is invalid
 cos(z2)+(9*tan(x^2)) - z2 is invalid
 sun(x1) + z          - sun, x1 and z are invalid
 y2+4                 - y2 is invalid


Boundary Functions

This method requires the following 4 boundary functions to be entered on
separate lines:

 u1(A,y), Endpoint A boundary condition
 u2(B,y), Endpoint B boundary condition
 u3(x,C), Endpoint C boundary condition
 u4(x,D), Endpoint D boundary condition

The functions must be entered on separate lines. If two functions are equal,
they must both be entered. If a function is 0, it must be entered as 0.

This method requires that the two variables in each differential function
are x and y (or X and Y). Any other variable names will result in errors.
For example:

 Valid function's

 cos(x)+(y*tan(y^2))
 pi*(ln(y*x)/(y-x+6.789))

 Invalid function's

 pi*ln(t)             - t is invalid
 cos(z2)+(9*tan(x^2)) - z2 is invalid
 sun(x1) + z          - sun, x1 and z are invalid
 y2+4                 - y2 is invalid

========================================================================

The function's follow standard computer conventions and will handle the
following operators, functions and constants:

 Operators

 +  -  *  /  ^

 Functions:

 sin      cos      tan      cot
 arcsin   arccos   arctan   ln
 log10    log2     abs      sqr
 sqrt     exp

Note: Trigonometric functions are in radians

 Constants:

 e pi

Blanks are ignored within the function and are recommended for reading
clarity. Standard computer operator precedence is followed but using '(' and ')'
is recommended for clarity. When in doubt, use extra brackets!