/* NODELIST.CMD - Looks for new nodediff and/or os2list
files in their respective directories. If found, unzips and
does a force compile for Lora and GoldED.
Version 1.1 - 25 June 1994 by Elliott Goodman 

Donations for this program may be sent to:

     Elliott Goodman        
     PO Box 500038          
     Palmdale, CA 93591-0038
*/

/* check if RxFuncs are loaded. If not, loads */
if RxFuncQuery('SysLoadFuncs') then
do
  call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
  call SysLoadFuncs
  end

/* TRACE ?A */     /* uncomment to see what's going on! */

/* point to text file for messages */
sav_file = 'd:\lora\lang\nodecmd.txt'

/* set up directories and filenames */
area.1 = 'd:\lora\file\os2diff' ; file.1 = 'os2list.*'
area.2 = 'd:\lora\file\nodediff' ; file.2 = 'nodediff.*'

/* initialize a couple of flags */
flag.1 = 0 ; flag.2 = 0

/* main routine to look in each specified directory */
do i = 1 to 2
  newdir = area.i
  f_name = file.i
  call directory newdir
  
  /* used later to remove leading drive/directory info */
  pattern = newdir||'\'
  
  /* converts to uppercase */
  pattern = translate(pattern)
  
  /* initialize variable to find newest file */
  maxage = 0

  /* form an array of names meeting filespec f_name */
  call SysFileTree f_name, 'tfile' , 'F'
  
  /* the point: if more than one diff file is found,
  a new one must have been tic'd there. */
  if tfile.0 > 1 then
  do
    /* set flag for later use */
    flag.i = 1

    /* find which file is the newest */
    call get_new

    /* delete older ones */
    call del_old

    /* update files.bbs after saving to files.bak */
    call fix_files
    end /* if tfile.0 > 1 */
  end /* main do i = 1 to 2 loop */

/* if we processed os2list... */
if flag.1 = 1 then
do
  /* get rid of older os2list */
  'del d:\lora\nodes\os2list.*'

  /* copy new os2list here for processing */
  'cd \lora\lang'
  'copy d:\lora\file\os2diff\os2list.* d:\lora\lang'

  /* rename to zip so infozip will process without having
  to know the exact filename */
  'ren os2list.* os2list.zip'
  
  'unzip os2list'

  /* clean up as we go along */
  'del os2list.zip'

  /* see if things have worked so far, ie., a
  os2list.xxx file is present */
  call SysFileTree file.1, 'tfile' , 'F'

  /* if not, notify and skip further processing */
  if tfile.0 = 0 then
  do
    m_txt = 'Error with os2list'
    call lineout sav_file, m_txt
    end

  /* else continue processing */
  else do
    /* move */
    'copy os2list.* d:\lora\nodes'
    'del os2list.*'
    end
  end

if flag.2 = 1 then
do
  'cd \lora\lang'
  'copy d:\lora\file\nodediff\nodediff.* d:\lora\lang'
  'ren nodediff.* nodediff.arc'
  'd:\lora\arce nodediff nodediff.* d:\lora\nodes /R'
  'del nodediff.arc'
  end

if flag.1 = 1 | flag.2 = 1 then do
  'cd \lora'
  'lora nodelist'
  'cd \lora\golded'
  'gn2 -f'
  'e:\util\gamma2\hpfsopt d: -u'
  end
exit

/* subroutines follow */

get_new:
do k=1 to tfile.0
  parse upper var tfile.k month '/' day '/' year,
        hour size attrib name
  tfile.k.age = (month * 30) + day + (year * 10)
  if tfile.k.age > maxage then
    maxage = tfile.k.age
  end
return

del_old:
do k=1 to tfile.0
  parse upper var tfile.k date hour size attrib name
  name = strip(name)
  if tfile.k.age < maxage then do
    parse upper var name (pattern) name
    name = translate(name)
    call SysFileDelete name
    end
  end
return

fix_files:
'del files.bak'
lineno = 1
out_name = 'FILES.BAK'
in_name = 'FILES.BBS'
do until lines(in_name) = 0
  bbs.lineno = linein(in_name)
  call lineout out_name, bbs.lineno
  lineno = lineno + 1
  end
lineno = lineno - 1
call lineout in_name
call lineout out_name
'del files.bbs'
call lineout in_name, bbs.lineno
call lineout in_name
return

