/* Door Tracking REXX cmd file by Elliott Goodman
Version 1.42, 20 Apr, 1995. 1:102/1319

Modify as needed. Please note: you may have to adjust
the directories you are in when calling this. It's set up
for my system (of course).

Donations for this program may be sent to:

     Elliott Goodman        
     PO Box 500038          
     Palmdale, CA 93591-0038

*/

/* trace ?a */

phrase = 'External'		/* Specific phrases to look for */
phrase1 = 'off-line.'
phrase2 = 'Returned'
phrase3 ='D:\LORA\LORD1.BAT'
phrase4 ='D:\LORA\PLANET1.BAT'
phrase5 ='D:\LORA\DOORS\EZELS.BAT'
phrase6 = 'Write'
phrase7 = 'Connect FAX'
phrase8 = 'Calls=1,'
phrase9 = 'System call'
phrase10 = 'Receiving'
phrase11 = 'packet(s):'
phrase12 = 'D:\LORA\DOORS\EZVOTE\EZVOTE.BAT'
phrase13 = 'D:\LORA\DOORS\SPIKE\SPIKE.BAT'

count = 0	/* initialize counters */
caller_count = 0
lord = 0
planet = 0
ezels = 0
ezvote = 0
spike = 0
ice = 0
fax_count = 0
Sys_Txt = ' No System Calls??'
BBS_calls = 0
user_names = 0
temp_name = ' '
temp_count = 0
total_count = 0
echomail = 0

drop callers.

max_time = (24 * 3600)	/* 24:00 if someone should span the day */
total_time = 0			/* total time in doors */
total_hours = 0
total_minutes = 0
total_seconds = 0

say "Door Trakker by Elliott Goodman"
say "Version 1.42, April 20, 1995"
say ''

in_name = 'lora.log'            /* filename to search */

do until lines(in_name) = 0             /* read in each line */
  work_line = linein(in_name)           /* current line to examine */
  j = wordpos(phrase, work_line)      /* look for the phrase */
  if j \= 0 then do                     /* phrase found */
      next_line = linein(in_name)	/* get next line */
      k = wordpos(phrase2, next_line)
      if k \= 0 then do

/* Okay, work_line has 'External' in it and next_line has 'Returned' in it.
Therefore, a user has gone to a door and returned. Now, let's parse the lines */

        count = count + 1		/* increment count */
/* find out which door was run */

	n = wordpos(phrase3, work_line)	/* Test for Legend */
	  if n \= 0 then do
	    lord = lord + 1
	    end
	n = wordpos(phrase4, work_line)	/* Test for Planets */
	  if n \= 0 then do
	    planet = planet + 1
	    end
	n = wordpos(phrase5, work_line)	/* Test for EZ-Els */
	  if n \= 0 then do
	    ezels = ezels + 1
	    end

        n = wordpos(phrase12, work_line)   /* Test for EZ-Vote */
          if n \= 0 then do
            ezvote = ezvote + 1
            end

        n = wordpos(phrase13, work_line)  /* test for Spiked! */
          if n \= 0 then do
            spike = spike + 1
            end

/* these lines get the time the event occurred */
        parse var work_line ':' start_time junk
        parse var next_line ':' end_time junk

/* these lines parse the time into hours/minutes/seconds */
        parse var start_time shour ':' smin ':' ssec
        parse var end_time ehour ':' emin ':' esec

/* calculate total seconds */
        stotal = (3600 * shour) + (60 * smin) + ssec
        etotal = (3600 * ehour) + (60 * emin) + esec

/* if start time > end time, user has spanned midnight - adjust */
        if stotal > etotal then
          this_time = (max_time - stotal) + etotal
        else
          this_time = etotal - stotal

        total_time = total_time + this_time

        end /* k \= */
      k = wordpos(phrase6, next_line)
      if k \= 0 then do
        ice = ice + 1
        count = count + 1
      end /* if k \=0 */

    end       /* end if j \= */

    else do /* 'external' NOT found. Test for these phrases */

      j = wordpos(phrase7, work_line) /* 'connect FAX' */
      if j \= 0 then
      do
        fax_count = fax_count + 1
        end /* if j \= 0 */

      j = wordpos(phrase8, work_line) /* new caller */
      if j \= 0 then
      do
           parse upper var work_line . . first_name last_name 'OFF-LINE.' dummy
           say "New caller: "first_name last_name
           end /* j \= 0 */

       j = wordpos(phrase9, work_line) /* BBS call - increment count */
       if j \= 0 then
       do
           parse var work_line . . Sys_Txt
           BBS_calls = BBS_calls + 1
           end

        j = wordpos(phrase10, work_line) /* file RECEIVED! */
        if j \= 0 then
        do
            parse var work_line . . to_where dummy
            select
               when left(to_where, 13) = 'FILE\UNCHECK\' then
                  say 'File Uploaded:' to_where
               otherwise
                  iterate
               end
            end

    j = wordpos(phrase11, work_line) /* track echo messages */
    if j \= 0 then
      do
         parse var work_line . . . . . . e_temp dummy
         echomail = echomail + e_temp
         end

    j = wordpos(phrase1, work_line) /* track caller names */
    if j \= 0 then do
        parse var work_line . . first last (phrase1) stuff
        caller_tag = first last
        found = 0
        do index = 1 to user_names
           if callers.index = caller_tag then do
              callers.index.caller_count = callers.index.caller_count + 1
              found = 1
              leave
              end /* if */
           end /* do index = 1 to user_names */
        if found = 0 then do
           user_names = user_names + 1
           callers.user_names = caller_tag
           callers.user_names.caller_count = 1
           end /* if found = 0 */
        end /* if j \= */
    end  /* else do */
end             /* do until */

call lineout in_name       /* close file */

say "BBS Calls:" BBS_calls || ", High" || Sys_Txt
say " "

/* calculate hours and minutes */
if total_time > 3600 then do
  total_hours = total_time % 3600
  total_time = total_time // 3600
  end

if total_time > 60 then do
  total_minutes = total_time % 60
  total_time = total_time // 60
  end

total_seconds = total_time

/* adjust total to EXCLUDE Ice Edit messages */
count = count - ice

say "Times in doors today:" count || ", Echomail:" echomail
say "LORD =" lord "Planets =" planet "EZ-Echo Searcher =" ezels "EZ-Vote =" ezvote "Spiked! =" spike
say "Hours:" total_hours||", Minutes:" total_minutes
if ice = 1 then
   say "Ice Edit wrote" ice "message."
else
   say "Ice Edit wrote" ice "messages."
/* say "Faxes received: " fax_count */
say ''

/* sort callers by # of times called today */
swap = 1
do until swap = 0
    swap = 0
    do index = 1 to user_names -1
        t_index = index + 1
        if callers.t_index.caller_count > callers.index.caller_count then do
            temp_name = callers.index
            temp_count = callers.index.caller_count
            callers.index = callers.t_index
            callers.index.caller_count = callers.t_index.caller_count
            callers.t_index = temp_name
            callers.t_index.caller_count = temp_count
            swap = 1
            end /* if */
        end /* do */
    end /* do until */

do index = 1 to user_names
   m_txt = callers.index.caller_count '-' callers.index
   say m_txt
   end
say 'Press any key to exit....' 

parse pull stuff

exit
