#ifndef stdlib

#define stdlib

#define assert(condition) \
  if (~(condition)) then \
    writeln("assertion failed: File ",#file,", line ",#linenum,": ",#condition); \
    halt; \
  endif;

#define visassert(condition) \
  if (~(condition)) then \
    writeln("assertion failed: File ",#file,", line ",#linenum,": ",#condition); \
    halt; \
  else \
    writeln("assertion passed: File ",#file,", line ",#linenum,": ",#condition); \
  endif;

#define inc(i) i:=i+1
#define dec(i) i:=i-1

#define min(a,b) (temp(t1,a,temp(t2,b,cond(t1<t2,t1,t2))))
#define max(a,b) (temp(t1,a,temp(t2,b,cond(t1>t2,t1,t2))))

#define upcase(ch) (temp(t1,ch,cond((t1>='a') & (t1<='z'),t1-'a'+'A',t1)))
#define locase(ch) (temp(t1,ch,cond((t1>='A') & (t1<='Z'),t1-'A'+'a',t1)))

(*
procedure upcase(ch: char): char;
begin;
 if (ch>='a') & (ch<='z') then
   return ch-'a'+'A';
 else
   return ch;
 endif;
end upcase;

procedure locase(ch: char): char;
begin;
 if (ch>='A') & (ch<='Z') then
   return ch-'A'+'a';
 else
   return ch;
 endif;
end locase;
*)

procedure upstr(s: string): string;
var
 i: integer;
begin;
 for i:=1 to length(s) do
   s[i]:=upcase(s[i]);
 endfor;
 return s;
end upstr;

procedure lostr(s: string): string;
var
 i: integer;
begin;
 for i:=1 to length(s) do
   s[i]:=locase(s[i]);
 endfor;
 return s;
end lostr;

procedure rpad(s: string; num: integer; s2: string): string;
begin;
 while length(s)<num do
   s:=strcat(s,s2); 
 endwhile;
 return s;
end rpad;

external 99 procedure ftoi(f: double): integer;

#endif