; File......: SEG2SEL.ASM
; Author....: Ted Means
; CIS ID....: 73067,3332
; Date......: $Date$
; Revision..: $Revision$
; Log file..: $Logfile$
;
; This is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log$
;
;  $DOC$
;  $FUNCNAME$
;     cpmiSeg2Sel()
;  $CATEGORY$
;     CPMI
;  $ONELINER$
;     Generate a protected mode selector from a real mode segment
;  $SYNTAX$
;     SELECTOR pascal cpmiSeg2Sel( SEGMENT RMSeg )
;  $ARGUMENTS$
;     RMSeg is the real mode memory segment address for which a selector
;     is needed.
;  $RETURNS$
;     A selector which maps to the same physical memory.  A null selector
;     is returned if the function fails.
;  $DESCRIPTION$
;     This function is similar to cpmiProtectedPtr(), but differs in
;     a few important ways:
;
;     1)  This function always generates a 64K selector.
;
;     2)  Selectors generated by this function can never be modified or
;         freed.
;
;     3)  Multiple calls to this function with the same segment will
;         always return the same selector.
;
;     This function should be used sparingly.  It is mainly intended
;     for use with commonly used real mode memory segments like
;     0xB800 or 0x0040.
;  $EXAMPLES$
;     auto char * Video;
;
;     FP_SEG( Video ) = cpmiSeg2Sel( 0xB800 );
;     FP_OFF( Video ) = 0;
;
;  $INCLUDE$
;     CPMI.H
;  $SEEALSO$
;     cpmiProtectedPtr()
;  $END$
;

IDEAL
P286

Public    cpmiSeg2Sel

Segment   _NanFor   Word      Public    "CODE"
          Assume    CS:_NanFor

Proc      cpmiSeg2Sel         Far

          Enter     0,0                           ; Create stack frame

          Mov       AX,2                          ; DPMI -- Seg to Descriptor
          Mov       BX,[Word Ptr BP + 6]          ; Get segment
          Int       31h                           ; Call DPMI
          JNC       @@Exit                        ; Leave if no error
          Xor       AX,AX                         ; Return null selector

@@Exit:   Leave                                   ; Destroy stack frame
          RetF      2
Endp      cpmiSeg2Sel
Ends      _NanFor
End