; File......: SHADOW.ASM
; Author....: Ted Means
; CIS ID....: 73067,3332
;
; This is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
;     Rev 1.7   27 Nov 1992 10:39:18   GLENN
;  Another memory related bug fixed by Ted.
;
;     Rev 1.6   21 Nov 1992 11:30:24   GLENN
;  Ted fixed a bug in which memory was being overwritten if the top and
;  bottom coordinates were equal.
;
;     Rev 1.5   16 Nov 1992 00:10:26   GLENN
;  An accidental change to the interface was made when ft_shadow() was
;  rewritten.  This brings it back to the old calling convention.
;
;     Rev 1.4   16 Oct 1992 00:07:06   GLENN
;  Just making sure we had Ted's current revision.
;
;     Rev 1.3   28 Sep 1992 21:41:06   GLENN
;  Ted Means completely and totally rewrote this to compile under TASM's
;  IDEAL mode, with more features.  See the documentation.  It should be
;  compatible with the old Reginald Walton function, but is much faster.
;
;     Rev 1.2   15 Aug 1991 23:07:26   GLENN
;  Forest Belt proofread/edited/cleaned up doc
;
;     Rev 1.1   11 May 1991 00:29:22   GLENN
;  Major re-write by Ted Means.  He sped it up.  It will also cooperate
;  with Clipper's internal _gtmaxrow and _gtmaxcol settings.
;
;     Rev 1.0   02 Apr 1991 18:25:40   GLENN
;  Nanforum Toolkit
;
;


;  $DOC$
;  $FUNCNAME$
;      FT_SHADOW()
;  $CATEGORY$
;      Video
;  $ONELINER$
;      Draw a non-destructive shadow on the screen
;  $SYNTAX$
;     FT_SHADOW( <nTop>, <nLeft>, <nBottom>, <nRight> [ ,<nAttr>] ) -> NIL
;  $ARGUMENTS$
;     <nTop>    is the top row of the shadow area.
;     <nLeft>   is the upper left column of the shadow area.
;     <nBottom> is the bottom row of the shadow area.
;     <nRight>  is the lower right column of the shadow area.
;     <nAttr>   is optional and is the screen attribute to use for drawing
;               the shadow.  If not specified, the default is 8.
;  $RETURNS$
;     NIL
;  $DESCRIPTION$
;     This function allows you to implement the popular "shadow effect."  It
;     draws a shadow using the specified screen coordinates.  The shadow
;     is drawn along the bottom and right side of the specified region.
;
;     The source code is written to TASM IDEAL mode.
;  $EXAMPLES$
;     FT_Shadow(10,10,15,50, 8)  // draw a dim shadow
;
;     FT_Shadow(10,10,15,40,47)  // draw a green shadow
;  $END$

IDEAL                                        ; Invoke TASM IDEAL mode

Public   FT_Shadow

Extrn    __ParNI:Far
Extrn    __xGrab:Far
Extrn    __xFree:Far
Extrn    __gtSave:Far
Extrn    __gtRest:Far
Extrn    __gtRectSize:Far

nTop     EQU       Word Ptr BP - 2
nLeft    EQU       Word Ptr BP - 4
nBottom  EQU       Word Ptr BP - 6
nRight   EQU       Word Ptr BP - 8
nAttr    EQU       Byte Ptr BP - 10
nSize    EQU       Word Ptr BP - 12

Segment  _NanFor   Word      Public    "CODE"
         Assume    CS:_NanFor

Proc     FT_Shadow Far

         Push      BP                        ; Save BP
         Mov       BP,SP                     ; Set up stack reference
         Sub       SP,12                     ; Allocate locals

         Mov       CX,5                      ; Set param count
@@Coord: Push      CX                        ; Put on stack
         Call      __ParNI                   ; Retrieve param
         Pop       CX                        ; Get count back
         Push      AX                        ; Put value on stack
         Loop      @@Coord                   ; Get next value

         Pop       [nTop]                    ; Get top coordinate
         Pop       [nLeft]                   ; Get left coordinate
         Pop       [nBottom]                 ; Get bottom coordinate
         Pop       [nRight]                  ; Get right coordinate
         Pop       [Word Ptr BP - 10]        ; Get attribute
         Cmp       [nAttr],0                 ; Is attribute invalid?
         JNE       @@Right                   ; If not, continue
         Mov       [nAttr],8                 ; Default attribute to 8

@@Right: Mov       AX,[nBottom]              ; Load bottom coordinate
         Sub       AX,[nTop]                 ; Subtract top
         JZ        @@Bottom                  ; If no room, skip right side

         LEA       AX,[nSize]                ; Get size address
         Push      SS                        ; Put segment on stack
         Push      AX                        ; Put offset on stack

         Mov       AX,[nTop]                 ; Load top coordinate
         Inc       AX                        ; Drop down a row
         Mov       BX,[nBottom]              ; Load bottom coordinate
         Inc       BX                        ; Drop down a row
         Mov       CX,[nRight]               ; Load right coordinate
         Inc       CX                        ; Move over one
         Mov       DX,CX                     ; Copy to DX
         Inc       DX                        ; Move over another one

         Push      DX                        ; Put right coord on stack
         Push      BX                        ; Put bottom coord on stack
         Push      CX                        ; Put left coord on stack
         Push      AX                        ; Put top coord on stack
         Call      __gtRectSize              ; Get size

         Push      [nSize]                   ; Put size on stack
         Call      __xGrab                   ; Allocate memory
         Add       SP,2                      ; Realign stack

         Mov       [Word Ptr BP - 14],DX     ; Reset segment
         Mov       [Word Ptr BP - 16],AX     ; Reset offset
         Call      __gtSave                  ; Save screen image

         Mov       CX,[nSize]                ; Get size
         SHR       CX,1                      ; Divide by 2
         Mov       AL,[nAttr]                ; Load attribute
         LES       BX,[DWord Ptr BP - 16]    ; Load buffer pointer
         Inc       BX                        ; Point to attribute byte
@@RAttr: Mov       [Byte Ptr ES:BX],AL       ; Store attribute
         Add       BX,2                      ; Adjust offset
         Loop      @@RAttr                   ; Do next byte

         Call      __gtRest                  ; Put shadowed image onscreen
         Add       SP,8                      ; Remove params from stack
         Call      __xFree                   ; Free buffer
         Add       SP,4                      ; Realign stack

@@Bottom:Mov       AX,[nRight]               ; Load right coordinate
         Sub       AX,[nLeft]                ; Subtract top
         Cmp       AX,2                      ; Enough room for shadow?
         JB        @@Done                    ; If not, skip it

         LEA       AX,[nSize]                ; Get size address
         Push      SS                        ; Put segment on stack
         Push      AX                        ; Put offset on stack

         Mov       AX,[nBottom]              ; Load bottom coordinate
         Inc       AX                        ; Drop down a row
         Mov       BX,AX                     ; Copy to BX
         Mov       CX,[nLeft]                ; Load left coordinate
         Inc       CX                        ; Move over two
         Inc       CX
         Mov       DX,[nRight]               ; Load right coordinate
         Inc       DX                        ; Move over two
         Inc       DX
         Push      DX                        ; Put right coord on stack
         Push      BX                        ; Put bottom coord on stack
         Push      CX                        ; Put left coord on stack
         Push      AX                        ; Put top coord on stack
         Call      __gtRectSize              ; Get size

         Push      [nSize]                   ; Put size on stack
         Call      __xGrab                   ; Allocate memory
         Add       SP,2                      ; Realign stack

         Mov       [Word Ptr BP - 14],DX     ; Reset segment
         Mov       [Word Ptr BP - 16],AX     ; Reset offset
         Call      __gtSave                  ; Save screen image

         Mov       CX,[nSize]                ; Get size
         SHR       CX,1                      ; Divide by 2
         Mov       AL,[nAttr]                ; Load attribute
         LES       BX,[DWord Ptr BP - 16]    ; Load buffer pointer
         Inc       BX                        ; Point to attribute byte
@@BAttr: Mov       [Byte Ptr ES:BX],AL       ; Store attribute
         Add       BX,2                      ; Adjust offset
         Loop      @@BAttr                   ; Do next byte

         Call      __gtRest                  ; Put shadowed image onscreen
         Add       SP,8                      ; Remove params from stack
         Call      __xFree                   ; Free buffer

@@Done:  Mov       SP,BP                     ; Realign stack
         Pop       BP                        ; Restore BP
         Ret
Endp     FT_Shadow
Ends     _NanFor
End

