; File......: ADAPTER.ASM
; Author....: Ted Means
; CIS ID....: 73067,3332

; This is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
;     Rev 1.0   01 Jan 1995 03:01:00   TED
;  Nanforum Toolkit
;

;  $DOC$
;  $FUNCNAME$
;     FT_IAmIdle()
;  $CATEGORY$
;     DOS/BIOS
;  $ONELINER$
;     Inform the operating system that the application is idle.
;  $SYNTAX$
;     FT_IAmIdle() -> lSuccess
;  $ARGUMENTS$
;     None
;  $RETURNS$
;     .T. if supported, .F. otherwise.
;  $DESCRIPTION$
;     Some multitasking operating environments (e.g. Windows or OS/2) can
;     function more efficiently when applications release the CPU during
;     idle states.  This function allows you "announce" to the operating
;     system that your application is idle.
;
;     Note that if you use this function in conjunction with FT_OnIdle(),
;     you can cause Clipper to automatically release the CPU whenever
;     Clipper itself detects an idle state.
;  $EXAMPLES$
;     while inkey() != K_ESC
;        FT_IAmIdle()         // Wait for ESC and announce idleness
;     end
;
;     * Here's another way to do it:
;
;     FT_OnIdle( {|| FT_IAmIdle()} )
;
;     Inkey( 0 )              // Automatically reports idleness until key
;                             // is pressed!
;  $SEEALSO$
;     FT_OnIdle()
;  $END$
;

IDEAL

Public    FT_IAmIdle

Extrn     __RetL:Far

Segment   _NanFor   Word      Public    "CODE"
          Assume    CS:_NanFor

Proc      FT_IAmIdle          Far

          Mov       AX,1680h
          Int       2Fh

          Mov       AX,0
          Xor       AL,80h
          Push      AX
          Call      __RetL
          Add       SP,2

          RetF
Endp      FT_IAmIdle
Ends      _NanFor
End