UNIT VTKEY;

INTERFACE
 Var Key,Key1 : Byte;
     StatusBits : Word Absolute $0040:$0017;

Procedure GetKey(Var AscCode,PosCode : Byte);
Procedure KeyPressed(Var AscCode,PosCode : Byte);
Procedure FlushKBD;

Function LeftShiftPressed : Boolean;
Function RightShiftPressed : Boolean;
Function ShiftPressed : Boolean;
Function RightAltPressed : Boolean;
Function LeftAltPressed : Boolean;
Function AltPressed : Boolean;
Function RightCtrlPressed : Boolean;
Function LeftCtrlPressed : Boolean;
Function CtrlPressed : Boolean;
Function  CapsOn : Boolean;
Function  NumOn : Boolean;
Function  ScrollOn : Boolean;

Procedure SetCaps (Stat : Boolean);
Procedure SetNum (Stat : Boolean);
Procedure SetScroll (Stat : Boolean);
IMPLEMENTATION
 procedure Getkey(var AscCode,PosCode : Byte); assembler;
   asm
   PUSH DS   { Save the DS & ES }
   PUSH ES
   MOV AH,0h { Attach the 0 function | Get next key or wait for key }
   INT 16h
   LES DI,AscCode { Load the ASCII code }
    STOSB
   MOV AL,AH      { Load Position code }
   LES DI,PosCode
    STOSB
   POP ES         { Restore old ES & DS }
   POP DS
  end;

 Procedure KeyPressed(var AscCode,PosCode : Byte); assembler;
 asm
  PUSH DS        { Save  DS & ES }
  PUSH ES
  MOV AH,01h     { Attach the 01 function | check if have a key into buufer }
  INT 16h
  JNZ @LoadData  { ZeroFlag is set to 1 if have key }
  MOV AX,0       { Else return 0}
 @LoadData:
   LES DI,AscCode { Load ASCII code | AL - ASCII Code }
   STOSB
   MOV AL,AH      { Load Position code | AH - Position code }
   LES DI,PosCode
   STOSB
   POP ES         { Restore Old ES & BP }
   POP DS
 End;
Procedure FlushKBD;
 Var a,b : Byte;
Begin
 Repeat GetKey(a,b); Until a = 0;
End;

Function LeftShiftPressed : Boolean;
Begin
 leftShiftPressed := (StatusBits and 2) <> 0;
End;
Function RightShiftPressed : Boolean;
Begin
 RightShiftPressed := (StatusBits and 1) <> 0;
End;

Function ShiftPressed : Boolean;
Begin
 ShiftPressed := ((StatusBits And 1) <> 0) Or ((StatusBits and 2) <> 0);
End;
Function RightAltPressed : Boolean;
Begin
 RightAltPressed := (StatusBits and 8) <> 0;
End;
Function LeftAltPressed : Boolean;
Begin
 LeftAltPressed := (StatusBits and 520) <> 0;
End;
Function AltPressed : Boolean;
Begin
 AltPressed:= ((StatusBits and 520) <> 0) Or ((StatusBits and 8) <> 0);
End;
Function RightCtrlPressed : Boolean;
Begin
RightCtrlPressed := (StatusBits and 4) <> 0;
End;
Function LeftCtrlPressed : Boolean;
Begin
 LeftCtrlPressed := (StatusBits and 260) <> 0;
End;
Function CtrlPressed : Boolean;
Begin
 CtrlPressed := ((StatusBits and 260) <> 0) Or ((StatusBits and 4) <> 0);
End;
Function  CapsOn : Boolean;
Begin
 CapsOn := (StatusBits and 64) <> 0;
End;
Function  NumOn : Boolean;
Begin
 NumOn := (StatusBits and 32) <> 0;
End;
Function ScrollOn : Boolean;
Begin
 ScrollOn := (StatusBits and 16) <> 0;
End;
Procedure SetCaps (Stat : Boolean);
Begin
 If Stat Then StatusBits := (StatusBits Or 64)
 Else StatusBits := (StatusBits And 191);
End;
Procedure SetNum (Stat : Boolean);
Begin
 If Stat Then StatusBits := (StatusBits Or 32)
 Else StatusBits := (StatusBits And 223);
End;
Procedure SetScroll (Stat : Boolean);
Begin
 If Stat Then StatusBits := (StatusBits Or 16)
 Else StatusBits := (StatusBits And 239);
End;
BEGIN
END.
