program tvlm;
{$F+}

{ Example for the nwIntr unit / NwTP 0.6 (c) 1995, R.Spronk

  Shows the same information as the VLM /X command.

  Example for the use of the GetVLMHeader and GetVLMControlBlock
  functions in the unit nwIntr }

uses dos,nwintr,nwmisc;

Var t:byte;
    HDR:TVLMHeader;
    CBL:TVLMcontrolBlockEntry;
    s:string;
    GlobSize,TransSize:longint;
    regs:registers;
    w:word;

begin
IF NOT VLM_EXE_Loaded
 then begin
      writeln('VLM.EXE not loaded.');
      halt(0);
      end;
GetVLMHeader(HDR);

regs.ax:=$7a20;
regs.bx:=$0000;
regs.cx:=$0000;
intr($2f,regs);

writeln('Handler entry point  : ',HexStr(regs.es,4),':',HexStr(regs.bx,4));
writeln('Headerlength (or id?): ',HexStr(HDR.headerlen,2),'h');
writeln('IDstring             : ',hdr.multiplexIdString[1],
                     hdr.multiplexIdString[2],
                     hdr.multiplexIdString[3]);

writeln('TransientSwitchCount : ',hdr.TransientSwitchCount);
writeln('CallCount            : ',hdr.CallCount);
writeln('CurrentVLMid         : ',HexStr(hdr.CurrentVLMID,4),'h');
writeln('MemoryType           : ',HexStr(hdr.MemoryType,2),'h [04 = XMS]');
writeln('ModulesLoaded        : ',hdr.ModulesLoaded);
writeln('BlockID              : ',HexStr(hdr.BlockId,4),'h');
writeln('TransientBlock       : ',HexStr(hdr.TransientBlock,4),'h');
writeln('GlobalSegment        : ',HexStr(hdr.GlobalSegment,4),'h');
writeln('FullMapCount         : ',hdr.FullMapCount);

GlobSize:=0;TransSize:=0;
writeln;
writeln('VLM control block information               Address   Memory size (bytes) ');
writeln('Name     ID   Flag Func Maps Call TSeg Gseg Low  Hi   TSize  Gsize  SSize ');
writeln('-------- ---- ---- ---- ---- ---- ---- ---- ---- ---- ------ ------ ------');
for t:=0 to hdr.modulesLoaded
 do begin
    GetVLMcontrolBlock(t,CBL);

    With CBL
     do begin
        s[0]:=#8;
        move(cbl.VLMname,s[1],8);
        write(s,' ');

        write(HexStr(id,4),' ');
        write(HexStr(Flag,4),' ');
        write(HexStr(Func,4),' ');
        write(HexStr(Maps,4),' ');
        write(HexStr(TimesCalled,4),' ');
        write(HexStr(TransientSeg,4),' ');
        write(HexStr(GlobalSeg,4),' ');
        write(HexStr(AddressLow,4),' ');
        write(HexStr(AddressHi,4),' ');
        writeln(16*TsegSize:6,' ',16*GSegSize:6,' ',16*SSegSize:6);
        if TsegSize>TransSize
         then TransSize:=TsegSize;
        GlobSize:=GlobSize+GSegSize;
        end;
    end;
writeln('Transient block size: ',TransSize*16);
writeln('Global segment size : ',GlobSize*16);

end.