{$X+,B-,V-}
program SendHello;

{ Simple IPX demonstration program. Run this program on 1 workstation,
  run R_HELLO on another. R_HELLO will receive the "hello world" messages
  that this program sends.

  Polls the ECB until a packet is sent. No ESR used.   }

uses crt,nwMisc,nwIPX;

CONST IOSocket=$5678;

Var SendEcb:Tecb;
    IpxHdr:TipxHeader;
    socket:word;
    dest:TinternetworkAddress;
    buf:array[1..546] of byte;
    t:byte;
    w:word;
    s:string;
begin
IF NOT IpxInitialize
 then begin
      writeln('Ipx needs to be installed.');
      halt(1);
      end;
socket:=IOSocket;
IF NOT IPXopenSocket(Socket,SHORT_LIVED_SOCKET)
 then begin
      writeln('IPXopenSocket returned error# ',nwIPX.result);
      halt(1);
      end;

for t:=1 to 4 do dest.net[t]:=$00; { this net / segment }
for t:=1 to 6 do dest.node[t]:=$FF; { all nodes }
dest.socket:=IOsocket;
w:=0;

Repeat
  inc (w);

  { Fill buffer (ECB.fragment[2]^) }
  str(w:4,s);
  s:=s+' IPX: Hello World';
  FillChar(buf,546,#0);
  move(s[1],buf,ord(s[0]));

  { setup ECB and IPX header }
  IPXsetupSendECB(NIL,IOsocket,dest,@buf,ord(s[0]),
                  IpxHdr,SendEcb);
  IPXsendPacket(SendEcb);

  { Poll the Inuse Flag until the packet is sent. }
  While SendEcb.InUseFlag<>0
   do IPXrelinquishControl;

  { ECB.InUseFlag was lowered, now determine if packet was sent: }
  CASE SendEcb.CompletionCode OF
   $00:writeln('IPX packet #',w:0,' was sent.');
   $FC:writeln('The send of packet #',w:0,' was canceled.');
       { impossible, as this cancelation to be done by THIS program, and it doesn't }
   $FD:writeln('Packet# ',w:0,' is malformed and was not sent.');
       { illegal param: packet length, number of fragments, fragment size. }
   $FE:writeln('Packet# ',w:0,' was undelivered. No stations listening.');
   $FF:writeln('Packet# ',w:0,' not sent due to a hardware error.');
  end;

  { Wait 5 seconds between sending packets }
  delay(5000);
UNTIL keypressed;

IF NOT IPXcloseSocket(IOsocket)
then writeln('IPXcloseSocket returned error# ',nwIPX.result);

end.