{$X+,B-,V-} {essential compiler directives}

program pwexp;

{ Example for the nwConn unit / NwTP 0.6 API. (c) 1993,1995, R. Spronk }


{ Q: We're forcing our users to change their passwords every 40 days.
     After the password expiration date, they have 3 grace logins, one
     of which they should use to change their password. To force them
     to change their passwords whenever they login after the expiration
     date, we need an utility that returns a distinctive Errorlevel
     whenever the password has expired.

  The following program will return an errorlevel 0 whenever the calling
  station's password has expired (current date later than expiration
  date). In all other cases (i.e. an expiration date wasn't set, 1 will
  be returned.
}

Uses nwMisc,NwBindry,nwConn,nwServ;

Function LaterDate(Var t1,t2):Boolean;
Type Tascii3=array[1..3] of char;
Var ta:Tascii3 ABSOLUTE t1;
    tb:Tascii3 ABSOLUTE t2;
begin
if ta[1]<#80 then inc(ta[1],100);
if tb[1]<#80 then inc(tb[1],100);
LaterDate:=(ta>tb);
end;

Var AccLev:Byte;
    MyObjId:Longint;
    MyObjName:string;
    MyObjType:word;
    Info:TloginControl;
    Now:TnovTime;

begin
IF GetBinderyAccessLevel(AccLev,MyObjId)
   and GetBinderyObjectname(MyObjId,MyObjName,MyObjType)
 then begin
      IF GetObjectLoginControl(MyObjName,MyObjType,info)
       then with Info.PasswordExpirationDate
             do begin
                if (year=0) and (month=0) and (day=0)
                 then begin
                      writeln('PWEXP: Expiration date not set.');
                      halt(1); { exp. date not set }
                      end;
                GetFileServerDateAndTime(now);
                IF LaterDate(now,info.PasswordExpirationDate)
                 then begin
                      writeln('PWEXP: Password expired !');
                      halt(0) { PW expired }
                      end
                 else halt(1);
                end;
      end;
writeln('PWEXP: Bindery read error. Shell wel geladen ? Ingelogd ?');
halt(1);
end.
