program chkvend;
{$I-}

{ Testprogram checking all nodes on all attached servers and
  showing the manifacturers of the corresponding ethernet cards. }

uses nwMisc,nwConn,nwServ;

var PleaseMail:Boolean;
    Path      :string;

    StationNbr    : byte;
    StationAddress: TinternetworkAddress;
    Sinfo         : TFileServerInformation;
    t,conn        : byte;

    ObjName  :string;
    objType  :word;
    ObjId    :Longint;
    LoginTime:TnovTime;

    s,ts,subs:string;
    f        :text;
    fnd      :boolean;
    p        :byte;
begin
PleaseMail:=False;

Path:=ParamStr(0);
while NOT (path[ord(path[0])] IN [':','\','/']) do dec(Path[0]);
{Path now holds the name of the path where the chkvend.exe file is located }

assign(f,Path+'VEND_XXX.');
reset(f);
IF IOresult<>0
 then begin
      writeln('Couldn''t open VEND_XXX');
      writeln('<CHKVEND expects the file to in the same directory as the executable>');
      halt(1);
      end;

{ Check all 8 possible server attchments }
For conn:=1 to 8
 do begin
    SetPreferredConnectionId(conn);
    If IsConnectionIdInUse(conn)
     then begin
          GetFileServerInformation(Sinfo); { Get maximum number of conections }
          for t:=1 to Sinfo.ConnectionsMax
          do begin
             { check all connections }
             IF GetInternetAddress(t,StationAddress)
              then begin
                   GetConnectionInformation(t,objName,objType,ObjId,LoginTime);
                   objname:=objName+'                   ';
                   objName[0]:=#16;
                   ts:=HexDumpStr(StationAddress.node,12);
                   { check file if vendor's code known }
                   fnd:=False;
                   reset(f);
                   REPEAT
                   readln(f,s);
                   p:=pos('#',s);
                   if p>0 then s[0]:=chr(p-1);
                   p:=pos(' ',s);
                   if p=0
                    then suBs:=''
                    else begin
                         subS:=copy(s,1,p-1);
                         if pos(subs,ts)=1
                          then begin
                               fnd:=true;
                               writeln(ts,' ',objName,' -',s);
                               end;
                         end;

                   UNTIL eof(f) or fnd;

                   if (NOT fnd)
                    then begin
                         PleaseMail:=true;
                         writeln(ts,' ',objname,' -????');
                         end;

                   end;
             end;
          end;
    end;

IF PleaseMail
 then begin
      writeln;
      writeln('A number of unknown Vendor codes have been found.');
      writeln('If you know the vendor(s) of the Ethernet cards in question,');
      writeln('you can update the VEND_XXX. file with a text editor.');
      writeln;
      writeln('You are also kindly requested to mail the information to us.');
      writeln('Fido    : 2:512/250.4064 or 2:2426/4030.13');
      writeln('InterNet: Rene.Spronk@p4064.f250.n512.z2.fidonet.org');
      writeln;
      end;

SetPreferredConnectionId(0);
close(f);
end.