'  -- TERM_IO.BAS --
'
'  This program is donated to the Public
'  Domain by MarshallSoft Computing, Inc.
'  It is provided as an example of the use
'  of the Personal Communications Library.
'
$CPU 8086          'make compatible with XT systems
$LIB ALL OFF       'turn off all PowerBASIC libraries
$ERROR ALL OFF     'turn off all PowerBASIC error checking
$OPTIMIZE SIZE     'optimize for smaller code
$COMPILE UNIT      'compile to a UNIT (.PBU)

DEFINT A-Z

$INCLUDE "PCL4PB.BI"
$INCLUDE "TERM_IO.BI"
$INCLUDE "ARRAYS.BI"

%CAN = 24

DIM StartCol AS SHARED INTEGER
DIM EchoFlag AS SHARED INTEGER

'** set / clear message echo flag

SUB MsgEcho(BYVAL Flag AS INTEGER) PUBLIC
EchoFlag = Flag
END SUB

'** match baud rate string

FUNCTION MatchBaud(BaudString AS STRING) PUBLIC AS INTEGER

  MatchBaud = -1
  IF BaudString$ = "300" THEN MatchBaud = 0
  IF BaudString$ = "600" THEN MatchBaud = 1
  IF BaudString$ = "1200" THEN MatchBaud = 2
  IF BaudString$ = "2400" THEN MatchBaud = 3
  IF BaudString$ = "4800" THEN MatchBaud = 4
  IF BaudString$ = "9600" THEN MatchBaud = 5
  IF BaudString$ = "19200" THEN MatchBaud = 6
  IF BaudString$ = "38400" THEN MatchBaud = 7
  IF BaudString$ = "57600" THEN MatchBaud = 8
  IF BaudString$ = "115200" THEN MatchBaud = 9

END FUNCTION

'** Transmits CAN's **

SUB TxCAN(BYVAL Port AS INTEGER) PUBLIC

  DIM I AS INTEGER
  DIM Code AS INTEGER

  FOR I = 1 TO 6
    Code = SioPutc(Port,%CAN)
  NEXT I

END SUB

'** read message form line 25 **

SUB ReadMsg(MsgString       AS STRING,  _
            BYVAL StartCol  AS INTEGER, _
            BYVAL MaxLength AS INTEGER) PUBLIC

  DIM I      AS INTEGER
  DIM Row    AS INTEGER
  DIM Col    AS INTEGER
  DIM AnyKey AS STRING

  I = 0
  Row = CSRLIN
  Col = POS(0)
  VIEW TEXT (1,25) - (80,25)
  COLOR 1
  MsgString$ = ""

  'input text from user
  LOCATE 1, StartCol, 1
  DO
    AnyKey$ = INKEY$
    IF AnyKey$ <> "" THEN
      SELECT CASE LEFT$(AnyKey$, 1)
        CASE CHR$(13)
          COLOR 7
          VIEW TEXT (1,1) - (80,24)
          LOCATE Row, Col, 1
          EXIT SUB
        CASE CHR$(27)  'Escape
          'return empty string
          MsgString$ = ""
          COLOR 7
          VIEW TEXT (1,1) - (80,24)
          LOCATE Row, Col, 1
          EXIT SUB
        CASE CHR$(8) 'backspace
          'back up if can
          IF I > 0 THEN
            'adjust buffer
            I = I - 1
            MsgString$ = LEFT$(MsgString$, LEN(MsgString$) - 1)
            'write blank at cursor
            LOCATE 1, StartCol + I, 1
            PRINT " ";
            LOCATE 1, StartCol + I, 1
          END IF
        CASE ELSE 'not one of above special chars
          'display on bottom line
          LOCATE 1, StartCol + I, 1
          PRINT AnyKey$;
          'save character
          I = I + 1
          MsgString$ = MsgString$ + AnyKey$
          'done ?
          IF I >= MaxLength THEN
            VIEW TEXT (1,1) - (80,24)
            COLOR 7
            LOCATE Row, Col, 1
            EXIT SUB
          END IF
      END SELECT
    END IF
  LOOP

END SUB

'** write onto line 25

SUB WriteColMsg(MsgString AS STRING, _
          BYVAL StartCol  AS INTEGER) PUBLIC

  DIM Row    AS INTEGER
  DIM Col    AS INTEGER
  DIM AnyKey AS STRING

  IF EchoFlag THEN
    PRINT MsgString
  END IF
  ' save screen row & col
  Col = POS(0)
  Row = CSRLIN
  ' set view at line 25
  VIEW TEXT (1,25) - (80,25)
  COLOR 1
  LOCATE 1, StartCol, 1
  PRINT STRING$(39," ");
  LOCATE 1, StartCol, 1
  PRINT MsgString;
  ' back to main screen
  VIEW TEXT (1,1) - (80,24)
  COLOR 7
  LOCATE Row, Col, 1

END SUB

SUB WriteMsg(MsgString AS STRING) PUBLIC
StartCol = 40
CALL WriteColMsg(MsgString,StartCol)
END SUB

SUB WriteIntMsg(MsgString AS STRING, _
                BYVAL IntVal AS INTEGER) PUBLIC
DIM Temp AS STRING
Temp = MsgString + STR$(IntVal)
CALL WriteMsg(Temp)
END SUB

SUB WriteHexMsg(MsgString   AS STRING, _
                BYVAL IntVal AS INTEGER) PUBLIC
DIM Temp AS STRING
Temp = MsgString + HEX$(IntVal)
CALL WriteMsg(Temp)
END SUB

SUB WriteLongMsg(MsgString AS STRING, _
                BYVAL  LongVal  AS LONG) PUBLIC
DIM Temp AS STRING
Temp = MsgString + STR$(LongVal)
WriteMsg(Temp)
END SUB

SUB WriteCPS(BYVAL StartTics AS LONG, _
             BYVAL FileBytes AS LONG, _
                   Filename() AS BYTE, _
             BYVAL Skipped   AS INTEGER) PUBLIC
 DIM CPS AS INTEGER
 DIM Tics AS LONG
 DIM Secs AS LONG
 DIM Temp AS STRING
 IF Filename(0) = 0 THEN EXIT SUB
 IF NOT Skipped THEN
    Secs = (SioTimer - StartTics) \ 18
    IF Secs > 0 THEN CPS = (FileBytes \ Secs)
 ELSE
    Skipped = 1
 END IF
 CALL Array2String(Filename(),Temp)
 IF Skipped THEN
    Temp = Temp + " skipped (" + STR$(FileBytes) + " bytes)"
 ELSE
    Temp = Temp + " transfered @ " + STR$(CPS) + " CPS (" + STR$(FileBytes) + " bytes)"
 END IF
 PRINT Temp
END SUB


FUNCTION FetchName(TheFile AS STRING) PUBLIC AS INTEGER
  DIM TheLen AS INTEGER
  TheLen = LEN(TheFile)
  IF TheLen = 0 THEN
    CALL WriteMsg("Enter filename: ")
    CALL ReadMsg(TheFile, 55, 20)
    FetchName = LEN(TheFile)
  ELSE
    FetchName = TheLen
  END IF

END FUNCTION