
//
// Program:     STRUCT C/C++ code organizator.   
//
// Author:      Ahmet Emre (CompuServe #100335,2771)
//
// Purpose:     If you are C/C++ programmer and suffering from different
//              tab settings of different programmers and editors, this
//              program is what you want. This program erases tab characters
//              and inserts blank spaces to beginning of each line according
//              to nested braces like { and }. Main purpose of this program
//              is to make your sources more readable.              
//
// Copyright:   Copyright 1995, The Hekla Information Society, All Rights Reserved.
//
// Version:     Version 1.0 for DOS.
// 
// Shareware:   This program is ShareWare. There is no charge on using or
//              copying this program.
//
// Distribution:You may distribute this program unmodified as long as all
//              accompanying documentation and notes are also distributed.
//
// Disclaimer:  This program is provided as is with no implied or express
//              warranties.  You should test this class for your particular
//              use on non-critical data before using it in a production
//              system.
//          

#include <stdio.h>  
#include <stdlib.h>
#include <ctype.h>
#include <string.h>    
#include <dos.h>

#define MAX_LINE_SIZE   500

FILE *in,*out;

int spaceno=4; // number of spaces to insert (default is 4)
int ob,colptr=0,
araprev, arabra; // 1 if brackets in the middle of line.

char inname[100];
char outname[15]="$BJK1903.$$$";

char buffer[MAX_LINE_SIZE];     
char outbuffer[MAX_LINE_SIZE];     


//+ Function : void OutFileWrite(char c)
//+ Purpose  : writes to temporary output file.
//+ Input    : char c  : current processing character.
//+ Output   : none.

void OutFileWrite(char c)
{
    char finalbuffer[MAX_LINE_SIZE];
    int cp;
    
    memset(finalbuffer,' ',MAX_LINE_SIZE);  
    
    if (ob>0 && (c=='{' || c=='}'))
    {
        sprintf(finalbuffer+colptr,"%s",outbuffer);
        fprintf(out,"%s\n",finalbuffer);
        memset(outbuffer,'\0',MAX_LINE_SIZE);
    }
    
    if (c=='}') 
    {
        colptr -= spaceno;
        sprintf(outbuffer,"}");    
        if (colptr < 0) colptr=0;
    }
    
    if (arabra) cp=araprev;
    else cp=colptr;
    
    
    if (c=='{') 
    {
        sprintf(outbuffer,"{");  
        cp=colptr;
        colptr += spaceno;
    }
    
    memset(finalbuffer,' ',MAX_LINE_SIZE);  
    
    sprintf(finalbuffer+cp,"%s",outbuffer);
    fprintf(out,"%s\n",finalbuffer);
    
}


//+ Function : int ccopy(char *from,char *to)
//+ Purpose  : Copies files. Use this instead of escaping to the shell for
//+            the copies.
//+ Input    : char *from : Source file name. NULL terminated.
//+            char *to   : Target file name. NULL terminated.
//+ Output   : Returns : 0 : No error.
//+                      else : various errors.

int ccopy(char *from,char *to)
{
    FILE *f,*t;  
    long sz;
    int rc;
    
    f = fopen(from,"rb");
    if (f==NULL) return(11);
    t = fopen(to,"wb");
    if (t==NULL) return(12);
    fseek(f,0L,SEEK_END);
    sz = ftell(f);
    fseek(f,0L,SEEK_SET);
    
    while (sz > 0)
    {
        if (sz > 512)
        rc = 512;
        else    rc = sz;
        sz -= rc;
        if (1 != fread(&buffer,rc,1,f)) return(21);
        if (1 != fwrite(&buffer,rc,1,t)) return(22);
    }
    if (fclose(t)) return(31);
    if (fclose(f)) return(32);
    return(0);
}

//+ Function : char *FindPath(char *s)
//+ Purpose  : analyzes a string and finds path by excluding filename.
//+ Input    : char *s  : string to be searched.
//+ Output   : return a pointer to the string pointing the path.

char *FindPath(char *s)
{
    char *pdest;
    int result;
    char buf[100];
    
    pdest = strrchr( s, '\\' );
    result = pdest - s + 1;
    if( pdest != NULL )
    {
        memcpy(buf,s,result);
        buf[result]='\0';  
        strupr(buf);        
        return (buf);
    }
    else   
    return NULL;
}

//+ Function : int GetParameter(char *c)
//+ Purpose  : get argument if entered.
//+ Input    : char *s  : string to be searched.
//+ Output   : return : 1 : invalid argument.
//+                   : 0 : Ok.

int GetParameter(char *c)
{
    int prm;
    if (c[0] != '-' && c[0] != '/') return 1;
    if (strlen(c) != 3 && strlen(c) != 2 ) return(1); // err
    if (strlen(c) <= 2 && !isdigit(c[1])) return(1);
    if (strlen(c) == 3 && !isdigit(c[2])) return(1);
    sscanf(c+1,"%d",&prm);    
    if (prm>20) return(1);
    spaceno=prm;
    return (0);
}

void Error()
{
    printf("Usage:\n");
    printf("\tstruct {path}filename {-arg}\n\n");
    printf("\tThe filename parameter may use DOS wildcard \n");
    printf("\t\tcharacters (* and ?).\n");
    printf("\targ is unit number of spaces to insert each \n");
    printf("\t\tline. Default is 4 and maximum is 20 allowed.\n\n"); 
    printf("\tExamples:\n");
    printf("\t\tstruct c:\\myproj\\*.c\n");
    printf("\t\tstruct \\myproj\\ket*.c -5\n");
    printf("\t\tstruct \\myproj\\ketpcmn.c /10\n");
    
    exit(2);
}

int main(int argc,char *argv[])
{
    
    int kk, sts, cnt=0,
    pp,   
    cmt1, // comment like /* */
    cmt2, // comment like //
    sqm,  // single quotation mark              
    dqm;  // double quotation mark                
    char path[100];  
    
    struct _find_t  c_file;
    
    printf("\nStruct Version 1.0, C/C++ Structure Organizator\n");
    printf("The Hekla Information Society, 1995\n"); 
    printf("Ahmet Emre, CompuServe #100335,2771\n");
    printf("Shareware, Feel free to distribute\n\n");
    
    strcpy(path,FindPath(argv[1]));
    
    if (argc==3 && GetParameter(argv[2]) || argc <2 ) Error();    
    if (argc==2 && (argv[1][0]=='-' || argv[1][0]=='/')) Error();
    
    
    sts=_dos_findfirst( argv[1], _A_NORMAL, &c_file );
    
    while(!sts)
    {
        strcpy(inname,path);
        strcat(inname,c_file.name);    
        printf("Struct: %s ",inname);
        in = fopen(inname,"r");        
        if (in == NULL) 
        {
            printf("\nCannot open input file: %s",inname);
            exit(1);
        }
        out = fopen(outname,"w");
        if (out == NULL) 
        {
            printf("\nCannot open output file.");
            fclose(in);
            exit(1);
        }
        colptr=0;        
        cmt1=0;                 
        while( fgets( buffer, MAX_LINE_SIZE, in ) != NULL)
        {
            ob=0; /* out buffer counter */
            pp=cmt2=sqm=dqm=arabra=0;
            araprev=colptr;
            memset(outbuffer,'\0',MAX_LINE_SIZE);
            
            for (kk=0; buffer[kk] != '\0'; kk++)
            {
                if (buffer[kk]=='/' && buffer[kk+1]=='*' && cmt2==0) // comment begin
                cmt1=1;
                if (buffer[kk]=='/' && buffer[kk+1]=='/') // comment 
                cmt2=1;
                if (buffer[kk]=='*' && buffer[kk+1]=='/' && cmt2==0) // comment end
                cmt1=0; 
                if (buffer[kk]=='\'') // single quotation mark
                {
                    if((kk==1 && buffer[kk-1] == '\\' ) ||
                    (kk>1 && buffer[kk-2] != '\\' && buffer[kk-1] == '\\')); 
                    else
                    if (sqm) sqm=0;
                    else sqm=1;
                }
                if (buffer[kk]=='\"') // double quotation mark            
                {
                    if((kk==0 && buffer[kk-1] =='\\') ||
                    (kk>1 && buffer[kk-2] != '\\' && buffer[kk-1] == '\\')); 
                    else
                    if (dqm) dqm=0;
                    else dqm=1;
                }
                if ((buffer[kk] =='\t' && ob==0) ||
                buffer[kk] =='\n' ||
                buffer[kk] =='\r' || 
                buffer[kk] =='\f' || 
                buffer[kk] == ' ' && ob==0 && cmt1==0  ) ;
                else
                {
                    if (buffer[kk]=='\t') buffer[kk]=' '; // fill space instead of tab
                    
                    if (!(sqm || dqm || cmt1 || cmt2))
                    {
                        if (buffer[kk]=='{' && ob>0) 
                        {
                            colptr += spaceno;  
                            arabra=1;             
                        }
                        if (buffer[kk]=='}' && ob>0) 
                        {
                            colptr -= spaceno;  
                            if (colptr < 0) colptr=0;
                            arabra=1;             
                        }
                    }
                    
                    if ((buffer[kk] != '{' && buffer[kk] != '}')
                    || cmt1 || cmt2 || sqm || dqm || arabra ) 
                    {
                        outbuffer[ob]=buffer[kk];
                        ob++;            
                        pp=0;
                    }
                    else 
                    {
                        OutFileWrite(buffer[kk]);              
                        memset(outbuffer,'\0',MAX_LINE_SIZE);
                        ob=0;
                        pp=1; // parantez islendi..
                    }
                }
                
            }
            if (pp==0) OutFileWrite(' '); 
        }
        
        fclose(in);
        fclose(out);
        if (ccopy(outname,inname)) 
        {
            printf("Error in copy from %s to %s",outname,inname);        
        }
        else cnt++;
        printf("\n");
        sts=_dos_findnext( &c_file );
        
    }
    remove(outname);
    
    if (cnt==0) printf("\nNo source found to struct.\n");
    else if (cnt==1)printf("\n1 source has been structed with %d spaces\n",spaceno);
    else printf("\n%d sources has been structed with %d spaces\n",cnt,spaceno);
    
    return(0);                      
    
}

