// These packing routines are based on the LZHUF.C program by
// Haruyasu Yoshizaki. Copyright (C) 1995 Christian Worm.

#ifndef UNPACK
#define UNPACK

#include <packint.hpp>
#include <huffman.hpp>

// En klasse der bruges til at lse bit for bit
class bitread {
  char buffer[FILEBUFLEN];
  int bufbyteofs,bytesback;
  char bufbitofs;

  public:
  signed char readbit(); // -1 ved EOF

  void initread();
  virtual int read(char* buffer, int bufsize)=0;
};

// En simpel buffer klasse til at skrive byte for byte
class bytewrite {
  char buffer[FILEBUFLEN];
  unsigned bufbyteofs;

  public:
  void putbyte(unsigned char byte);

  void initwrite() { bufbyteofs=0; }
  void flushbuf();

  virtual void write(char* buffer, int bufsize)=0;
  // Kaldes nr et antal bytes er parat
};

class unpack_huffman:base_huff,public bitread {
  public:
  base_huff::inithuff;

  int getcode();
};

// Bruger interface:
class decode:unpack_huffman,bytewrite {
  unsigned char ascbuf[BUFSIZE];

  int getpos(); // Returnerer -1 ved EOF

  public:

  void do_decode();
};

#endif
