; These packing routines are based on the LZHUF.C program by
; Haruyasu Yoshizaki. Copyright (C) 1995 Christian Worm.

include ctrl\packint.ah
include bufferio\bufbitwr.ah

pack_text segment

bitwrite_done proc
  write_buffer:
  mov si,offset bw.bwbuf ; ES:SI=Offset p buffer
  mov dx,bw.bwbyteofs
  sub dx,offset bw.bwbuf ; DX=Antal hele bytes der indtil nu er
  cmp bw.bwbitofs,0      ; Er der ogs nogle bits?
  jz all_god             ; Hvis nej, s hop
  inc dx                 ; Ellers: Skriv en byte mere
  all_god:

  call user_write        ; Skriv til bufferen
  cmp ax,0               ; Er der sket en fejl?
  jnz file_error         ; S hop
  clc
  ret                    ; Returner at der ingen fejl er.
  file_error:
  stc
  return:
  ret                    ; Returner fejl
endp

; Flgende nulstiller bufferen:
reset_buf macro startofs
  mov di,offset bw.bwbuf+startofs
  xor ax,ax
  mov cx,(bitwrite_bufsize-startofs) shr 1
  rep stosw
endm

  flush:
  ; Skriv det der er at skrive:
  push ax
  push cx
  mov si,offset bw.bwbuf    ; ES:SI=Offset p buffer
  mov dx,bitwrite_bufsize-2 ; Skriv bufferens strelse excl sidste word
  call user_write           ; Skriv til bufferen
  cmp ax,0                  ; Er der sket en fejl?
  jnz file_error            ; S hop
  ; Flyt det af det der er af det sidste word ned i starten af bufferen:
  mov ax,word ptr bw.bwbuf[bitwrite_bufsize-2] ; AX=Det sidste word
  mov word ptr bw.bwbuf,ax                     ; St wordet ned i starten
  mov cx,bw.bwbyteofs
  sub cx,offset bw.bwbuf+bitwrite_bufsize-2 ; CX=Bytes vi er get over bufferen
  shl cx,3
  add cl,bw.bwbitofs ; CX=Bits vi er get udover bufferen
                     ; Skriv nu vores nye byte og bit offset
  mov ax,cx
  and cx,111b
  shr ax,3
  add ax,offset bw.bwbuf
  mov bw.bwbyteofs,ax
  mov bw.bwbitofs,cl
  ; Rest nu vores buffer:
  reset_buf 2
  pop cx
  pop ax

  ; Fortst nu.

write_bits proc near
  mov si,bw.bwbyteofs ; SI=Offset i bufferen

  cmp si,offset bw.bwbuf+bitwrite_bufsize-2 ; Har SI net slutningen?
  jae flush                                 ; S skriv bufferen

  mov dx,ax          ; DX=AX=Det vi skal skrive
  mov cl,bw.bwbitofs ; CL=Offset vi skal skrive til
  shl ax,cl          ; AX=Frste word - CL bits
  mov bh,ch          ;    Gem CH
  or [si],ax         ; Skriv det nye
  ; Vi har nu skrevet 16-CL bits og skal skrive CH bits i alt
  ; Vi mangler derfor at skrive CH-(16-CL) bits = CH-16+CL:
  sub ch,16          ; -CH=Antal bits der er skrevet
  add ch,cl          ;  CH=Antal bits vi mangler at skrive
  jge we_miss        ; Hop hvis vi mangler at skrive noget

  ; Opdater vores variabler:
  ; Vi mangler at skrive -CH bits i at SI skal forges med 2
  add ch,16           ; S mange bits skal vi g frem
  mov cl,ch
  shr cl,3            ; CL=Skal adderese til SI
  and ch,111b         ; CH=Skal lgges i bw.bitofs
  mov bw.bwbitofs,ch
  xor ch,ch
  add bw.bwbyteofs,cx ; St nye byte offset
  clc
  ret                 ; Returner at der ingen fejl er

  we_miss:
  ; Det hele blev ikke skrevet.
  ; Vi skal skrive CH bits mere             (CH<8)
  ; Disse bits er i DX startende ved bit BH (BH>8)
  mov cl,bh           ; CL=Bit offset p sidste byte
  sub cl,ch           ; CL=Bit offset p den bit vi skal bruge
  shr dx,cl           ; St DX
  add si,2            ; St SI til dets nye sted
  or [si],dl          ; Og skriv det nye
  mov bw.bwbyteofs,si ; Gem vores nye bytes postion
  mov bw.bwbitofs,ch  ; Gem vores nye bit position
  clc
  ret                 ; Returner at der ingen fejl er.
endp

bitwrite_init proc near
  ; Initer de forskellige variabler - angiv at vi starter i starten:
  mov bw.bwbitofs,0
  mov bw.bwbyteofs,offset bw.bwbuf

  reset_buf 0 ; Og nulstil vores buffer som vi or'e ind i.

  ret
endp

ends
end
