#include <pc.h>
#include <stdio.h>
#include "gccint8.h"

void            main(void)
{
    int             i;
    unsigned long int tick_1,
                    tick_2,
                    elapsedtime;

    printf("\nInitialize PCTIMER: init8h(1000), millisecond precision timing.\n");
    printf("Press any key to continue.\n");
    getkey();
    init8h(1000);
    ticks_8h = 0;

    printf("\nTest delay8h function: delay8h(2000), delay 2000 milliseconds (2 seconds).\n");
    printf("Press any key to begin.\n\n");
    getkey();
    tick_1 = ticks_8h;
    delay8h(2000);
    tick_2 = ticks_8h;
    printf("int8h ticks=%U\n", (tick_2 - tick_1));
    elapsedtime = time8h(tick_1, tick_2);
    printf("int8h ms=%U\n", elapsedtime);

    printf("\nTest sound8h function: sound8h(800, 300), Generate a 800 Hz sound for 300 ms.\n");
    printf("Press any key to begin.\n");
    getkey();
    sound8h(800, 300);

    printf("\nFive trials of measuring reaction times.\n");
    printf("Press any key to begin.\n");
    getkey();

    for (i = 0; i < 5; i++) {
        tick_1 = ticks_8h;
        printf("\nPress any key to stop timer.\n");
        getkey();
        tick_2 = ticks_8h;
        printf("int8h ticks=%U\n", (tick_2 - tick_1));
        elapsedtime = time8h(tick_1, tick_2);
        printf("int8h ms=%U\n", elapsedtime);
    }

    quit8h();
}
