/***********************************************************************

                                       CSA Library, Release 1.5.d 

       Defining the PANEL class.

                                          Copyright(c) 1994,1995 
                                          Combis 
                                          The Netherlands   
***********************************************************************/

#ifndef __CSPANEL_H
#define __CSPANEL_H


#ifndef __CSWINDOW_H
  #include "cswindow.h"
#endif
#ifndef __CSFIELD_H
  #include "csfield.h"
#endif

#define MAX_FIELDS  35
#define mod_field  field()




class PANEL: public WINDOW
{
private:

   int num_field;
   int exitkey;
   int use_exit_f;
   int esc_allow;
   int fieldcolor;
   int is_changed;

   FIELD *fields[MAX_FIELDS+1];   // pointers to the fields

protected:
   int calc_changed(void);
   int add_field(int r,int k,int le,FIELD *fpp);


////////////////////////////////////////////////////////////////////////
////////////////////// PUBLIC FUNCTIONS ////////////////////////////////
////////////////////////////////////////////////////////////////////////

public:


/////////////////////// Adding a field /////////////////////////////////
   int add_field(int r,int k,CSCHAR *s) { return add_field(r,k,strlen(s),s); }
   int add_field(int r,int k,int le,CSCHAR *s) ;
   int add_field(int r,int k,int dl,int ml, CSCHAR *s) ;
   int add_field(int r,int k,int le,CSCHAR &ch) ;
   int add_field(int r,int k,int le,int &i) ;
   int add_field(int r,int k,int le,long &l) ;
   int add_field(int r,int k,int le,float &t) ;
   int add_field(int r,int k,int le,double &d) ;
   int add_field(int r,int k,int le,DATE &d) ;
   int add_field(int r,int k,DATE &d) { return add_field(r,k,d.long_year()*2+8,d); }



/////////////////////// Read & Edit ////////////////////////////////////
   int read(void);

//////////////////////// Display ///////////////////////////////////////
   void display(void);

//////////////////////// Update panel //////////////////////////////////
   void recreate(void);

//////////////////////// Changed? //////////////////////////////////////
   int changed(void)		      { return is_changed; }

//////////////////////// FIELD pointer /////////////////////////////////
   FIELD& field(void)		      { return field(num_field-1); }
   FIELD& field(int num)	      { return *fields[num]; }


//////////////////////// Defining the panel ////////////////////////////
   void protect(int ebd);
   void protect(int field,int ebd);
   void exit_key(int tf)	      { exitkey=tf; }
   void exit_field(int num,int tf);
   void exit_field(int tf)	      { exit_field(num_field-1,tf); }
   void escape_off(void)	      { escape(FALSE); }
   void escape_on(void) 	      { escape(TRUE); }
   void escape(int tf)		      { esc_allow=tf; }


/////////////////////////Remove panel from screen //////////////////////
   void remove(void);


///////////////////////// Setting colors ///////////////////////////////
   void field_color(int c)	      { fieldcolor=c; }
   int	field_color(void)	      { return fieldcolor; }
   void color(int borc,int scrc,int fiec)
				      { border_color(borc);
					screen_color(scrc);
					field_color(fiec);
				      }


///////////////////////// Con&Des-structor /////////////////////////////
   PANEL(void);
   ~PANEL(void);

};



#endif
