/***********************************************************************

                                       CSA Library, Release 1.5.d 

       HEAP class, for allocating memory in chunks of
       about 2 kB instead of allocating many small
       blocks.

                                          Copyright(c) 1994,1995 
                                          Combis 
                                          The Netherlands   
***********************************************************************/

#ifndef __CSHEAP_H
#define __CSHEAP_H

#include "stdio.h"
#include "cstools.h"
#include "cstypes.h"

class HEAP
{
   U16 size;	// Chunck size
   U16 nr;	// Number of allocations in a page.
   U16 rs;	// Real chunk size;
   U16 pasi;	// Page size;
   U32 nrbl;	// Number of Blocks allocated.
   U16 is_open;

   void *np;	// Next page
   void *fp;	// Chain of full pages.

   typedef struct
   {
     void *n;	// next page
     void *p;	// prev page
     void *e;	// empty chain
     U16  count;// number available
   } pahe;	// Page HEader


protected:
   void connect(void *l,void *r);
   void *new_page(void);
   void unchain(void *&chain,void *p);
   void head_chain(void *&chain,void *p);
   void zap2(void );

public:

   ~HEAP(void) { if (is_open) close(); }
   HEAP(void)  { is_open=FALSE; fp=np=NULL; nrbl=0; size=0; }

////////////////////// Compatibility functions //////////////////////////
   void vfree(void *p) { free(p); }
   void *vmalloc(void) { return malloc(); }


////////////////////// Init/Creation ////////////////////////////////////
   void init(U16 s,U16 page_size=2048);

////////////////////// Open/Close ///////////////////////////////////////
   void close(void);
   int	open(void);

////////////////////// Malloc/Free //////////////////////////////////////
   void free(void *);
   void *malloc(void);


   void empty(void );
   void zap(void );
   U32	blocks(void) { return nrbl; }
   void report(FILE *fp,int sub);


};


#endif
