/***********************************************************************

                                      CSDB Library, Release 1.5.d 

       A simple class to overcome problems with
       file names.

                                          Copyright(c) 1994,1995 
                                          Combis 
                                          The Netherlands   
***********************************************************************/

#ifndef __CSFILE_H
#define __CSFILE_H


#ifndef __DIR_H
  #include <dir.h>
#endif
#ifndef __STRING_H
  #include <string.h>
#endif
#ifndef __STDIO_H
  #include <stdio.h>
#endif

#ifndef __CSTOOLS_H
  #include "cstools.h"
#endif
#ifndef __CSEDSTR_H
  #include "csedstr.h"
#endif


class FILE_NAME
{

private:
  STR fn;      // user input UNCHANGED
  STR direc;   // default path	( including DRIVE)
  STR exten;

protected:
  void combine(void);

////////////////////////////////////////////////////////////////////////
////////////////////// PUBLIC FUNCTIONS ////////////////////////////////
////////////////////////////////////////////////////////////////////////


public:
  void set_dir(CSCHAR *s);
  void set_name(CSCHAR *s)    { fn=s; set_dir_cur(); }
  int  exist(void)	      { return file_exist(name_dpfe()); }
  int  file_delete(void)      { return remove(name_dpfe()); }
  CSCHAR *name(void)	      { return ((CSCHAR *)fn); }

  void set_ext(CSCHAR *s);
  void set_dir_cur(void);
  void del_ext(void);
  CSCHAR *extension(void)     { return exten; }

  void force_ext(CSCHAR *s)   { del_ext(); set_ext(s); }

  CSCHAR *name_dpfe(CSCHAR *n);
  CSCHAR *name_dp(CSCHAR *n);
  CSCHAR *name_dpf(CSCHAR *n);
  CSCHAR *name_pfe(CSCHAR *n);
  CSCHAR *name_pf(CSCHAR *n);
  CSCHAR *name_fe(CSCHAR *n);
  CSCHAR *name_f(CSCHAR *n);
  CSCHAR *name_e(CSCHAR *n);
  CSCHAR *name_p(CSCHAR *n);
  CSCHAR *name_d(CSCHAR *n);

  CSCHAR *name_dpfe(void);
  CSCHAR *name_dp(void);
  CSCHAR *name_dpf(void);
  CSCHAR *name_pfe(void);
  CSCHAR *name_pf(void);
  CSCHAR *name_fe(void);
  CSCHAR *name_f(void);
  CSCHAR *name_e(void);
  CSCHAR *name_p(void);
  CSCHAR *name_d(void);


  int operator==(FILE_NAME& fn);

  FILE_NAME(void);



};


#endif
