#include "ctype.h" 
#include "csa.h" 
#include "csdb.h" 

#define NAME_LENGTH	 40 
#define ADRE_LENGTH	 32 
#define CITY_LENGTH	 23 
#define COUNT_LENGTH	 32 
#define ZIP_LENGTH	 9 
#define TEL_LENGTH	 17 
#define RELATION_LENGTH	 10 
#define INFO_LENGTH	 70 

////////// Indexes to be used with the 'order()' function./////////////
#define UNSORTED	 0
#define NAME_INDEX	 1 
#define CITY_INDEX	 2 
#define BIRTH_INDEX	 3 
#define RELATION_INDEX	 4 

typedef struct 
{
   char   _name[NAME_LENGTH+1]; 
   char   _adre[ADRE_LENGTH+1]; 
   char   _city[CITY_LENGTH+1]; 
   char   _count[COUNT_LENGTH+1]; 
   char   _zip[ZIP_LENGTH+1]; 
   char   _tel[TEL_LENGTH+1]; 
   long   __update; 
   long   __birth; 
   char   _relation[RELATION_LENGTH+1]; 
   char   _info[INFO_LENGTH+1]; 
} record;

class NAM_foundation
{
 protected:

   record rec;
   record *recp;

   long current;
   int  dirty;
   int  is_open;


   void (NAM_foundation::*skip_fun)(int delta);
   void (NAM_foundation::*top_fun)(void);
   void (NAM_foundation::*bottom_fun)(void);
   int  (NAM_foundation::*search_fun)(void *k);

   TBASE  db;
   BTREEa in1;		//Index on field name  
   BTREEa in2;		//Index on field city  
   BTREEl in3;		//Index on field birth  
   BTREEa in4;		//Index on field relation  

   DATE  _update;
   DATE  _birth;

   void top0(void)	{ current=1; }
   void top1(void)	{ in1.min_dat(&current); }
   void top2(void)	{ in2.min_dat(&current); }
   void top3(void)	{ in3.min_dat(&current); }
   void top4(void)	{ in4.min_dat(&current); }

   void bottom0(void)	{ current=db.numrec(); }
   void bottom1(void)	{ in1.max_dat(&current); }
   void bottom2(void)	{ in2.max_dat(&current); }
   void bottom3(void)	{ in3.max_dat(&current); }
   void bottom4(void)	{ in4.max_dat(&current); }

   int  search0(void * )	{ return TRUE; } 
   int  search1(void *k)	{ return in1.search_dat_ge(k,&current); }
   int  search2(void *k)	{ return in2.search_dat_ge(k,&current); }
   int  search3(void *k)	{ return in3.search_dat_ge(k,&current); }
   int  search4(void *k)	{ return in4.search_dat_ge(k,&current); }

   void skip0(int delta)	{ current=max(min(current+delta,db.numrec()),1); }
   void skip1(int delta)	{ in1.skip_dat(delta,&current); }
   void skip2(int delta)	{ in2.skip_dat(delta,&current); }
   void skip3(int delta)	{ in3.skip_dat(delta,&current); }
   void skip4(int delta)	{ in4.skip_dat(delta,&current); }

   void in1_ins_tok(void *s)	{ in1.insert(s,&current); }
   void in1_del_tok(void *s)	{ in1.delet(s,&current); }

   void tokenize(char *s,void(NAM_foundation::*fun)(void *));

 public:

 //////////////////////////////// class constructor ////////////////////////////
   NAM_foundation(void); 

 //////////////////////////////// class destructor /////////////////////////////
   ~NAM_foundation(void)  { close(); }

 //////////////////////////////// current record number ////////////////////////
   long curr_rec(void)   { return current; }

 //////////////////////////////// define ///////////////////////////////////////
   void define(void);  

 //////////////////////////////// open & close ////////////////////////////////
   void open(void);  
   void close(void);  

 //////////////////////////////// delete //////////////////////////////////////
   int  is_delet(void)  { return db.is_delet(current); } 
   void undelet(void)   { db.undelet(current); }         
   void delet(void)     { db.delet(current); }           

 //////////////////////////////// number of records ///////////////////////////
   long numrec(void)         { return db.numrec(); } 

 //////////////////////////////// import/export ///////////////////////////////
   int  import(char *s);
   int  export(char *s);
   int  to_DBASE(char *s);

 //////////////////////////////// read/write current record ///////////////////

   void write_rec2(void);
   void write_rec(void) { if(dirty) write_rec2(); }

   void read_rec(void) 
   {
        recp=(record *)db.locate_rec(current); 
        rec=*recp; 
        _update.sem_jul(rec.__update); 
        _birth.sem_jul(rec.__birth); 
   }

 //////////////////////////////// reindexing //////////////////////////////////
   void reindex(void); 

 //////////////////////////////// append //////////////////////////////////////
   void append(void);        //Indexes are NOT updated.
   void append_blank(void);  //Indexes ARE updated.

 //////////////////////////////// pack ////////////////////////////////////////
   void pack(void);

 //////////////////////////////// set active index ////////////////////////////
   void order(int nr);    

 //////////////////////////////// relocating //////////////////////////////////
   int  skip(int del); 
   void bottom(void)     { write_rec(); (this->*bottom_fun)(); read_rec(); }  
   void top(void)        { write_rec(); (this->*top_fun)(); read_rec(); }  
   void search(void *k)  { write_rec(); if(!(this->*search_fun)(k)) bottom(); read_rec(); }
   void go_to(long n)    { write_rec(); current=max(min(n,db.numrec()),1); read_rec(); }

 /////////////////////////reading fields //////////////////////////////////////
    char * name(void)           { return rec._name; } 
    char * adre(void)           { return rec._adre; } 
    char * city(void)           { return rec._city; } 
    char * count(void)          { return rec._count; } 
    char * zip(void)            { return rec._zip; } 
    char * tel(void)            { return rec._tel; } 
    char * update(void)         { return (char *)_update; } 
    char * birth(void)          { return (char *)_birth; } 
    char * relation(void)       { return rec._relation; } 
    char * info(void)           { return rec._info; } 

 /////////////////////////writing fields //////////////////////////////////////
 // Note: when writing strings there are NO checks on the 
 //       length. A string which is longer then the definition 
 //       of the field indicates, will OVERWRITE other data!!     
 //   
    void   name(char *s)        { strcpy(rec._name,s); dirty=TRUE; } 
    void   adre(char *s)        { strcpy(rec._adre,s); dirty=TRUE; } 
    void   city(char *s)        { strcpy(rec._city,s); dirty=TRUE; } 
    void   count(char *s)       { strcpy(rec._count,s); dirty=TRUE; } 
    void   zip(char *s)         { strcpy(rec._zip,s); dirty=TRUE; } 
    void   tel(char *s)         { strcpy(rec._tel,s); dirty=TRUE; } 
    void   update(char *s)      { _update=s; dirty=TRUE; } 
    void   birth(char *s)       { _birth=s; dirty=TRUE; } 
    void   relation(char *s)    { strcpy(rec._relation,s); dirty=TRUE; } 
    void   info(char *s)        { strcpy(rec._info,s); dirty=TRUE; } 

};