PROGRAM PaginateTextFiles;
{------------------------------------------------------------------------------

                                REVISION HISTORY

v1.00 : 1993/07/14.  First public release.  DDA
v1.01 : 1993/10/22.  Now removes existing page breaks automatically.  DDA
v1.02 : 1995/02/24.  Now handles files longer than 65535 pages.  DDA
                     Changed parameter specification.  DDA
                     Improved error handling.  DDA

------------------------------------------------------------------------------}

USES Dos;
const
  progdesc = 'Paginate v1.02 - Free DOS utility: text file paginator.';

VAR SavedExitProc: Pointer;

procedure CustomExit; far;
{---- Always exit through here ----}
const
  author   = 'February 24, 1995. Copyright (c) 1995 by David Daniel Anderson - Reign Ware.';
  usage    = 'Usage:    Paginate <infile> <outfile> ##[:##]';
  where    = 'Where:    ##[:##]  = lines per ODD:EVEN pages.  If not specified, EVEN=ODD.';
  example  = 'Example:  Paginate draft.txt paged.doc 55:50';
var
  message: string[79];
begin
  ExitProc := SavedExitProc;
  if (ExitCode > 0) then begin
    writeln(progdesc);
    writeln(author);    writeln;
    writeln(usage);
    writeln(where);     writeln;
    writeln(example);   writeln;
  end;
  if ErrorAddr <> nil then
  begin
    writeln('An unanticipated error occurred, please contact DDA with the following data:');
    writeln('Address = ', Seg(ErrorAddr^), ':', Ofs(ErrorAddr^));
    writeln('Code    = ', Exitcode);
    ErrorAddr := nil;
  end
  else
    if (ExitCode > 0) and (ExitCode < 255) then begin
       case ExitCode of
         2 : Message := 'Wildcard characters (*,?) are not allowed in any parameter.';
         3 : Message := 'Input file "'+ParamStr(1)+'" doesn''t exist or cannot be opened.';
         4 : Message := 'Output file "'+ParamStr(2)+'" already exists or cannot be written to.';
         5 : Message := 'Non-numeric found in line specification: '+ParamStr(3);
       else  message := 'Unknown error.';
       end;
       writeln (#7, 'Error encountered, number ',ExitCode,':'); writeln (message);
    end;
end;

function fileexists(const filename:pathstr): boolean;
var
  attr: word;
  f   : file;
begin
  assign(f, filename);
  getfattr(f, attr);
  fileexists := (DOSerror = 0);
end;

procedure ParseCommandLine(var infile, outfile: text; var odd, even: word);
var count: byte;  VErr: integer;
    oddstr, evenstr: string[7];

begin
  if ParamCount <> 3 then halt(255);
  for count := 1 to 3 do
    if (Pos('*',ParamStr(count)) > 0) or (Pos('?',ParamStr(count)) > 0)
      then halt(2);
  oddstr := ParamStr(3);
  if Pos(':', oddstr) > 0 then
    begin
      evenstr := Copy(oddstr,1+Pos(':',oddstr), Length(oddstr)-Pos(':',oddstr));
      oddstr := Copy(oddstr,1,Pos(':',oddstr)-1);
    end
    else
      evenstr := oddstr;

  Val(oddstr, odd, VErr); if VErr <> 0 then halt(5);
  Val(evenstr, even, VErr); if VErr <> 0 then halt(5);

  if NOT fileexists(ParamStr(1)) then halt(3)
    else begin
      assign(infile, ParamStr(1));
      reset(infile); if (IOResult <> 0) then halt(3);
    end;

  if fileexists(ParamStr(2)) then halt(4)
    else begin
      assign(outfile, ParamStr(2));
      rewrite(outfile); if (IOResult <> 0) then halt(4);
    end;

  Writeln(progdesc);
  Writeln('Paginate is processing your data, specified as follows:');
  Writeln('Input (unpaged) file = ',ParamStr(1));
  Writeln('Output (paged) file  = ',ParamStr(2));
  Writeln('Lines per odd page   = ',Odd);
  Writeln('Lines per even page  = ',Even);
end;

procedure InsertFF(var infile, outfile: text; var oddLines, evenLines: word);
CONST
  FF = #12;  { the page break character }
VAR
  PageCopying,
  LinesCopied   : LongInt;
  LinesPerPage,
  LinesThisPage : Word;
  CurrLine      : String;
BEGIN
  PageCopying := 1;
  LinesCopied := 0;
  LinesPerPage := OddLines;
  LinesThisPage := 0;
  WHILE (NOT Eof(InFile)) DO
  BEGIN
    ReadLn(InFile,CurrLine);
    WHILE ((Pos(FF,CurrLine)) > 0) do delete(CurrLine,(pos(FF,CurrLine)),1);
    IF (LinesThisPage = LinesPerPage) THEN
    BEGIN
      CurrLine := FF + CurrLine;
      LinesThisPage := 0;
      Inc(PageCopying);
      IF ((PageCopying MOD 2) = 0) THEN
        LinesPerPage := EvenLines
      ELSE
        LinesPerPage := OddLines;
    END;
    WriteLn(OutFile,CurrLine);
    Inc(LinesThisPage);
    Inc(LinesCopied);
  END;
  Close(InFile);
  Close(OutFile);
  Write('Paginate created ',PageCopying,' pages out of ',LinesCopied);
  Writeln(' lines, the final page has ',LinesThisPage,' lines.');
END;

VAR
  InFile, OutFile: Text;
  OddLines, EvenLines: Word;

BEGIN  { main }
  SavedExitProc := ExitProc;
  ExitProc := @CustomExit;

  ParseCommandLine(InFile, OutFile, OddLines, EvenLines);
  InsertFF(InFile, OutFile, OddLines, EvenLines);
END.
