/*
 * Filename:	joytest.cpp
 * Author:	Robert Manley
 * Date:	Jan 9, 1995
 *
 * Copyright 1994 Robert J. Manley and Multi-Player Computer Adventures
 * All rights reserved.
 */

#include <stdlib.h>
#define INCL_DOSDEVICES
#define INCL_DOSDEVIOCTL
#define INCL_DOSMEMMGR
#include <os2.h>
#include <iostream.h>

#include "joyos2.h"

ostream &
operator << (ostream &os, const GAME_2DPOS_STRUCT &pos)
{
	os << pos.x << "," << pos.y;
	return os;
}

ostream &
operator << (ostream &os, const GAME_3POS_STRUCT &pos)

{
	os << pos.lower << "," << pos.centre << "," << pos.upper;
	return os;
}

istream &
operator >> (istream &is, GAME_3POS_STRUCT &pos)

{
	is >> pos.lower >> pos.centre >> pos.upper;
	return is;
}

int
main (int argc, char *argv[])
{
	APIRET			rc;
	HFILE			hGame;
	ULONG			action;
	ULONG			version;
	GAME_PARM_STRUCT	gameParms;
	GAME_CALIB_STRUCT	gameCalib;
	GAME_STATUS_STRUCT	gameStatus;
	ULONG			parmLen, dataLen;

	cout << "Advanced OS/2 Joystick Driver API Sample v0.2" << endl;
	cout << "Copyright 1994 Robert J. Manley and Multi-Player Computer Adventures" << endl;
	cout << endl;

	cout << "Opening device " << GAMEPDDNAME << endl << endl;
	rc = DosOpen(
		GAMEPDDNAME,
		&hGame,
		&action,
		0,
		FILE_READONLY,
		FILE_OPEN,
		OPEN_ACCESS_READONLY | OPEN_SHARE_DENYNONE,
		NULL);
	if (rc != 0)
	{
		cerr << "ERROR " << rc << ": Could not open device" << endl;
		exit(-1);
	}

	cout << "Getting device version" << endl;
	dataLen = sizeof(version);
	rc = DosDevIOCtl(
		hGame,
		IOCTL_CAT_USER,  GAME_GET_VERSION,
		NULL, 0, NULL,
		&version, dataLen, &dataLen);
	if (rc != 0)
	{
		cerr << "ERROR " << rc << ": Could not call IOCtl" << endl;
		exit(-1);
	}
	cout << "Version: " << hex << version << dec << endl << endl;

	cout << "Getting device parameters" << endl;
	dataLen = sizeof(gameParms);
	rc = DosDevIOCtl(
		hGame,
		IOCTL_CAT_USER,  GAME_GET_PARMS,
		NULL, 0, NULL,
		&gameParms, dataLen, &dataLen);
	if (rc != 0)
	{
		cerr << "ERROR " << rc << ": Could not call IOCtl" << endl;
		exit(-1);
	}

	if ((gameParms.useA == 0) && (gameParms.useB == 0))
	{
		cout << "No joysticks detected" << endl;
		DosClose(hGame);
		exit(0);
	}

#if 0 // version 0.2a method
	if (gameParms.useA)
		cout << "Joystick A in use" << endl;
	if (gameParms.useB)
		cout << "Joystick B in use" << endl;
#else
	if (gameParms.useA & GAME_USE_BOTH_NEWMASK)
		cout << "Joystick A in use" << endl;
	else if (gameParms.useA & GAME_USE_X_NEWMASK)
		cout << "Joystick Ax in use" << endl;
	else if (gameParms.useA & GAME_USE_Y_NEWMASK)
		cout << "Joystick Ay in use" << endl;

	if (gameParms.useB & GAME_USE_BOTH_NEWMASK)
		cout << "Joystick B in use" << endl;
	else if (gameParms.useB & GAME_USE_X_NEWMASK)
		cout << "Joystick Bx in use" << endl;
	else if (gameParms.useB & GAME_USE_Y_NEWMASK)
		cout << "Joystick By in use" << endl;
#endif
	cout << endl;

	cout << "Getting calibration values" << endl;
	dataLen = sizeof(gameCalib);
	rc = DosDevIOCtl(
		hGame,
		IOCTL_CAT_USER,  GAME_GET_CALIB,
		NULL, 0, NULL,
		&gameCalib, dataLen, &dataLen);
	if (rc != 0)
	{
		cerr << "ERROR " << rc << ": Could not call IOCtl" << endl;
		exit(-1);
	}
	if (gameParms.useA)
		cout << "Ax: " << gameCalib.Ax << "  Ay: " << gameCalib.Ay << endl;
	if (gameParms.useB)
		cout << "Bx: " << gameCalib.Bx << "  By: " << gameCalib.By << endl;
	cout << endl;

	cout << "Getting current joystick status" << endl;
	dataLen = sizeof(gameStatus);
	rc = DosDevIOCtl(
		hGame,
		IOCTL_CAT_USER, GAME_GET_STATUS,
		NULL, 0, NULL,
		&gameStatus, dataLen, &dataLen);
	if (rc != 0)
	{
		cerr << "ERROR " << rc << ": Could not call IOCtl" << endl;
		exit(-1);
	}
	if (gameParms.useA)
		cout << "A: " << gameStatus.curdata.A << endl;
	if (gameParms.useB)
		cout << "B: " << gameStatus.curdata.B << endl;
	cout << endl;

	cout << "Get joystick status at next button press" << endl;
	dataLen = sizeof(gameStatus);
	rc = DosDevIOCtl(
		hGame,
		IOCTL_CAT_USER, GAME_GET_STATUS_BUTWAIT,
		NULL, 0, NULL,
		&gameStatus, dataLen, &dataLen);
	if (rc != 0)
	{
		cerr << "ERROR " << rc << ": Could not call IOCtl" << endl;
		exit(-1);
	}
	if (gameParms.useA)
		cout << "A: " << gameStatus.curdata.A << endl;
	if (gameParms.useB)
		cout << "B: " << gameStatus.curdata.B << endl;
	cout << endl;

	cout << "Changing sampling rate to 1 Hz" << endl;
	gameParms.sampDiv = 32;
	parmLen = sizeof(gameParms);
	rc = DosDevIOCtl(
		hGame,
		IOCTL_CAT_USER,  GAME_SET_PARMS,
		&gameParms, parmLen, &parmLen,
		NULL, 0, NULL);
	if (rc != 0)
	{
		cerr << "ERROR " << rc << ": Could not call IOCtl" << endl;
		exit(-1);
	}
	cout << endl;

	cout << "Getting status until button 1 pressed" << endl << endl;
	for (;;)
	{
		dataLen = sizeof(gameStatus);
		rc = DosDevIOCtl(
			hGame,
			IOCTL_CAT_USER, GAME_GET_STATUS_SAMPWAIT,
			NULL, 0, NULL,
			&gameStatus, dataLen, &dataLen);
		if (rc != 0)
		{
			cerr << "ERROR " << rc << ": Could not call IOCtl" << endl;
			exit(-1);
		}

		if (gameStatus.b1cnt > 0)
			break;

		if (gameParms.useA)
			cout << "A: " << gameStatus.curdata.A << endl;
		if (gameParms.useB)
			cout << "B: " << gameStatus.curdata.B << endl;
		cout << "Button 2 count: " << gameStatus.b2cnt << endl;
	}
	cout << endl;
	
	cout << "Closing device" << endl;
	DosClose(hGame);
}
