/*
 * FM/2 2.x installation program copyright (c) 1994/95 by M. Kimes
 *
 * This program creates a folder to hold program objects,
 * then creates program objects for each executable.  It only needs to be
 * run once (unless you move the FM/2 directory -- see say notes at end).
 * It also calls MIGINI.CMD if it finds an old FM2.INI file to migrate
 * some information to the new version's FM3.INI file.  Run this program
 * in the FM/2 directory (where you unpacked the archive).
 *
 * For unattended installation, remove the lines marked with "NOTE:" below.
 */

/* see if we might be in the right directory... */

'@Echo off'
'cls'

say'     Ŀ'
say'                       FM/2 2.x Installation Program                    '
say'                  FM/2 is copyright (c) 1993-95 by M. Kimes             '
say'                            All rights reserved                         '
say'     Ĵ'
say'     Ĵ'
say'                     Have you read the READ.ME file yet?                '
say'             By running this program, you agree to the license          '
say'                          as specified in that file,                    '
say'           and it tells you how to install, so you should read it.      '
say'                                  Please?                               '
say'     '

/*
 * allow user to eliminate associations from being placed on AV/2.
 * seemed to upset some fellow on CIS (I guess he doesn't know about
 * Settings notebooks on WPS objects).
 */
assocfilter = ';ASSOCFILTER=*.ZIP,*.ARC,*.LZH,*.ARJ,*.ZOO,*.MO0,READ.ME,README,README.1ST,README.OS2,REGISTER.TXT'
existed = ''
parse upper arg dummy
if dummy = 'NOASSOC' then assocfilter = ''

rc = stream('fm3.exe','c','query exists')
if rc = '' then
do
  say 'Sorry, FM3.EXE not found.  Must not be right directory.  Terminating.'
  exit
end

/* tell user what we're doing, give him a chance to hit CTRL-C */

say ''
say 'This program creates objects for FM/2.'
say ''



/* NOTE:  remove following 3 lines for unattended use... */
say '  Press [Enter] to continue...'
pull dummy .
say ''


/* save current directory */

curdir = directory()

/* load rexx utility functions */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* say it, then do it */

say "Creating File Manager/2 folder and objects..."

/* first, create FM/2 folder */

title = "File Manager/2"
classname = 'WPFolder'
location = '<WP_DESKTOP>'
setup = 'OBJECTID=<FM3_Folder>;OPEN=DEFAULT'
result=SysCreateObject(classname,title,location,setup,f)

/* NOTE:  remove following 9 lines for unattended use... */
if result = 0 then
do
  assocfilter = ''
  existed = 'TRUE'
  say ''
  say 'The File Manager/2 folder already exists.'
  say 'Should I update the objects? (Y/n)'
  parse upper pull dummy
  if left(dummy,1) = 'N' then exit
  say ''
end

/* now, create program objects in FM/2 folder */

title = "FM/2"
classname = 'WPProgram'
location = '<FM3_Folder>'
setup = 'OBJECTID=<FM/2>;EXENAME='curdir'\FM3.EXE;STARTUPDIR='curdir
if existed = '' then setup = setup';PARAMETERS=%*'
call SysCreateObject classname,title,location,setup,u

rc = stream('av2.exe','c','query exists')
if rc \= '' then
do
  title = "Archive Viewer/2"
  classname = 'WPProgram'
  location = '<FM3_Folder>'
  setup = 'EXENAME='curdir'\AV2.EXE;STARTUPDIR='curdir''assocfilter
  if existed = '' then setup = setup';PARAMETERS=%*'
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('doicon.exe','c','query exists')
if rc \= '' then
do
  title = "SysIcon"
  classname = 'WPProgram'
  location = '<FM3_Folder>'
  setup = 'EXENAME='curdir'\DOICON.EXE;STARTUPDIR='curdir
  if existed = '' then setup = setup';PARAMETERS=%*'
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('eas.exe','c','query exists')
if rc \= '' then
do
  title = "EA Viewer"
  classname = 'WPProgram'
  location = '<FM3_Folder>'
  setup = 'EXENAME='curdir'\EAS.EXE;STARTUPDIR='curdir
  if existed = '' then setup = setup';PARAMETERS=%*'
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('ini.exe','c','query exists')
if rc \= '' then
do
  if assocfilter \= '' then assocfilter = ';ASSOCFILTER=*.INI'
  title = "INI Viewer"
  classname = 'WPProgram'
  location = '<FM3_Folder>'
  setup = 'EXENAME='curdir'\INI.EXE;STARTUPDIR='curdir''assocfilter
  if existed = '' then setup = setup';PARAMETERS=%*'
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('viewinfs.exe','c','query exists')
if rc \= '' then
do
  title = "Bookshelf Viewer"
  classname = 'WPProgram'
  location = '<FM3_Folder>'
  setup = 'EXENAME='curdir'\VIEWINFS.EXE;STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
  title = "Helpfile Viewer"
  classname = 'WPProgram'
  location = '<FM3_Folder>'
  setup = 'EXENAME='curdir'\VIEWINFS.EXE;PARAMETERS=DUMMY;STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('killproc.exe','c','query exists')
if rc \= '' then
do
  title = "Process Killer"
  classname = 'WPProgram'
  location = '<FM3_Folder>'
  setup = 'OBJECTID=<FM/2_KILLPROC>;EXENAME='curdir'\KILLPROC.EXE;PARAMETERS=%;STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('undel.exe','c','query exists')
if rc \= '' then
do
  title = "Undeleter"
  classname = 'WPProgram'
  location = '<FM3_Folder>'
  setup = 'OBJECTID=<FM/2_UNDEL>;EXENAME='curdir'\UNDEL.EXE;STARTUPDIR='curdir
  if existed = '' then setup = setup';PARAMETERS=%*'
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('vtree.exe','c','query exists')
if rc \= '' then
do
  title = "Visual Tree"
  classname = 'WPProgram'
  location = '<FM3_Folder>'
  setup = 'OBJECTID=<FM/2_VTREE>;EXENAME='curdir'\VTREE.EXE;STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('vdir.exe','c','query exists')
if rc \= '' then
do
  title = "Visual Directory"
  classname = 'WPProgram'
  location = '<FM3_Folder>'
  setup = 'OBJECTID=<FM/2_VDIR>;EXENAME='curdir'\VDIR.EXE;STARTUPDIR='curdir
  if existed = '' then setup = setup';PARAMETERS=%*'
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('vcollect.exe','c','query exists')
if rc \= '' then
do
  title = "Collector"
  classname = 'WPProgram'
  location = '<FM3_Folder>'
  setup = 'OBJECTID=<FM/2_VCOLLECT>;EXENAME='curdir'\VCOLLECT.EXE;STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('READ.ME','c','query exists')
if rc \= '' then
do
  title = "Read.Me"
  classname = 'WPShadow'
  location = '<FM3_Folder>'
  setup = 'SHADOWID='rc
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('HISTORY.TXT','c','query exists')
if rc \= '' then
do
  title = "History.Txt"
  classname = 'WPShadow'
  location = '<FM3_Folder>'
  setup = 'SHADOWID='rc
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('REGISTER.TXT','c','query exists')
if rc \= '' then
do
  title = "Register.Txt"
  classname = 'WPShadow'
  location = '<FM3_Folder>'
  setup = 'SHADOWID='rc
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('ASSOCIAT.TXT','c','query exists')
if rc \= '' then
do
  title = "Associat.Txt"
  classname = 'WPShadow'
  location = '<FM3_Folder>'
  setup = 'SHADOWID='rc
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('FM3.HLP','c','query exists')
if rc \= '' then
do
  if assocfilter \= '' then assocfilter=';ASSOCFILTER=*.HLP'
  rc = stream('SEEHELP.EXE','c','query exists')
  if rc \= '' then
  do
    title = "FM/2 Online Help"
    classname = 'WPProgram'
    location = '<FM3_Folder>'
    setup = 'EXENAME='curdir'\SEEHELP.EXE;STARTUPDIR='curdir';PARAMETERS= %* 'curdir'\FM3.HLP'
    call SysCreateObject classname,title,location,setup,u
  end
end

rc = stream('FM3MENU.DAT','c','query exists')
if rc = '' then
do
  say 'Creating a sample FM3MENU.DAT file for you.'
  'rename FM3MENU.TMP FM3MENU.DAT 1>NUL 2>NUL'
end
else 'DEL FM3MENU.TMP 1>NUL 2>NUL'

/*
 * create command files that the user can execute from anywhere (we'll
 * ask the user to put this utils directory on the PATH) and that other
 * programs can execute to use FM/2 as "their" file manager.
 */

call SysMkDir curdir'\UTILS'
dummy = directory(curdir'\UTILS')
if dummy = curdir'\UTILS' then
do
  'set PATH=%PATH%;'curdir'\utils'
  'move ..\example.cmd 1>NUL 2>NUL'
  'del FM2.CMD 1>NUL 2>NUL'
  dummy = stream('FM2.CMD','C','open')
  if dummy = 'READY:' then
  do
    say 'Creating an FM2.CMD file.'
    call lineout 'FM2.CMD', "/* FM/2 command file.  Locate in a directory"
    call lineout 'FM2.CMD', " * on your PATH. */"
    call lineout 'FM2.CMD', "'@echo off'"
    call lineout 'FM2.CMD', "arg dummy"
    call lineout 'FM2.CMD', "if dummy = '' then"
    call lineout 'FM2.CMD', "  curdir = directory()"
    call lineout 'FM2.CMD', "else"
    call lineout 'FM2.CMD', "  curdir = ''"
    call lineout 'FM2.CMD', "n = setlocal()"
    call lineout 'FM2.CMD', "n = directory('"curdir"')"
    call lineout 'FM2.CMD', "'start fm3.exe 'curdir' %1 %2 %3 %4 %5 %6 %7 %8 %9'"
    call lineout 'FM2.CMD', "n = endlocal()"
    call stream 'FM2.CMD','C','close'
    'del AV2.CMD 1>NUL 2>NUL'
    dummy = stream('AV2.CMD','C','open')
    if dummy = 'READY:' then
    do
      say 'Creating an AV2.CMD file.'
      call lineout 'AV2.CMD', "/* AV/2 command file.  Locate in a directory"
      call lineout 'AV2.CMD', " * on your PATH. */"
      call lineout 'AV2.CMD', "'@echo off'"
      call lineout 'AV2.CMD', "arg arg1"
      call lineout 'AV2.CMD', "if arg1 \= '' then arg1 = stream(arg1,'c','query exists')"
      call lineout 'AV2.CMD', "n = setlocal()"
      call lineout 'AV2.CMD', "n = directory('"curdir"')"
      call lineout 'AV2.CMD', "'start av2.exe 'arg1"
      call lineout 'AV2.CMD', "n = endlocal()"
      call stream 'AV2.CMD','C','close'
    end
    else say "Couldn't create AV2.CMD file."
    'del VDIR.CMD 1>NUL 2>NUL'
    dummy = stream('VDIR.CMD','C','open')
    if dummy = 'READY:' then
    do
      say 'Creating a VDIR.CMD file.'
      call lineout 'VDIR.CMD', "/* VDIR (FM/2) command file.  Locate in a directory"
      call lineout 'VDIR.CMD', " * on your PATH. */"
      call lineout 'VDIR.CMD', "'@echo off'"
      call lineout 'VDIR.CMD', "arg dummy"
      call lineout 'VDIR.CMD', "if dummy = '' then"
      call lineout 'VDIR.CMD', "  curdir = directory()"
      call lineout 'VDIR.CMD', "else"
      call lineout 'VDIR.CMD', "  curdir = ''"
      call lineout 'VDIR.CMD', "n = setlocal()"
      call lineout 'VDIR.CMD', "n = directory('"curdir"')"
      call lineout 'VDIR.CMD', "'start vdir.exe 'curdir' %1 %2 %3 %4 %5 %6 %7 %8 %9'"
      call lineout 'VDIR.CMD', "n = endlocal()"
      call stream 'VDIR.CMD','C','close'
    end
    else say "Couldn't create VDIR.CMD file."
    'del VTREE.CMD 1>NUL 2>NUL'
    dummy = stream('VTREE.CMD','C','open')
    if dummy = 'READY:' then
    do
      say 'Creating a VTREE.CMD file.'
      call lineout 'VTREE.CMD', "/* VTREE (FM/2) command file.  Locate in a directory"
      call lineout 'VTREE.CMD', " * on your PATH. */"
      call lineout 'VTREE.CMD', "'@echo off'"
      call lineout 'VTREE.CMD', "n = setlocal()"
      call lineout 'VTREE.CMD', "n = directory('"curdir"')"
      call lineout 'VTREE.CMD', "'start vtree.exe %1 %2 %3 %4 %5 %6 %7 %8 %9'"
      call lineout 'VTREE.CMD', "n = endlocal()"
      call stream 'VTREE.CMD','C','close'
    end
    else say "Couldn't create VTREE.CMD file."
    'del VCOLLECT.CMD 1>NUL 2>NUL'
    dummy = stream('VCOLLECT.CMD','C','open')
    if dummy = 'READY:' then
    do
      say 'Creating a VCOLLECT.CMD file.'
      call lineout 'VCOLLECT.CMD', "/* VCOLLECT (FM/2) command file.  Locate in a directory"
      call lineout 'VCOLLECT.CMD', " * on your PATH. */"
      call lineout 'VCOLLECT.CMD', "'@echo off'"
      call lineout 'VCOLLECT.CMD', "n = setlocal()"
      call lineout 'VCOLLECT.CMD', "n = directory('"curdir"')"
      call lineout 'VCOLLECT.CMD', "'start vcollect.exe %1 %2 %3 %4 %5 %6 %7 %8 %9'"
      call lineout 'VCOLLECT.CMD', "n = endlocal()"
      call stream 'VCOLLECT.CMD','C','close'
    end
    else say "Couldn't create VCOLLECT.CMD file."
    'del INI.CMD 1>NUL 2>NUL'
    dummy = stream('INI.CMD','C','open')
    if dummy = 'READY:' then
    do
      say 'Creating an INI.CMD file.'
      call lineout 'INI.CMD', "/* INI (FM/2) command file.  Locate in a directory"
      call lineout 'INI.CMD', " * on your PATH. */"
      call lineout 'INI.CMD', "'@echo off'"
      call lineout 'INI.CMD', "n = setlocal()"
      call lineout 'INI.CMD', "n = directory('"curdir"')"
      call lineout 'INI.CMD', "'start INI.exe %1 %2 %3'"
      call lineout 'INI.CMD', "n = endlocal()"
      call stream 'INI.CMD','C','close'
    end
    else say "Couldn't create INI.CMD file."
    'del EAS.CMD 1>NUL 2>NUL'
    dummy = stream('EAS.CMD','C','open')
    if dummy = 'READY:' then
    do
      say 'Creating an EAS.CMD file.'
      call lineout 'EAS.CMD', "/* EAS (FM/2) command file.  Locate in a directory"
      call lineout 'EAS.CMD', " * on your PATH. */"
      call lineout 'EAS.CMD', "'@echo off'"
      call lineout 'EAS.CMD', "n = setlocal()"
      call lineout 'EAS.CMD', "n = directory('"curdir"')"
      call lineout 'EAS.CMD', "'start eas.exe %1 %2 %3'"
      call lineout 'EAS.CMD', "n = endlocal()"
      call stream 'EAS.CMD','C','close'
    end
    else say "Couldn't create EAS.CMD file."
    'del UNDEL.CMD 1>NUL 2>NUL'
    dummy = stream('UNDEL.CMD','C','open')
    if dummy = 'READY:' then
    do
      say 'Creating an UNDEL.CMD file.'
      call lineout 'UNDEL.CMD', "/* UNDEL (FM/2) command file.  Locate in a directory"
      call lineout 'UNDEL.CMD', " * on your PATH. */"
      call lineout 'UNDEL.CMD', "'@echo off'"
      call lineout 'UNDEL.CMD', "n = setlocal()"
      call lineout 'UNDEL.CMD', "n = directory('"curdir"')"
      call lineout 'UNDEL.CMD', "'start undel.exe %1'"
      call lineout 'UNDEL.CMD', "n = endlocal()"
      call stream 'UNDEL.CMD','C','close'
    end
    else say "Couldn't create UNDEL.CMD file."
    'del KILLPROC.CMD 1>NUL 2>NUL'
    dummy = stream('KILLPROC.CMD','C','open')
    if dummy = 'READY:' then
    do
      say 'Creating a KILLPROC.CMD file.'
      call lineout 'KILLPROC.CMD', "/* KILLPROC (FM/2) command file.  Locate in a directory"
      call lineout 'KILLPROC.CMD', " * on your PATH. */"
      call lineout 'KILLPROC.CMD', "'@echo off'"
      call lineout 'KILLPROC.CMD', "n = setlocal()"
      call lineout 'KILLPROC.CMD', "n = directory('"curdir"')"
      call lineout 'KILLPROC.CMD', "'start killproc.exe'"
      call lineout 'KILLPROC.CMD', "n = endlocal()"
      call stream 'KILLPROC.CMD','C','close'
    end
    else say "Couldn't create KILLPROC.CMD file."
    'del VIEWINFS.CMD 1>NUL 2>NUL'
    dummy = stream('VIEWINFS.CMD','C','open')
    if dummy = 'READY:' then
    do
      say 'Creating a VIEWINFS.CMD file.'
      call lineout 'VIEWINFS.CMD', "/* VIEWINFS (FM/2) command file.  Locate in a directory"
      call lineout 'VIEWINFS.CMD', " * on your PATH. */"
      call lineout 'VIEWINFS.CMD', "'@echo off'"
      call lineout 'VIEWINFS.CMD', "n = setlocal()"
      call lineout 'VIEWINFS.CMD', "n = directory('"curdir"')"
      call lineout 'VIEWINFS.CMD', "'start viewinfs.exe'"
      call lineout 'VIEWINFS.CMD', "n = endlocal()"
      call stream 'VIEWINFS.CMD','C','close'
    end
    else say "Couldn't create VIEWINFS.CMD file."
    'del VIEWHELP.CMD 1>NUL 2>NUL'
    dummy = stream('VIEWHELP.CMD','C','open')
    if dummy = 'READY:' then
    do
      say 'Creating a VIEWHELP.CMD file.'
      call lineout 'VIEWHELP.CMD', "/* VIEWHELP (FM/2) command file.  Locate in a directory"
      call lineout 'VIEWHELP.CMD', " * on your PATH. */"
      call lineout 'VIEWHELP.CMD', "'@echo off'"
      call lineout 'VIEWHELP.CMD', "n = setlocal()"
      call lineout 'VIEWHELP.CMD', "n = directory('"curdir"')"
      call lineout 'VIEWHELP.CMD', "'start viewinfs.exe DUMMY'"
      call lineout 'VIEWHELP.CMD', "n = endlocal()"
      call stream 'VIEWHELP.CMD','C','close'
    end
    else say "Couldn't create VIEWHELP.CMD file."
    say ""
    parse upper var curdir curdir
    say "Please add the directory"
    say "  "curdir"\UTILS"
    say "to your PATH in CONFIG.SYS."
    say ""
    say "Remember, you'll need to reboot before such a change takes effect."
    say "FM/2 will run fine from its WPS objects without this change; the"
    say "proposed change allows it to be run from any command line, and for"
    say "other programs that might want to use FM/2 as its file manager to"
    say "find and run it easily."
    if existed \= "TRUE" then
    do
      say ""
      say "Press [Enter] for more..."
      rc = stream('fatopt.exe','c','query exists')
      if rc = '' then
      do
        say ""
        say "I suggest that you place the utilities from the FM/2 Utilities"
        say "archive in this directory, also, in which case you should "
        say "_definitely_ make the change to PATH so that FM/2 can find them."
      end
      say ""
      say "You may want to tweak the command lines in the .CMD files I just"
      say "built and/or those in the WPS objects in the FM/2 folder for"
      say "desired specific behaviors.  The READ.ME file will tell you how."
    end
    if existed = 'TRUE' then
    do
      say ''
      say "If you have previously altered your CONFIG.SYS's PATH statement"
      say 'as instructed above, please ignore this rambling.'
    end
    say ""
    say "  Press [Enter] to continue..."
    /* NOTE:  Remove next line for unattended use */
    pull dummy .
  end
  else say "Couldn't create FM2.CMD file."
  say ''
  dummy = directory(curdir)
end
else say "Couldn't switch to "curdir"\utils"

/* Migrate old settings from FM2.INI if it exists and an FM3.INI doesn't */

rc = stream('fm3.ini','c','query exists')
if rc \= '' then
  say 'An FM3.INI exists -- not attempting to migrate 1.x information.'
else
do
  /* if we can find FM2.INI, run MIGINI.CMD */
  fm2ini = value('fm2ini',,'OS2ENVIRONMENT')
  if fm2ini \= '' then fm2ini = stream(fm2ini,'c','query exists')
  if fm2ini = '' then
  do
    fm2ini = value('fm2ini',,'OS2ENVIRONMENT')
    if fm2ini \= '' then
    do
      fm2ini = insert('\FM2.INI',fm2ini,length(fm2ini))
      fm2ini = stream(fm2ini,'c','query exists')
    end
  end
  fm2ini = SysSearchPath('PATH', 'FM2.INI')
  if fm2ini = '' then fm2ini = SysSearchPath('DPATH', 'FM2.INI')
  if fm2ini = '' then fm2ini = SysSearchPath('XPATH', 'FM2.INI')
  if fm2ini \= '' then
  do
    'call migini.cmd dummy'
    say ''
    say '  (You can remove the old FM/2 1.x files when installation completes.)'
    call SysSleep 2
    say ''
  end
end

/* type the install.dat file to show any critical info/notices */

rc = stream('install.dat','c','query exists')
if rc \= '' then
do
  /* NOTE:  remove following 4 lines for unattended use... */
  rc = stream('install.dat','c','query exists')
  if rc \= '' then 'type install.dat'
  say '  Press [Enter] to continue...'
  pull dummy .
end

/* Final words */

say 'To move FM/2 to another directory, move the files, delete the FM/2 folder,'
say 'then rerun INSTALL.  To remove FM/2, run UNINSTAL and follow its directions.'
say ''
say "I'm done now."

