/*====================================================================
This file is part of the Blackout screen saver.       v0.9  1995-04-11
Copyright (C) 1995 by Staffan Ulfberg.    See README file for details.
====================================================================*/
#define INCL_DOS
#define INCL_KBD
#define INCL_NOPM
#define INCL_DOSMONITORS

#include <os2.h>
#include <stdio.h>
#include <conio.h>
#include <process.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "16bit.h"

static PGINFOSEG gdt;
static HKBD KBDHandle = (HKBD)0;
static PGINFOSEG gdt;
static MONIN monInbuf = {0};
static MONOUT monOutbuf = {0};
static KEYPACKET keybuff;
static HEV hevKeyb;

static void start_monitor(void);
static int child = -1;

void sighandler() {
  printf("Interrupt!  Killing child process.");
  if (child > 0) {
    kill(child, SIGKILL);
    wait(NULL);
  }
  exit(0);
} 

int main(int argc, char *argv[], char *envp[]) {
  SEL gdt_descriptor, ldt_descriptor;
  static UCHAR c, n;

  DosGetInfoSeg(&gdt_descriptor, &ldt_descriptor);
  gdt = (PGINFOSEG)MAKEP(gdt_descriptor, 0);
  
  signal(SIGINT, &sighandler);

  c = 255;
  for (;;) {
    if (c != (n = gdt->sgCurrent)) {
      if (child != -1) {
	kill(child, SIGKILL);
	child = 0;
	wait(NULL);
      }
      if (child = fork()) 
	c = n;
      else
	start_monitor();
    }
    sleep(5);
  }
}

static void start_monitor() {
  time_t LastTimePosted = 0, temptime;
  USHORT count, rc;

  if (rc = DosOpenEventSem("\\SEM32\\BLACKOUT\\KEYB", &hevKeyb)) {
    printf("DosOpenEventSem: %d\nBlackout is not running?\n", rc);
    exit(1);
  }

  monInbuf.cb  = sizeof(MONIN);
  monOutbuf.cb = sizeof(MONOUT);

  if (rc = DosMonOpen("KBD$", &KBDHandle)) {
    printf("DosMonOpen: %d\n", rc);
    exit(1);
  }
  if (rc = DosMonReg(KBDHandle, (PBYTE)&monInbuf, (PBYTE)&monOutbuf,
		     MONITOR_BEGIN, gdt->sgCurrent)) {
    printf("DosMonReg: %d\n", rc);
    exit(1);
  }
  for (;;) {
    count = sizeof(keybuff);
    DosMonRead((PBYTE)&monInbuf, IO_WAIT, (PBYTE)&keybuff, &count);
    DosMonWrite((PBYTE)&monOutbuf,(PBYTE)&keybuff,count);

    if (time(&temptime) - LastTimePosted > 10) {
      LastTimePosted = temptime; 
      DosPostEventSem(hevKeyb);
    } 
  }
}




