/*====================================================================
This file is part of the Blackout screen saver.       v0.9  1995-04-11
Copyright (C) 1995 by Staffan Ulfberg.    See README file for details.
====================================================================*/
#define INCL_WIN
#define INCL_DOS
#define INCL_DOSPROCESS
#define INCL_KBD
#include <stdlib.h>
#include <process.h>
#include <signal.h>
#include <string.h>
#include <os2.h>
#include <sys/wait.h>
#include "blackout.h"
#include "grey.h"
#include "16bit.h"

#define BLANKED_NOTBLANKED 0
#define BLANKED_GREY 1
#define BLANKED_BLACK 2

void ErrMsg(char *);

static MRESULT EXPENTRY ClientWndProc(HWND, ULONG, MPARAM, MPARAM);

static long TimeBeforeGrey = 15; /* Minutes before grey screen */
static long TimeBeforeDPMS = 45; /* Minutes after grey screen
				    until screen is shut off */
void keyboard_thread(void *);
ULONG progtype(PID idSession);

HAB hab;
HEV hevKeyb, hevBlack;
HWND hwndFrame;
static int fullid = 0, blanked = BLANKED_NOTBLANKED;

int main(int argc, char *argv[]) {
  HMQ hmq;
  ULONG flFrameFlags;
  HWND hwndClient, *hwndFrameShared;
  QMSG qmsg;
  HMODULE DllHandle;
  char DllLoadError[100];
  PFN DllProcAddr;
  int Remove = 0, InMem, AddToTaskList = 0, i;
    
  hab = WinInitialize(0);
  hmq = WinCreateMsgQueue(hab, 0);

  WinRegisterClass(hab, "Blackout.Win", ClientWndProc,
		   CS_SIZEREDRAW, 0L);

  if (argc == 2 && !strcmp(argv[1], "-r"))
    Remove = 1;
  else {
    for (i = 1; i < argc; i++) {
      if (!strcmp(argv[i], "-l")) {
	AddToTaskList = 1;
      } else {
	if (i == argc - 1)
	  ErrMsg("Bad command line options");
	if (!strcmp(argv[i], "-t")) 
	  TimeBeforeGrey = atol(argv[i+1]) < 1 ? 1 : atol(argv[i+1]);
	else if (!strcmp(argv[i], "-b")) 
	  TimeBeforeDPMS = atol(argv[i+1]);
	else
	  ErrMsg("Bad command line option");
	i++;
      }
    }
  }

  flFrameFlags = (FCF_TITLEBAR      | FCF_SYSMENU |
                  FCF_SHELLPOSITION | FCF_ICON |
                  (FCF_TASKLIST * AddToTaskList) | FCF_MINBUTTON );

  hwndFrame = WinCreateStdWindow(HWND_DESKTOP, 0, &flFrameFlags,
				 "Blackout.Win", "Blackout Window", 0L, 0,
				 ID_BLACKOUT, &hwndClient);

  InMem = !DosQueryModuleHandle(DLL_NAME, &DllHandle);
  if (InMem && !Remove)
    ErrMsg("Already loaded!");
  else if (Remove && !InMem)
    ErrMsg("Can't find program in memory!");

  if (DosLoadModule(DllLoadError, 100, DLL_NAME, &DllHandle))
    ErrMsg(DllLoadError);
  if (DosQueryProcAddr(DllHandle,0, "InputHook", &DllProcAddr))
    ErrMsg("DosQueryProcAddr InputHook");
  if (DosQueryProcAddr(DllHandle,0, "hwndFrameShared", (PPFN)&hwndFrameShared))
    ErrMsg("DosQueryProcAddr hwndFrameShared");

  if (Remove)
    WinPostMsg(*hwndFrameShared, WM_CLOSE, 0, 0);
  else {
    if ((fullid = spawnl(P_NOWAIT, "full.exe", "full.exe", NULL)) == -1)
      ErrMsg("Couldn't spawn full.exe");

    *hwndFrameShared = hwndFrame;
    if (!WinSetHook(hab, NULLHANDLE, HK_INPUT, DllProcAddr, DllHandle))
      ErrMsg("Winsethook");

    if (DosCreateEventSem("\\SEM32\\BLACKOUT\\KEYB", &hevKeyb,
			  DC_SEM_SHARED, FALSE))
      ErrMsg("DosCreateEventSem: \\SEM32\\BLACKOUT\\KEYB");

    if (DosCreateEventSem("\\SEM32\\BLACKOUT\\DPMS", &hevBlack,
			  DC_SEM_SHARED, FALSE))
      ErrMsg("DosCreateEventSem: \\SEM32\\BLACKOUT\\DPMS");

    if (_beginthread(keyboard_thread, NULL, 10000l, 0) == -1)
      ErrMsg("_beginthread");

    WinPostMsg(hwndFrame, WM_USER, 0, 0);
    while (WinGetMsg(hab, &qmsg, 0L, 0, 0))
      WinDispatchMsg(hab, &qmsg);
    
    WinReleaseHook(hab, NULLHANDLE, HK_INPUT, DllProcAddr, DllHandle);
  }
  DosFreeModule(DllHandle);
  WinDestroyWindow(hwndFrame);
  WinDestroyMsgQueue(hmq);
  WinTerminate(hab);
  return (0);
}

static MRESULT EXPENTRY ClientWndProc(HWND hwnd, ULONG msg,
				      MPARAM mp1, MPARAM mp2) {
  static PGINFOSEG gdt;
  static ULONG ptype;
  HPS hps;
  RECTL rcl;
  SEL gdt_descriptor, ldt_descriptor;
  ULONG count;
  char s[50];
  int blackid, stat_val;

  switch (msg) {
  case WM_CREATE:
    DosGetInfoSeg(&gdt_descriptor, &ldt_descriptor);
    gdt = (PGINFOSEG)MAKEP(gdt_descriptor, 0);
    break;
  case WM_CLOSE:
    kill(fullid, SIGINT);
    WinStopTimer(hab, hwnd, 0);
    WinPostMsg(hwnd, WM_QUIT, 0, 0);
    break;
  case WM_PAINT:
    hps = WinBeginPaint(hwnd, NULLHANDLE, NULL);
    WinQueryWindowRect(hwnd, &rcl);
    GpiSetColor(hps, CLR_DARKCYAN);
    WinDrawText(hps, -1, "Not much of a window is it?", &rcl, 0, 0,
		DT_TEXTATTRS | DT_CENTER | DT_VCENTER | DT_ERASERECT);
    WinEndPaint(hps);
    break;
  case WM_TIMER:
    if (blanked == BLANKED_BLACK)
      break;
    if ((ptype = progtype(gdt->sgCurrent)) == PROG_VDM)
      break;
    if (blanked == BLANKED_NOTBLANKED && TimeBeforeDPMS) {
      grey_blank(hwnd);
      WinStartTimer(hab, hwnd, 0, TimeBeforeDPMS * 60 * 1000);
      blanked = BLANKED_GREY;
    } else {
      if (blanked == BLANKED_GREY)
	grey_unblank(hwnd);
      
      if (ptype == PROG_FULLSCREEN) {
	grey_blankblack(hwnd);
      } else {
	count = 0;
	DosResetEventSem(hevBlack, &count);
	WinSetFocus(HWND_DESKTOP, hwndFrame);
	if ((blackid = spawnl(P_SESSION, "black", "black", NULL)) == -1)
	  ErrMsg("spawn(black.exe) failed");
      }
      blanked = BLANKED_BLACK;
    } 
    break;
  case WM_USER:
    if (blanked == BLANKED_GREY) 
      grey_unblank(hwnd);
    else if (blanked == BLANKED_BLACK) {
      if (ptype == PROG_FULLSCREEN) {
	grey_unblank(hwnd);
      } else {
	DosPostEventSem(hevBlack);
	wait(&stat_val);
	if (WEXITSTATUS(stat_val)) {
	  _itoa(WEXITSTATUS(stat_val), s, 10);
	  ErrMsg(s);
	}
      }
    }
    blanked = BLANKED_NOTBLANKED;
    WinStartTimer(hab, hwnd, 0, TimeBeforeGrey * 60 * 1000);
    break;
  default:
    return WinDefWindowProc(hwnd, msg, mp1, mp2);
  }
  return 0;
}

void ErrMsg(char *s) {
  if (fullid > 0)
    kill(fullid, SIGINT);
  WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, s, NULL, 0, MB_ERROR | MB_CANCEL);
  exit(1);
}

void keyboard_thread(void *slask) {
  ULONG count = 0;

  for (;;) {
    DosWaitEventSem(hevKeyb, (ULONG)SEM_INDEFINITE_WAIT);
    WinPostMsg(hwndFrame, WM_USER, 0, 0);
    DosResetEventSem(hevKeyb, &count);
  }
}


/* Function to return the type of programs in a session */
ULONG progtype(PID idSession) {
  USHORT num,i;
  SWBLOCK *pSwb;
  ULONG pt;

  if (!(num = WinQuerySwitchList(0L, NULL, 0)))
    ErrMsg("WinQuerySwitchList");

  pSwb = malloc(sizeof(HSWITCH) + sizeof(SWENTRY) * num);
  num = WinQuerySwitchList(0L, pSwb,
			   sizeof(HSWITCH) + sizeof(SWENTRY) * num);
  for(i = 0; i < num; i++) 
    if (pSwb->aswentry[i].swctl.idSession == idSession)
      pt = pSwb->aswentry[i].swctl.bProgType;

  free(pSwb);
  return pt;
}
