/*

                                   BGF2MD
                                Version 1.00
          Copyright (c) Bob Swift, 1995.  All Rights Reserved.
                  Compiled with the Watcom C/C++ compiler.

   This program is used to read the FAXIN.LOG file generated by BGFax
   and extract the fax information into the MainDoor LASTIN.* file.
   The program is used as follows:

                       BGF2MD infile [P:mdpath] [T:task]

   where:   infile = path and name of BGFax FAXIN.LOG file
            mdpath = path to MainDoor directory
            task   = MainDoor task number

   If mdpath is missing, BGF2MD will write the LASTIN.* file in the
   current directory.  If task is missing, BGF2MD will write the file
   LASTIN.MD, otherwise the file will be written for the appropriate
   MainDoor task (ie. LASTIN.001 for task 1).

   The program will display a VERY brief set of instructions if it is called
   without any arguments or if it encounters an error.  The following is a
   list of the error codes returned by the program:

                  0 - No errors.  Normal termination.
                  1 - Missing or extra command line arguments.
                  2 - Unable to open the FAXIN.LOG file.
                  3 - Unable to read the FAXIN.LOG file.
                  4 - Problem writing the LASTIN.* file.

   When an error is encountered, the program will exit immediately and will
   attempt to properly close all files.

   Although I have chosen to retain all rights to this program, you are free
   to use it under the following conditions:

            - You realize that there is NO Warrantee of any sort.
              It was tested pretty thoroughly here before release
              but who knows what bugs may be lurking within.

            - You will not modify the code and release a new version
              of the program.  I welcome suggestions for improvement
              (especially when accompanied by code) but I make no
              guarantee of future releases.

            - You drop me a note to let me know that you use the
              program.  That way, I know who to inform if there are
              any future releases.  Please either send netmail to:

                        Bob Swift
                        1:342/5 @ fidonet

              or a postcard to:

                        Bob Swift
                        5708 - 47th Street
                        Stony Plain, Alberta
                        T7Z 1C6, Canada

            - If you find the program useful, I ask that you do
              something to brighten somebody else's day.  Just
              exactly what, I will leave up to you.


   You may freely distribute this program provided that you distribute only
   the complete archive which includes the BGF2MD.EXE, BGF2MD.C and
   BGF2MD.DOC.

                                                   Bob Swift (1:342/5)



   Revision History
   ----------------

   1.00     95/01/21    First release version.

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>

struct   _mdlast
   {
      char  system[54];     /* System Name                                  */
      char  sysop[54];      /* SysOp's Name                                 */
      char  city[54];       /* System's Location                            */
      char  address[35];    /* System's Network Address                     */
      time_t timedate;      /* Time and Date of Call                        */
      short int unknown;    /* Unknown (value is always 1)                  */
   };


void helpscrn(int ernum, char *name);

/*******************************************************************/

void main(int argc, char *argv[])
{

FILE *infile;
static struct _mdlast mdlast;
char temp[128],temp1[128],temp2[128],outname[4],*p;
char version[] = {"1.00"};  /* Current Version Number */
char title[] = {"BGF2MD Version "};
char cpyright[] = {"Copyright (c) Bob Swift, 1995.  All Rights Reserved."};
struct stat buf;
int fname,i;

printf("\n\n%s%s\n",title,version);
printf("%s\n",cpyright);

if (argc < 2) helpscrn(1,"");

strcpy(temp,argv[1]);

if ((fname=open(temp,O_RDONLY|O_BINARY)) == -1)
    helpscrn(2,temp);

if (fstat(fname, &buf) != 0)
    helpscrn(2,temp);

close(fname);

if ((infile=fopen(temp,"rt")) == NULL)
    helpscrn(2,temp);

temp1[0] = 0;
temp2[0] = 0;

while (fgets(temp1,127,infile) != NULL)
    if (strlen(temp1) > 78) strcpy(temp2,temp1);

fclose(infile);

if (strlen(temp2) < 79)
    helpscrn(3,temp);

strcpy(temp1,temp2+44);
p = strtok(temp1," \n\0");
if (p == NULL) helpscrn(3,temp);
strcpy(temp2,"Fax from: ");
strcat(temp2,p);
temp2[53] = 0;
strcpy(mdlast.system,temp2);
strcpy(mdlast.sysop,temp2);
p = strtok(NULL," \n\0");
if (p == NULL) helpscrn(3,temp);
strcpy(temp2,p);
strcat(temp2," page");
if (atoi(p) != 1) strcat(temp2,"s");
temp2[53] = 0;
strcpy(mdlast.city,temp2);
p = strtok(NULL," \n\0");
if (p == NULL) helpscrn(3,temp);
strcpy(temp2,"Status: ");
strcat(temp2,p);
temp2[34] = 0;
strcpy(mdlast.address,temp2);
mdlast.timedate = buf.st_mtime - (time_t) timezone;
mdlast.unknown = 1;



/*
        if (argc > 2)
          {
          strcpy(temp,argv[2]);
          if (temp[strlen(temp)-1] != '\\') strcat(temp,"\\");
          strcat(temp,"LASTIN.MD");
          }
        else
          strcpy(temp,"LASTIN.MD");
*/
i = 2;
strcpy(temp,"");
strcpy(outname,"MD");
while (i < argc)
  {
  strcpy(temp1,argv[i]);
  temp1[2] = 0;
  if (strcmpi(temp1,"P:") == 0)
    {
    strcpy(temp,argv[i]+2);
    if (temp[strlen(temp)-1] != '\\') strcat(temp,"\\");
    }
  if (strcmpi(temp1,"T:") == 0)
    {
    strcpy(temp1,argv[i]+2);
    strrev(temp1);
    strcat(temp1,"000");
    temp1[3] = '\0';
    strrev(temp1);
    strcpy(outname,temp1);
    }
  i++;
  }
strcat(temp,"LASTIN.");
strcat(temp,outname);

if ((infile=fopen(temp,"wb")) == NULL)
    helpscrn(4,temp);

if (fwrite(&mdlast,sizeof(struct _mdlast),1,infile) != 1)
    helpscrn(4,temp);

fclose(infile);

printf("\nComplete.  Thank-you for using BGF2MD.\n\n");
exit(0);
}

/*******************************************************************/

void helpscrn(int ernum, char *name)
/*  Here are the error messages and VERY brief instructions  */
{
printf("\n");
switch (ernum) {

case  1 : printf("Bad or missing command line argument\n\n");

printf("   This program is used to read the FAXIN.LOG file generated by BGFax\n");
printf("   and extract the fax information into the MainDoor LASTIN.* file.\n");
printf("   The program is used as follows:\n\n");
printf("                       BGF2MD infile [P:mdpath] [T:task]\n\n");
printf("   where:   infile = path and name of BGFax FAXIN.LOG file\n");
printf("            mdpath = path to MainDoor directory\n");
printf("            task   = MainDoor task number\n\n");
printf("   If mdpath is missing, BGF2MD will write the LASTIN.* file in the\n");
printf("   current directory.  If task is missing, BGF2MD will write the file\n");
printf("   LASTIN.MD, otherwise the file will be written for the appropriate\n");
printf("   MainDoor task (ie. LASTIN.001 for task 1).\n\n");

          break;

case  2 : printf("ERROR opening %s input file\n\n",name);
          break;

case  3 : printf("ERROR reading %s input file\n\n",name);
          break;

case  4 : printf("Problem writing %s file\n\n",name);
          break;
    }
exit(ernum);
}

