/* FS1.C
 * handle_dir functions
 * MSC8 (VC++ 1.5)
 * FS 2.9
 * 270195
 * Copyright (C) M. van Breemen, 1992-1995, All rights reserved.
 */

#include "FS.H"
#include "SPAWNO.H"

/* Prototypes */
void make_today_string( char *daystring );
int ed_turnover_datetime( void );
int set_turnover_datetime( char *datetime );
int date_interval_correct(unsigned long file_datetime, unsigned long turnover_datetime, int turnover_datetime_mode);
int cdecl fs_systemo(const char *overlay_path, const char *command);
int whereis(char *searchstring, int *current_page, int *filenumber );
int find_name(char *fname, int *current_page, int *filenumber);
void outtextm( char *string );
int handle_dir( char *searchstring, char *selected , int safe_mode);
char filename( int filenumber, int mode );
void fileinfo( int filenumber );
char *timestr( unsigned d, char *buf );
char *datestr( unsigned d, char *buf );     
unsigned int strtime( char *buf );
unsigned int strdate( char *buf );
unsigned long make_dt( unsigned d, unsigned t);
void set_cursor( int filenumber );
void clear_remaining( int filenumber );
int extract_directory( char *searchstring );
void put_parent_on_top( int order_type );
void make_parent_two_dots( void );
void show_dir_page( int page );
void kader( void );
void alert( void );
void helpscreen( void );
void aboutscreen( void );
void show_error( char *message );
void show_message( char *message );
void wait_sec( int milliseconds );
int rename_file( int filenumber);
int rename_volume_label( int filenumber);
void _far hhandler( unsigned deverr, unsigned doserr, unsigned _far *hdr );
int _bios_str( char *p );
void clear_left_button_queue( void );
void clear_right_button_queue( void );
int read_left_button_queue( int *row, int *col );
int read_right_button_queue( int *row, int *col );
void init_mouse( void );
void set_mouse_position( int col, int row );
void hide_mouse( void );
void show_mouse( void );
int mouse_button_pressed( void );
void perform_repaint(int current_page, int filenumber);
void c_pgup( int *current_page, int *filenumber);
void c_pgdn( int *current_page, int *filenumber);
void find_first(char chr, int *currentpage, int *filenumber);
void c_home( int *current_page, int *filenumber);
void c_end( int *current_page, int *filenumber);
void c_cup( int *current_page, int *filenumber);
void c_cdn( int *current_page, int *filenumber);
void c_cri( int *current_page, int *filenumber);
void c_cle( int *current_page, int *filenumber);
int _cdecl cmpgle( const void *elem1, const void *elem2 );
unsigned int n_kbhit( void );
int show_file(char *filename, int max_linewidth);
int old_show_file(char *filename);
int getkey(void);
void changecursor(int insmode);
void setcursor(unsigned int shape);
unsigned int getshift(void);
int editstring(int row, int col, char *s, char *legal_illegal, int legalmode, int maxlength);
int edit(char *title, char *string, int length , char *legal_illegal, int legalmode);
int copy_file( int filenumber);
int make_directory( void );
int ed_attributes( int filenumber);
int ed_datetime( int filenumber);
int copy( char *oldname, char *newname );
char __near *saveScrn(void);
char __near *restScrn(char __near *saveArea);
void show_path( void );
int valid_filename( char *newname);
int freespace( char *linebuf );
int getdiskfree( int newdrive, long *freebytes );
void working( int mode );
void shadebox( short r1, short c1, short r2, short c2 );
void shadechar( int row, int col );
char *set_working_drive_and_dir( char *full_filename );
int find_in_file( char *filename , char *string, int ignore_case);
void do_dir(char *path);
void find_parent( int *current_page, int *filenumber, char *searchstring);
int getdrv(void);
int chdrv(int drive);
int drvalid(int drive);
char *FilGetVolid( unsigned char Drive );
int FilSetVolid( unsigned char Drive, char *Volid );
int FilDelVolid( unsigned char Drive );
void ScrPutS(char *String, unsigned char Attr,
	     unsigned char Row, unsigned char Col);
int ask_drive_number(char *message);
void construct_search_path( char *linebuf );
int floptest(int drv);
char *getpath( int drive, char *buffer, int maxlen );
char __near *show_string(char *string, int bg_color, int text_color);
void paint_box(char *string, int vis_width, int vis_height);
void restrict_mouse_topline( void );
void default_mouse_rectangle( void );

/* global variables */
char turnover_datetime_string[23]={"\0"};
unsigned long turnover_datetime;
int turnover_datetime_mode=SINCE;

char processor[_MAX_PATH]={"\0"};

unsigned short int checkpoint1[3]= { 0xFEFF, 0xFCFD, 0xFAFB }; /* Backword FFFEFDFCFBFA */
short int screen_bg_color        = BLUE;
short int file_color             = WHITE;
short int hidden_file_color      = BRIGHTWHITE;
short int directory_color        = YELLOW;
short int hidden_directory_color = LIGHTGREEN;
short int volume_label_color     = CYAN;             /* 11 bytes color info and fsswitch */
short int cursor_bg_color        = RED;
short int info_bg_color          = GREEN;
short int info_text_color        = BRIGHTWHITE;
short int error_bg_color         = RED;
short int error_text_color       = WHITE;
short int fsswitch = (short int) '/';    /* parameter switch character for FS */   
unsigned short int checkpoint2[3]= { 0xFBFA, 0xFDFC, 0xFFFE }; /* Backword FAFBFCFDFEFF */

/* for monochrome systems */
short int cursor_file_color;
short int cursor_directory_color;
short int cursor_hidden_file_color;
short int cursor_hidden_directory_color;
short int cursor_volume_label_color;

static char searchstring[13]={"\0"};

char *swap_dir;
int allow_swap;
int swap_types;
int order_by;                                                  /* NONE, NAME, DATE or SIZE */
int order_type;                                                /* ASCENDING or DESCENDING */

static struct {                            /* FCB for volume label functions */
		  unsigned char Extcode;
		  char Res1[5];
		  unsigned char Code;
		  unsigned char OldDrive;
		  char OldName[11];
		  char Res2[5];
		  char NewName[11];
		  char Res3[9];
	      } DirFcb = {0xFF,"",0x10,0,"","","",""},
		VolFcb = {0xFF,"",0x08,0,"???????????","","",""};

static struct {                            /* DTA for volume label functions */
		  char Res1[8];      /* reserved */
		  char OldVolid[11]; /* filled in by DOS */
		  char Res2[5];      /* reserved */
		  char NewVolid[11]; /* used by FilSetVolid */
		  char Res3[9];      /* reserved */
	      } Dta;

int number_of_files;    /* number of files found */

typedef struct find_t_small {
				char name [13];
				char attrib;
				unsigned long datetime_or_size;
				/* char filler[14]; */
			    } FIND_T_SMALL;

FIND_T_SMALL __huge *find;       /* pointer to the file info structures */
/* The size of find[] is limited to 128K due to _halloc limitations. */
/* Extend the structure to 32 bytes (power of 2) to increase the capacity */
/* The penalty is inefficient use of memory (14 bytes filler per structure) */

int mouse_present;       /* boolean is there a mouse ? */
int moved_after_init_mouse; /* is the mouse actually used ? */
int mouse_row=0;         /* mouse position, NOT screen rows and columns */
int mouse_col=0;
int max_files=0;         /* maximal number of accessible files per directory or root, defaults to 912 */
int max_linewidth=0;     /* linewidth for S function */
int dos_error;           /* set by error handler */
int dos_retries;         /* set by error handler */
int dos_error_auto_fail=FALSE;  /* read by error handler */
int allow_abort_on_error=FALSE;
int setting_factory_defaults=FALSE;
      
      
      
/* volume label functions taken from 'Systems Programming in Microsoft C, Michael J. Young */

char *FilGetVolid( unsigned char Drive )
{
    int ErrorCode;
    union REGS Reg;
    
    dos_error_auto_fail=TRUE;
    Reg.x.dx = (unsigned int) &Dta;
    Reg.h.ah = 0x1A;
    int86(0x21, &Reg, &Reg);
    VolFcb.OldDrive = Drive;
    Reg.x.dx = (unsigned int) &VolFcb;
    Reg.h.ah = 0x11;
    int86(0x21, &Reg, &Reg);
    dos_error_auto_fail=FALSE;
    
    ErrorCode = Reg.h.al;
    if (ErrorCode == 0) return (Dta.OldVolid);
    else return (NULL);
}

int FilSetVolid( unsigned char Drive, char *Volid )
{
    register int i;
    int ErrorCode;
    union REGS Reg;
    if (FilGetVolid(Drive)==NULL)
    {
	dos_error_auto_fail=TRUE;
	for (i=0;i<11;++i)
	    if (*Volid=='\0') VolFcb.OldName[i]= ' ';
	    else VolFcb.OldName[i]= *Volid++;
	Reg.x.dx=(unsigned int) &VolFcb;
	Reg.h.ah=0x16;
	int86(0x21, &Reg, &Reg);
	dos_error_auto_fail=FALSE;
	
	ErrorCode=Reg.h.al;
	if (ErrorCode==0) return (NOERROR);
	else return (NOCREAT);
    }
    else
    {
	dos_error_auto_fail=TRUE;
	for (i=0;i<11;++i)
	    if (*Volid=='\0') Dta.NewVolid[i]= ' ';
	    else Dta.NewVolid[i]= *Volid++;
	Reg.x.dx=(unsigned int) &Dta;
	Reg.h.ah=0x17;
	int86(0x21, &Reg, &Reg);
	
	dos_error_auto_fail=FALSE;
	ErrorCode=Reg.h.al;
	if (ErrorCode==0) return (NOERROR);
	else return (NOREN);
    }
}

int FilDelVolid( unsigned char Drive )
{
    int ErrorCode;
    union REGS Reg;

    if (FilGetVolid ( Drive )==NULL)
    {
	return (NOVOL);
    }
    else
    {
	dos_error_auto_fail=TRUE;
	Reg.x.dx=(unsigned int) &Dta;
	Reg.h.ah=0x13;
	int86(0x21, &Reg,&Reg);

	dos_error_auto_fail=FALSE;
	ErrorCode=Reg.h.al;
	if (ErrorCode==0) return (NOERROR);
	else return (NODEL);
    }
}

/*---------------------------------------------------------------------------*/
/*   FF Routines taken from FFF 3.4.5, a public domain program to search files
 *      Author: Don A. Williams                                                                                  *
 *              CompuServ -                                                                                      *
 *              Genie     - DON-WILL                                                                             
 *   These routines are customized
*/


#define U_ESC    1
#define U_SELECT 2
#define U_GOTO 3

#define FIND_FIRST(Name,Block,Attrib) _dos_findfirst(Name, Attrib, Block);
#define FIND_NEXT(Block) _dos_findnext(Block);
#define DIR_ENTRY find_t        /* Name of the directory entry structure        */
#define D_ATTRIB attrib         /* Attribute field in directory entry           */
#define D_NAME name             /* File name field in directory entry           */


typedef struct QueEntry {
			  struct QueEntry *Next;
			  char  *Body;
			} QUE_ENTRY;

typedef struct QueDef {
			QUE_ENTRY *Head, *Current;
			int        Count;
		      } QUE_DEF;

/* Function prototypes    */

int             fff( char *fpattern, char *sstring, int ignore_case);
void            InitQueue (QUE_DEF *Q);
QUE_ENTRY       *Enque (QUE_DEF *Q, void *Body);
int             WalkTree (QUE_DEF * Q, char *sstring , int ignore_case);
int             SearchQ (char *Str);
int             Match (char *Str, char *Pat);
static int      I_Match (char *Str, char *Pat);
static int      S_Match (char *S, char *P, int Anchor);

/*----------------------------------------------------------------------*/

QUE_DEF         PatQue;
char            T_Path[_MAX_PATH];                    /* Temporary directory path to search   */
char            V_Path[_MAX_PATH];                    /* Selected file */

/**************************************************************************
 Find and put cursor on file with matching name
*/
int find_name(char *fname, int *current_page, int *filenumber)
{
     register int counter;
     int result=FAILURE;
     if (!number_of_files) return (result);
     for (counter=1;counter<=number_of_files;counter++)
       if (!strcmp(find[counter].name,fname))
       {
	   result=SUCCESS;
	   break;
       }
     if (result==SUCCESS)
     {
	 *filenumber=counter;
	 *current_page=((counter%114) ? counter/114 : counter/114 - 1);
     }
     return (result);
}

/*************************************************************************
 hide mouse, _outtext, show_mouse
*/
void outtextm( char *string )
{
    hide_mouse();
    _outtext(string);
    show_mouse();
}

/*************************************************************************
  Returns F for normal file, D for directory, V for volume label, H for hidden file.
  Displays Filename if mode != NOREPAINT
*/
char filename( int filenumber, int mode )
{
    char type, namebuf[14];
    static struct videoconfig vc={0,0,0,0,0,0,0,0,0,0,0};

    if (!vc.numcolors) _getvideoconfig( &vc ); /* initialize on first call */

    if (vc.mode==_TEXTMONO)
	sprintf( namebuf, "%c%-12s",
		 (find[filenumber].attrib & _A_HIDDEN) ? '' : ' ',
		 find[filenumber].name);
    else sprintf( namebuf, "%-12s ",find[filenumber].name);

    if( find[filenumber].attrib & _A_SUBDIR )      type='D';  /* directory */
    else if( find[filenumber].attrib & _A_VOLID )  type='V';  /* volume label */
	 else type='F';                                       /* normal file */

    switch (mode)
    {
    case NOREPAINT: break;
    case CURSOR: set_cursor( filenumber );
		 switch (type)
		 {
		    case 'D': if (find[filenumber].attrib & _A_HIDDEN) _settextcolor( (short) cursor_hidden_directory_color );
			      else _settextcolor( (short) cursor_directory_color );
			      break;
		    case 'V': _settextcolor( (short) cursor_volume_label_color );
			      break;
		    case 'F': if (find[filenumber].attrib & _A_HIDDEN) _settextcolor( (short) cursor_hidden_file_color );
			      else _settextcolor( (short) cursor_file_color );
			      break;
		 }    
	 if (number_of_files) _setbkcolor( (long) cursor_bg_color );
		 outtextm( namebuf );
		 _setbkcolor( (long) screen_bg_color );
		 break;
    case NORMAL: set_cursor( filenumber );
		 switch (type)
		 {
		    case 'D': if (find[filenumber].attrib & _A_HIDDEN) _settextcolor( (short) hidden_directory_color );
			      else _settextcolor( (short) directory_color );
			      break;
		    case 'V': _settextcolor( (short) volume_label_color );
			      break;
		    case 'F': if (find[filenumber].attrib & _A_HIDDEN) _settextcolor( (short) hidden_file_color );
			      else _settextcolor( (short) file_color );
			      break;
		 }
		 _setbkcolor( (long) screen_bg_color );
		 outtextm( namebuf );
		 break;
    }
    return (type);
}


/***************************************************************************
 Displays information about a file.
*/
void fileinfo( int filenumber )
{
    char timebuf[9], datebuf[12], attrbuf[5], namebuf[13], sizebuf[9], type;
    struct find_t pfind;
    short x,y,c;
    char b[8*29+10];                    /* Buffer for string */
    char __near *savedscreen;
    int key=0;
    unsigned result;

    /* get full file information */
    working(TRUE);
    dos_error_auto_fail=TRUE;
    if (!strcmp(find[filenumber].name,"..")) result=_dos_findfirst( ".", 0xffff, &pfind );
    else result=_dos_findfirst( find[filenumber].name, 0xffff, &pfind );
    working(FALSE);
    dos_error_auto_fail=FALSE;
    if (result) /* not succeeded, get out */
    {
       show_error("Cannot get the information for this file ");
       return;
    }
    savedscreen=saveScrn();

    y = ((25 -  8) / 2) + 1;     /* 8 lines, add 1 to center in FS window */
    x = ((80 - 28) / 2);         /* 28 visible characters per line */

    datestr( pfind.wr_date, datebuf );
    timestr( pfind.wr_time, timebuf );

    sprintf( attrbuf, "%c%c%c%c",
	    (pfind.attrib & _A_RDONLY) ? 'R' : '_',
	    (pfind.attrib & _A_HIDDEN) ? 'H' : '_',
	    (pfind.attrib & _A_SYSTEM) ? 'S' : '_',
	    (pfind.attrib & _A_ARCH)     ? 'A' : '_' );

    sprintf( sizebuf, "%ld", pfind.size);

    sprintf( namebuf, "%-12s", pfind.name);

    if( pfind.attrib & _A_SUBDIR )       type='D';  /* directory */
    else if( pfind.attrib & _A_VOLID )   type='V';  /* volume label */
	 else type='F';                             /* normal file */

    _settextcolor( (short) info_text_color );
    _setbkcolor( (long) info_bg_color );
    /* Use text window to place output in middle of screen */
    /* The window is 1 position larger than the output string. */
    _settextwindow( y, x, y + 8, x + 28 );
    shadebox(    y, x, y + 8 - 1 , x + 28 - 1 );

    /* Write all information to a string, then output string. */
    c  = sprintf( b    , "ͻ\n");
    c += sprintf( b + c, " Filename  : %-12s \n",namebuf);
    c += sprintf( b + c, " Size      : %-12s \n",sizebuf);
    c += sprintf( b + c, " Date      : %-12s \n",datebuf);
    c += sprintf( b + c, " Time      : %-12s \n",timebuf);
    c += sprintf( b + c, " Attributes: %-12s \n",attrbuf);
    c += sprintf( b + c, " Type      : ");
    switch (type)
    {
	case 'F': c += sprintf( b + c, "%-12s \n","File");
		  break;
	case 'D': c += sprintf( b + c, "%-12s \n","Directory");
		  break;
	case 'V': c += sprintf( b + c, "%-12s \n","Volume label");
		  break;
    }
    c += sprintf( b + c, "ͼ\n");
    outtextm( b );
    while (!(key=n_kbhit()) && !mouse_button_pressed()) /* wait */ restrict_mouse_topline();
    _settextwindow( 3, 1, 23, 80 );
    _setbkcolor( (long) screen_bg_color );
    savedscreen=restScrn(savedscreen);
    if ((key & 0x00FF)==ESC) getkey();  /* trash ESC */
}

/***************************************************************************
 * Takes unsigned time in the format:             fedcba9876543210
 * s=2 sec incr, m=0-59, h=23                       hhhhhmmmmmmsssss
 * Changes to a 8-byte string:                      hh:mm:ss
 */
char *timestr( unsigned t, char *buf )
{
    int h = (t >> 11) & 0x1f, m = (t >> 5) & 0x3f, s= t & 0x1f;

    sprintf( buf, "%2.2d:%02.2d:%02.2d", h, m, s*2 );   return buf;
}

/**************************************************************************
 * Takes unsigned date in the format:               fedcba9876543210
 * d=1-31, m=1-12, y=0-119 (1980-2099)              yyyyyyymmmmddddd
 * Changes to a 11-byte string:                     DD-MON-YYYY
 */
char *datestr( unsigned d, char *buf )
{
    char *month[]={"JAN","FEB","MAR","APR","MAY","JUN","JUL","AUG","SEP","OCT","NOV","DEC"};
    int day = d & 0x1f, m = (d >> 5) & 0x0f, y = ((d >> 9) & 0x7f) + 1980;

    sprintf( buf, "%02d-%s-%d", day, month[m-1], y);
    return buf;
}

/***************************************************************************
 * Takes time in a 8-byte string:                      hh:mm:ss
 * Changes to unsigned time in the format:             fedcba9876543210
 * s=0-29 (2 sec incr), m=0-59, h=0-23                 hhhhhmmmmmmsssss
 */
unsigned int strtime( char *buf )
{   
    unsigned int t;
    int hour;
    int min;
    int sec;
    int corrected=FALSE;
    
    sec = atoi(buf+6); 
    if (sec<0)
    {
	sec=0;
	corrected=TRUE;
    }    
    if (sec>59)
    {
	sec=59;
	corrected=TRUE;
    }    
    t = sec / 2;
    
    buf[5] = '\0';
    min=atoi(buf+3);
    if (min<0)
    {
	min=0;
	corrected=TRUE;
    }    
    if (min>59)
    {
	min=59;
	corrected=TRUE;
    }    
    t += (min << 5);
    
    buf[2] = '\0';
    hour=atoi(buf);
    if (hour<0)
    {
	hour=0;
	corrected=TRUE;
    }    
    if (hour>23)
    {
	hour=23;
	corrected=TRUE;
    }    
    t += (hour << 11);  
    
    if (corrected) show_error("Limited time between 00:00:00 and 23:59:59");
    
    return t;
}


/**************************************************************************
 * Takes date in a 11-byte string:                     DD-MON-YYYY
 * Changes to unsigned date in the format:             fedcba9876543210
 * d=1-31, m=1-12, y=0-119 (1980-2099)                 yyyyyyymmmmddddd
 */
unsigned int strdate( char *buf )
{   
    char *month[]={"JAN","FEB","MAR","APR","MAY","JUN","JUL","AUG","SEP","OCT","NOV","DEC"};
    int mnth=0;
    unsigned int date;
    int day;
    int year;
    int corrected=FALSE;
		 
    strupr(buf);
		 
    year = atoi(buf+7)-1980;
    if (year<0) 
    {
	year=0;          /* limit to valid year */
	corrected=TRUE; 
    }    
    if (year>119)
    {
	year=119;
	corrected=TRUE; 
    }    
    date = (year << 9);
    
    buf[6] = '\0';
    while (strcmp(buf+3,month[mnth]) && mnth<=11) mnth++;
    if (mnth>11)
    {
	mnth=0;         /* limit to valid month */
	corrected=TRUE; 
    }    
    date += ((++mnth) << 5);
       
    buf[2] = '\0';
    day = atoi(buf);       
    if (day<1)
    {
	day=1;            /* limit to valid day */
	corrected=TRUE; 
    }    
    if (day>31)
    {
	day=31;
	corrected=TRUE; 
    }    
    date += day;
       
    if (corrected) show_error("Limited date between 01-JAN-1980 and 31-DEC-2099");
       
    return date;  
}

/***************************************************************************
 * Calculate page, line, column from filenumber and sets cursor position
 * Displays page number if this is changed
 * pagelayout: 6 columns of 19 files per page, 114 files per page,
 *             starting at window line 1, column width 13 (position 1,14,27...)
 * filenumber= 1,2,...
 * page      = 0,1,...
 * line      = 2,3,...,21
 * column    = 2,15,28,41,54,67
 */
void set_cursor( int filenumber )
{
    int line, column, relfilenumber, old_page, old_max_page;
    char linebuf[10];
    static int page=-1;
    static int max_page=-1;
    old_page=page;
    old_max_page=max_page;
    max_page=((number_of_files%114) ? number_of_files/114 : number_of_files/114 - 1);
    line=((filenumber%19) ? filenumber%19 : 19) + 1;
    page=((filenumber%114) ? filenumber/114 : filenumber/114 - 1);
    relfilenumber=(filenumber - page*114);
    column=((relfilenumber%19) ? relfilenumber/19 : relfilenumber/19 - 1) * 13 + 2;
    if (old_page!=page || old_max_page!=max_page)
    {
	sprintf(linebuf,"%d/%d ",page+1,max_page+1);
	_settextposition( 1, 72 );
	_settextcolor( (short) file_color );
	_setbkcolor( (long) screen_bg_color );
	outtextm(linebuf);
    }
    _settextposition( line, column );
}


/**************************************************************************
  Clear remaining directory page by displaying blank names, starting with
  filenumber+1
 */
void clear_remaining( int filenumber )
{
    register int line, column, relfilenumber;
    int page;

    hide_mouse();
    page=((filenumber%114) ? filenumber/114 : filenumber/114 - 1);
    relfilenumber=(filenumber - page*114);
    _setbkcolor( (long) screen_bg_color );
    _settextcolor( (short) file_color );
    while (relfilenumber < 114 )
    {
	filenumber++;
	relfilenumber++;
	line=((filenumber%19) ? filenumber%19 : 19) + 1;
	column=((relfilenumber%19) ? relfilenumber/19 : relfilenumber/19 - 1) * 13 + 2;
	_settextposition( line, column );
	outtextm( "             " );
    }
    show_mouse();
}

/***************************************************************************
 * Compares e1 and e2 and returns greater than (>0), less than (<0), or equal to (0).
 * This function is called by qsort.
 */

int _cdecl cmpgle( const void *elem1, const void *elem2 )
{
    const struct find_t_small *e1, *e2;
    e1=elem1;
    e2=elem2;
    if (order_type==DESCENDING)
    { 
       switch(order_by)
       {
	  case SIZE:
	  case DATE: if (e1->datetime_or_size < e2->datetime_or_size) return (1);
		     if (e1->datetime_or_size > e2->datetime_or_size) return (-1);
		     if (e1->datetime_or_size == e2->datetime_or_size) return (0);
		     break;
	  case NAME: return (strcmp(e2->name,e1->name));
		     break;
       }
    }
    else
    {
       switch(order_by)
       {
	  case SIZE:
	  case DATE: if (e1->datetime_or_size < e2->datetime_or_size) return (-1);
		     if (e1->datetime_or_size > e2->datetime_or_size) return (1);
		     if (e1->datetime_or_size == e2->datetime_or_size) return (0);
		     break;
	  case NAME: return (strcmp(e1->name,e2->name));
		     break;
       }
    }
}

/***************************************************************************
 Fills find structure and sets number_of_files global. Filters files with
 searchstring mask. Skips "." directory and volume label. Sorts find structure
*/
int extract_directory( char *searchstring )
{
    struct find_t findtemp;
    char type;
    int key;

    number_of_files=0;
    working(TRUE);
    /* Find first matching file, then find additional matches. */
    dos_error_auto_fail=TRUE;
    if( !_dos_findfirst( "*.*\0", _A_ARCH | _A_HIDDEN | _A_NORMAL | _A_RDONLY |
				  _A_SUBDIR | _A_SYSTEM | _A_VOLID, &findtemp ) )
    {
       if( findtemp.attrib & _A_SUBDIR ) type='D';      /* directory */
       else if( findtemp.attrib & _A_VOLID ) type='V'; /* volume label */
	    else type='F'; /* normal file (and hidden file) */
       if (findtemp.name[0]=='.' && findtemp.name[1]=='\0' && type== 'D') type='N'; /* null dir */
       if (type=='F' || type=='D' || type=='V')
       {
	 strcpy(find[++number_of_files].name,findtemp.name);
	 find[number_of_files].attrib=findtemp.attrib;
	 if (order_by==SIZE) find[number_of_files].datetime_or_size=(unsigned long) findtemp.size;
	 else find[number_of_files].datetime_or_size=make_dt(findtemp.wr_date,findtemp.wr_time);
       }
       if (type=='F' && strlen(searchstring) && !Match(findtemp.name,searchstring)) number_of_files--;

       while( !_dos_findnext( &findtemp ) && (number_of_files < max_files ))
       {
	 if( findtemp.attrib & _A_SUBDIR ) type='D';    /* directory */
	 else if( findtemp.attrib & _A_VOLID ) type='V'; /* volume label */
	      else type='F'; /* normal file */
	 if (findtemp.name[0]=='.' && findtemp.name[1]=='\0' && type== 'D') type='N'; /* null dir */
	 if (type=='F' || type=='D' || type=='V')
	 {
	   strcpy(find[++number_of_files].name,findtemp.name);
	   find[number_of_files].attrib=findtemp.attrib;
	   if (order_by==SIZE) find[number_of_files].datetime_or_size=(unsigned long) findtemp.size;
	   else find[number_of_files].datetime_or_size=make_dt(findtemp.wr_date,findtemp.wr_time);
	 }
	 /* do we really want this file? */
	 if (type=='F')
	 {              
	     /* does it match the mask ? */
	     if (strlen(searchstring) && !Match(findtemp.name,searchstring))
		number_of_files--; 
	     /* does it match the date and time ? */   
	     else if (!date_interval_correct(make_dt(findtemp.wr_date,findtemp.wr_time),turnover_datetime, turnover_datetime_mode))
		     number_of_files--;
	 }      

	 /* user cancels find operation */
	 if (n_kbhit()) 
	 {   
	     key=getkey();
	     if ((key & 0x00FF)==ESC) 
	     {    
		 getkey();  /* trash ESC */ 
		 show_message( "Aborted by user, not all files visible" );
		 break;
	     } 
	 }   
	 
       }
    }
    working(FALSE);
    dos_error_auto_fail=FALSE;
    if (!number_of_files)
    {
	show_message( "No files found" );
	find[1].attrib='\0';
	find[1].name[0]='\0';
	find[1].datetime_or_size=0L;
	return FAILURE;
    }

    if (order_by != NONE)
    {
	working(TRUE);
	put_parent_on_top(order_type);
	qsort( (void *) (&(find[1])), (size_t) number_of_files,
	       (size_t) sizeof(FIND_T_SMALL), cmpgle);
	make_parent_two_dots();
	working(FALSE);
    }

    return SUCCESS;
}

void put_parent_on_top( int order_type )
{
    register int counter;

    for (counter=1;counter<number_of_files;counter++)
    {
	if (!strcmp(find[counter].name,".."))     /* force .. directory on top */
	{
	   if (order_type==ASCENDING)
	   {
	       find[counter].datetime_or_size=0L;
	       find[counter].name[0]='\0';
	       find[counter].name[1]='\0';
	   }
	   else
	   {
	       find[counter].datetime_or_size=0xFFFFFFFFL;
	       find[counter].name[0]=(unsigned char) 0xFF;
	       find[counter].name[1]='\0';

	   }
	   break;
	}
    }
}

void make_parent_two_dots( void )
{
    register int counter;

    for (counter=1;counter<number_of_files;counter++)
    {
	if (find[counter].name[1]=='\0' &&
	    (find[counter].name[0]=='\0' || find[counter].name[0]==(unsigned char) 0xFF))
	{                 /* restore parent to .. */
	   strcpy(find[counter].name,"..");
	   break;
	}
    }

}

/* Construct yymmddhhmmss number to enable sort on file date & time */
unsigned long make_dt( unsigned d, unsigned t)
{
    unsigned long dt;

    dt= ( ((unsigned long) d) << 16) + ((unsigned long) t);
    return dt;
}

/****************************************************************************
 Display the filenames of one page
*/
void show_dir_page( int page )
{
    register int filenumber;
    for (filenumber=1 + page*114; filenumber<=(114 + page*114) && filenumber<=number_of_files; filenumber++)
    {
	filename( filenumber, NORMAL );
    }
    clear_remaining( filenumber-1 );
}

/****************************************************************************
 Draw the border lines
*/
void kader( void )
{
    int line;
    char scratch[_MAX_PATH];
    
    _settextwindow( 3, 1, 24, 80 );  /* prevent scroll-up */
    _settextcolor( (short) file_color );
    _settextposition( 1, 1 );
    hide_mouse();
    _outtext("          ͻ");
    for (line=2;line<=20;line++)
    {
	_settextposition( line, 1 );
	_outtext("");
	_settextposition( line, 80 );
	_outtext("");
    }
    _settextposition( 21, 1 );
    _outtext("ͼ");
    if (number_of_files==max_files)
    {
	 _settextposition( 21,64 );
	 _outtext( "File table full");
    }
    
	_settextposition( 21,14 );
	
	strcpy(scratch," ");
	strncat(scratch,processor,62);
	strcat(scratch," ");
	strlwr(scratch);
	_outtext( scratch );
	
    show_mouse();
    _settextwindow( 3, 1, 23, 80 );
}

/**************************************************************************
 Beep
*/
void alert( void )
{
    _bios_str( "\007" );
} /* end alert */

/****************************************************************************
 * Handler to deal with hard error codes. Since DOS is not reentrant,
 * it is not safe to use DOS calls for doing I/O within the DOS Critical
 * Error Handler (int 24h) used by _harderr. Therefore, screen output and
 * keyboard input must be done through the BIOS.
 * Do not interact with user and return doserr if dos_error_auto_fail is TRUE
 */
void _far hhandler( unsigned deverr, unsigned doserr, unsigned _far *hdr )
{
    int ch;
    unsigned char row=3;
    int itel,itel2;

    static char buf[200], tmpbuf[10];

    /* save error code */
    dos_error=doserr;
    
    if (dos_error_auto_fail)
    {
	  dos_error_auto_fail=FALSE;    /* avoid looping */
	  _hardretn( doserr );
    }
    strcpy( buf, " Device error code: " );
    strcat( buf, itoa( deverr, tmpbuf, 10 ) );
    strcat( buf, " " );
    ScrPutS( buf, 0x0f, row++, 1);
    strcpy( buf, " DOS error code   : " );
    strcat( buf, itoa( doserr, tmpbuf, 10 ) );
    strcat( buf, " " );
    ScrPutS( buf, 0x0f, row++, 1);
    if ( allow_abort_on_error) strcpy( buf, " (F) for Fail, (A) to Abort, any other key to Retry ? " );
    else strcpy( buf, " (F) for Fail, any other key to Retry ? " );
    ScrPutS( buf, 0x0f, row++, 1);

    _bios_str( "\007" );
    ch = _bios_keybrd( _KEYBRD_READ ) & 0x00ff;

    switch( ch )
    {   
	case 'A':
	case 'a': if (allow_abort_on_error) _hardresume( _HARDERR_ABORT );
		  break; 
	case 'F':
	case 'f':       /* Return to DOS with error code */
	    dos_retries=0;
	    for (itel=3;itel<=6;itel++)          /* blank screen segment */
		for (itel2=1;itel2<=41;itel2++)
		    ScrPutS( " ", ((unsigned char) (screen_bg_color * 16)),
				  (unsigned char) itel,(unsigned char) itel2);
	    _hardretn( doserr );
	default:        /* Try again */
	    dos_retries++;
	    strcpy( buf, " Retrying");
	    for (itel=0;itel<dos_retries;itel++) strcat( buf,".");
	    ScrPutS( buf, 0x0f, row++, 1);
	    _hardresume( _HARDERR_RETRY );
    }
}


/****************************************************************************
 * Display a string using BIOS interrupt 0x0e (Write TTY). Return length
 * of string displayed.
 */
int _bios_str( char *p )
{
    union REGS inregs, outregs;
    char *start = p;

    inregs.h.ah = 0x0e;
    for( ; *p; p++ )
    {
	inregs.h.al = *p;
	int86( 0x10, &inregs, &outregs );
    }
    return p - start;
}

/*************************************************************************
 Display an error message, wait one second and blank out message
*/
void show_error( char *message )
{
    char __near *savedscreen;
    alert();
    savedscreen=show_string( message, error_bg_color, error_text_color );
    wait_sec(1000);
    restScrn(savedscreen); /* remove string box */
}

/*************************************************************************
 Display a message, wait one second and blank out message
*/
void show_message( char *message )
{
    char __near *savedscreen;
    savedscreen=show_string( message, info_bg_color, info_text_color );
    wait_sec(1000);
    restScrn(savedscreen); /* remove string box */
}

/*************************************************************************
 wait, suspend program
*/
void wait_sec( int milliseconds )
{
    clock_t cstart;
    cstart=clock();
    while ( (clock()-cstart) < (clock_t) (CLOCKS_PER_SEC/1000) * (clock_t) milliseconds) ;
}

/****************************************************************************
 Displays help information
*/
void helpscreen( void )
{
    int key=0;
    char b[(15*77)+10]={              /* Buffer for string */
			 "ͻ\n"
			 "            FS 2.9 (C) Copyright M.C.J. van Breemen, 1992-1995            \n"
			 "͹\n"
			 " \x1B\x17\x1A    Move cursor       / Refresh screen          O Change order        \n"
			 " Return Select file/dir   D Select drive            B Since/before date   \n"     
			 " Alt-AZ Go to filename    I File information        W Where is file/text  \n"
			 " PgUp   Previous screen   R Rename item             C Copy file           \n"
			 " PgDn   Next screen       S Show file               J Change linewidth    \n"
			 " Home   First file        Z Change file date/time   A Change attributes   \n"
			 " End    Last file         M Change selection mask   N Create directory    \n"
			 " T      Top directory     E Execute file            V Create volume label \n"
			 " U      Up one dir.       X Temporary exit to DOS   F Disk space free     \n"
			 " Esc    Exit / Cancel     L Exit & keep dir.        P About the program   \n"
			 " Del    Delete item                                                       \n"
			 "ͼ\n"
		       };
    char __near *savedscreen;

    savedscreen=saveScrn();

    _settextcolor( (short) info_text_color );
    _setbkcolor( (long) info_bg_color );

    paint_box( b, 76, 15);

    while (!(key=n_kbhit()) && !mouse_button_pressed()) /* wait */ restrict_mouse_topline();
    _settextwindow( 3, 1, 23, 80 );
    _setbkcolor( (long) screen_bg_color );
    savedscreen=restScrn(savedscreen);
    if ((key & 0x00FF)==ESC) getkey();  /* trash ESC */
}


/****************************************************************************
 Displays program information
*/
void aboutscreen( void )
{
    int key=0;
    char b[(18*53)+10]={              /* Buffer for string */
			 "ͻ\n"
			 "                                                  \n"
			 "             File Selector, Version 2.9           \n"
			 "   Copyright (C) 1992-1995 by M.C.J. van Breemen  \n"
			 "                                                  \n"
			 "             Release date: 27-JAN-1995            \n"
			 "                                                  \n"
			 "          Program designed and written by:        \n"
			 "                                                  \n"
			 "             Maarten van Breemen                  \n"
			 "             Combinatiepolder 13                  \n"
			 "             5235 TR 's-Hertogenbosch             \n"
			 "             The Netherlands                      \n"
			 "                                                  \n"
			 "             E-mail: vbreemen@knoware.nl          \n"
			 "             CompuServe ID: 100125,2704           \n"
			 "                                                  \n"
			 "ͼ\n"
		       };
    char __near *savedscreen;

    savedscreen=saveScrn();

    _settextcolor( (short) info_text_color );
    _setbkcolor( (long) info_bg_color );

    paint_box( b, 52, 18);

    while (!(key=n_kbhit()) && !mouse_button_pressed()) /* wait */ restrict_mouse_topline();
    _settextwindow( 3, 1, 23, 80 );
    _setbkcolor( (long) screen_bg_color );
    savedscreen=restScrn(savedscreen);
    if ((key & 0x00FF)==ESC) getkey();  /* trash ESC */
}

/*************************************************************************
 Mouse
*/
void clear_left_button_queue( void )
{
    union REGS in_regs, out_regs;
    in_regs.x.bx = 0;   /* Clear left button queue */
    in_regs.x.ax = 5;
    int86(0x33, &in_regs, &out_regs);
}

/*************************************************************************
 Mouse
*/
void clear_right_button_queue( void )
{
    union REGS in_regs, out_regs;
    in_regs.x.bx = 1;   /* Clear right button queue */
    in_regs.x.ax = 5;
    int86(0x33, &in_regs, &out_regs);
}

/*************************************************************************
 Mouse
 * Read left button queue
 * Return 0 if no left button pressed
 *        1 if pressed but on new position
 *        2 if re-pressed on old position within 0.75 second
 */
int read_left_button_queue( int *row, int *col )
{
    union REGS in_regs, out_regs;
    static int lastrow, lastcol, number_times;
    static clock_t cstart;

    in_regs.x.bx = 0;
    in_regs.x.ax = 5;
    int86(0x33, &in_regs, &out_regs);

    number_times = out_regs.x.bx;
    *row = out_regs.x.dx / 8 + 1;
    *col = out_regs.x.cx / 8 + 1;
    if (!number_times) return 0;
    if (lastrow==*row && lastcol==*col && ((clock()-cstart) < (clock_t) CLOCKS_PER_SEC*2/3))
    {
	clear_left_button_queue();
	cstart=clock();
	return 2;
    }
    lastrow = *row;
    lastcol = *col;
    clear_left_button_queue();
    cstart=clock();
    return 1;
}
/*************************************************************************
 Mouse
 * Read right button queue
 * Return 0 if no right button pressed
 *        1 if pressed but on new position
 *        2 if re-pressed on old position within 0.75 second
 */
int read_right_button_queue( int *row, int *col )
{
    union REGS in_regs, out_regs;
    static int lastrow, lastcol, number_times;
    static clock_t cstart;

    in_regs.x.bx = 1;
    in_regs.x.ax = 5;
    int86(0x33, &in_regs, &out_regs);

    number_times = out_regs.x.bx;
    *row = out_regs.x.dx / 8 + 1;
    *col = out_regs.x.cx / 8 + 1;
    if (!number_times) return 0;
    if (lastrow==*row && lastcol==*col && ((clock()-cstart) < (clock_t) CLOCKS_PER_SEC*2/3))
    {
	clear_right_button_queue();
	cstart=clock();
	return 2;
    }
    lastrow = *row;
    lastcol = *col;
    clear_right_button_queue();
    cstart=clock();
    return 1;
}

/*********************************************************************88
 Mouse
*/
void init_mouse( void )
{
    union REGS in_regs, out_regs;
    int top, bottom, left, right;
    
    in_regs.x.ax = 0;           /* Initialize mouse */
    int86(0x33, &in_regs, &out_regs);
    if (!out_regs.x.ax)
    {
	 mouse_present=FALSE;
	 return;
    }    else mouse_present=TRUE;
    
    /* well, there is a mouse driver present, but hide the mouse until the first move */
    /* is detected by restrict_mouse_topline() */
    moved_after_init_mouse=FALSE;

    right = 79;  /* Restrict cursor horizontally */
    left = 2;
    in_regs.x.cx = 8 * (right - 1);
    in_regs.x.dx = 8 * (left - 1);
    in_regs.x.ax = 7;
    int86(0x33, &in_regs, &out_regs);
    top = 4;              /* Restrict cursor vertically */
    bottom = 22;
    in_regs.x.cx = 8 * (top - 1);
    in_regs.x.dx = 8 * (bottom - 1);
    in_regs.x.ax = 8;
    int86(0x33, &in_regs, &out_regs);
    clear_left_button_queue();
    if (mouse_col)         /* re-position mouse */
    {
       in_regs.x.cx = mouse_col;
       in_regs.x.dx = mouse_row;
       in_regs.x.ax = 4;
       int86(0x33, &in_regs, &out_regs);
    }
    /* show_mouse(); */
    /* do not show the mouse yet, let restrict_mouse_topline check for the first user move */
}

void set_mouse_position( int col, int row )
{
    union REGS in_regs, out_regs;
              
    mouse_col = 8 * (col - 1);              
    mouse_row = 8 * (row - 1);              
    in_regs.x.cx = mouse_col;
    in_regs.x.dx = mouse_row;
    in_regs.x.ax = 4;
    int86(0x33, &in_regs, &out_regs);
    
}

/***************************************************************************
 Mouse
*/
void hide_mouse( void )
{
    union REGS in_regs, out_regs;
    if (!mouse_present) return;
    /* first save mouse position for possible future mouse_init */
    in_regs.x.ax = 3;
    int86(0x33, &in_regs, &out_regs);
    mouse_col = out_regs.x.cx;
    mouse_row = out_regs.x.dx;

    in_regs.x.ax = 2;   /* Hide mouse cursor */
    int86(0x33, &in_regs, &out_regs);
}

/***************************************************************************
 Mouse
*/
void show_mouse( void )
{
    union REGS in_regs, out_regs;
    if (!mouse_present) return;
    in_regs.x.ax = 1;           /* Show mouse cursor */
    int86(0x33, &in_regs, &out_regs);
}

/*************************************************************************
 Mouse
 * Status mouse buttons
 * Return 0 if no button pressed
 *        else something is in queue
 */
int mouse_button_pressed( void )
{
    union REGS in_regs, out_regs;

    if (!mouse_present) return 0;

    in_regs.x.bx = 0;
    in_regs.x.ax = 3;
    int86(0x33, &in_regs, &out_regs);
    return( out_regs.x.bx );
}

/***************************************************************************
 Common redraw functions
*/
void perform_repaint(int current_page, int filenumber)
{
    char linebuf[81];
    int page, max_page;
    max_page=((number_of_files%114) ? number_of_files/114 : number_of_files/114 - 1);
    page=((filenumber%114) ? filenumber/114 : filenumber/114 - 1);
    _setbkcolor( (long) screen_bg_color );
    _settextcolor( (short) file_color );
    hide_mouse();
    _clearscreen( _GWINDOW );
    show_mouse();
    kader();
    show_path();
    show_dir_page( current_page );
    _setbkcolor( (long) screen_bg_color );
    _settextcolor( (short) file_color );
    sprintf(linebuf,"%d/%d ",page+1,max_page+1);
    _settextposition( 1, 72 );
    outtextm( linebuf );
    filename( filenumber, CURSOR );  /* emphasize file under cursor */
}

/**************************************************************************
 Cursor movement key handler, page down
*/
void c_pgdn( int *current_page, int *filenumber)
{
   int max_page;
   int old_current_page;

   old_current_page = *current_page;
   max_page=((number_of_files%114) ? number_of_files/114 : number_of_files/114 - 1);
   if (*current_page<max_page) (*current_page)++;
   else *current_page=0;

   if (*current_page != old_current_page)
   {
       show_dir_page( *current_page );
       *filenumber=((*current_page)*114+1);
       filename( *filenumber, CURSOR );
   }
}

/**************************************************************************
 Cursor movement key handler, page up
*/
void c_pgup( int *current_page, int *filenumber)
{
    int max_page;
    int old_current_page;

    old_current_page = *current_page;
    max_page=((number_of_files%114) ? number_of_files/114 : number_of_files/114 - 1);
    if (*current_page>0) (*current_page)--;
    else *current_page=max_page;

    if (*current_page != old_current_page)
    {
	show_dir_page( *current_page );
	*filenumber=((*current_page)*114+1);
	filename( *filenumber, CURSOR );
    }
}

/**************************************************************************
 Cursor movement key handler, home
*/
void c_home( int *current_page, int *filenumber)
{
     *current_page=0;
     show_dir_page( *current_page );
     *filenumber=((*current_page)*114+1);
     filename( *filenumber, CURSOR );
}

/**************************************************************************
 Find and display file with starting character chr
*/
void find_first(char chr, int *current_page, int *filenumber)
{
     register int counter;
     int old_page;
     int old_filenumber;
     if (!number_of_files) return;
     old_page=*current_page;
     old_filenumber=*filenumber;
     for (counter=1;counter<number_of_files;counter++) /* should end at last file */
       if (find[counter].name[0]>=chr) break;
     *filenumber=counter;
     *current_page=((counter%114) ? counter/114 : counter/114 - 1);
     if (*current_page!=old_page) perform_repaint(*current_page,*filenumber);
     else
     {
	if (*filenumber!=old_filenumber)
	{
	    filename( old_filenumber, NORMAL );
	    filename( *filenumber, CURSOR );
	}
     }
}

/**************************************************************************
 Cursor movement key handler, end
*/
void c_end( int *current_page, int *filenumber)
{
     int max_page;
     max_page=((number_of_files%114) ? number_of_files/114 : number_of_files/114 - 1);
     *current_page=max_page;
     show_dir_page( *current_page );
     *filenumber=((*current_page)*114+114);
     *filenumber=(*filenumber<number_of_files) ? *filenumber : number_of_files;
     filename( *filenumber, CURSOR );
}

/**************************************************************************
 Cursor movement key handler, up arrow
*/
void c_cup( int *current_page, int *filenumber)
{
   int old_filenumber;
   old_filenumber=*filenumber;
   if (*filenumber>((*current_page)*114+1)) (*filenumber)--;
   else
   {
	*filenumber=((*current_page)*114+114);
	*filenumber=(*filenumber<number_of_files) ? *filenumber : number_of_files;
   }
   if (*filenumber!=old_filenumber)
   {
	filename( old_filenumber, NORMAL );
	filename( *filenumber, CURSOR );
   }
}

/**************************************************************************
 Cursor movement key handler, down arrow
*/
void c_cdn( int *current_page, int *filenumber)
{
   int old_filenumber;
   old_filenumber=*filenumber;
   if (*filenumber<((*current_page)*114+114) &&
       *filenumber<number_of_files) (*filenumber)++;
    else *filenumber=((*current_page)*114+1);
   filename( old_filenumber, NORMAL );
   filename( *filenumber, CURSOR );
}

/**************************************************************************
 Cursor movement key handler , right arrow
*/
void c_cri( int *current_page, int *filenumber)
{
    int old_filenumber;
    old_filenumber=*filenumber;
    if ((*filenumber <= ((*current_page)*114+95)) &&
	((*filenumber+19) <= number_of_files)) (*filenumber)+=19;
    else
    {
	(*filenumber)%=19;
	if (!(*filenumber)) *filenumber=19;
	(*filenumber)+=((*current_page)*114);
    }
    if (*filenumber!=old_filenumber)
    {
	filename( old_filenumber, NORMAL );
	filename( *filenumber, CURSOR );
    }
}

/**************************************************************************
 Cursor movement key handler, left arrow
*/
void c_cle( int *current_page, int *filenumber)
{
    int old_filenumber;
    int maxcolumnnumber;
    old_filenumber=*filenumber;
    if (*filenumber>=((*current_page)*114+1)+19) (*filenumber)-=19;
    else
    {
	maxcolumnnumber=5;
	while ((*filenumber+maxcolumnnumber*19)>number_of_files) maxcolumnnumber--;
	(*filenumber)+=maxcolumnnumber*19;
    }
    if (*filenumber!=old_filenumber)
    {
	filename( old_filenumber, NORMAL );
	filename( *filenumber, CURSOR );
    }
}


/***********************************************************************
 returns 0 if no key waiting, key code if key waiting
*/
unsigned int n_kbhit()
{
    int kread = _KEYBRD_READ;
    int kready = _KEYBRD_READY;
    int kshiftstatus = _KEYBRD_SHIFTSTATUS;

    /* If bit 4 of the byte at 0x0040:0x0096 is set, the new keyboard
     * is present.
     */
    if( peek( 0x00400096 ) & 0x10 )
    {
	kread = _NKEYBRD_READ;
	kready = _NKEYBRD_READY;
	kshiftstatus = _NKEYBRD_SHIFTSTATUS;
    }
    return _bios_keybrd( kready );
}

/************************************************************************
 Entry point of directory handler
 Globals: find, files structure
	  number_of_files
	  colors
 Returns SUCCESS if a valid choice has been made, else EXIT_RESTORE if ESCaped
 or EXIT_KEEP if Leaved
 Passes selected file in string selected
*/
int handle_dir( char *searchstr, char *selected , int safe_mode)
{
    int key;
    int repaint;
    static int current_page=0;
    static int filenumber=1;
    int old_filenumber;
    short  oldfgd;               /* old foreground color */
    long   oldbgd;               /* old background color */
    struct rccoord oldpos;
    short oldcursor;             /* old cursor shape */
    int olddrive, lastdrive, newdrive;
    char oldcwd[_MAX_PATH];
    int row, col;                       /* mouse variables */
    int finished;
    struct videoconfig vc;
    char scratch[ _MAX_PATH ];          /* scratch string space */
    int exit_and_keep=FALSE;            /* boolean for 'l' function */
    char __near *dummyspace;            /* memory reserved for saveScrn */
    struct diskfree_t drvinfo;
    char comspec[_MAX_PATH];
    int huge_find=FALSE;                /* first try to use near heap memory */
    int old_order_by;                   /* old info could still be valid */
    char __near *savedscreen;
    int mouse_clicks;
    void __near *nearfind;              /* needed to free the near heap memory */
    unsigned int shift;
		      
    if (!safe_mode) allow_abort_on_error=TRUE;
			  
    strcpy(comspec,getenv("COMSPEC"));
    if (!strlen(comspec)) strcpy(comspec,"COMMAND"); /* default program to run is COMMAND.COM */

    /* Save original foreground, background, and text position. */
    init_mouse();
    set_mouse_position( 40,12); /* initial position */
    oldfgd = _gettextcolor();
    oldbgd = _getbkcolor();
    oldpos = _gettextposition();
    oldcursor=_gettextcursor();
    _settextcursor( 0x2000 );
    _settextwindow( 3, 1, 23, 80 );

    _getvideoconfig( &vc );

    if (vc.mode==_TEXTMONO)
    {
	screen_bg_color   = M_BLACK_BG;
	file_color        = M_GRAY;
	hidden_file_color = M_GRAY;
	directory_color   = M_WHITE;
	hidden_directory_color       = M_WHITE;
	volume_label_color= M_GRAY;
	cursor_bg_color   = M_BLACK_BG;
	info_bg_color     = M_BLACK_BG;
	info_text_color   = M_WHITE;
	error_bg_color    = M_BLACK_BG;
	error_text_color  = M_WHITE;
	cursor_bg_color              = M_BLACK_BG;
	cursor_file_color            = M_GRAY_UNDL;
	cursor_directory_color       = M_WHITE_UNDL;
	cursor_hidden_file_color     = M_GRAY_UNDL;
	cursor_hidden_directory_color= M_WHITE_UNDL;
	cursor_volume_label_color    = M_GRAY_UNDL;
    }
    else
    {
	cursor_file_color            = file_color;
	cursor_directory_color       = directory_color;
	cursor_hidden_file_color     = hidden_file_color;
	cursor_hidden_directory_color= hidden_directory_color;
	cursor_volume_label_color    = volume_label_color;
    }


    if (!strlen(searchstring)) strcpy(searchstring,searchstr); /* keep old definition */
    if (!strlen(searchstring)) strcpy(searchstring,"*.*");
    find=(FIND_T_SMALL *) 0L;
    if (max_files<=0) max_files=MAX_FILES;
    if (max_linewidth<=0) max_linewidth=MAX_LINEWIDTH;

    dummyspace = (char __near *) _nmalloc (4096+1024); /* alloceer ruimte voor screen saves, near heap copy */

    if ( (((long) max_files + 2) * (long) sizeof(FIND_T_SMALL)) >= (long) _memmax() || huge_find)
    {
      if ( !(find = _halloc( ((long) max_files + 2), (size_t) sizeof(FIND_T_SMALL) )) )
      {
	_settextwindow( 1, 1, 25, 80 );
	_settextposition( oldpos.row, oldpos.col );
	_settextcursor( oldcursor );
	printf("Cannot allocate far heap memory for %d files ",max_files);
	alert();
	hide_mouse();
	default_mouse_rectangle();
	wait_sec(1000);
	if (dummyspace) _nfree(dummyspace);
	return FAILURE;
      }
      huge_find=TRUE;
    }
    else
    {
      find = (FIND_T_SMALL *) _ncalloc( (size_t) max_files + 2, (size_t) sizeof(FIND_T_SMALL) );
      if( !(((long) find) & 0x0000FFFF) ) /* 16 bits NULL if failed */ 
      {
	if (dummyspace) _nfree(dummyspace);
	_settextwindow( 1, 1, 25, 80 );
	_settextposition( oldpos.row, oldpos.col );
	_settextcursor( oldcursor );
	printf("Cannot allocate near heap memory for %d files ",max_files);
	alert();
	hide_mouse();
	wait_sec(1000);
	return FAILURE;
      }
      huge_find=FALSE;
    }
    if (dummyspace) _nfree(dummyspace);
    /* hoppa, we hebben weer lucht */

    /* Install our hard error handler. */
    _harderr( hhandler );

    /* Save current drive and current working directory. */
    olddrive = lastdrive = _getdrive();
    getcwd( oldcwd, _MAX_PATH );

    repaint=TRUE;
    extract_directory( searchstring );
    if (filenumber>number_of_files)     /* can we restore the cursor ? */
    {
	current_page=0;                 /* no */
	filenumber=1;
    }
    finished=FALSE;
    do
    {
	dos_error=0;
	dos_retries=0;

	if (repaint)
	{
	     /* maak kader repaint */
	     perform_repaint(current_page, filenumber);
	     repaint=FALSE;
	}

	if (mouse_present)
	{

	  restrict_mouse_topline();

	  mouse_clicks = read_left_button_queue(&row,&col);
	  if (row>3)
	  {
	    switch (mouse_clicks)
	    {
	    case 0: break;
	    case 1: if (!number_of_files) break;
		    old_filenumber=filenumber;
		    filenumber=(row-4)+(current_page*114+1)+((col-2)/13)*19;
		    if (filenumber>number_of_files) filenumber=old_filenumber;
		    if (filenumber!=old_filenumber)
		    {
			filename( old_filenumber, NORMAL );
			filename( filenumber, CURSOR );
		    }
		    break;
	    case 2: if (!number_of_files) break;
		    old_filenumber=filenumber;
		    filenumber=(row-4)+(current_page*114+1)+((col-2)/13)*19;
		    if (filenumber<=number_of_files)
		    {
			if (filename( filenumber, NOREPAINT )=='D')
			{
			   repaint=TRUE;
			   if (!strcmp(find[filenumber].name,"..")) /* going up */
			   {
			       find_parent( &current_page, &filenumber, searchstring);
			   }
			   else  /* going down */
			   {
				chdir( find[filenumber].name );
				extract_directory( searchstring );
				current_page=0;
				filenumber=1;
			   }
			} else finished=TRUE; /* add normal file handling here */
		    } else filenumber=old_filenumber;
		    break;
	    }
	  }
	  else
	  {
	      /* page down */
	      if (mouse_clicks)
	      {
		  if (number_of_files) c_pgdn( &current_page, &filenumber);
	      }
	  }

	  mouse_clicks = read_right_button_queue(&row,&col);
	  if (mouse_clicks && row>3 && number_of_files) /* right button */
	  { 
	    working(TRUE);
	    getpath( _getdrive(), scratch, _MAX_PATH );
	    working(FALSE);
	    if (strlen(scratch)>3)
	    {
	       repaint=TRUE;
	       find_parent( &current_page, &filenumber,searchstring);
	    }
	  }
	  else
	  {
	      /* page up */
	      if (mouse_clicks)
	      {
		  if (number_of_files) c_pgup( &current_page, &filenumber);
	      }
	  }

	}

       if (n_kbhit() && !finished)
       {
	key = getkey();
	if (key<256) key = tolower(key);
	if (key=='l' && !safe_mode)     /* leave FS here */
	{
	     exit_and_keep=TRUE;
	     key=ESC;
	}
	if (key==ESC) break;     /* ESC, exit do while TRUE loop */
	repaint=FALSE;
	switch (key)
	{
	    case 'i': if (number_of_files) fileinfo( filenumber );
		      break;
	    case 'h':
	    case '?': helpscreen();
		      break;
	    case 'p': aboutscreen();
		      break;
	    case 'a': if (safe_mode) break;
		      if (number_of_files)
		      {
			switch (ed_attributes(filenumber))
			{
			  case FAILURE: show_error("Cannot change attributes");
					break;                  
			  case SUCCESS: repaint=TRUE;
					extract_directory( searchstring );
					if (filenumber > number_of_files)
					{
					    filenumber=1;
					    current_page=0;
					}
					break;
			  case NOCHANGE: break;
			}
		      }  
		      break;
	    case 'z': if (safe_mode) break;
		      if (number_of_files)
		      {
			switch (ed_datetime(filenumber))
			{
			  case FAILURE: show_error("Cannot change date and time");
					break;                  
			  case SUCCESS: repaint=TRUE;
					extract_directory( searchstring );
					if (filenumber > number_of_files)
					{
					    filenumber=1;
					    current_page=0;
					}
					break;
			  case NOCHANGE: break;
			}
		      }
		      break;
	    case 'b': if (number_of_files)
		      {
			switch (ed_turnover_datetime())
			{
			  case FAILURE: show_error("Illegal date-time format");
					break;                  
			  case SUCCESS: repaint=TRUE;
					extract_directory( searchstring );
					if (filenumber > number_of_files)
					{
					    filenumber=1;
					    current_page=0;
					}
					break;
			  case NOCHANGE: break;
			}
		      }
		      break;
	    case 'o': if (number_of_files)
		      {
			  old_order_by=order_by;
			  strcpy(scratch,"");
			  switch(order_by)
			  {
			     case NAME: strcpy(scratch,"N");
					break;
			     case DATE: strcpy(scratch,"D");
					break;
			     case SIZE: strcpy(scratch,"S");
					break;
			  }
			  if (order_by != NONE)
			  {
			    switch(order_type)
			    {
			       case ASCENDING: strcat(scratch,"+");
					       break;
			       case DESCENDING: strcat(scratch,"-");
						break;
			    }
			  }
			  if (edit("Order by (N)ame, (D)ate or (S)ize. Order + or -",scratch,3,
			     "NDSnds+-",LEGAL))
			  {
			    strupr(scratch);
			    if (!strlen(scratch)) order_by=NONE;
			    if (strchr(scratch,(int) 'N')) order_by=NAME;
			    if (strchr(scratch,(int) 'S')) order_by=SIZE;
			    if (strchr(scratch,(int) 'D')) order_by=DATE;
			    if (strchr(scratch,(int) '-')) order_type=DESCENDING;
			    if (strchr(scratch,(int) '+')) order_type=ASCENDING;
			    repaint=TRUE;
			    if (order_by != NONE &&
				(old_order_by==order_by || (old_order_by!=SIZE && order_by!=SIZE)))
			    {
				working(TRUE);
				put_parent_on_top(order_type);
				qsort( (void *) (&(find[1])), (size_t) number_of_files,
				       (size_t) sizeof(FIND_T_SMALL), cmpgle); /* still valid */
				make_parent_two_dots();
				working(FALSE);
			    }
			    else
			    {
				extract_directory( searchstring );
				if (filenumber > number_of_files)
				{
				    filenumber=1;
				    current_page=0;
				}
			    }
			  }
		      }
		      break;
	    case K_PGDN: if (number_of_files) c_pgdn( &current_page, &filenumber);
			 break;
	    case K_PGUP: if (number_of_files) c_pgup( &current_page, &filenumber);
			 break;
	    case K_HOME: if (number_of_files) c_home( &current_page, &filenumber);
			 break;
	    case K_END: if (number_of_files) c_end( &current_page, &filenumber);
			break;
	    case K_CUP: if (number_of_files) c_cup( &current_page, &filenumber);
			break;
	    case K_CDN: if (number_of_files) c_cdn( &current_page, &filenumber);
			break;
	    case K_CRI: if (number_of_files) c_cri( &current_page, &filenumber);
			break;
	    case K_CLE: if (number_of_files) c_cle( &current_page, &filenumber);
			break;
	    case 'j': sprintf(scratch,"%d",max_linewidth);
		      if (edit("Maximal linewidth for Show File",scratch,5,
			     "0123456789",LEGAL))
		      {
		          max_linewidth=atoi(scratch);
		          if (max_linewidth<=0) max_linewidth=MAX_LINEWIDTH;
	              }
		      break;
	    case '\r': if (!number_of_files) break;
		       repaint=TRUE;
		       if (filename( filenumber, NOREPAINT )=='D')
		       {
			   if (!strcmp(find[filenumber].name,"..")) /* going up */
			   {
			       find_parent( &current_page, &filenumber,searchstring);
			   }
			   else  /* going down */
			   {
			       chdir( find[filenumber].name );
			       extract_directory( searchstring );
			       current_page=0;
			       filenumber=1;
			   }
		       } else finished=TRUE; /* add normal file handling here */
		       break;
	    case 'u':  if (!number_of_files) break;
		       working(TRUE);
		       getpath( _getdrive(), scratch, _MAX_PATH );
		       working(FALSE);
		       if (strlen(scratch)>3)
		       {
			   repaint=TRUE;
			   find_parent( &current_page, &filenumber,searchstring);
		       }
		       break;
	    case 't': if (!number_of_files) break;
		      working(TRUE);
		      getpath( _getdrive(), scratch, _MAX_PATH );
		      working(FALSE);
		      if (strlen(scratch)>3)
		      {
			  repaint=TRUE;
			  scratch[0]= (char) (_getdrive() - 1 + 'A');
			  scratch[1]=':';
			  scratch[2]='\\';
			  scratch[3]='\0';
			  chdir( scratch );
			  extract_directory( searchstring );
			  current_page=0;
			  filenumber=1;
		      }
		      break;
	    case 'x': if (safe_mode) break;
		      hide_mouse();
		      default_mouse_rectangle();
		      _settextcolor( oldfgd );
		      _setbkcolor( oldbgd );
		      _clearscreen( _GCLEARSCREEN );
		      _settextcursor( oldcursor );
		      lastdrive = _getdrive();
		      strcpy(scratch,"PROMPT=Type EXIT to return to FS$_$p$g");
		      putenv(scratch);
		      if (allow_swap) fs_systemo(swap_dir,"");
		      else system(comspec);
		      _harderr( hhandler );
		      init_mouse();
		      _settextcursor( 0x2000 );
		      _chdrive( lastdrive );
		      extract_directory( searchstring );
		      if (filenumber>number_of_files)   /* can we restore the cursor ? */
		      {
			  current_page=0;
			  filenumber=1;
		      }
		      repaint=TRUE;
		      break;

	    case 'f': working(TRUE);
		      if (freespace( scratch )==SUCCESS)
		      {
			   working(FALSE);
			   _settextposition( 23, 26 );
			   savedscreen=show_string( scratch , info_bg_color, info_text_color );
			   while (!n_kbhit() && !mouse_button_pressed()) /* wait */ restrict_mouse_topline();
			   restScrn(savedscreen);       /* remove string box */
		      } else
		      {
			   show_error("Cannot get disk information from this drive");
			   working(FALSE);
		      }
		      break;
	    case 'd': newdrive=ask_drive_number(" Type new drive letter or ESC ");
		      lastdrive = _getdrive();
		      if (newdrive==-1) break;

		      do
		      {
			  /* start excessive error checking to prevent */
			  /* triggering the dos error handler */
			  while (newdrive==-1)
			  {
			      newdrive=ask_drive_number(" Type new valid drive letter ");
			  }
			  working(TRUE);
			  dos_error=0;
			  dos_retries=0;
			  dos_error_auto_fail=TRUE;

			  if (!drvalid(newdrive-1) || dos_error)
			  {
			      working(FALSE);
			      show_error("Cannot change to this drive");
			      newdrive=-1;
			      continue;     /* and again */
			  }

			  dos_error=0;
			  dos_retries=0;
			  if (newdrive==1 || newdrive==2)
			  {
			      if (floptest(newdrive-1)) /* checks drive A or B */
			      {
				  working(FALSE);
				  show_error("Cannot select this drive");
				  newdrive=-1;
				  continue;             /* again */
			      }
			  }

			  dos_error_auto_fail=TRUE;
			  _dos_getdiskfree( newdrive, &drvinfo );
			  if (dos_error)
			  {
			      working(FALSE);
			      show_error("Cannot get disk information from this drive");
			      newdrive=-1;
			      continue;     /* and again */
			  }

			  dos_error_auto_fail=FALSE;
			  lastdrive=newdrive;   /* YES, successfull, get out */
			  break;
		      } while (TRUE);

		      working(FALSE);
		      extract_directory( searchstring );
		      current_page=0;
		      filenumber=1;
		      repaint=TRUE;
		      break;
	    case K_DEL: if (safe_mode) break;
			if (!number_of_files) break;
			if (!strcmp(find[filenumber].name,"..")) break;  /* this could give you a lot of free space */
			savedscreen=show_string("Type Y to delete or any other key to cancel", info_bg_color, info_text_color);
			_settextposition( 1, 1 );        /* prevent scroll-up from dos error */
			key = getkey();
			restScrn(savedscreen);  /* remove string box */

			if (key=='y' || key=='Y')
			{  
			   working(TRUE);
			   dos_error_auto_fail=TRUE; 
			   if (filename( filenumber, NOREPAINT )=='D')
			   {
				if (rmdir(find[filenumber].name)) /* first try normal delete, will fail if not empty */
				{                                 /* then try to clean up */
				       working(FALSE); 
				       savedscreen=show_string("Directory contains files.\n Type Y to delete, any other key to cancel",info_bg_color,info_text_color);
				       _settextposition( 1, 1 );          /* prevent scroll-up from dos error */
				       key = getkey();
				       restScrn(savedscreen);   /* remove string box */
				       if (key=='y' || key=='Y')
				       { 
					   working(TRUE);
					   do_dir(find[filenumber].name);
					   working(FALSE);
				       }
				}
			   dos_error_auto_fail=FALSE;
			   }
			   else
			   {
				dos_error_auto_fail=TRUE;
				working(TRUE);
				if (filename( filenumber, NOREPAINT )=='V')
				{
				    if (FilDelVolid( (unsigned char) _getdrive() )==NODEL)
				       show_error("Cannot delete this volume label");
				}
				else
				{
				    if (unlink(find[filenumber].name))
				       show_error("Cannot delete this file");
				}
				dos_error_auto_fail=FALSE;
				working(FALSE);
			   }
			   extract_directory( searchstring );
			   if (filenumber > number_of_files) /* we lost the file under the cursor */
			   {
			       if (number_of_files)
				  c_end( &current_page, &filenumber);
			   }
			   working(FALSE); 
			   repaint=TRUE;
			}
		      break;
	    case '/': repaint=TRUE;
		      extract_directory( searchstring );
		      if (filenumber > number_of_files)
		      {
			  filenumber=1;
			  current_page=0;
		      }
		      break;
	    case 'v': if (safe_mode) break;
		      dos_error_auto_fail=TRUE;
		      switch (rename_volume_label(0)) /* use dummy zero index */
		      {
			      case FAILURE: show_error("Cannot create this volume label");
					    break;
			      case SUCCESS: repaint=TRUE;
					    extract_directory( searchstring );
					    if (filenumber > number_of_files)
					    {
						filenumber=1;
						current_page=0;
					    }
					    break;
			      case NOCHANGE: break;
		      }
		      dos_error_auto_fail=FALSE;
		      break;
	    case 's': if (number_of_files)
		      {   
			 hide_mouse();
			 shift=getshift();
			 if ((shift & 1) || (shift & 2))  /* left or right shift is down */
			 {
			     if (old_show_file( find[filenumber].name)==SUCCESS)
				repaint=TRUE;
			 } else if (show_file( find[filenumber].name,max_linewidth)==SUCCESS)
				   repaint=TRUE;
			 show_mouse();
		      }            
		      break;
	    case 'e': if (safe_mode) break;
		      if (!number_of_files) break;
		      strcpy(scratch,find[filenumber].name);
		      strcat(scratch," ");
		      scratch[strlen(scratch)+1]='\0';
		      if (edit("Enter command-line arguments, ESC to cancel",scratch+strlen(scratch),48,"", ILLEGAL))
		      {
			 hide_mouse();
			 default_mouse_rectangle();
			 repaint=TRUE;
			 _settextcolor( oldfgd );
			 _setbkcolor( oldbgd );
			 _settextcursor( oldcursor );
			 lastdrive = _getdrive();
			 _clearscreen( _GCLEARSCREEN ); 
			 if (allow_swap) fs_systemo(swap_dir,scratch);
			 else system(scratch);
			 _settextcolor( (short) info_text_color );
			 _setbkcolor( (long) screen_bg_color );
			 _settextposition( 23, 25 );
			 outtextm(" Press any key to continue ");
			 getkey();

			 _harderr( hhandler );
			 init_mouse();
			 _settextcursor( 0x2000 );
			 extract_directory( searchstring );
			 if (filenumber>number_of_files)         /* can we restore the cursor ? */
			 {
			     current_page=0;
			     filenumber=1;
			 }
		      }
		      break;
	    case 'm': strcpy(scratch,searchstring);
		      if (edit("Enter a filename mask, ESC to cancel",searchstring, 12,":\\ +=[];|,<>/\"",ILLEGAL))
		      {
			 if (strcmp(searchstring,scratch))
			 {
			   extract_directory( searchstring );
			   if (filenumber>number_of_files)      /* can we restore the cursor ? */
			   {
			       current_page=0;
			       filenumber=1;
			   }
			   repaint=TRUE;
			 }
		      }
		      break;
	    case 'r': if (safe_mode) break;
		      if (number_of_files)
		      {
			dos_error_auto_fail=TRUE;
			if (filename( filenumber, NOREPAINT )=='V')
			{
			    switch (rename_volume_label(filenumber))
			    {
			      case FAILURE: show_error("Cannot rename this volume label");
					    break;
			      case SUCCESS: repaint=TRUE;
					    extract_directory( searchstring );
					    if (filenumber > number_of_files)
					    {
						filenumber=1;
						current_page=0;
					    }
					    break;
			      case NOCHANGE: break;
			    }
			}
			else switch (rename_file(filenumber))  /* file or dir */
			{
			  case FAILURE: show_error("Cannot rename this file");
					break;
			  case SUCCESS: repaint=TRUE;
					extract_directory( searchstring );
					if (filenumber > number_of_files)
					{
					    c_end( &current_page, &filenumber);
					}
					break;
			  case NOCHANGE: break;
			}
			dos_error_auto_fail=FALSE;
		      }
		      break;
	    case 'n': if (safe_mode) break;
		      switch (make_directory())
		      {
			  case FAILURE: show_error("Cannot create this directory");
					break;
			  case SUCCESS: repaint=TRUE;
					extract_directory( searchstring );
					if (filenumber > number_of_files)
					{
					    filenumber=1;
					    current_page=0;
					}
					break;
			  case NOCHANGE: break;
		      }
		      break;
	    case 'w': switch (whereis(searchstring, &current_page, &filenumber))
		      {
			  case U_SELECT: finished=TRUE;
					 break;
			  case U_GOTO: repaint=TRUE;
				       break;
			  case FAILURE: repaint=TRUE;
					show_error( "File find failed");
					extract_directory( searchstring );
					if (filenumber > number_of_files)
					{
					     filenumber=1;
					     current_page=0;
					}
					break;
			  case U_ESC: break;
		      }
		      break;
	    case 'c': if (safe_mode) break;
		      if (number_of_files)
		      switch (copy_file(filenumber))
		      {
			 case FAILURE: show_error("Cannot copy this file");
				       repaint=TRUE;
				       extract_directory( searchstring );
				       if (filenumber > number_of_files)
				       {
					 filenumber=1;
					 current_page=0;
				       }
				       break;
			 case SUCCESS: repaint=TRUE;
				       extract_directory( searchstring );
				       if (filenumber > number_of_files)
				       {
					 filenumber=1;
					 current_page=0;
				       }
				       break;
			 case NOCHANGE: break;
		      }
		      break;
	    case SCAN_A: find_first('A',&current_page, &filenumber);
			 break;
	    case SCAN_B: find_first('B',&current_page, &filenumber);
			 break;
	    case SCAN_C: find_first('C',&current_page, &filenumber);
			 break;
	    case SCAN_D: find_first('D',&current_page, &filenumber);
			 break;
	    case SCAN_E: find_first('E',&current_page, &filenumber);
			 break;
	    case SCAN_F: find_first('F',&current_page, &filenumber);
			 break;
	    case SCAN_G: find_first('G',&current_page, &filenumber);
			 break;
	    case SCAN_H: find_first('H',&current_page, &filenumber);
			 break;
	    case SCAN_I: find_first('I',&current_page, &filenumber);
			 break;
	    case SCAN_J: find_first('J',&current_page, &filenumber);
			 break;
	    case SCAN_K: find_first('K',&current_page, &filenumber);
			 break;
	    case SCAN_L: find_first('L',&current_page, &filenumber);
			 break;
	    case SCAN_M: find_first('M',&current_page, &filenumber);
			 break;
	    case SCAN_N: find_first('N',&current_page, &filenumber);
			 break;
	    case SCAN_O: find_first('O',&current_page, &filenumber);
			 break;
	    case SCAN_P: find_first('P',&current_page, &filenumber);
			 break;
	    case SCAN_Q: find_first('Q',&current_page, &filenumber);
			 break;
	    case SCAN_R: find_first('R',&current_page, &filenumber);
			 break;
	    case SCAN_S: find_first('S',&current_page, &filenumber);
			 break;
	    case SCAN_T: find_first('T',&current_page, &filenumber);
			 break;
	    case SCAN_U: find_first('U',&current_page, &filenumber);
			 break;
	    case SCAN_V: find_first('V',&current_page, &filenumber);
			 break;
	    case SCAN_W: find_first('W',&current_page, &filenumber);
			 break;
	    case SCAN_X: find_first('X',&current_page, &filenumber);
			 break;
	    case SCAN_Y: find_first('Y',&current_page, &filenumber);
			 break;
	    case SCAN_Z: find_first('Z',&current_page, &filenumber);
			 break;

	    case '!': sprintf(scratch,"Debug: near heap memory free: %u", _memmax()); /* debug info */
		      show_message( scratch );
		      break;
	    case '@': sprintf(scratch,"Compiled on: %s, %s", __DATE__,__TIME__); /* debug info */
		      show_message( scratch );
		      break;
	    default: break;
	} /* switch */
       } /* kbhit */
    } while (!finished);

    if (key!=ESC || finished)   /* do not miss the mouse selection */
    {
	/* construct filename */
	working(TRUE);
	lastdrive = _getdrive();
	working(FALSE);
	getpath( lastdrive, selected, _MAX_PATH );
	if (selected[strlen(selected)-1]!='\\') strcat(selected,"\\");

	strcat(selected,find[filenumber].name);
    }

    if (!exit_and_keep)         /* restore old situation */
    {
       _chdrive( olddrive );
       chdir( oldcwd );
    }
    hide_mouse();
    default_mouse_rectangle();
    /* Restore original foreground and background. */
    _settextcolor( oldfgd );
    _setbkcolor( oldbgd );
    _clearscreen( _GWINDOW );
    _settextwindow( 1, 1, 25, 80 );
    _settextposition( oldpos.row, oldpos.col );
    _settextcursor( oldcursor );
    if (find)
    {
       if (huge_find) _hfree( find );
       else
       {
	 nearfind=(void __near *) ( ((long) find) & 0x0000FFFF);  /* 16 bits needed */

	 _nfree( (FIND_T_SMALL __near *) nearfind );
       }
    }
    if (key==ESC && !finished)
    {
	if (exit_and_keep) return EXIT_KEEP;
	else return EXIT_RESTORE;
    }
    else return SUCCESS;
} /* end handle_dir */

/****************************************************************************
 renames file
*/
int rename_file( int filenumber)
{
    char newname[50];
    int result;
    
    strcpy(newname,find[filenumber].name);
    if (edit("Rename: Enter a new filename, ESC to cancel",newname,48," +=[];|,<>/?*\"",ILLEGAL))
    {
	if (!strlen(newname)) return NOCHANGE;         /* null filename */
	if (!valid_filename(newname)) return FAILURE;  /* invalid filename */
	if (strcmp(find[filenumber].name,newname))
	{ 
	   working(TRUE);
	   dos_error_auto_fail=TRUE;  
	   result=rename(find[filenumber].name,newname);
	   dos_error_auto_fail=FALSE;   
	   working(FALSE);
	   if (result) return FAILURE;
	   else return SUCCESS;                        /* rename succeeded */
	}
    }
    return NOCHANGE;                                   /* ESCaped */
}

/****************************************************************************
 renames volume_label
*/
int rename_volume_label( int filenumber)
{
    char newname[50];
    char *p;
    int result;
    
    strcpy(newname,find[filenumber].name);
    if (p=strrchr(newname,'.')) memmove( p, p+1, strlen(p+1)+1); /* remove . */


    if (edit("Enter a new volume label, ESC to cancel",newname,11,"+=[];|,.<>/?*\\:()&^\"",ILLEGAL))
    {
	if (!strlen(newname)) return NOCHANGE;         /* null filename */
	strupr(newname);
	if (strcmp(find[filenumber].name,newname))
	{    
	   working(TRUE);
	   result=FilSetVolid( (unsigned char) _getdrive() ,newname);
	   working(FALSE);
	   if (result!=NOERROR) return FAILURE;
	   else return SUCCESS;
	}                           /* rename succeeded */
    }
    return NOCHANGE;                                   /* ESCaped */
}

/*************************************************************************
 Change file attributes
*/
int ed_attributes( int filenumber)
{
    char attrbuf[5];
    unsigned int fattr;
    unsigned result;
    
    strcpy( attrbuf, "");
    if (find[filenumber].attrib & _A_RDONLY) strcat(attrbuf,"R");
    if (find[filenumber].attrib & _A_HIDDEN) strcat(attrbuf,"H");
    if (find[filenumber].attrib & _A_SYSTEM) strcat(attrbuf,"S");
    if (find[filenumber].attrib & _A_ARCH)   strcat(attrbuf,"A");

    if (edit("(R)eadonly, (H)idden, (S)ystem, (A)rchive",attrbuf,4,
	"RHSArhsa",LEGAL))
    {
      fattr=0;
      strlwr(attrbuf);
      if (strchr(attrbuf, 'r')) fattr|=_A_RDONLY;
      if (strchr(attrbuf, 'h')) fattr|=_A_HIDDEN;
      if (strchr(attrbuf, 's')) fattr|=_A_SYSTEM;
      if (strchr(attrbuf, 'a')) fattr|=_A_ARCH;
      if ((find[filenumber].attrib & (_A_RDONLY | _A_HIDDEN | _A_SYSTEM | _A_ARCH)) != (char) fattr)
      {
	working(TRUE);
	dos_error_auto_fail=TRUE;  
	result=_dos_setfileattr( find[filenumber].name, fattr) ;
	dos_error_auto_fail=FALSE;      
	working(FALSE);
	if (result) return FAILURE;
	else return SUCCESS;
      }
    }
    return NOCHANGE;
}
 

/*************************************************************************
 Change file date and time
*/
int ed_datetime( int filenumber)
{
    unsigned result;
    char datetime[22];
    struct find_t pfind;
    int fh;
    unsigned int new_date;
    unsigned int new_time;
   
    /* get full file information */
    working(TRUE);
    dos_error_auto_fail=TRUE;
    if (!strcmp(find[filenumber].name,"..")) result=_dos_findfirst( ".", 0xffff, &pfind );
    else result=_dos_findfirst( find[filenumber].name, 0xffff, &pfind );
    working(FALSE);
    dos_error_auto_fail=FALSE;
    if (result) return FAILURE; /* not succeeded, get out */
      
    datestr( pfind.wr_date, datetime );
    strcat(datetime," ");
    timestr( pfind.wr_time, datetime+strlen(datetime) );

    if (edit("Date and time as DD-MON-YYYY HH:MM:SS",datetime,21,
	"0123456789- ABCDEFGJLMNOPRSTUVYabcdefgjlmnoprstuvy:",LEGAL))
    {                
      if (strlen(datetime)==20)
      {
	datetime[11]='\0';        
	new_date=strdate( datetime );
	new_time=strtime( datetime+12 );
	if (pfind.wr_time==new_time && pfind.wr_date==new_date)
	   return NOCHANGE;
	   
	working(TRUE);
	dos_error_auto_fail=TRUE;
	
	/* Open file with _dos_open function */
	dos_error_auto_fail=TRUE;
	if( _dos_open( pfind.name, _O_RDONLY, &fh ) != 0 )
	{
	    working(FALSE);
	    dos_error_auto_fail=FALSE;
	    return FAILURE; 
	}
	/* Modify file date and time */
	dos_error_auto_fail=TRUE;
	result=_dos_setftime( fh, new_date, new_time );
	
	/* close file */
	if (_dos_close( fh ) != 0)
	{
	    dos_error_auto_fail=FALSE;
	    working(FALSE);
	    return FAILURE; 
	}
	dos_error_auto_fail=FALSE;      
	working(FALSE);
	if (result) return FAILURE;
	else return SUCCESS;
      } else return FAILURE;
    }
    return NOCHANGE;
}

/***************************************************************************
 Copy file
*/
int copy_file( int filenumber)
{
    char newname[50];
    int result;

    strcpy(newname,find[filenumber].name);
    if (edit("Copy: Enter a new filename, ESC to cancel",newname,48," +=[];|,<>/?*\"",ILLEGAL))
    {
	if (!strlen(newname)) return NOCHANGE;
	if (!valid_filename(newname)) return FAILURE;
	if (strcmp(find[filenumber].name,newname))
	{  
	   working(TRUE);
	   result=copy(find[filenumber].name,newname);
	   working(FALSE);
	   if (result) return FAILURE;
	   else return SUCCESS;
	}

    }
    return NOCHANGE;
}

/**************************************************************************
 mkdir
*/
int make_directory( void )
{
    char newname[50];
    int result;
    
    strcpy(newname,"");
    if (edit("Create: Enter a new directory name, ESC to cancel",newname,48," +=[];|,<>/?*\"",ILLEGAL))
    {
	if (!strlen(newname)) return NOCHANGE;
	if (!valid_filename(newname)) return FAILURE;
	working(TRUE);
	dos_error_auto_fail=TRUE;
	result=mkdir(newname);
	dos_error_auto_fail=FALSE;
	working(FALSE);
	if (result) return FAILURE;
	   else return SUCCESS;
    }
    return NOCHANGE;
}



/***************************************************************************
 Displays common edit screen
 Returns FALSE if ESCaped
*/
int edit(char *title, char *string, int length, char *legal_illegal, int legalmode)
{
    char scratch[_MAX_PATH];
    char b[(5*53)+10]={                /* Buffer for string */
		       "ͻ\n"
		       "                                                  \n"
		       "͹\n"
		       "                                                  \n"
		       "ͼ\n"
		      };
    int result;
    char __near *savedscreen;

    strcpy(scratch,string);

    savedscreen=saveScrn();

    _settextcolor( (short) info_text_color );
    _setbkcolor( (long) info_bg_color );

    paint_box( b, 52, 5);

    _settextposition( 2, 3 );
    outtextm(title);
    if (editstring(4, 3, scratch, legal_illegal, legalmode, length))
    {
       strcpy(string,scratch);
       result=TRUE;
    }
    else result=FALSE;

    _settextwindow( 3, 1, 23, 80 );
    _setbkcolor( (long) screen_bg_color );
    savedscreen=restScrn(savedscreen);
    return result;
}


/***************************************************************************
 Returns ASCII or scancode + 256 if no ASCII
*/
int getkey(void)
{
    int kread = _KEYBRD_READ;
    int kready = _KEYBRD_READY;
    int kshiftstatus = _KEYBRD_SHIFTSTATUS;
    unsigned key;
    int lo, hi;
    /* If bit 4 of the byte at 0x0040:0x0096 is set, the new keyboard
     * is present.
     */
    if( peek( 0x00400096 ) & 0x10 )
    {
	kread = _NKEYBRD_READ;
	kready = _NKEYBRD_READY;
	kshiftstatus = _NKEYBRD_SHIFTSTATUS;
    }
    key=_bios_keybrd( kread );
    lo = key & 0X00FF;
    hi = (key & 0XFF00) >> 8;
    return((lo == 0 || lo == 0xE0 ) ? hi + 256 : lo);
}

/****************************************************************************
 Changes the text cursor shape based on the current insert mode
*/
void changecursor(int insmode)
{
 if (insmode)
  setcursor( 0x090C);
 else setcursor(0x0A0C);
} /* changecursor */

/***************************************************************************
 Sets the shape of the text cursor
*/
void setcursor(unsigned int shape)
{
 union REGS reg;

 reg.h.ah = 1;
 reg.x.cx = shape;
 int86(0X10, &reg, &reg);
} /* setcursor */
  
unsigned int getshift(void)
{
    int kshiftstatus = _KEYBRD_SHIFTSTATUS;

    /* If bit 4 of the byte at 0x0040:0x0096 is set, the new keyboard
     * is present.
     */
    if( peek( 0x00400096 ) & 0x10 )
    {
	kshiftstatus = _NKEYBRD_SHIFTSTATUS;
    }

    /* Get shift state. */
    return (_bios_keybrd( kshiftstatus ));
}

  
/****************************************************************************
 Allows the user to edit a string with only certain characters allowed -
 Returns TRUE if ESC was not pressed, FALSE is ESC was pressed.
*/
int editstring(int row, int col, char *s, char *legal_illegal, int legalmode, int maxlength)
{
 int c, len = strlen(s), pos = len;
 static int insert=TRUE;
 register int tel;
 int mouse_row, mouse_col;
 int ulc_row, ulc_col, dummy;          /* upper left corner row and column of window */
 int update=TRUE;
 static char old_strings[5][55]={"","","","",""};
 static int last_old_string=0;
 unsigned int shift;
 
 /* use next old_strings buffer */
 if (last_old_string<4) last_old_string++;
 else last_old_string=0;

 changecursor(insert);
 _gettextwindow(&ulc_row,&ulc_col,&dummy,&dummy);  /* mouse coordinates are absolute! */

 do
 {
  if (update)
  {
     hide_mouse();
     _settextposition( row, col );
     _outtext(s);
     for (tel=len;tel<=maxlength;tel++) _outtext(" ");
     _settextposition( row, col + pos );
     show_mouse();
     update=FALSE;
  }

  if (mouse_present)
  {
     restrict_mouse_topline();
     if (read_left_button_queue(&mouse_row,&mouse_col))
     {
	if (((mouse_row-ulc_row+1)==row) &&
	    ((mouse_col-ulc_col+1)<=(col+len)) &&
	    ((mouse_col-ulc_col+1)>=col))
	{
	   pos=(mouse_col-ulc_col+1)-col;
	   update=TRUE;
	}  else alert();
      }
   }

  if (n_kbhit())
  {
  update=TRUE;
  switch(c = getkey())
  {
   case K_CUP:
    if (maxlength>53) break; /* buffers too small */
    strcpy(old_strings[last_old_string],s);
    if (last_old_string>0) last_old_string--;
    else last_old_string=4;
    strcpy(s,old_strings[last_old_string]);
    if (strlen(s)<=(size_t) maxlength)                        /* check length */
    {   
      if (strlen(legal_illegal))
      {
	for (tel=0;tel<(int) strlen(s);tel++)
	{
	    if ((legalmode==ILLEGAL &&  strchr(legal_illegal,s[tel])) ||
		(legalmode==LEGAL   && !strchr(legal_illegal,s[tel]))
	       )
    
	    {
	    strcpy(s,"");
	    break;
	    }
	}    
      } 
    } else strcpy(s,"");

    len = strlen(s);
    pos = len;
    break;
   case K_CDN:
    if (maxlength>53) break; /* buffers too small */
    strcpy(old_strings[last_old_string],s);
    if (last_old_string<4) last_old_string++;
    else last_old_string=0;
    strcpy(s,old_strings[last_old_string]);
    if (strlen(s)<=(size_t) maxlength)                        /* check length */
    {
      if (strlen(legal_illegal))
	for (tel=0;tel<(int) strlen(s);tel++)
	    if ((legalmode==ILLEGAL &&  strchr(legal_illegal,s[tel])) ||
		(legalmode==LEGAL   && !strchr(legal_illegal,s[tel]))
	       )
	{
	    strcpy(s,"");
	    break;
	}
    } else strcpy(s,"");

    len = strlen(s);
    pos = len;
    break; 
    
   case K_F1:
   case K_F2:
   case K_F3:
   case K_F4:
   case K_F5:
   case K_F6:
   case K_F7:
   case K_F8:
   case K_F9:
   case K_F10:
   case K_PGDN:
   case K_PGUP: break;

   case K_HOME:
    pos = 0;
    break;
   case K_END:
    pos = len;
    break;
   case K_INS:
    insert = !insert;
    changecursor(insert);
    break;
   case K_CLE:
    if (pos > 0)
     pos--;
    break;
   case K_CRI:
    if (pos < len)
     pos++;
    break;
   case BS :
    if (pos > 0)
    {
     memmove(&s[pos - 1], &s[pos], len - pos + 1);
     pos--;
     len--;
    }
    break;
   case K_DEL:
    shift=getshift();
    if ((shift & 1) || (shift & 2))  /* left or right shift is down */
    {
	    /* save string to be deleted */
	    if (maxlength<127) /* else buffers too small */
	    {
		strcpy(old_strings[last_old_string],s);
		if (last_old_string<4) last_old_string++;
		else last_old_string=0;
	    }
	    len=0;     /* delete string */
	    pos=len;
    }
    else
    if (pos < len)
    {
     memmove( &s[pos], &s[pos + 1],len - pos);
     len--;
    }
    break;
   case CR :
    if (maxlength<=53) strcpy(old_strings[last_old_string],s);
    break;
   case ESC :
    len = 0;
    break;
   default :
     if (!strlen(legal_illegal) ||
	 (
	  (legalmode==ILLEGAL && !strchr(legal_illegal,c)) ||
	  (legalmode==LEGAL   &&  strchr(legal_illegal,c))
	 )
	)
     if (((c >= ' ') && (c <= '~')))
     {
      if (insert && len == maxlength) alert();
      if (insert && len < maxlength)
      {
       memmove(&s[pos + 1], &s[pos], len - pos + 1);
       len++;
       s[pos++] = (char) c;
      }
      if (!insert && pos < maxlength)
      {
	 if ((pos >= len) && (len < maxlength)) len++;
	 s[pos++] = (char) c;
      }
     }
    break;
  } /* switch */
  }
  s[len] = 0;
 }
 while ((c != CR) && (c != ESC));
 changecursor(FALSE);
 setcursor(0x2000);
 return(c != ESC);
} /* editstring */


void construct_search_path( char *linebuf )
{
   strcpy(linebuf,"");
   getpath( _getdrive(), linebuf, _MAX_PATH );
   if (strlen(linebuf))
      if (linebuf[strlen(linebuf)-1]!='\\') strcat(linebuf,"\\\0");
   strcat(linebuf,searchstring);
}

/****************************************************************************
 Display current drive and working directory
*/
void show_path( void )    /* this HAS some impact, searches disk on each call */
{
   char linebuf[_MAX_PATH];

   construct_search_path(linebuf);
   strlwr(linebuf);
   if (strlen(linebuf) >= 54)
   {
	linebuf[53]='';
	linebuf[54]='\0';
   }
   strcat(linebuf," ");
   while (strlen(linebuf)<56) strcat(linebuf,"");
   _settextposition( 1, 15 );
   _settextcolor( (short) file_color );
   _setbkcolor( (long) screen_bg_color );
   outtextm(linebuf);
}

/***************************************************************************
 Check a full filename on illegal characters, name length, extension
 length, drive letter
*/
int valid_filename( char *newname)
{
    char linebuf[_MAX_PATH];
    char *chrpointer;
    char illegal[20]={"\" +=[];|,<>/?*\\"};
    int length;
    register int teller;

    strcpy(linebuf,newname);

    if (strchr(illegal, linebuf[strlen(linebuf)-1])) return FALSE; /* check last character */

    if (strchr(linebuf,':'))   /* check drive */
    {
	if ((strchr(linebuf, ':') - linebuf)!=1) return FALSE; /* check place of : */
	linebuf[0] = (char) tolower((int) linebuf[0]);
	if ((linebuf[0] < 'a') || (linebuf[0] > 'z')) return FALSE;
	strcpy(linebuf,linebuf+2);  /* remove drive */
    }

    chrpointer = strtok( linebuf, "\\" );       /* Find first token */
    while( chrpointer != NULL )
    {

      chrpointer = strchr(linebuf,'.'); /* check extension */
      if (chrpointer)
      {
	if ((length=strlen(chrpointer+1))>3) return FALSE;           /* check size */
	for (teller=0;teller<length;teller++)
	  if (strchr(illegal, *(chrpointer + 1 + teller))) return FALSE; /* check each character */
	*chrpointer = '\0';                                          /* remove extension */
      }

      chrpointer = strrchr(linebuf,'\\');        /* check name */
      if (!chrpointer) chrpointer=linebuf; /* no slash, start with first character */
      if (chrpointer)
      {
	if ((length=strlen(chrpointer+1))>8) return FALSE;           /* check size */
	for (teller=0;teller<length;teller++)
	  if (strchr(illegal, *(chrpointer + 1 + teller))) return FALSE; /* check each character */
	*chrpointer = '\0';                                          /* remove name */
      }

     chrpointer = strtok( NULL, "\\" ); /* Find next token */
     }
    return TRUE;
}

/***************************************************************************
 Build a string with disk space free on current drive
*/
int freespace( char *linebuf )
{
   int lastdrive;
   char scratch[_MAX_PATH];
   register int tel;
   int tel2;
   long freebytes;
   
   dos_error=0;
   dos_retries=0;
   lastdrive = _getdrive();
   
   if (getdiskfree( lastdrive, &freebytes )==FAILURE) return FAILURE;

   sprintf( scratch,"%ld",freebytes);
   
   strrev( scratch );
   linebuf[0]='\0';
   tel2=0;
   for (tel=0;tel<(int) strlen(scratch);tel++)
   {
       if (tel && !(tel%3)) linebuf[tel2++]=',';   /* thousands separator */
       linebuf[tel2++]=scratch[tel];
   }
   if (linebuf[tel2-1]==',') linebuf[tel2-1]='\0'; /* blank trailing ',' */
      else linebuf[tel2]='\0';                     /* terminate string */
   strrev( linebuf );
   strcpy( scratch,linebuf );
   strcpy( linebuf," Disk space free: ");
   strcat( linebuf,scratch );
   strcat( linebuf," bytes" );
   return SUCCESS;
}

/***************************************************************************
 Get disk space free on drive
*/
int getdiskfree( int newdrive, long *freebytes )
{
   struct diskfree_t drvinfo;
   int current_drive;
   
   current_drive = _getdrive();

   dos_error=0;
   dos_retries=0;
   if (!drvalid(newdrive-1)) return FAILURE;

   dos_error_auto_fail=TRUE; 
   _dos_getdiskfree( newdrive, &drvinfo ); /* try to access the disk */
   dos_error_auto_fail=FALSE;  
   
   if (current_drive!=newdrive) _chdrive(current_drive); /* change to old device */
   
   if (dos_error) return FAILURE;

   *freebytes = ( (long)drvinfo.avail_clusters *
			drvinfo.sectors_per_cluster *
			drvinfo.bytes_per_sector );
   return SUCCESS;
}


void working( int mode )
{
   _settextposition( 1, 1 );
   _setbkcolor( screen_bg_color );
   if (mode)
   {
       _settextcolor( (short) info_text_color );
       outtextm( "" );
   }
   else
   {
       _settextcolor( (short) file_color );
       outtextm( "" );
   }
}



/***************************************************************************
 * Put shading under and at the right side of a box, if in COLOR mode
 */
void shadebox( short r1, short c1, short r2, short c2 )
{
  struct videoconfig vc;
  short int row, col;
  _getvideoconfig( &vc );
  if (vc.mode== _TEXTMONO) return;               /* monochroom scherm, geen schaduw */
  hide_mouse();
  for (row=r1+1;row<=r2+1;row++)
  {
     shadechar(row,c2+1);
     shadechar(row,c2+2);
  }
  for (col=c1+1;col<=c2+1;col++) shadechar(r2+1,col);
  show_mouse();
}

/***************************************************************************
 * Direct video write, shade a character
 */
#define MAKELONG(a, b)  ((long)(((unsigned)a) \
		       | ((unsigned long)((unsigned)b)) << 16))
#define COLORTEXT_BUFFER   0XB800

void shadechar( int row, int col )
/* row    : row of location 1 to 25                     */
/* col    : column of location 1 to 80                  */
/* attrib : standard character attribute                */
{
    unsigned int offset; /* Offset from the segment address of
			    the desired video page */
    char far *y;         /* Long Pointer to the position in memory
			    where we will put the character and
			    it's attribute (next byte) */
    int pageno;  /* page number to load character into (0 to 3) */
    char attrib; /* standard character attribute                */

    pageno=0;
    attrib=0x08; /* background=black, textcolor=dark grey       */
    row--;  /* coord 1,1 is 0,0 for the function logic */
    col--;

    if (row<0 || row >24) return;   /* clip to screen boundary */
    if (col<0 || col >79) return;

    /* Calc the in-page offset w/page number offset and segment address */
    offset = (unsigned int) ((row * 160 )+(col*2)+(pageno*4096));

    /*  Set the attribute byte. See a DOS programmers reference for
    more information on video attributes. */
    offset++;
    y = (char far *)MAKELONG( offset, COLORTEXT_BUFFER);
    *y = attrib;
}

/* set working drive and directory and return a pointer to the first
 * character of the filename
 */
char *set_working_drive_and_dir( char *full_filename )
{
    char scratch[_MAX_PATH];
    char *slash;
    strcpy(scratch,full_filename); /* make drive & dir default */
    strupr(scratch);
    if (slash=strrchr(scratch, (int) '\\')) *slash='\0'; /* remove filename */
       else if (slash=strrchr(scratch, (int) ':')) *slash='\0'; /* maybe in format A:FILE.EXT */
    if (strlen(scratch)==1) strcat(scratch,":");                       /* top directory ? */
    if (strlen(scratch)==2) strcat(scratch,"\\");              /* top directory ? */
    if (scratch[1]==':') _chdrive(scratch[0]-'A'+1);
    chdir(scratch);
    /* find filename */
    if (slash=strrchr(full_filename, (int) '\\')) return slash+1;  /* in format A:\FILE.EXT */
       else if (slash=strrchr(scratch, (int) ':')) return slash+1; /* maybe in format A:FILE.EXT */
    return 0L;
}

/**************************************************************************
 Change to parent directory and place cursor
*/
void find_parent( int *current_page, int *filenumber, char *searchstring)
{
     register int counter;
     char linebuf[_MAX_PATH];
     char *p;
     
     getpath( _getdrive(), linebuf, _MAX_PATH );
     
     if (p=strrchr(linebuf,'\\'))
     {
	memmove( linebuf, p+1, strlen(p+1)+1);
     } else return;                         /* do nothing */

     if (!strlen(linebuf)) return; /* do nothing, already in root */
     dos_error_auto_fail=TRUE;
     chdir( ".." );
     dos_error_auto_fail=FALSE;
     extract_directory( searchstring );
     if (!number_of_files)
     {
	 *current_page=0;
	 *filenumber=1;
     }
     else
     {
	 for (counter=1;counter<number_of_files;counter++)    /* should end at last file */
	     if (!strcmp(find[counter].name,linebuf)) break;
	 *filenumber=counter;
	 *current_page=((counter%114) ? counter/114 : counter/114 - 1);
     }
}


/*
**  Customized routines from DRVALID.C - validate disk drives
**  Original Copyright 1988-1991 by Bob Stout as part of
**  the MicroFirm Function Library (MFL)
**
**  public domain.
*/


/*
**  getdrv()
**
**  returns the current drive.
**
**  Arguments: None.
**
**  Returns:   Current drive (0 = A:, 1 = B:, etc.)
**
**  Side effects: none
*/

int getdrv(void)
{
      union REGS regs;

      regs.h.ah = 0x19;
      intdos(&regs, &regs);
      return (regs.h.al);
}

/*
**  chdrv()
**
**  changes drives.
**
**  Arguments: 1 - target drive (0 = A:, 1 = B:, etc.)
**
**  Returns: SUCCESS or ERROR
**
**  Side effects: none
*/

int chdrv(int drive)
{
      union REGS regs;

      regs.h.ah = 0x0e;
      regs.h.dl = (char)drive;
      intdos(&regs, &regs);
      if (drive != getdrv())
	    return ERROR;
      else  return SUCCESS;
}

/*
**  drvalid()
**
**  Verifies whether a logical disk drive is available without
**  triggering the DOS critical error handler, and changes to this drive
**  if successful.
**
**  Arguments: 1 - target drive (0 = A;, 1 = B:, etc.)
**
**  Returns:   TRUE  - drive is valid
**             FALSE - drive is invalid
**
**  Side effects: none
*/

int drvalid(int drive)
{
      int original, result;

      original = getdrv();
      result   = (SUCCESS == chdrv(drive));
      if (!result) chdrv(original);
      return result;
}

void ScrPutS (char *String, unsigned char Attr,
	      unsigned char Row, unsigned char Col)
{
    register unsigned char A;
    unsigned char far *PtrVideoMode = (unsigned char far *) 0x00400049;
    unsigned char far *Video;

    A = Attr;

    FP_SEG (Video) = (*PtrVideoMode == 7) ? 0xb000 : 0xb800;
    FP_OFF (Video) = Row*160+Col*2;

    while (*String)
    {
	*Video++ = *String++;
	*Video++ = A;
    }
}

/* Ask for a drive */
/* In: key a..z pressed */
/* Out: drive number A=1, B=2 etc. or -1 if ESCaped */

int ask_drive_number( char *message)
{
    int key;
    char __near *savedscreen;

    do
    {
       savedscreen=show_string( message , info_bg_color,info_text_color);
       _settextposition( 1, 1 );        /* prevent scroll-up from dos error */
       key = getkey();
       if (key<256) key = tolower(key);
    } while (((key < 'a') || (key > 'z')) &&(key != ESC));

    restScrn(savedscreen);      /* remove string box */

    if (key!=ESC) return ( key - 'a' + 1);
    else return -1;
}

char *getpath( int drive, char *buffer, int maxlen )
{
   char *result;
   
   dos_error_auto_fail=TRUE;
   if (!(result=_getdcwd( drive, buffer, maxlen )))
   {
       show_error("Cannot get disk path");
       strcpy(buffer,"");
   }
   dos_error_auto_fail=FALSE;
   return (result);
}

/****************************************************************************
 save screen image , return pointer to allocated memory
*/
char __near *saveScrn(void)
{
  char far *src;
  char __near *saveArea;
  struct videoconfig vc;

  saveArea = (char __near *) _nmalloc (4096);       /* alloceer ruimte */
  if (!saveArea)
  {
       show_error("Cannot allocate memory for screen save");
       return (char __near *) NULL;
  }
  _getvideoconfig( &vc );
  if (vc.mode== _TEXTMONO)
     src = (char far *) 0xB0000000;     /* monochroom scherm */
    else
     src = (char far *) 0xB8000000;     /* grafische text buffer */
  hide_mouse();
  _fmemmove( (char far *) saveArea, (char far *) src, 4096 );
  show_mouse();
  return (saveArea);                             /* return pointer !!!! */
}


/***************************************************************************
 restore screen if saveArea != NULL
 Return NULL pointer for update of saveArea to prevent multiple restores
 Memory is freed so else garbage would be restored if saveScrn and restScrn
 are not balanced
*/
char __near *restScrn(char __near *saveArea)
{
  char far *dest;
  struct videoconfig vc;

  if (!saveArea) return (char *) 0L;

  _getvideoconfig( &vc );
  if (vc.mode== _TEXTMONO)
     dest = (char far *) 0xB0000000;
  else
     dest = (char far *) 0xB8000000;
  hide_mouse();
  _fmemmove( (char far *) dest , (char far *) saveArea, 4096 );
  show_mouse();
  _nfree (saveArea);
  return (char __near *) NULL;
}




/***************************************************************************
 Displays common message screen
*/
char __near *show_string(char *string, int bg_color, int text_color)
{
    char b[(5*53)+10]={                /* Buffer for string */
		       "ͻ\n"
		       "                                                  \n"
		       "                                                  \n"
		       "                                                  \n"
		       "ͼ\n"
		      };
    char __near *savedscreen;

    savedscreen=saveScrn();

    _settextcolor( (short) text_color );
    _setbkcolor( (long) bg_color );

    paint_box( b, 52, 5);

    if (strchr( string, (int) '\n')) _settextposition( 2, 3);
    else
    {
	/* max length 48 */
	if (strlen(string) > 48 ) string[47]='\0';
	_settextposition( 3, 3 + (48-strlen(string))/2 );
    }
    outtextm(string);

    _settextwindow( 3, 1, 23, 80 );
    _settextcolor( (short) file_color );
    _setbkcolor( (long) screen_bg_color );

    return (savedscreen);
}



/***************************************************************************
 Paint box string
*/
void paint_box(char *string, int vis_width, int vis_height)
{
    short x,y;

    y = ((25 - vis_height) / 2) + 1;
    x =  (80 - vis_width) / 2;

    /* Use text window to place output in middle of screen. */
    _settextwindow( y, x, y + vis_height, x + vis_width );
    shadebox( y, x, y + vis_height - 1, x + vis_width - 1 );
    outtextm( string );
}



/* Change dynamically the mouse restricting rectangle
 */
void restrict_mouse_topline( void )
{
    union REGS in_regs, out_regs;
    int col, row, top, bottom;
    static int old_top=4;
    
    if (!mouse_present) return;
  
    /* first save mouse position */
    in_regs.x.ax = 3;
    int86(0x33, &in_regs, &out_regs);
    col = out_regs.x.cx / 8 + 1;
    row = out_regs.x.dx / 8 + 1;
    
    /* check initial move, show mouse for the first time */
    if (!moved_after_init_mouse)   
       if (out_regs.x.cx!=(unsigned int) mouse_col || out_regs.x.dx!=(unsigned int) mouse_row)
       {
          moved_after_init_mouse=TRUE;
          show_mouse();
       }
      
    /* Change cursor vertical restriction */
    if (col>71) top = 3;
    else top = 4;

    if (top!=old_top)
    {
	old_top = top;

	/* re-position mouse if needed */
	if (col<=71 && row==3)
	{
	    in_regs.x.cx = 8 * (col - 1);
	    in_regs.x.dx = 8 * (++row - 1);
	    in_regs.x.ax = 4;
	    int86(0x33, &in_regs, &out_regs);
	}

	/* Restrict cursor vertically */
	bottom = 22;
	in_regs.x.cx = 8 * (top - 1);
	in_regs.x.dx = 8 * (bottom - 1);
	in_regs.x.ax = 8;
	int86(0x33, &in_regs, &out_regs);

    }
}



/* Set the default mouse restricting rectangle
 */
void default_mouse_rectangle( void )
{
    union REGS in_regs, out_regs;
    int top, bottom, left, right;

    if (!mouse_present) return;

    right = 80;  /* Restrict cursor horizontally */
    left = 1;
    in_regs.x.cx = 8 * (right - 1);
    in_regs.x.dx = 8 * (left - 1);
    in_regs.x.ax = 7;
    int86(0x33, &in_regs, &out_regs);
    top = 1;               /* Restrict cursor vertically */
    bottom = 24;
    in_regs.x.cx = 8 * (top - 1);
    in_regs.x.dx = 8 * (bottom - 1);
    in_regs.x.ax = 8;
    int86(0x33, &in_regs, &out_regs);
}



int date_interval_correct(unsigned long file_datetime, unsigned long turnover_datetime, int turnover_datetime_mode)
{   
    if (turnover_datetime_mode==ALL) return TRUE;
    if (file_datetime>=turnover_datetime) return (turnover_datetime_mode==SINCE) ? TRUE : FALSE;
    else return (turnover_datetime_mode==SINCE) ? FALSE : TRUE;
}

  
/*************************************************************************
 Edit the turnover date and time string 
*/
int ed_turnover_datetime( void )
{
    char scratch_datetime[23];
				  
    strcpy(scratch_datetime,turnover_datetime_string);
    
    if (edit("Date and time since DD-MON-YYYY HH:MM:SS",scratch_datetime,22,
	"0123456789- ABCDEFGJLMNOPRSTUVYabcdefgjlmnoprstuvy:><+",LEGAL))
    {
      /* save new user string */
      strupr(scratch_datetime);
      strcpy(turnover_datetime_string,scratch_datetime);
      return (set_turnover_datetime(scratch_datetime));
	 
    } else return NOCHANGE;
}


/*************************************************************************
 Convert a date and time string to the globals turnover_datetime
 and turnover_datetime_mode
*/
int set_turnover_datetime( char *datetime )
{
    char scratch_datetime[23];
				  
    strcpy(scratch_datetime,datetime);
    
	 
    if (!strlen(scratch_datetime)) /* no before/since wanted */
    {
	  turnover_datetime_mode=ALL;
	  return SUCCESS;
    }    
	
    if (scratch_datetime[0]=='<' || scratch_datetime[0]=='-') /* forced to BEFORE by user */  
    {
	turnover_datetime_mode=BEFORE;
	strcpy(scratch_datetime,scratch_datetime+1);
    } else if (datetime[0]=='>' || scratch_datetime[0]=='+')  /* forced to SINCE by user */
	   {
	       turnover_datetime_mode=SINCE;
	       strcpy(scratch_datetime,scratch_datetime+1);
	   } else turnover_datetime_mode=SINCE; /* default to SINCE */
	    
    if (!strcmp(scratch_datetime,"T") || !strcmp(scratch_datetime,"TODAY"))
    {                  
	/* build midnight date and time */          
	make_today_string( scratch_datetime );
	turnover_datetime=make_dt(strdate(scratch_datetime),0);
	return SUCCESS;                   
    }            
    if (strlen(scratch_datetime)==20) /* process full date-time string */
    {            
	scratch_datetime[11]='\0';        
	turnover_datetime=make_dt(strdate(scratch_datetime),strtime(scratch_datetime+12));
	return SUCCESS;
    }
    if (strlen(scratch_datetime)==11) /* process date string, set time to midnight */
    {            
	turnover_datetime=make_dt(strdate(scratch_datetime),0);
	return SUCCESS;
    } 
      
    /* syntax error, show all dates */          
    turnover_datetime_mode=ALL;
    return FAILURE;
}


void make_today_string( char *daystring )
{
    time_t ltime;
    struct tm *today;

    time( &ltime );
    /* Use time structure to build a customized time string. */
    today = localtime( &ltime );

    /* Use strftime to build a customized time string. */
    strftime( daystring, 13,"%d-%b-%Y", today );
    strupr(daystring);
}
  
