/* FS0.C
 * main program body
 * MSC8 (VC++ 1.5)
 * FS 2.9
 * 270195
 * Copyright (C) M.C.J. van Breemen, 1992-1995, All rights reserved.
 */

#include "FS.H"       /* most C header files are included here ! */
#include "spawno.h"

enum FILEATTRIB { EXIST, WRITE = 2, READ = 4, READWRITE = 6 };
#define EXIST( name ) !_access( name, EXIST )

/* Prototypes */
int set_turnover_datetime( char *datetime );
int cdecl fs_systemo(const char *overlay_path, const char *command);
int  handle_dir( char *searchstring, char *selected , int safe_mode);
int execute(char *comm, char **a, int tot_commargs, int no_return, int testing);
void main( int argc, char *argv[]);
int convcolorinfo( char colinfo );
int set_colors( char *scratch);
char __near *saveScrn (void);
char __near *restScrn(char __near *saveArea);
int getkey(void);
void show_error( char *message );
int save_colors_in_exe( char *imagename , int setcolorresult);
char *set_working_drive_and_dir( char *full_filename );
void interpret_params( char *imagename, int argc, char *param,
		       int *no_return, int *init_screen, int *testing,
		       int *wait, int *swap_types, int *allowswap,
		       int *keep_path, int *max_files, int *mask_argc_number,
		       int *mask_starting_char, int *mask_length,
		       int *safe_mode, int *order_by, int *order_type,
		       int *max_linewidth);
void locate_processor(char *command, char *processor);
int _Cdecl fs_spawnlpeo(const char *overlay_path,const char *prog_name,...);
int _Cdecl fs_spawnvpeo(const char *overlay_path, const char *prog_name,
			const char **args, const char **env);

/* externals, used by the handle_dir routines */
extern char __far turnover_datetime_string[];
extern unsigned long turnover_datetime;
extern int turnover_datetime_mode;       /* BEFORE,SINCE or ALL*/

extern char __far processor[];
extern int setting_factory_defaults;
extern char *swap_dir;
extern int allow_swap;
extern int swap_types;
extern int max_files;          /* max. number of files accessible */
extern int max_linewidth;      /* max. number of chars on one line for show file */
extern int order_by;           /* NONE, NAME, DATE or SIZE */
extern int order_type;         /* ASCENDING or DESCENDING */
extern short int screen_bg_color;
extern short int file_color;
extern short int directory_color;
extern short int hidden_file_color;
extern short int hidden_directory_color;
extern short int volume_label_color;
extern short int cursor_bg_color;
extern short int info_bg_color;
extern short int info_text_color;
extern short int error_bg_color;
extern short int error_text_color;
extern short int fsswitch;

/********************************************************************************/
void main( int argc, char *argv[])
{
    char selected[_MAX_PATH];  /* selected file */
    char trailer[_MAX_PATH];   /* trailing string appended to selected file */
    char mask[_MAX_PATH];      /* filter */
    char scratch[_MAX_PATH];   /* temporary strings, really scratch */
    int init_screen=FALSE;     /* initialise display adapter */
    int no_return=FALSE;       /* run FS once */
    int keep_path=FALSE;       /* keep initial drive and directory path */
    int wait=FALSE;            /* wait for a keystroke before resetting screen */
    int safe_mode=FALSE;       /* changes to files not allowed (/N) */
    int iTeller;               /* counter */
    int mask_argc_number=2;    /* default place of mask in argument list */
    unsigned int mask_starting_char=1; /* default first character of mask in argument */
    unsigned int mask_length=0;        /* default up to string terminator */
    char *slash;               /* pointer to FSSWITCH env (we only want the first char!) */
    int olddrive;              /* old current drive */
    char oldcwd[_MAX_PATH];    /* old current working directory */
    int commarg[17];           /* initial argument list */
    int tot_commargs=0;        /* number of command arguments */
    char *arglist[17];         /* final argument list */
    struct videoconfig vc;     /* video info structure */
    char __near *savedscreen;  /* pointer to saved screen memory */
    struct rccoord oldpos;     /* old cursor position (_setvideomode will reset to 0,0) */
    int handle_dir_result;
    int testing=FALSE;         /* if TRUE, test mode, show command line */
    char *p;                   /* char pointer for strtok etc. */
    short oldcursor=_gettextcursor();

    allow_swap=TRUE;
    swap_types=SWAP_ANY;
    swap_dir = getenv("SWAPDIR");
    if (swap_dir == NULL)
       swap_dir = getenv("TEMP");
    if (swap_dir == NULL)
       swap_dir = getenv("TMP");
    if (swap_dir == NULL)
       swap_dir = "." ;          /* default swap directory is current dir */
    init_SPAWNO(swap_dir,swap_types);

    order_by=NAME;            /* order files by name */
    order_type=ASCENDING;     /* order lowest-> highest = top->bottom (0-9,A-Z) */
    strcpy(selected,"");

    _getvideoconfig( &vc );

    savedscreen=saveScrn();         /* save video memory */
    oldpos = _gettextposition();

    /* Save current drive and current working directory. */
    olddrive=_getdrive();
    getcwd( oldcwd, _MAX_PATH );

    slash=getenv("FSSWITCH");          /* alternative FS switch character */
    if (slash) fsswitch=(short int) *slash;

    /* process arguments from environment */
    slash=getenv("FSPARAMS");
    if (slash)
    {
	strcpy(scratch,slash);
	strupr(scratch);
	p = strtok( scratch, " ;" );     /* Find first token */
	while( p != NULL )
	{
	    if (p[0]!='D')                /* v parameters without switch */
		interpret_params( argv[0], argc, p, &no_return, &init_screen,
				  &testing, &wait, &swap_types,
				  &allow_swap, &keep_path, &max_files, &mask_argc_number,
				  &mask_starting_char, &mask_length,
				  &safe_mode, &order_by, &order_type, &max_linewidth);
	    p = strtok( NULL, " ;");
	}
    }

    for (iTeller=0;iTeller<17;iTeller++) /* reset argument list */
    {
	commarg[iTeller]=0;
	arglist[iTeller]=(char *) 0L;
    }

    if (argc<2 || (argv[1][0]==(char) fsswitch)) /* at least a command should be present, show info */
    {
	 printf("\nFS 2.9  Copyright (C) M.C.J. van Breemen, 1992-1995, All rights reserved.\n"
		"Syntax:\n"
		"FS command filemask %c1 %cChex %cM %cR %cFnum %cPa,c,l %cW %cSxxxx %cDhex %cT %cOxy\n"
		"%c1\tRun FS one time, exit after selecting a file\n"
		"%cChex\tSet color mode & optionally set run-time colors (11 hex digits)\n"
		"%cM\tSet monochrome mode\n%cR\tRestore drive & dir before executing command\n"
		"%cFnum\tAllocate memory for 'num' files per directory (default 912)\n"
		"%cPa,c,l\tPosition of filemask in argument list, argument a,\n"
		"\tstarting character c, length l  Default 2,1: argument 2 (FS=0),\n" 
		"\tbeginning on first character, all remaining characters of the string\n"
		"%cW\tWait for a key pressed before returning\n"
		"%cSxxxx\tSwap types: Enable swapping to Disk, Ems, Xms, raw exT. Default %cSdext\n"
		"\t%cS without types disables all swapping\n"
		"%cDhex\tSave new default colors (hex: 11 hex digits, 0-F)\n"
		"%cDs\tSave new default switch (s: 1 character)\n"
		"\t%cD alone sets both default %cD17FEA342F47 and %cD/\n"
		"%cT\tTest mode, show resulting commandline\n"
		"%cN\tNo changes to files allowed in FS, safe mode\n"
		"%cOxy\tOrder by x: Name, Date, Size. y: + Ascending, - Descending (default N+)\n"
		"\t%cO alone cancels ordering\n"
		"%cB+dd-mon-yyyy:hh:mm:ss\tShow only files since (+ or empty) or before (-) date\n"
		"%cJnum\tMaximal linewidth for show file function, 'num' characters\n"
		"Other non-FS arguments are passed through in the same order\n",
		fsswitch,fsswitch,fsswitch,fsswitch,fsswitch,fsswitch,fsswitch,fsswitch,
		fsswitch,fsswitch,fsswitch,fsswitch,fsswitch,fsswitch,fsswitch,fsswitch,
		fsswitch,fsswitch,fsswitch,fsswitch,fsswitch,fsswitch,fsswitch,fsswitch,
		fsswitch,fsswitch,fsswitch,fsswitch,fsswitch,fsswitch,fsswitch,fsswitch,
		fsswitch);
	 printf("-- More --");
	 getch();
	 printf("\nThe command string should always be entered, even if not significant\n"
		"(like in FS DUMMY %cD).\n"
		"The %c switch can be re-defined with environment variable FSSWITCH.\n"
		"All parameters except D are also definable with environment variable FSPARAMS\n"
		"which should be set as a list of parameters without switch, separated by ; or\n"
		"space. Run-time commandline parameters will override FSPARAMS settings.\n"
		"EXAMPLES: FS EDIT,   FS EDIT *.C,   FS C:\\UTILS\\ARJ e *.ARJ %cP3 %cR,\n"
		"          FS COPY C:\\ALLC.TXT+*.C %cP2,13 C:\\ALLC.TXT\n"
		"          FS ECHO [*.C] %cP2,2,3 %cW,   FS LHA a C:\\ARCHIVE.LZH *.* %cP4\n\n\n",
		fsswitch,fsswitch,fsswitch,fsswitch,fsswitch,fsswitch,fsswitch,fsswitch);
	 exit(1);
    }

    /* position of filemask is needed before processing of the commandline parameters */
    for (iTeller=2;iTeller<argc;iTeller++)  /* where is the filemask ? */
    {
	    strcpy(scratch,argv[iTeller]);
	    strupr(scratch);
	    if (scratch[0]==(char) fsswitch && (scratch[1]=='P'))
	    {                                 /* vvvvvvvvv skip switch */
		interpret_params( argv[0], argc, scratch+1, &no_return, &init_screen,
				  &testing, &wait, &swap_types,
				  &allow_swap, &keep_path, &max_files, &mask_argc_number,
				  &mask_starting_char, &mask_length,
				  &safe_mode, &order_by, &order_type, &max_linewidth);
		break;
	    }
    }

    /* process arguments from command line (will override environment) */
    for (iTeller=2;iTeller<argc;iTeller++)  /* process FS & command switches */
    {
	    strcpy(scratch,argv[iTeller]);
	    strupr(scratch);
	    if (scratch[0]==(char) fsswitch)
	    {                                 /* vvvvvvvvv skip switch */
		interpret_params( argv[0], argc, scratch+1, &no_return, &init_screen,
				  &testing, &wait, &swap_types,
				  &allow_swap, &keep_path, &max_files, &mask_argc_number,
				  &mask_starting_char, &mask_length,
				  &safe_mode, &order_by, &order_type, &max_linewidth);

		if (iTeller==mask_argc_number) commarg[tot_commargs++]=iTeller;
		   /* parameter found on filemask place */
		   /* count this one as filemask to enable selected string replacement */
	    } else
		 if (tot_commargs<15) /* mark command arguments */
		    commarg[tot_commargs++]=iTeller;
		 else show_error("Argument list full");
    }

    /* no arguments at all, create the default filemask argument */
    if (!tot_commargs) commarg[tot_commargs++]=mask_argc_number;

    /* construct arglist array */
    /* arglist is an array of pointers to the run-time command line arguments, to be passed */
    /* to the target command. The filemask substring will be replaced with the selected */
    /* filename from the handle_dir function. */
    /* This is done by replacing the address of the original filemask argument */
    /* with the address of a string buffer 'selected' */
    /* The leading characters (Pa,c c component) are skipped. The resulting address */
    /* is fed to function handle_dir to enable a correct replacement */
    /* The first parameter will be made the processor name */
    for (iTeller=0;iTeller<tot_commargs;iTeller++)
    {
	if (commarg[iTeller]!=mask_argc_number) arglist[iTeller+1]=argv[commarg[iTeller]];
	else
	{
	     arglist[iTeller+1]=selected;               /* replace with buffer address for selected string */
	     strcpy(selected,argv[commarg[iTeller]]);  /* save leading characters */
	     strcpy(trailer,""); 
	     if (mask_length)
	     {
	       if ((mask_starting_char - 1 + mask_length) <= strlen(argv[commarg[iTeller]]))
	       strcpy(trailer,argv[commarg[iTeller]] + mask_starting_char - 1 + mask_length);
	       else  show_error("incorrect l in Pa,c,l"); 
	     }
	     selected[mask_starting_char-1]='\0';      /* get rid of original filemask */
	     p=selected;                               /* make a pointer of it */
	     if (mask_starting_char==1 || ((mask_starting_char-1) < strlen(argv[commarg[iTeller]]))) /* is the offset possible ? */
		 p+=(mask_starting_char-1);            /* skip leading characters  (do nothing if mask_starting_char== 1) */
	     else 
	     {
		 show_error("incorrect c in Pa,c");
		 mask_starting_char=1;
	     }
	}
    }

    /* get correct mask component */
    if (argc==2) strcpy(mask,"*.*");    /* is there a filemask ? */
    else
    {
	 strcpy(mask, argv[mask_argc_number]+(mask_starting_char-1)); /* get mask */
	 if (mask_length) mask[mask_length]='\0';  /* remove trailer */
    }
    if (mask[0]==(char) fsswitch) strcpy(mask,"*.*"); /* a switch ? Replace it with *.* */      
    if (strlen(mask)>13) mask[13]='\0';     /* max. 13 characters! */

    _settextposition( oldpos.row, oldpos.col );  /* recover from show_error calls */

    /* expand the processor name */
    locate_processor( argv[1], processor);
    if (!strlen(processor)) strcpy(processor,argv[1]); /* not found, let execute() do the work */

    /* put the processor name in the first argument of the argument list */
    arglist[0]=processor;
    
    while (!setting_factory_defaults) /* select a file */
    {
	if (init_screen)
	{
	  /* set video mode */
	  if (init_screen==COLOR)
	     if( !_setvideomode( _TEXTC80 ) )
		_setvideomode( _TEXTMONO );
	  if (init_screen==MONO)
	     _setvideomode( _TEXTMONO );
	}

	strcpy(p,"");
	handle_dir_result=handle_dir( mask , p , safe_mode);  /* fill p here */
	strcat(p,trailer);

	if (init_screen)
	{
	    _setvideomode(vc.mode); /* restore old video mode */
	    _settextposition( oldpos.row, oldpos.col );
	}
	if (handle_dir_result==EXIT_RESTORE || handle_dir_result==FAILURE)
	{
	      _chdrive( olddrive );     /* restore path */
	      chdir( oldcwd );
	      break; /* ESC, break out of TRUE loop */
	}
	if (handle_dir_result==EXIT_KEEP) break; /* ESC, break out of TRUE loop */

	/* a lot of foggy stuff with the _chdrive and chdir around this because we have to handle the L function */

	if (keep_path || no_return)  /* restore path before executing commands */
	{
	   _chdrive( olddrive );
	   chdir( oldcwd );
	}

	if (no_return) savedscreen=restScrn(savedscreen);             /* restore video memory */
	execute( processor, arglist, tot_commargs, no_return, testing );
	if (!keep_path && !no_return) /* change to the selected drive and directory for future calls */
	   set_working_drive_and_dir( selected );

	if (wait || testing)
	{
	     _outtext("\n*** Press any key to continue ***");
	      getkey();
	     _outtext("\r                                 ");
	}

	if (no_return) break;             /* /1 switch and still alive, get out! */
    }

    savedscreen=restScrn(savedscreen);    /* this is double if execlp fails on /1, but who cares */
    _settextcursor(oldcursor); /* the cursor should be balanced, but programs called with */
			       /* function E could eat-up the cursor */

    if (handle_dir_result==FAILURE) exit( 1 );
    else exit( 0 );
}

/****************************************************************************
   command executor, uses execlp for single run, spawnlp for multiple runs of
   external commands, system for internal commands.
   uses spawno functions if allow_swap=TRUE
   comm        : command string
   a           : pointer to the argument string list.
   tot_commargs: number of arguments, excluding a[0] (==command string)
   no_return   : single run, use execlp instead of spawnlp
   testing     : show command, do not execute
*/
int execute(char *comm, char **a, int tot_commargs, int no_return, int testing)
{
	char scratch[ _MAX_PATH];
	int error, iTeller;
       
	if (testing)
	{
	     strcpy(scratch,"\n");
	     strcat(scratch,comm);
	     for (iTeller=0;iTeller<tot_commargs;iTeller++)
	     {
		 strcat(scratch," ");
		 strcat(scratch,a[iTeller+1]); /* skip a[0] */
	     }
	     strcat(scratch,"\n");
	     _outtext(scratch);
	     return (0);
	}

	if (no_return)
	     error=execvp( comm, a );
	    /* this will normally not return, write-over FS code, do not swap */
	else
	{
	    if (allow_swap) error=fs_spawnvpeo( swap_dir,comm,a,_environ ); /* swap FS code */
	    else error=spawnvp( P_WAIT, comm, a ); /* preserve FS code */
	}
	if (error==-1)
	{
	     /* Can't execute or spawn this process, probably resident MS-DOS
	      * Let us hope spawn is not returning a -1 return code and try
	      * a system call now */
	     strcpy(scratch,comm);
	     for (iTeller=0;iTeller<tot_commargs;iTeller++)
	     {
		 strcat(scratch," ");
		 strcat(scratch,a[iTeller+1]); /* skip a[0] */
	     }
	     if (allow_swap) fs_systemo(swap_dir,scratch);
	     else error=system(scratch);
	}
	return (error);
}

/* Converts hex digits to decimals, make invalid digits 0
*/
int convcolorinfo( char colinfo)
{
    toupper(colinfo);
    if ((colinfo >= '0') && (colinfo <= '9')) return ((int) (colinfo - '0'));
    else if ((colinfo >= 'A') && (colinfo <= 'F')) return ((int) (colinfo - 'A') + 10);
	 else return 0;
}

/* Process ?hhhhhhhhhhh option to colors
*       or ?s option to fsswitch
*/
int set_colors( char *scratch)
{
  if (strlen(scratch)==1) return FAILURE; /* do not set run-time colors */
  if (strlen(scratch)==2 && scratch[0]=='D')
  {
      fsswitch=(short int) scratch[1];
      return SUCCESS; /* side-effect: will set run-time colors to the same values */ 
  }
  if (strlen(scratch)==12) /* process color info */
  {

     screen_bg_color       =convcolorinfo(scratch[1]);
     file_color            =convcolorinfo(scratch[2]);
     hidden_file_color     =convcolorinfo(scratch[3]);
     directory_color       =convcolorinfo(scratch[4]);
     hidden_directory_color=convcolorinfo(scratch[5]);
     volume_label_color    =convcolorinfo(scratch[6]);
     cursor_bg_color       =convcolorinfo(scratch[7]);
     info_bg_color         =convcolorinfo(scratch[8]);
     info_text_color       =convcolorinfo(scratch[9]);
     error_bg_color        =convcolorinfo(scratch[10]);
     error_text_color      =convcolorinfo(scratch[11]);
     return SUCCESS;
  }  else show_error("Incorrect color string, using defaults");
  return FAILURE;
}

/***************************************************************************
 Save default colors, patch FS.EXE
 setcolorresult SUCCESS: nieuwe colors zetten in image
		FAILURE: default colors zetten in image en run-time
 zoek naar fffefdfcfbfa, kontroleer of na 24 bytes (2*12) fafbfcfdfeff komt en
 patch 12 short integers daartussen
*/


int save_colors_in_exe( char *imagename , int setcolorresult)
{
     char *buff;                 /* Pointer to data buffer */
     struct color  {
		    short int c1;
		    short int c2;
		    short int c3;
		    short int c4;
		    short int c5;
		    short int c6;
		    short int c7;
		    short int c8;
		    short int c9;
		    short int c10;
		    short int c11;
		    short int s1;
		   } colors;
     int fn;                     /* file handle */
     long fl;                    /* file length */
     unsigned int count=0x7fff;  /* buffer size */
				 /* does not work above 0x7fff. Cannot figure out why */
     int  found;                 /* True if checkpoint code found */
     long rsize;                 /* Amount of data read into buffer */
     long tot_offset,offset;     /* Position where checkpoint code found */

     if (setcolorresult==FAILURE)    /* set & patch factory defaults */
     {
	set_colors("C17FEA342F47");
	fsswitch=(short int) '/';
     }
     colors.c1=screen_bg_color;
     colors.c2=file_color;
     colors.c3=hidden_file_color;
     colors.c4=directory_color;
     colors.c5=hidden_directory_color;
     colors.c6=volume_label_color;
     colors.c7=cursor_bg_color;
     colors.c8=info_bg_color;
     colors.c9=info_text_color;
     colors.c10=error_bg_color;
     colors.c11=error_text_color;
     colors.s1=fsswitch;
   if( (fn = open( imagename, O_BINARY | O_RDWR )) == - 1 )
   {
     show_error("FS image not found");
     return FAILURE;
   }
   /* Get size of file */
   fl = filelength(fn);
   if( (unsigned long) fl < (unsigned long) count )
	count = (unsigned int) fl;

    /* Dynamically allocate a large file buffer. If there's not enough
     * memory for it, find the largest amount available
     */
    if( !(buff = (char *)malloc( (size_t)count )) )
    {
	count = _memmax();
	if( !(buff = (char *)malloc( (size_t)count )) )
	{
		 show_error("Cannot allocate memory");
		 close(fn);
		 return FAILURE;
	}
    }

   found = FALSE;
   tot_offset=0L;
   while ( !eof(fn) && !found)
   {
     if( (rsize = (unsigned long) read( fn, buff, count )) == FAILURE )
     {
		 show_error("Read error");
		 close(fn);
		 free(buff);
		 return FAILURE;
     }
     for (offset=0L; offset <= rsize-36L; offset++)     /* 6+24+6 */
     {
      if (!strncmp(&buff[offset], "\xFF\xFE\xFD\xFC\xFB\xFA", 6 ))
      {
	if (!strncmp(&buff[offset+30L], "\xFA\xFB\xFC\xFD\xFE\xFF", 6 ))
	{
	  found = TRUE;
	  break;         /* escape from FOR loop */
	}
      }
     }

     if (!found && !eof(fn)) /* reposition back 6+24+5 to recover from split search string */
     {
	   if (lseek (fn, -35L, SEEK_CUR)==FAILURE)
	   {
		 show_error("Seek error");
		 close(fn);
		 free(buff);
		 return FAILURE;
	   }
     }

     tot_offset+=offset;  /* after a lseek operation, the 36 bytes in the end-condition in the loop */
			  /* eliminates the need of substraction of 35 bytes for lseek */

   }
   free(buff);

   if (!found)
   {
    show_error("Cannot locate color storage position");
    close(fn);
    return FAILURE;
   }

   /* Write the colors structure into the exe file */
   if (lseek (fn, tot_offset + 6L, SEEK_SET)==FAILURE) show_error("Seek error");
      else if (write(fn,&colors, 24)==FAILURE) show_error("Write error");
   if (close(fn)==FAILURE) show_error("Close error");
   return SUCCESS;
}


/* process a command-line switch or environmental variable in string param */
void interpret_params( char *imagename, int argc, char *param,
		       int *no_return, int *init_screen, int *testing,
		       int *wait, int *swap_types, int *allow_swap,
		       int *keep_path, int *max_files, int *mask_argc_number,
		       int *mask_starting_char, int *mask_length,
		       int *safe_mode, int *order_by, int *order_type,
		       int *max_linewidth)
{
    char scratch[_MAX_PATH];
    char *p;
    int swap_to_disk=TRUE;      /* can't test on symbol SWAP_DISK (0) */

    strcpy(scratch,param);
    switch (scratch[0])
    {
	case '1': *no_return=TRUE;
		  break;
	case 'C': *init_screen=COLOR;
		  set_colors(scratch);
		  break;
	case 'D': setting_factory_defaults=TRUE;
		  if (save_colors_in_exe(imagename,set_colors(scratch))==FAILURE)
		     show_error("Can't save colors and/or switch");
		  break;
	case 'T': *testing=TRUE;
		  break;
	case 'M': *init_screen=MONO;
		  break;
	case 'W': *wait=TRUE;
		  break;
	case 'N': *safe_mode=TRUE;
		  break;
	case 'S': if (!strlen(scratch+1)) *allow_swap=FALSE; /* only S, disable all swapping */
		  else
		  {
		    *swap_types=0;              /* reset all */
		    swap_to_disk=FALSE;
		    if (strchr(scratch+1,(int) 'D')) 
		    {
			 *swap_types |= SWAP_DISK; /* allow disk swaps */ 
			 swap_to_disk=TRUE;
		    }
		    if (strchr(scratch+1,(int) 'E')) *swap_types |= SWAP_EMS; /* allow EMS */ 
		    if (strchr(scratch+1,(int) 'X')) *swap_types |= SWAP_XMS; /* allow XMS */ 
		    if (strchr(scratch+1,(int) 'T')) *swap_types |= SWAP_EXT; /* allow raw EXT */
		    if (!swap_to_disk) strcpy(swap_dir,"");  /* disable disk_swaps */
		    init_SPAWNO(swap_dir,*swap_types);
		  }
		  break;
	case 'O': *order_by=NONE;
		  if (strlen(scratch)>1)
		  switch(scratch[1])
		  { 
		    case 'D': *order_by=DATE;
			      break;
		    case 'S': *order_by=SIZE;
			      break;
		    case 'N':
		    default: *order_by=NAME;
			     break;
		  }
		  if (strlen(scratch)>2)
		  switch(scratch[2])
		  { 
		    case '-': *order_type=DESCENDING;
			      break;
		    case '+':
		    default: *order_type=ASCENDING;
			     break; 
		  }
		  break;
	case 'R': *keep_path=TRUE;
		  break;
	case 'B': strcpy(turnover_datetime_string,scratch+1);
		  if (set_turnover_datetime( turnover_datetime_string )==FAILURE)
		  {
		      strcat(scratch," ignored");
		      show_error(scratch);
		  }
		  break;
	case 'F': *max_files=atoi(scratch+1);
		  if (*max_files<=0 || *max_files>0x7FFF)
		  {
		      *max_files=MAX_FILES;
		      strcat(scratch," ignored");
		      show_error(scratch);
		  }
		  break;
	case 'J': *max_linewidth=atoi(scratch+1);
		  if (*max_linewidth<=0 || *max_linewidth>0x7FFF)
		  {
		      *max_linewidth=MAX_LINEWIDTH;
		      strcat(scratch," ignored");
		      show_error(scratch);
		  }
		  break;
	case 'P': *mask_argc_number=atoi(scratch+1);
		  if (*mask_argc_number<2 || *mask_argc_number >=argc)
		  {
		     *mask_argc_number=2;
		     strcat(scratch," ignored");
		     show_error(scratch);
		     break;
		  }
		  p = strtok( scratch+1, "," );  /* skip first token, already processed */
		  p = strtok( NULL, ",");        /* find next token */
		  if (p!=NULL)
		  {
		     *mask_starting_char=atoi(p);
		     if (*mask_starting_char<1) 
		     {
		     *mask_starting_char=1;
		     strcat(scratch," c,l component ignored");
		     show_error(scratch);
		     break;
		     }
		     p = strtok(NULL, ",");
		  }
		  if (p!=NULL)
		  {
		     *mask_length=atoi(p);
		     if (*mask_length<0 || *mask_length>13) 
		     {
		     *mask_length=0;
		     strcat(scratch," l component ignored");
		     show_error(scratch);
		     break;
		     }
		  }
		  break;
	default: /* ignore unknown FS switches*/
		 strcat(scratch," ignored");
		 show_error(scratch);
		 break;
    }
}



/* Puts complete filename in processor string or "" if not found
 */
void locate_processor(char *command, char *processor)
{
    char drive[_MAX_DRIVE], dir[_MAX_DIR];
    char fname[_MAX_FNAME], ext[_MAX_EXT];
    char scratch[_MAX_DRIVE + _MAX_DIR + _MAX_FNAME + _MAX_EXT];

    _strupr(command);
    _splitpath( command, drive, dir, fname, ext );

    if (strlen(dir) || strlen(drive))    /* location is known */
    {
	if (strlen(ext))                 /* extension is known */
	{
	    if (EXIST(command)) strcpy(processor,command);
	    else strcpy(processor,"");
	    return;
	}

	strcpy(scratch,command);         /* look for .COM */
	strcat(scratch,".COM");
	if (EXIST(scratch))
	{
	    strcpy(processor,scratch);
	    return;
	}

	strcpy(scratch,command);         /* look for .EXE */
	strcat(scratch,".EXE");
	if (EXIST(scratch))
	{
	    strcpy(processor,scratch);
	    return;
	}

	strcpy(scratch,command);         /* look for .BAT */
	strcat(scratch,".BAT");
	if (EXIST(scratch))
	{
	    strcpy(processor,scratch);
	    return;
	}

	strcpy(processor,"");            /* failed */
	return;
    }

    if (strlen(ext))      /* complete filename.ext is known */
    {
	strcpy(scratch,fname);
	strcat(scratch,ext);
	_searchenv( scratch, "PATH", processor );
	return;
    }

    /* construct executable filenames */
    strcpy(scratch,fname);
    strcat(scratch,".COM");
    _searchenv( scratch, "PATH", processor );
    if (strlen(processor)) return;             /* found FILE.COM */

    strcpy(scratch,fname);
    strcat(scratch,".EXE");
    _searchenv( scratch, "PATH", processor );
    if (strlen(processor)) return;             /* found FILE.EXE */

    strcpy(scratch,fname);
    strcat(scratch,".BAT");
    _searchenv( scratch, "PATH", processor );
    if (strlen(processor)) return;             /* found FILE.BAT */

    strcpy(processor,"");                      /* failed */
}
