/**************************************************************************/
/*                           UNSCRAMBLE Utility					    */
/*														    */
/*                                 M\Cooper						    */
/*                        3425 Chestnut Ridge Rd.					    */
/*                        Grantsville, MD 21536-9801				    */
/*                        --------------------------				    */
/*                        Email:  thegrendel@aol.com				    */
/*                                                                        */
/*                $2.00 to register the entire WORDY package	         */
/*														    */	
/**************************************************************************/


/**********************************WORDTEST********************************/
/*       Function tests if word is constructible from Letterset	        */
/*                 Args in: char *letterset, char *word						  */
/*   Returns: error_flag == TRUE (1) if constructible, FALSE (0) if not   */
/**************************************************************************/

#include <conio.h>
#include "srch.h"


#define FILE_OPENING_ERROR 3
#define FILENAME_MAXLEN 8
#define CR "\n"
#define FILE_SUFFIX ".wds"
#define MAXLEN 30
#define LINE_LEN 80
#define NOARGS 1
#define INCREMENT 1
#define SPACE ' '

char ad[] =
"UNSCRAMBLE utility by M\\Cooper, 3425 Chestnut Ridge Rd., Grantsville, MD 21536";



void getword( char *letter_set, size_t w_len );
void center( char *strng );

typedef enum { FALSE, TRUE } Boolean;

void main( int argc, char **argv )
{

   char letterset[ MAXLEN ];

	 if( argc == NOARGS )
	    {
	    clrscr();
	    puts( "Enter a LETTERSET to test ... " );
	    gets( letterset );
     getword( letterset, strlen( letterset ) );
	    }
	 else
	    {
	    strcpy( letterset, *( argv + 1 ) );
	    getword( letterset, strlen( *( argv + 1 ) ) );
	    }
}



Boolean wordtest( char *letterset, char *word )
{
	Boolean error_flag = TRUE;
	static char dup_lset[ MAXLEN ];
	register char *letpos;

//	 dup_lset = strdup( letterset );
	 strcpy( dup_lset, letterset );
		 
		while( *word )
			{
			if( ( letpos  = strchr( dup_lset, *word++ ) ) != NULL )
				*letpos = '*';     //As long as letter contained...
			else
				{ error_flag = FALSE; break; } //test fails (not contained)
			}

		return( error_flag );
}

/*************************************************************/
void getword( char *letter_set, size_t w_len )
{

	char	l_set [ MAXLEN ],
		word [ MAXLEN ],
		tempstr [ MAXLEN + 1 ],
		bar [ LINE_LEN + 1 ],
		double_bar [ LINE_LEN + 1 ],
   ts [ MAXLEN ];

	FILE *fptr;
	long wcount = 0L;

	   memset( bar, '-', LINE_LEN );
	   *( bar + LINE_LEN ) = NULL;
	   memset( double_bar, '=', LINE_LEN );
	   *( double_bar + LINE_LEN ) = NULL;

	   /*************opening credits*************/
	   clrscr();
	   printf( double_bar );
	   strcpy( tempstr, ad );
	   center ( tempstr );
	   printf( tempstr );
	   printf( CR );
	   printf( double_bar );
	   printf( CR );
	   /****************************************/


	   strcpy ( l_set, letter_set );
	   strcat ( letter_set, CR );


	   if( !( fptr = fopen( Wordfile, "rt" ) ) )
		 {
		 printf( "\7\7\7Cannot open Wordfile!" );
		 exit( FILE_OPENING_ERROR );
		 }

	   /**************'Wait' Message************/
	   printf( CR CR );
	   printf( "WORKING...\n\n" );
	   printf( "This will take from 10 seconds or less [fast 486 machine]\n" );
	   printf( "to 5 minutes or more [slow 8088 with old hard drive].\n\n" );
	   printf( "Now searching 99,000+ word file for possible solutions...\n\n" );
	   /*****************************************/





	   sprintf( tempstr, "Words unscrambled from: %s\n", strupr( l_set ) );
	   center( tempstr );
	   printf( double_bar );
	   printf( tempstr );
	   printf( double_bar );
	   printf( CR );


		 /*********************Main Loop*************/	 
		  while( fgets( word, MAXLEN, fptr ) != NULL )

			if( wordtest( letter_set, word ) )
			   if( strlen( word ) == w_len + INCREMENT )
				 {
				 printf( "%s", word );
				 wcount++;
                     }

      if( wcount == INCREMENT )
         strcpy( ts, "word" );
      else
         strcpy( ts, "words" );

		  /*******************************************/

		  printf( bar );
		  sprintf( tempstr, "%ld %s can be unscrambled from %s.",
				 wcount, ts, l_set );
		  center( tempstr );		      
		  printf( tempstr );
		  printf( "\n\n" );

		  center( ad );
		  printf( ad );
      printf( "\7\n\n" );

		  fcloseall();


}



void center( char *str )
{
   int padding;
   char st [ LINE_LEN + INCREMENT ];

	 padding = LINE_LEN / 2 - strlen( str ) / 2;
	 memset( st, SPACE, padding );
	 *( st + padding ) = NULL;  //Terminate string
	 strcat( st, str );
	 strcpy( str, st );

	 return;
}
