program movingclock;
uses crt, dos;
{------------------------------------------------------------------------------

                                REVISION HISTORY

v1.00  : 1993/08/19.  First public release.  DDA
v1.00a : 1993/08/30.  Fixed cursoron procedure, with thanks to David Cheung.
v1.01  : 1993/09/10.  New getcursor and setcursor procedures, via Randall
                          Woodman.  Supercede cursoroff/ cursoron.     DDA
v1.02  : 1993/09/27.  Refined getcursor and setcursor procedures, with much
                          help from Mark Shadley.  DDA
v1.03  : 1994/12/07.  New cursor procedures (again!).  DDA
v1.04  : 1995/01/25.  Tightened code.  DDA

------------------------------------------------------------------------------}

procedure showhelp;
const
  progdesc = 'MCLK - Free DOS utility: colorful moving clock display.';
  author   = 'v1.04: January 25, 1995. (c) 1995 by David Daniel Anderson - Reign Ware.';
  usage    = 'Usage:  MCLK';
begin
  writeln (progdesc);
  writeln (author);
  writeln (usage);
  halt;
end;

procedure cursor(const on : boolean);
var
  r : registers;
begin
  r.ah:=$03;            {----get cursor shape on page 0               }
  r.bh:=$00;            {----to be exact use function 2 to obtain page}
  intr($10,r);

  if ((r.cx< $2000) and not(on)) or
     ((r.cx>=$2000) and on)
    then
      begin
        r.ah:=$01;
        r.cx:=r.cx xor $2000;   {----toggle bit if neccesary}
        intr($10,r);
      end;
end; {of cursor}

function leadingzero(const w : word) : string;
var
  s : string;
begin
  str(w:0,s);
  if length(s) = 1 then
    s := '0' + s;
  leadingzero := s;
end;

procedure DisplayDate;
var
  h,mi,s,u   : word;
  date_time  : datetime;
begin
  gettime (h,mi,s,u);
  with date_time do
  begin
    hour := (h);
    min  := (mi);
    sec  := (s);
    write (leadingzero (hour), ':', leadingzero (min), ':', leadingzero (sec));
  end;
end;

var
  rtcol,
  btrow : byte;

begin
  checkbreak := false;
  if paramcount <> 0 then showhelp;

  rtcol := lo (windmax);
  btrow := hi (windmax);
  textattr := 8;
  cursor (false);
  randomize;

  while not keypressed do begin
    TextAttr := ((succ(TextAttr)) mod 8) + 8;
    clrscr;
    GotoXY ((1+random(rtcol-8)), (1+random(btrow-1)));
    DisplayDate;
    delay (990);
  end;
  cursor (true);
  NormVideo;
  clrscr;

  while keypressed do readkey;
end.
