program GENDEMO;
{$S-}
uses
  App, Views, Objects, Drivers, Dialogs, Menus;

var
  ResFile: PResourceFile;

type
  TDEMO1App = Object(TApplication)
    constructor Init;
    destructor Done; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
  end;

constructor TDEMO1App.Init;
begin
  RegisterObjects;
  RegisterViews;
  RegisterDialogs;
  RegisterMenus;
  ResFile := New(PResourceFile, Init(New(PBufStream, Init('DEMO1.RES', stOpen, 4096))));
  TApplication.Init;
end;

destructor TDEMO1App.Done;
begin
  if ResFile <> nil then Dispose(ResFile, Done);
  TApplication.Done;
end;

procedure TDEMO1App.HandleEvent(var Event: TEvent);
begin
  TApplication.HandleEvent(Event);
  case Event.What of
    evCommand:
      case Event.Command of
        cmOpen: ;
        else
          Exit;
      end;
    else
      Exit;
  end;
  ClearEvent(Event);
end;

procedure TDEMO1App.InitMenuBar;
var
  R: TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  MenuBar := PMenuView(ResFile^.Get('MainMenu'));
  MenuBar^.ChangeBounds(R);
end;

procedure TDEMO1App.InitStatusLine;
var
  R: TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine := PStatusLine(ResFile^.Get('StatusLine'));
  StatusLine^.ChangeBounds(R);
end;

var
  DEMO1App: TDEMO1App;

begin
  DEMO1App.Init;
  DEMO1App.Run;
  DEMO1App.Done;
end.
