.I 0 10
/*
** rounding macros by Dave Knapp, Thad Smith, Jon Strayer, & Bob Stout
*/

#include <math.h>

#if __cplusplus

/*
** Safe C++ inline versions
.D 1 2
.I 6 4
inline int iround(double x)
{
      return (int)floor(x + ((x >= 0) ? 0.5 : -0.5));
}
.D 7 1
.I 10 24
inline double fround(double n, unsigned d)
{
      return floor(n * pow(10., d) + .5) / pow(10., d);
}

#else

/*
** NOTE: These C macro versions are unsafe since arguments are referenced
**       more than once.
**
**       Avoid using these with expression arguments to be safe.
*/

/*
** round to integer
*/

#define iround(x) floor((x) + ((x) >= 0 ? 0.5 : -0.5))

/*
** round number n to d decimal points
*/

.I 11 2

#endif
