.I 124 39

#ifdef TEST

#include <stdio.h>

int main(int argc, char *argv[])
{
      unsigned day, yr, mo;
      char *months[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun",
                        "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

      if (3 > argc)
      {
            puts("Usage: JDN d m y");
            puts("where: d = day (1 - 31)");
            puts("       m = month (1 - 12)");
            puts("       y = year (1 - 99, 1800 - 3000)");
            return -1;
      }

      yr  = atoi(argv[3]);
      mo  = atoi(argv[2]);
      day = atoi(argv[1]);

      if (!mo || 12 < mo)
            return -1;

      if (!day || 31 < day)
            return -1;

      if (100 > yr)
            yr += 1900;

      printf("jdn(%d %s %d) = %ld\n", day, months[mo], yr,
            ymd_to_jdn(yr, mo, day, 0));
      return 0;
}

#endif
