/*
**  Portable PC screen functions
**  Public domain by Bob Stout
**  Uses SCRNMACS.H and HUGEREAD.C, also from SNIPPETS
*/
 
#include <stdio.h>
#include "scrnmacs.h"         /* Also in SNIPPETS     */

typedef enum { ERROR = -1, SUCCESS} RESULT;

/*
**  Prototypes from HUGEREAD.C, also in SNIPPETS
*/

long hugefread(FILE *fp, char FAR *buf, long size);
long hugefwrite(FILE *fp, char FAR *buf, long size);

/*
**  Save the text screen to a file
*/

RESULT fSaveScrn(const char *fname)
{
      FILE *file;

      if (NULL == (file = fopen(fname, "wb")))
            return ERROR;
      if ((long)SCRNBYTES != hugefwrite(file, (unsigned char FAR *)SCRBUFF,
            (long)SCRNBYTES))
      {
            return ERROR;
      }
      fclose(file);
      return SUCCESS;
}

/*
**  Restore the text screen from a file
*/

RESULT fRestoreScrn(const char *fname)
{
      FILE *file;

      if (NULL == (file = fopen(fname, "rb")))
            return ERROR;
      if ((long)SCRNBYTES != hugefread(file, (unsigned char FAR *)SCRBUFF,
            (long)SCRNBYTES))
      {
            return ERROR;
      }
      fclose(file);
      return SUCCESS;
}

#ifdef TEST

#include <conio.h>

/*
**  Run this test with a screenful of misc. stuff
**
**  Note that this test requires that VIDPORT.C and SCROLL.C, also from
**  SNIPPETS, be linked.
*/

main()
{
      if (ERROR == fSaveScrn("fscrnsav.tst"))
      {
            puts("Unable to save the screen");
            return 1;
      }
      ClrScrn(7);
      GotoXY(0, 0);
      fputs("fClrScrn() tested", stderr);
      fputs("\nHit any key to continue...\n", stderr);
      getch();
      fRestoreScrn("fscrnsav.tst");
}

#endif
