.I 0 14
/*
 * COMMCONV.C
 * Change C++ comments to C comments
 *
 * ver 2.0, 05 Mar 1995
 *
 * Public domain by:
 *   Jari Laaksonen
 *   Arkkitehdinkatu 30 A 2
 *   FIN-33720 Tampere
 *   FINLAND
 *
 *   Fidonet : 2:221/360.20
 *   Internet: jla@to.icl.fi
.D 1 5
.I 11 117
      int   Char,
            Char2,
            cpp_comment   = 0,
            c_comment     = 0,
            in_string     = 0,
            cpp_multiline = 0;
      char CannotOpen[] = "Cannot open %s\n\n";
      FILE *InFile, *OutFile = stdout;

      if (argc < 2)
      {
            fprintf (stderr, "USAGE: COMMCONV InFile [OutFile]\n");
            return 1;
      }
      if ((InFile = fopen (argv[1], "r")) == NULL)
      {
            fprintf (stderr, CannotOpen, argv[1]);
            return 2;
      }

      if (argc == 3)
      {
            if ((OutFile = fopen (argv[2], "w")) == NULL)
            {
                  fprintf (stderr, CannotOpen, argv[2]);
                  /* if can't open, output goes to stdout instead */
                  OutFile = stdout;
            }
      }

      while ((Char = fgetc (InFile)) != EOF)
      {
            fputc (Char, OutFile);

            if (Char == '\"')
            {
                  Char2 = fgetc (InFile);       /* check next char      */
                  if (Char2 != '\'')            /* character constant?  */
                        in_string = ! in_string;/* no, toggle flag      */
                  fputc (Char2, OutFile);
            }

            if (in_string)                /* we are in a string now     */
                  continue;

            if (Char == '/')
            {
                  Char = fgetc (InFile);  /* check next char            */
                  if (Char == '/')        /* is it start of C++ comment */
                  {
                        Char = '*';       /* change it to C comment     */
                        cpp_comment = 1;
                  }
                  else if (Char == '*')   /* is it start of C comment   */
                        c_comment = 1;

                  fputc (Char, OutFile);
            }
            else if (Char == '*' && c_comment)
            {
                  Char = fgetc (InFile);
                  if (Char == '/')        /* is it end of C comment     */
                        c_comment = 0;
                  fputc (Char, OutFile);
            }

            if (c_comment || cpp_comment) /* inside C or C++ comment    */
            {
                  /* check the rest of the line       */

                  while ((Char = fgetc (InFile)) != '\n')
                  {
                        if (Char == '\\' && cpp_comment)
                              cpp_multiline = 1;
                        if (Char == '*')
                        {
                              Char2 = fgetc (InFile); /* check next char   */
                              ungetc (Char2, InFile); /* put it back       */
                              if (Char2 == '/')       /* end of C comment? */
                              {
                                    c_comment = 0;
                                    /* end of C comment inside C++ comment?*/
                                    if (cpp_comment)
                                    {
                                          fputs ("* ", OutFile);
                                          Char = fgetc (InFile);
                                    }
                              }
                        }
                        fputc (Char, OutFile);
                  }
                  if (cpp_comment && cpp_multiline == 0)
                  {
                        /* put ending C comment mark */
                        fputs (" */", OutFile);
                        cpp_comment = 0;
                  }
                  fputc ('\n', OutFile);

                  /* clear flag for the next round. if it is still clear after
                     next C++ comment line is processed, multiline C++ comment
                     is ended.
                  */

                  cpp_multiline = 0;
            }
      } /* while end */

      if (argc == 3)
            fclose (OutFile);
      fclose (InFile);

      fflush (stdout);
      fprintf (stderr, "\nOK!\n");

      return 0;
}
.D 12 86
