-----BEGIN PGP SIGNED MESSAGE-----


  {:nf1}
  {help J}
  {}


  {:nf6}
  {:outequal}
  {call defaults}                 setup defaults for event menus
  {call dispback}
  {call pleswait}                 notify user to wait
  {call getval}                   get stored event values
  {call asmevstr}                 assemble event strings
  {call redisplay}                display
  {stop}

   {:defaults}                    setup for event manager menus
   {sete}                         clear default escape keypress
   {stat n}                       no status bar
   {parm ,,,T,}                   default screen attributes to tty
   {wind-k}                       preserv window displays
   {setv fieldnum,1}              default field number
   {setv fieldleng,1}             default field length
   {setv evnum,1}                 default event number
   {setv evenum,1}                default event number to 1
   {setv c,1}                     default event counter to 1
   {call evbar}                   get screen positions for selector bar
   {call help}                    get online help constants
   {return}

- -------------------------------------------------------------------------------
 Read M4Event.Dat (plaintext event parm file) & convert to display strings
- -------------------------------------------------------------------------------

  {:getval}
  {ropen m4event.dat,ret}         open event text data file
  {setv repeat,eachval,999}       get each line from event data
  {call repeat}                   test file
  {rclos}                         close file
  {setv line}                     clear temp vars
  {setv epos}
  {setv varnam}
  {setv varval}
  {return}

   {:eachval}                             get each line of data from event data
   {read line}                            read a line
   {inst line,=}                          where is `=' in line? (event variable)
   {setv epos,%_pos}                      put in EPOS
   {comp %epos,0}                         is it a blank line?
   {ifco upevt}                           if so, bring up event counter
   {subs varnam,1,4,%line}                array var prfx>1st 4 chars of file var
   {incr epos}                            bump up EPOS (right-of-equal-sign)
   {subs varval,%epos%,20,%line}          get value of var (from right of =)
   {comp varval}                          blank?
   {ifco-c padval}                        if so, pad value with blanks for disp
   {inst varval,*}                        *? (also a nul field indicator)
   {comp %_pos,1}                         if in 1st pos, treat as nul indicator
   {ifco-c padval}                        and pad value with blanks for display
   {setv %%varnam%%c,%varval}             assign VARNAME(count)=Value
   {return}

    {:upevt}                              bring event counter up
    {inst line,End M4-####-Setup File}    EOF string in line?
    {comp %_pos,0}                        if not
    {ifco ,ret}                           return
    {incr c}                              else, bump C up one to indicate
    {return}                              what event next vars will refer to

    {:padval}                             pad value of var a blank
    {setv varval, }                       so field isn't empty so
    {return}                              we can process it

- ------------------------------------------------------------------------------

{:dispback}                                   display background GFX
{setv background,}
{setv repeat,showbak,25}                      display above line on all 24
{call repeat}
{disp 2,29,17,    M4 Event Scheduler   }     identification field
{disp 3,29,17, (c) Allan Bowhill, 1995 }
{disp 3,54,00, }
{disp 4,30,00,                         }
{setv background,                                                                          }
{setv repeat,blankbak,24}                     cycle through lines to
{call repeat}                                 display gfx overlay box
{disp 18,6,00,                                                                         }
{setv background}
{return}

 {:showbak}                                    display background on row
 {disp %timecount%,1,17,%background%}          color=blue
 {return}

 {:blankbak}                                   display GFX overlay box
 {comp timecount,6}                            on 6th row?
 {ifco-l rit}                                  if not yet, no display
 {comp timecount,17}                           on 17th row?
 {ifco-g ret}                                  if past, no display
 {call showbak}                                since neither, display GFX line
 {comp timecount,7}                            if after 1st place in box
 {ifco-ge shadrite}                            drop a shadow on right
 {return}

  {:shadrite}
  {disp %timecount%,78,00, }                    shadow-right
  {return}

{:pleswait}          please-wait box
{disp 8,30,40,                       }
{disp 9,30,4B,   Please Wait ...     }
{disp 10,30,40,                       }
{disp 9,53,00, }
{disp 10,53,00, }
{disp 11,31,00,                       }
{return}


{:help}                                    display each event on GFX box
{setv helpA1, TYPE: Event Number                                                             }
{setv helpB1, HELP: Type <INS> to insert new event, <DEL> to delete event                    }
{setv helpA2, TYPE: Description                                                              }
{setv helpB2, HELP: Add/modify description of particular event. This shows in log.           }
{setv helpA3, TYPE: Days of Week                                                             }
{setv helpB3, HELP: Select day(s) event will run. M=Monday T=Tuesday W=Wednesday R=thuRsday..}
{setv helpA4, TYPE: Start Time                                                               }
{setv helpB4, HELP: Time-of-day event is to run in 24-hour format. 00:00=Midnight 12:00=noon }
{setv helpA5, TYPE: Duration                                                                 }
{setv helpB5, HELP: Run-time in HH:MM, for INT events. Set to 00:00 for DOS and ERL events   }
{setv helpA6, TYPE: Late-Start Extension                                                     }
{setv helpB6, HELP: Execute event up to HH:MM later, if start time is missed or interrupted  }
{setv helpA7, TYPE: Event Type                                                               }
{setv helpB7, HELP: INT-Run macrofile, DOS-Run program or bat file, ERL-Exit at errorlevel   }
{setv helpA8, TYPE: Errorlevel                                                               }
{setv helpB8, HELP: Only for ERL events. M4 exits at specified errorlevel. DOS/INT-no effect }
{setv helpA9, TYPE: Filename to load/call                                                    }
{setv helpB9, HELP: INT-Macrofile to load, DOS-.BAT/.EXE/.COM file to run, ERL-No effect     }
{setv helpA10, TYPE: Macro Label Name                                                        }
{setv helpB10, HELP: For INT events. Label name to call in macrofile after it's loaded.      }
{setv helpA11, TYPE: Active/Inactive flag                                                    }
{setv helpB11, HELP: Active=   Inactive=* (not executed, but settings kept)                 }
{return}

- ------------------------------------------------------------------------------
Assemble Event strings
- ------------------------------------------------------------------------------

{:asmevstr}
{setv repeat,showevt,%c%}
{call repeat}
{return}

 {:showevt}      assign plain data, pad and assemble into string
 {setv-s even,even%timecount}                  assign all array vars extracted
 {setv-s logt,logt%timecount}                  from text event file to their
 {setv-s days,days%timecount}                  non-array equivalents. In other
 {setv-s acti,acti%timecount}                  words, ABCDEFG=12345 in text
 {setv-s star,star%timecount}                  file is assigned to array thusly:
 {setv-s dura,dura%timecount}                   ABCD(eventnum)=12345
 {setv-s late,late%timecount}                  then, in this sub:
 {setv-s type,type%timecount}                   ABCD=(ABCD(eventnum))
 {setv-s erro,erro%timecount}                  Now, we can handle all vars
 {setv-s file,file%timecount}                  for each event at same time
 {setv-s labe,labe%timecount}                  they just plug in...
 {setv blank,                                                                               }
 {setv even,%even%%blank%}                    assign all array vars extracted
 {subs even,1,2,%even}                        pad blanks by truncating
 {setv logt,%logt%%blank%}                     append val in ABCD with blanks
 {subs logt,1,11,%logt}                        pad blanks by truncating
 {setv days,%days%%blank%}                     for display purposes.EG:
 {subs days,1,7,%days}                          ABCD=12345
 {setv star,%star%%blank%}                     (if we need 8 spaces for display)
 {subs star,1,5,%star}                          then,
 {setv dura,%dura%%blank%}                      ABCD=12345___
 {subs dura,1,5,%dura}
 {setv late,%late%%blank%}
 {subs late,1,5,%late}
 {setv type,%type%%blank%}
 {subs type,1,3,%type}
 {setv erro,%erro%%blank%}
 {subs erro,1,3,%erro}
 {setv file,%file%%blank%}
 {subs file,1,12,%file}
 {setv labe,%labe%%blank%}
 {subs labe,1,8,%labe}
 {comp acti,yes}                                for boolean: event active=yes?
 {ifco-c check1,blank1}                         ifso, substitute YES with 
 {setv eventline, %even% %logt% %days% %star% %dura% %late% %type% %erro% %file% %labe% %acti% }
 {setv e%timecount,%eventline}
 {setv eventline}
 {setv even}
 {setv logt}
 {setv days}
 {setv acti}
 {setv star}
 {setv dura}
 {setv late}
 {setv type}
 {setv erro}
 {setv file}
 {setv labe}
 {setv buff}
 {setv sque}
 setv-s even%timecount}
 {setv-s days%timecount}
 {setv-s acti%timecount}
 {setv-s star%timecount}
 {setv-s dura%timecount}
 {setv-s late%timecount}
 {setv-s type%timecount}
 {setv-s erro%timecount}
 {setv-s labe%timecount}
 {setv-s buff%timecount}         buff & sque are deleted
 {setv-s sque%timecount}
 {return}

  {:check1}                                      substitute boolean YES with 
  {setv acti,}                                  for var ACTIVE (event active)
  {return}

  {:blank1}                                      subs boolean NO with blank
  {setv acti,*}                                  for var ACTIVE (event active)
  {return}

  {:check2}                                      subs boolean YES with 
  {setv sque,}                                  for var SQUEEZE (squeeze event)
  {return}

  {:blank2}                                      subs boolean NO with blank
  {setv sque,*}                                  for var SQUEEZE (squeeze event)
  {return}

- ------------------------------------------------------------------------------
- ----- interactive event bar
- ------------------------------------------------------------------------------


{:evbar}                                        display event bar
{setv sc1,2}
{setv sc2,5}
{setv sc3,17}
{setv sc4,25}
{setv sc5,31}
{setv sc6,37}
{setv sc7,43}
{setv sc8,47}
{setv sc9,51}
{setv sc10,64}
{setv sc11,73}
{setv sl1,2}
{setv sl2,11}
{setv sl3,7}
{setv sl4,5}
{setv sl5,5}
{setv sl6,5}
{setv sl7,3}
{setv sl8,3}
{setv sl9,12}
{setv sl10,8}
{setv sl11,1}
{return}


{:newevbar}                               display new event bar
{setv xoff,%evnum}                        set row pos to event num
{incr xoff,6}                             add 6 to get display row num
{setv-s evtxt,e%evnum}                    get new event text
{disp %xoff,4,70,%evtxt}                  display padded fields in GFX box
{call sbar}                               display this as new selector bar
{return}

{:oldevbar}
{disp %xoff,4,1A,%evtxt}                  display padded fields in GFX box
{return}

{:dna}
{comp c,%evnum}
{ifco-ec enddna}
{call oldevbar}
{incr %evnum}
{call newevbar}
{return}

 {:enddna}
 {setv evnum,0}
 {return}

 {:endupa}
 {setv evnum,%c}
 {incr evnum}
 {return}

{:upa}
{comp evnum,1}
{ifco-ec endupa}
{call oldevbar}
{decr evnum}
{call newevbar}
{return}


{:sbar}                                     assign & display new selector bar
{call sbarhlp}                              find new selector bar help
{setv-s fieldpos,sc%fieldnum}               get new field display position
{setv-s fieldleng,sl%fieldnum}              get new field length
{subs field,%fieldpos,%fieldleng,%evtxt}    grab field from event string
{incr fieldpos,3}                           add 3 to field position
{disp %xoff,%fieldpos,4B,%field}            display new field
{setv oldoff,%xoff}                         store old row-pos
{setv oldfpos,%fieldpos}                    store old col-pos
{setv oldfield,%field}                      store old field val
{return}

 {:sbarhlp}                                  selector bar help
 {setv-s helpA,helpA%fieldnum}               field identifier line
 {setv-s helpB,helpB%fieldnum}               field description line
 {disp 24,1,30,%helpA}                       display both texts
 {disp 25,1,30,%helpB}                       ""
 {setv helpA}                                clear
 {setv helpB}                                both vars
 {return}

{:obar}                                     clear old selector bar from screen
{disp %xoff,%fieldpos,70,%field}
{return}

{:rta}
{comp fieldnum,11}
{ifco-e endrta}
{incr fieldnum}
{call obar}
{call sbar}
{return}

{:lfa}
{comp fieldnum,1}
{ifco-e endlfa}
{decr fieldnum}
{call obar}
{call sbar}
{return}

{:endrta}
{call obar}
{setv fieldnum,1}
{call sbar}
{return}

{:endlfa}
{call obar}
{setv fieldnum,11}
{call sbar}
{return}


{:ent}                      item selected
{call ed%fieldnum}          call the control interface for this field
{call pleswait}             tell to wait
{call redisplay}            redisplay screen with new parms
{stop}

{:back}
{call help}                 restore help constants
{call evbar}                restore field display constants
{comp file,%oldfile}        was file unchanged? (no file selected)
{ifco-c ,setnfile}          if so, fall thru, else set new file parms
{call redisplay}
{setv retsub}               clear return-sub var
{setv retfile}              clear return-file var
{stop}

 {:setnfile}                set new (selected) file parm
 {setv field,%thisfile}     assign filename selected to FIELD
            need to pad filename with blanks
 {setv-s file%evnum,file}   assign whole path to permanent storage
? {setv file,%thisfile}      set var file to just filename
 {call saveparm}            insert in string
 {return}

{:redisplay}                  redsiplay all event lines
{call dispback}
{call eredisp}
{setv evnum,1}
{call newevbar}               display new event bar
{return}

- -------------------------------------------------------------------------------

 {:ed1} Edit event number  (Field #1)
 {info-q Use Arrow-Keys to Move: INS-Insert Event DEL-Delete Event}
 {pops}
 {}

 {:stt}
 {stop}

     {:ins}
     {comp c,10}
     {ifco-ge eventen}
     {call insrtevt}
     {call redisplay}
     {return}

     {:eventen}
     {info-q Only ten events can be configured}
     {return}

     {:insrtevt}                     Insert after selected field
     {comp evnum,%c}                 are we at last evt listed?
     {ifco-ec insaft}                if so, insert after last one
     {setv-s thisevt,even%evnum}     assign current event number to
     {setv thisevt,%thisevt%%blank%} -new event. pad single-digit
     {subs thisevt,1,2,%thisevt}     -numbers, to accomodate 2-digit nums
     {call shifdn}                   shift following events down
     {setv e%evnum, %thisevt% Description MTWRFSS 00:00 00:00 00:00 DOS 000 BATCHFIL.BAT MACLABEL * }
     {setv logt%evnum,Description}   assign perm vars
     {setv file%evnum,BATCHFIL.BAT}
     {incr c}
     {setv thisevt}
     {return}

     {:insaft}
     {incr evnum}
     {setv even%evnum,%evnum}     establish EVEN(evnum)
     {return}

      {:shifdn}
      {setv numshfts,%c}                  number of shifts=maximum ev count
      {decr numshfts,%evnum}              subtract current field num
      {incr numshfts}
      {setv movto,%c}                     MOVTO=total fields
      {incr movto}                        add one
      {setv repeat,shifdn1,%numshfts%}
      {call repeat}
      {setv numshfts}
      {setv movto}
      {return}

          {:shifdn1}                         move each event
          {setv movfrom,%movto}              set current pointer to MOVTO
          {decr movfrom}                     point it to last event to move
          {setv-s etomove,e%movfrom}         put expanded var to move in ETOMOVE
          {setv-s ltomove,logt%movfrom}
          {setv-s ftomove,file%movfrom}
          {subs etomove,4,80,%etomove}       strip event num from string
          {setv edispnum,%movto%%blank%}     pad move-to number
          {subs edispnum,1,2,%edispnum}      trunc it to 2 positions
          {setv etomove, %edispnum%%etomove} reassemble string
          {setv e%movto,%etomove}            put in event(MOVTO)
          {setv logt%movto,%ltomove}
          {setv file%movto,%ftomove}
          {decr movto}                       point it to last event to move
          {setv movfrom}
          {setv etomove}
          {setv edispnum}
          {setv ftomove}
          {setv ltomove}
          {return}

      {:shifup}
      {setv numshfts,%c}                  number of shifts=maximum ev count
      {decr numshfts,%evnum}              subtract current field num
      {setv movfrom,%evnum}               MOVFROM=currently selected field
      {incr movfrom}                        add one
      {setv repeat,shifup1,%numshfts%}
      {call repeat}
      {setv movfrom}
      {return}

          {:shifup1}                         move each event
          {setv movto,%movfrom}              set current pointer to MOVTO
          {decr movto}                       point it to last event to move
          {setv-s etomove,e%movfrom}         put expanded var to move in ETOMOVE
          {setv-s ltomove,logt%movfrom}      store logtext parm
          {setv-s ftomove,file%movfrom}      store file parm
          {subs etomove,4,80,%etomove}       pad event number
          {setv etomove, %movto% %etomove}
          {setv e%movto,%etomove}            put in event(MOVTO)
          {setv file%movto,%ftomove}        shift perm file info
          {setv logt%movto,%ltomove}        shift perm logtext info
          {incr movfrom}                     point it to last event to move
          {setv movto}
          {setv etomove}
          {return}

  {:del}
  {comp c,1}
  {ifco-le monevt}
  {call delevt}
  {call redisplay}
  {return}

  {:monevt}
  {info-q You must have at least ONE event defined, active or not}
  {return}

  {:delevt}
  {info-q Delete Event %evnum%?}
  {ifco ,rit}
  {call shifup}
  {decr c}
  {return}

 {:eredisp}                                  event re-display
 {setv repeat,erea,%c}                       do it line by line
 {call repeat}
 {setv eventline}
 {return}

  {:erea}                                    re-display each line
  {setv col,%timecount}                      orient column with eventnum
  {incr col,6}                               add offset for display
  {setv-s eventline,e%timecount}             put event in Eventline
  {disp %col%,4,1A,%eventline}               display fields in GFX box
  {return}

- -----------------------------------------------------------------------------

  {:ed2} edit field #2 (description)
  {setv-s efield,logt%evnum}                  put LOGTEXT from file in EFIELD
  {inpu efield,Event Description}             get input box
  {setv logt%evnum,%efield}                   put new info in var due to trunc
  {setv efield,%efield%%blank%}               append with blanks
  {subs efield,1,11,%efield}                  truncate
  {subs etomove,1,3,%evtxt}               store event number
  {subs eventlin,%sc3%,80,%evtxt}             get text after description
  {setv e%evnum,%etomove% %efield% %eventlin%}eventnum,description,rest_of_line
  {return}

- ------------------------------------------------------------------------------
  _menu(x)  menu text
  _mlabel   menu label string
  _menter   label to goto when enter is pressed
  _mcolor   color
  _msn      menu label selection number
  _menu rows,cols,string

  {:ed3} edit field #3 (days active)
  {call setday}
  {call menuday}
  {return}

  {:menuday}
  {window-k}
  {setv %_menter,togday}
  {setv %_mlabel,a,b,c,doneday,e,f,g,h,i,j,k,l,m,Nextday,o,p,q,r,s,t,u,v,w,x,y,z}
  {setv %_mcolor,70,30}
  {setv %_menu1, Use `N' key to move pointer, `D' when done}
  {setv %_menu2, Press <Enter> to toggle day active/inactive}
  {setv %_menu3,                         }
  {setv %_menu4,                  %field%       }
  {setv %_menu6,}
  {setv %_menu7,}
  {setv %_menu8,}
  {setv %_menu9,}
  {menu 10,50,Days-of-Week Event is to be Active}
  {ifco ,doneday}
  {setv %field,%oldfield}
  {wind-k0}
  {return}

  {:doneday}
  {wind-k0}
  {subs x,1,16,%evtxt}
  {subs y,25,80,%evtxt}
  {setv e%evnum,%x%%field% %y}
  {setv x}
  {setv y}
  {return}

  {:setday}                           set day pointer
  {setv day,1}
  {setv pointer,                  }
  {setv %_menu5,%pointer}
  {setv m,%_menu5}
  {return}

  {:nextday}
  {setv olday,%day}
  {incr day}
  {comp %day,8}
  {ifco-e backday}
  {subs paday,1,%olday,%blank}
  {setv %_menu5,%paday%%pointer%}
  {setv m,%_menu5}
  {goto menuday}

   {:backday}
   {setv day,1}
   {setv olday,%day}
   {setv %_menu5,%pointer%}
   {setv m,%_menu5}
   {goto menuday}

  {:togday}
  {setv befday,%day}
  {decr befday}
  {setv aftday,%day}
  {incr aftday}
  {subs xfield,1,%befday,%field}
  {subs yfield,%aftday,8,%field}
  {subs zfield,%day,1,%field}
  {comp zfield,-}
  {ifco-c getdlet,makedash}
  {setv field,%xfield%%let%%yfield%}
  {setv %xfield}
  {setv %yfield}
  {setv aftday}
  {setv befday}
  {setv %_menu5,%m}
  {goto menuday}

    {:getdlet}        get day-letter
    {setv dayfield,MTWRFSS}
    {subs %let,%day,1,%dayfield}
    {return}

    {:makedash}    make dash instead of letter
    {setv let,-}
    {return}
- -------------------------------------------------------------------------------

 {:blatim}                 set blank time field to 00:00
 {inst field,:}
 {setv pos,%_pos}
 {comp pos,0}
 {ifco ,rit}
 {setv field,00:00}
 {return}


 {:ed4}
 {setv fieldtype,Event #%evnum% Start Time}
 {call blatim}
 {call mentime}
 {return}

 {:ed5}
 {setv fieldtype,Event #%evnum% Duration}
 {call blatim}
 {call mentime}
 {return}

 {:ed6}
 {setv fieldtype,Event #%evnum% Late Start}
 {call blatim}
 {call mentime}
 {return}

 {:mentime}
 {call disastime}                         dis-assemble HH and MM from string
 {call hhmode}                            set mode to hours
 {call menutime}                          display menu
 {setv evnum,1}
 {return}

 {:disastime}               dis-assemble time
 {subs hh,1,2,%field}
 {subs mm,4,2,%field}
 {return}

 {:asmtime}                 assemble time
 {leng %hh}
 {comp %_len,1}
 {ifco-cle hto0h}
 {leng %mm}
 {comp %_len,1}
 {ifco-cle mto0m}
 {setv field,%HH%:%MM%}
 {return}

 {:hto0h}
 {setv hh,0%hh%}
 {return}

 {:mto0m}
 {setv mm,0%mm%}
 {return}

  {:menutime}
  {wind-k}
  {setv %_menter,timesave}
  {setv %_mlabel,a,b,c,Decrtime,e,f,g,h,Incrtime,j,k,l,Modswitch,n,o,p,q,r,s,t,u,v,w,x,y,z}
  {setv %_mcolor,70,30}
  {setv %_menu1, %field%}
  menu2 - arrows
  menu3 - mode
  {setv %_menu4, }
  menu5 - decrease
  menu6 - increase
  menu7 - switch
  {setv %_menu8, }
  {setv %_menu9, }
  {menu 11,30,%fieldtype%}
  {ifco ,saveparm}
  {setv %field,%oldfield}
  {wind-k0}
  {return}

  {:timesave}    save time vars
  {call saveparm}
  {setv %field,%oldfield}
  {return}

   {:saveparm}                      store modified info
   {setv-s truncpos,sc%fieldnum}
   {decr truncpos}                 -1 to land in space before field
   {subs t1,1,%truncpos,%evtxt}    grab all text up to this space
   {setv-s truncoff,sl%fieldnum}   set trunc offset to this field's length
   {incr truncoff,%truncpos}       add the truncpos
   {incr truncoff,2}               add one for previous decr, and one for spc
   {subs t2,%truncoff,80,%evtxt}   grab all text after this field
   {setv e%evnum,%t1%%field% %t2%} put back in array
   {setv t1}
   {setv t2}
   {setv truncpos}
   {setv truncoff}
   {wind-k0}
   {return}

  {:modswitch}
  {comp timemode,hours}
  {ifco-c mmmode,hhmode}
  {goto menutime}

   {:hhmode}
   {setv timemode,Hours}
   {setv %_menu2, }             default pointer position  (bottom)
   {setv %_menu3, Hours (0-23)}     default pointer position  (hour)
   {setv %_menu5, (D)ecrease Hour}
   {setv %_menu6, (I)ncrease Hour}
   {setv %_menu7, (M)odify Minutes}
   {return}

   {:mmmode}
   {setv timemode,Minutes}
   {setv %_menu2,    }
   {setv %_menu3,    Minutes (0-59)}
   {setv %_menu5, (D)ecrease Minutes}
   {setv %_menu6, (I)ncrease Minutes}
   {setv %_menu7, (M)odify Hours}
   {return}

   {:incrtime}               increment time hh/mm
   {comp timemode,Hours}         mode=hh?
   {ifco-c incrhour,incrmin} if so, increment hh else increment mm
   {comp timemode,Hours}         mode=hh?
   {ifco-c hhmode,mmmode}    if so, set vars for hh, else for mm
   {call asmtime}            assemble time string
   {goto menutime}           menu

    {:incrhour}              increment hour
    {comp hh,23}
    {ifco hhto00}
    {incr hh}
    {return}
     {:hhto00}               wrap hours from 23 to 0
     {setv hh,0}
     {return}

    {:incrmin}               increment minutes
    {comp mm,59}
    {ifco mmto00}
    {incr mm}
    {return}
     {:mmto00}               wrap minutes from 59 to 00
     {setv mm,0}
     {return}

   {:decrtime}               decrement time hh/mm
   {comp timemode,Hours}     mode=hh?
   {ifco-c decrhour,decrmin} if so, decrement hh, else decrement mm
   {comp timemode,Hours}     mode=hh?
   {ifco-c hhmode,mmmode}    if so, set vars for hh, else for mm
   {call asmtime}            assemble timestring
   {goto menutime}           menu

    {:decrhour}              decrement hour
    {comp hh,00}
    {ifco hhto23}
    {decr hh}
    {return}
     {:hhto23}               wrap hours from 0 to 23
     {setv hh,23}
     {return}

   {:decrmin}                decrement minutes
   {leng mm}
   {comp %_len,1}
   {ifco-c mto0m}
   {comp mm,00}              due to a bug in commo  (decr x,by 0 or 00) use 00
   {ifco mmto59}             because 00 not=0 as far as decr is concerned
   {decr mm}
   {return}
    {:mmto59}                wrap minutes from 0 to 60
    {setv mm,59}
    {return}

- ------------------------------------------------------------------------------

 {:ed7}
 {:menutype}
 {wind-k}
 {comp field,   }
 {ifco-c maketype}
 {setv %_menter,savetype}
 {setv %_mlabel,a,b,c,DOS,ERL,f,g,h,INT,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z}
 {setv %_mcolor,70,30}
 {setv %_menu1,Current Event Type: %field%}
 {setv %_menu3, }
 {setv %_menu4,   D  DOS - DOS Command}
 {setv %_menu5,   E  ERL - Errorlevel Exit}
 {setv %_menu6,   I  INT - Internal Command}
 {menu 11,47,Event-Type}
 {setv %field,%oldfield}
 {wind-k0}
 {return}

 {:maketype}
 {setv field,INT}
 {return}


 {:savetype}
 {call saveparm}
 {wind-k0}
 {return}

  {:DOS}
  {setv %field,DOS}
  {goto menutype}

  {:ERL}
  {setv %field,ERL}
  {goto menutype}

  {:INT}
  {setv %field,INT}
  {goto menutype}

- ------------------------------------------------------------------------------

 {:ed8}
 {:menuerr}
 {call 3digits}
 {wind-k}
 {setv %_menter,saveerr}
 {setv %_mlabel,a,b,c,Decrlev,e,f,g,h,Incrlev,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z}
 {setv %_mcolor,70,30}
 {setv %_menu1,Current Errorlevel: %field%}
 {setv %_menu3, }
 {setv %_menu4,   D  Decrease Value}
 {setv %_menu5,   I  Increase Value}
 {menu 10,35,Exit at Errorlevel}
 {setv %field,%oldfield}
 {wind-k0}
 {return}

 {:saveerr}                   save
 {call saveparm}
 {wind-k0}
 {return}

 {:incrlev}                   increment errorlevel
 {comp %field%,255}
 {ifco lowlev}
 {incr field}
 {call 3digits}
 {goto menuerr}

  {:lowlev}                   bring to low errorlevel
  {setv field,000}
  {call 3digits}
  {goto menuerr}

 {:decrlev}                   decrement errorlevel
 {comp field,000}
 {ifco highlev}
 {decr field}
 {call 3digits}
 {goto menuerr}

  {:highlev}                  bring to high  errorlevel
  {setv field,255}
  {goto menuerr}


 {:3digits}                      convert to 3 digits
 {comp field,   }
 {ifco make000}
 {leng %field}
 {setv lf,%_len}
 {comp lf,3}
 {ifco-lec make3d}
 {instr field, }
 {setv lf,%_pos}
 {comp lf,0}
 {ifco-c ,takbl}
 {return}

 {:make000}
 {setv field,000}
 {return}

 {:takbl}                        take out blanks
 {decr lf}
 {subs field,1,%lf,%field}
 {call make3d}
 {return}

  {:make3d}                      make 3 digits out of 1 or 2
  {setv t,00}
  {subs t,%lf,2,%t}
  {setv field,%t%%field%}
  {subs field,1,3,%field}
  {return}

- --------------------------------------------------------------------------

 {:ed9}
 {setv line}
 {setv repeat,outhel,11}
 {call repeat}
 {setv oldfile,%file}
 {setv retsub,back}
 {setv retfile,m4evtman.M4}
 {call begin,m4select.M4}
 {return}


 {call pleswait}
 {setv topbox,1}                set top-of-box array filenum
 {setv curspos,1}               default cursor position
 {setv moff,4}                  menu offset pos
 {setv path,%_hom%*.*}
 {call newfbatch}               get new batch of files
 {setv tmpfil,%field}
 {setv oldfield,%field}
 {wind-k}
 {setv repeat,menufile,999}     repeat menu display 999times
 {call repeat}
 {wind-k0}
 {return}

 {:newfbatch}                   get new file batch
 {call getfiles}                get allnew files @ MASK in PATH
 {call markoffs}                mark offsetts to transfer to DF array
 {call shftfiles}               shift files to DF array
 {return}

 {:menufile}
 {setv %_menter,savefile}
 {setv %_mlabel,AdMask,b,c,Dncurs,e,f,g,h,i,j,k,l,m,n,o,p,q,r,Supcurs,t,u,v,w,x,y,z}
 {setv %_mcolor,70,30}
 {setv %_menu1,   %path%}
 {setv %_menu2, }
 {setv %_menu3, }
 {setv %_menu4,  Ŀ}
 {setv %_menu12,  }
 {setv %_menu13,       S  Move Up}
 {setv %_menu14,       D  Move Down}
 {setv %_menu15,       A  Adjust Path/Mask}
 {setv %_menu16,   Enter  Select File/Dir}
 {setv %_menu17,     Esc  Exit, No Change}
 {menu 21,37,File Selector}
 {setv %field,%oldfield}
 {goto ret}

 {:savefile}           save file for display
 {instr field,\}       was it a path-change command?
 {ifco chandir}        if so change directory
 {call saveparm}       else save settings to display string
 {call zapfiles}       clear old file batch list
 {goto ret}            since we selected a filename, stop menu process
 {return}

  {:chandir}                     instruction to change dir was made
  {instr field,\..}              was it an instruction to move back?
  {ifco-c backdr,forwdir}        if so back a dir, else forward
  {call newfbatch}
  {return}

   input: path, field
  output: path
 purpose: to test existence of filemask in HIGHER directory. If filemask
          exists, reform path info. If it doesn't, warn user and preserve
          old path info.
key:
   path=x:\y\**
   mask=*.M4
   field=\..

   {:backdr}                          back directory
   {call chkmask}                     correct mask          x:\y\** -> x:\y\*.*
   {setv stordpath,%path}             store current path    STORDPATH=x:\y\*.*
   {call getsla}                      find last slash       x:\y\<-*.*
   {decr slapos}                      move slapos to left   x:\y<-\*.*
   {subs path,1,%slapos,%path}        truncate path left    PATH=x:\y
   {call getsla}                      find last slash       x:\<-y
   {subs path,1,%slapos%,%path}       reform PATH           PATH=x:\
   {setv path,%path%%mask%}           add mask              x:\*.*
   {ifex %path,rit,}                  if good, return       ? -> x:\*.*
   {setv path,%stordpath}             else restore          x:\y\*.*
   {call fnotf}                       tell files not found  !
   {return}                           return to menus

{:sst}{}
   input: path, field
  output: path
 purpose: to test existence of filemask in a chosen SUBDIR, and reform path var
          if true. else, warn of no matches, and preserve original path info

 key:
   path=x:\y\**
   mask=*.M4
   field=\subdir
   (spaces=___)

   {:forwdir}                         forward directory
   {call chkmask}                     correct mask          x:\y\** -> x:\y\*.*
   {setv stordpath,%path}             store current path    STORDPATH=x:\y\*.*
   {call getsla}                      find last slash       x:\y\<-*.*
   {decr slapos}                      to left of..          x:\y<-\*.*
   {subs path,1,%slapos,%path}        truncate path right   PATH=x:\y
   {inst %field, }                    field first space aft \subdir_<-_____
   {setv pos,%_pos}                   put in pos            pos=6
   {decr pos}                         to get end char       \subdir<-______
   {subs field,1,%pos,%field}         trunc spaces: field   FIELD=\subdir
   {setv path,%path%%field%\%mask}    append current path   PATH=x:\y\subdir\*.*
   {ifex %path,rit,}                  if path ok, return    ?->x:\y\subdir\*.*
   {setv path,%stordpath}             else restore old path x:\y\*.*
   {call fnotf}                       warn files not found  !
   {return}                           return to menus


- ----------------------------------------------------------------------------
    input: path
   output: slapos
  purpose: to find position of last backslash in current path, and return
           it in the var SLAPOS
 key:
 path=x:\y\*.*



   {:getsla}                          get last backslash
   {setv slapos,0}                    SLAPOS=0
   {setv spath,%path}                 spath=x:\y\*.*
   {setv repeat,findsla,99}           cycle until condition met
   {call repeat}
   {setv pos}                         pos=nul
   {setv spath}                       spath=nul
   {return}

    {:findsla}                        find backslash (last) for path change
    {instr %spath,\}                  x:\<-y\*.*
    {setv pos,%_pos}                  pos=3
    {comp %pos,0}                     x:\y\*.*<-?
    {ifco ret}
    {incr slapos,%pos}                SLAPOS=3+slapos
    {incr pos}                        pos=4
    {subs spath,%pos,100,%spath}      spath=y\*.*
    {return}

- -----------------------------------------------------------------------------
 {:admask}  adjust file mask
 {setv fail}                               clear fail flag
 {sete-p0 ret}
 {input %path,Adjust path\file mask}      get it
 {call chkmask}                            check file mask
 {call newfbatch}
 {return}

  input vars: path
 output vars: path, mask, oldpath
     purpose: checks and corrects current path for syntax errors in mask.
     purpose: extracts filemask from PATH. checks syntax of file mask.
              if no dot in mask, or mask less than 3 chars long, mask is
              changed to "*.*". PATH is appended with reformed mask,
              and stored in OLDPATH.

 {:chkmask}                           check mask
 {call getsla}                        get backslash              x:\y\<-**
 {subs tpath,1,%slapos,%path}         strip mask from path       x:\y\*
 {incr slapos}                        decrement last slash pos   x:\y\*<-*
 {subs tmask,%slapos,100,%path}       get path info              *.*
 {instr %tmask,.}                     since its mask, find dot   ? -> ** -> .
 {setv dotpos,%_pos}                  dotpos=0
 {comp %dotpos,0}                     not there?                 ? -> .
 {ifco-c nodot}                       if not . in mask           ** -> *.*
 {leng %tmask}                        get length                 *.
 {setv lmask,%_len}                   put in lmask               2
 {comp %lmask,3}                      less than 3?               <3?
 {ifco-lc minlen}                     if so make new mask        *.*
 {comp dotpos,%lmask}                 no extension?              fil.<-?
 {ifco-ec nordot}                     make one                   fil.*
 {comp dotpos,1}                      no prefix?                 .ext?
 {ifco-ec noldot}                     make one                   *.ext
 {setv tpath,%tpath%%tmask%}         append tpath with tmask   x:\y\*.*
 {ifex %tpath,,fnotf}                path exist?               ? x:\y\*.*
 {setv mask,%tmask}                  assign tempmask to mask   MASK=*.*
 {setv oldpath,%tpath}               store old path            OLDPATH=x:\y\*.*
 {setv path,%tpath}                  temp path to path         PATH=x:\y\*.*
 {return}

 {:nodot}
 {setv tmask,*.*}
 {call newmskp}
 {return}

 {:noldot}
 {setv tmask,*%tmask%}               .M4 -> *.M4
 {call newmskp}
 {return}

 {:newmskp}                     new mask parms
 {leng %tmask}
 {setv lmask,%_len}
 {instr %tmask,.}
 {setv dotpos,%_pos}
 {return}

 {:nordot}
 {setv tmask,%tmask%*}
 {call newmskp}
 {return}

 {:minlen}
 {setv tmask,*.*}
 {call newmskp}
 {return}

 {:fnotf}                             files not found
 {info-q File(s) not found}
 {setv path,%oldpath}
 {return}

 {:badmask}
 {info-q file mask must be in format: *.M4, ????.M4, file??.*}
 {return}

 {:savetype}
 {call timesv1}
 {wind-k0}
 {return}

 {:dncurs}                         bring cursor down
 {comp curspos,%pointer}
 {ifco-e supcurs}
 {comp curspos,7}                  at position 7?
 {ifco-e dnfil}                    if so, shift window down
 {setv oldcurs,%curspos}
 {incr curspos}                    bring cursor down
 {call xferhold}
 {return}

 {:supcurs}                       bring cursor up
 {comp curspos,1}                 at position 1?
 {ifco-e upfil}                   if so, shift window up
 {setv oldcurs,%curspos}
 {decr curspos}                   bring cursor up
 {call xferhold}
 {return}

 {:xferhold}                      transfer hold array to menu array
 {setv oldcoff,%oldcurs}
 {incr oldcoff,4}                 old relative curs pos in Menu
 {setv newcoff,%curspos}
 {incr newcoff,4}                 new relative curs pos in menu
 {setv popoint,%topbox}
 {incr popoint,%curspos}          pos of pointer in file array for cursor
 {setv _menu5,%hold5}
 {setv _menu6,%hold6}
 {setv _menu7,%hold7}
 {setv _menu8,%hold8}
 {setv _menu9,%hold9}
 {setv _menu10,%hold10}
 {setv _menu11,%hold11}
 {decr popoint}
 {setv-s tmpfil,f%popoint}
 {setv %_menu%newcoff,  %tmpfil%%tmpfil%}
 {setv field,%tmpfil}
 {return}

  {:assmvars}                              assign menu vars
  {setv count,%timecount}                  assign basic count
  {incr count,%moff}                       add menu offset for beginning of _menu assignment
  {setv-s tmpfil,f%pospoint}               put filename temporarily in TEMPFIL
  {comp timecount,%curspos}                are we at cursor pos?
  {incr pospoint}                          bump position pointer up
  {ifco-le cursvar}                        if so, special string
  {comp tmpfil}
  {ifco nofil}
  {setv %_menu%count,  %tmpfil%}         else, normal string
  {setv %hold%count,  %tmpfil%}          else, normal string
  {return}

  {:nofil}              no files, so blank-out
  {setv %_menu%count,              }         else, normal string
  {setv %hold%count,              }          else, normal string
  {return}


   {:cursvar}                                 assign special string to menu @ cursor pos
   {setv %_menu%count,  %tmpfil%%tmpfil%}  special string
   {setv %hold%count,  %tmpfil%}            else, normal string
   {setv field,%tmpfil}                       put filename in field, as the one that was selected
   {return}

 {:dnfil}                                  down-key was pressed
 {setv _menu11,  %field%%field%}      special string
 {comp botbox,%pointer}                    does bottom-of-box=last file in array?
 {ifco-ge nochgdn}                          if greater or equal return
 {setv newbatch}                           get new batch of files
 {incr topbox}                             bump-up top-of-box position pointer for shift
 {call dnfil1}
 {return}

  {:dnfil1}
  {setv hold5,%hold6}         shift hold var up
  {setv hold6,%hold7}
  {setv hold7,%hold8}
  {setv hold8,%hold9}
  {setv hold9,%hold10}
  {setv hold10,%hold11}
  {setv _menu5,%hold5}        return vals to menu vars
  {setv _menu6,%hold6}
  {setv _menu7,%hold7}
  {setv _menu8,%hold8}
  {setv _menu9,%hold9}
  {setv _menu10,%hold10}
  {call markoffs}                       re-align bottom of box marker
  {setv-s tmpfil,f%botbox}              grab filename to go in bottom of box
  {setv _menu11,  %tmpfil%%tmpfil%}  special string to menu array
  {setv hold11,  %tmpfil%}            normal string to hold array
  {setv field,%tmpfil}
  {return}

  {:nochgdn}                            no change in window down key
  {setv _menu5,%hold5}                  menu 5 (first pos) static
  {call nochg}                          add files below ,static
  {return}

  {:nochg}                              restore files to menu array, no change
  {setv _menu6,%hold6}
  {setv _menu7,%hold7}
  {setv _menu8,%hold8}
  {setv _menu9,%hold9}
  {setv _menu10,%hold10}
  {return}

  {:nochgup}                            no change in window, up-key
  {setv _menu11,%hold11}                menu11 remains static
  {call nochg}
  {return}

 {:upfil}                               up-key was pressed
 {setv _menu5,  %field%%field%}    special string
 {comp topbox,1}                        does top-of-box=first file in array?
 {ifco-le nochgup}                      if less or equal return
 {setv newbatch}                        get new batch of files
 {decr topbox}                          else bump down top-of-box array pointer
 {call upfil1}                          reform hold array, transfer to menu array
 {return}                               redisplay

 {:upfil1}
 {setv hold11,%hold10}             shift hold vars down
 {setv hold10,%hold9}
 {setv hold9,%hold8}
 {setv hold8,%hold7}
 {setv hold7,%hold6}
 {setv hold6,%hold5}
 {setv _menu6,%hold6}                  store in menu array
 {setv _menu7,%hold7}
 {setv _menu8,%hold8}
 {setv _menu9,%hold9}
 {setv _menu10,%hold10}
 {setv _menu11,%hold11}
 {call markoffs}                       realign bottom of box pointer
 {setv-s tmpfil,f%topbox}              get filename for top of box
 {setv _menu5,  %tmpfil%%tmpfil%}   special string
 {setv hold5,  %tmpfil%}             normal string
 {setv field,%tmpfil}
 {return}

 {:markoffs}
 {setv botbox,%topbox}    find bottom of display box
 {incr botbox,6}          it's 7 lines after top
 {return}

 {:shftfiles}             shift files in viewing window
 {setv pospoint,%topbox}  set first file position point at topbox
 {setv repeat,assmvars,7} shift filenames to display for each of 7 files
 {call repeat}            so we get seamless shift of files
 {return}

 {:getfiles}                    get file names
 {call pleswait}
 {setv topbox,1}
 {call zapfiles}
 {file %path}                   get first file
 {setv file,%_ffn}              put filename in FILE
 {setv %file,%file%%blank%}     pad filename with blanks
 {subs %file,1,12,%file}        truncate so it's 12 chars long
 {setv lastfile,%file}          hold current padded file name
 {setv f1,%file}                put in F1
 {setv repeat,loadfile,75}      get all files in dir
 {call repeat}
 {setv-s f%pointer}             clear out last filename match
 {decr pointer}                 reflect this in pointer
 {comp pointer,75}              75 files?
 {ifco-gec 2manyf}              too many
 {comp %pointer,7}               7 files or less?
 {setv curspos,1}               reset cursor pos
 {return}

 {:2manyf}                      too many files
 {info-q Too many files in this dir: use 'A' to mark Path/File}
 {return}

  {:loadfile}                   store all filenames
  {file-x %path}                get next filename
  {setv file,%_ffn}             put filename into FILE
  {comp %file,%lastfile}        is it the same as last file we got?
  {ifco ret}                    if so escape from this routine
  {setv lastfile,%file}         hold current file name
  {setv %file,%file%%blank%}    pad filename with blanks
  {subs %file,1,12,%file}       truncate to 12 chars
  {setv pointer,%timecount}           store pointer in T
  {incr pointer}                      add one (for first file)
  {setv f%pointer,%file}              filename to F(T) array
  {return}

  {:zapfiles}
  setv tmpfil}
  setv fil2get}
  setv count}
  setv pospoint}
  setv botbox}
  setv pointer}
  {setv repeat,zap1,%pointer%}
  {call repeat}
  {return}

   {:zap1}
   {setv f%timecount}
   {setv df%timecount}
   {return}

- ----------------------------------------------------------------------------
{:ed10}                                      get macro labelname
{setv tmpfield,%field}
{inst tmpfield, }
{setv pos,%_pos}
{decr pos}
{subs tmpfield,1,%pos,%tmpfield}
{inpu %tmpfield,Enter Macro Label Name}
{info-q Verify?}
{ifco-c scanfil}
{setv tmpfield,%tmpfield%%blank%}
{subs tmpfield,1,8,%tmpfield}
{setv field,%tmpfield}
{call saveparm}
{return}

{:scanfil}                           verify labelname
{subs fil,%sc9,%sl9,%evtxt}
{comp fil,            }
{ifco fnotf}
{comp fil,}
{ifco fnotf}
{ifex %fil,,fnotf}
{ropen %fil,ret}
{setv fail,y}
{setv repeat,readfil,10000}
{call repeat}
{comp fail}
{ifco ,lnotf}
{info-q Subroutine found in %fil%}
{setv field,%tmpfield%%blank%}
{subs field,1,8,%field}
{return}

{:readfil}                   read  lines in file
{read line}
{inst line,^(:%tmpfield^)}
{comp %_pos,0}
{ifco rit}
{setv fail}
{goto ret}

{:lnotf}            labelname not found
{setv fail}
{info-q Label %tmpfield% not found in %fil%}
{return}

- ----------------------------------------------------------------------------

 {:ed11}
 {comp field,*}
 {ifco-c activ,deact}
 {return}

 {:activ}
 {info-q Activate this event?}
 {ifco ,rit}
 {setv field,}
 {call saveparm}
 {return}

 {:deact}
 {info-q Deactivate this event?}
 {ifco ,rit}
 {setv field,*}
 {call saveparm}
 {return}

 ----------------------------------------------------------------------------
 {:esc}
 {call pleswait}
 {setv repeat,outary,11}
 {call repeat}
 {setv repeat,outhel,11}
 {call repeat}
 {call asminmem}     assemble in memory
 {call cmpilmem}     compile memory
 {call evt2idx,m4event.M4}
 {call outvars}      clear variables
 {goto menu_beg,m4popcom.M4}
 {stop}

 {:asminmem}   assemble menu contents in memory
 {setv repeat,unstring,%c%}
 {call repeat}
 {return}


  {:unstring}   undo each string of menu into variables
  {setv-s evtxt,e%timecount}
  {subs even%timecount,%sc1,%sl1,%evtxt}
  subs logt%timecount,%sc2,%sl2,%evtxt}
  {subs days%timecount,%sc3,%sl3,%evtxt}
  {subs star%timecount,%sc4,%sl4,%evtxt}
  {subs dura%timecount,%sc5,%sl5,%evtxt}
  {subs late%timecount,%sc6,%sl6,%evtxt}
  {subs type%timecount,%sc7,%sl7,%evtxt}
  {subs erro%timecount,%sc8,%sl8,%evtxt}
  {subs file%timecount,%sc9,%sl9,%evtxt}
  {subs labe%timecount,%sc10,%sl10,%evtxt}
  {subs acti%timecount,%sc11,%sl11,%evtxt}
  {call actcov}
  {setv sque%timecount,* Reserved For Later Expansion}
  {setv buff%timecount,* Reserved For Later Expansion}
  {return}

  {:actcov}     active var * convert to yes/no
  {comp acti%timecount,*}
  {ifco-c strtono,chktoyes}
  {return}

   {:strtono} star-to-NO for Active var
   {setv acti%timecount,No}
   {return}

   {:chktoyes} active var (chk) to Yes
   {setv acti%timecount,Yes}
   {return}

 {:cmpilmem}
 {wopen m4event.dat}
 {setv repeat,writdat,%c%}
 {call repeat}
 {wclos}
 {return}

  {:writdat}
  {setv-s out,even%timecount}
  {writ Event=%out%}
  {setv-s out,acti%timecount}
  {writ Active=%out%}
  {setv-s out,logt%timecount}
  {writ Logtxt=%out%}
  {setv-s out,days%timecount}
  {writ Days=%out%}
  {setv-s out,star%timecount}
  {writ Start=%out%}
  {setv-s out,dura%timecount}
  {writ Duration=%out%}
  {setv-s out,late%timecount}
  {writ Late=%out%}
  {setv-s out,buff%timecount}
  {writ Buffer=%out%}
  {setv-s out,sque%timecount}
  {writ Squeeze=%out%}
  {setv-s out,erro%timecount}
  {writ Error=%out%}
  {setv-s out,type%timecount}
  {writ Type=%out%}
  {setv-s out,file%timecount}
  {writ File=%out%}
  {setv-s out,labe%timecount}
  {writ Label=%out%}
  {comp timecount,%c%}
  {ifco wrend}
  {writ }
  {return}

   {:wrend}
   {writ                             End M4-####-Setup File}
   {return}


 {:outvars}    clear all variables
 {setv repeat,outary,10}
 {call repeat}
 {setv repeat,outext,10}
 {call repeat}
 {setv repeat,outfs,11}
 {call repeat}
 {setv evnum}
 {setv col}
 {setv xoff}
 {setv evtxt}
 {setv helpa}
 {setv helpb}
 {setv fieldnum}
 {setv fieldlen}
 {setv fieldpos}
 {setv field}
 {setv oldoff}
 {setv oldfpos}
 {setv oldfield}
 {setv out}
 {setv grablock}
 {setv minblock}
 {setv even}
 {setv curspos}
 {setv topbox}
 {setv cpos}
 {setv epos}
 {setv varval}
 {setv varnam}
 {setv line}
 {setv early}
 {setv background}
 {setv eventline}
 {setv moff}
 {setv ftype}
 {setv mask}
 {setv path}
 {setv lastfile}
 {setv pointer}
 {setv botbox}
 {setv pospoint}
 {setv count}
 {setv tmpfil}
 {setv etomove}
 {setv efield}
 {setv day}
 {setv m}
 {setv zfield}
 {setv let}
 {setv olday}
 {setv paday}
 {setv fieldtyp}
 {setv hh}
 {setv mm}
 {setv timemode}
 {setv slapos}
 {setv tpath}
 {setv tmask}
 {setv dotpos}
 {setv lmask}
 {setv oldpath}
 {setv oldcurs}
 {setv oldcoff}
 {setv newcoff}
 {setv popoint}
 {setv stordpat}
 {setv tmpfield}
 {setv fil}
 {return}

 {:outary}
 {setv even%timecount}
 {setv acti%timecount}
 {setv days%timecount}
 {setv star%timecount}
 {setv dura%timecount}
 {setv late%timecount}
 {setv erro%timecount}
 {setv type%timecount}
 {setv file%timecount}
 {setv labe%timecount}
 {setv buff%timecount}
 {setv sque%timecount}
 {setv minblk%timecount}
 {setv grablk%timecount}
 {return}

 {:outext}
 {setv e%timecount}
 {setv logt%timecount}
 {return}


 {:outfs}   clear field-type arrays (1-11)
 {call outhel}
 {setv sl%timecount}
 {setv sc%timecount}
 {setv hold%timecount}
 {return}

 {unload}

 {:outhel}
 {setv helpA%timecount}
 {setv helpB%timecount}
 {return}


{:xcompile}
{wopen m4event.idx}
{writ M4 Event Index File Compiled: %_dat% %_tim%}
{writ }
{writ ^(:top^)}
{setv repeat,revent,%c}
{call repeat}
{writ ^(setv even,%c%^)}
{writ ^(return^)}
{return}


 {:revent}
 {writ ^(setv even%%timecount,}
 {setv acti%timecount}
 {setv days%timecount}
 {setv star%timecount}
 {setv dura%timecount}
 {setv late%timecount}
 {setv erro%timecount}
 {setv type%timecount}
 {setv file%timecount}
 {setv labe%timecount}
 {setv buff%timecount}
 {setv sque%timecount}
 {setv minblk%timecount}
 {setv grablk%timecount}
 {return}

-----BEGIN PGP SIGNATURE-----
Version: 2.6.2

iQEVAwUBLxGf/h1uLkXXbMBBAQEizAf/XdsdnR/KhEFCROORk+LT9cP6kKtjsPAZ
Jf5u1E/wlLvy4lriqRf1X/7MiTX+9zEpS94SqYbvNSuM7qgj8fqKMwuq58IGpJ8O
1GRBchFqGZbE75MavSrzmAIlTVPti4dYNniAkFRRu7eiuOyG6uBUSAQ/AVHmnf+B
r/DQzNYfIZVwuteICOB168Ke5sIm0NHr6KrBiHpa4oOcqW8MTWSeWzd5X9uiGxJl
QhOXDCDQyeHgxERmrOaaeDJSWEX5lwUMHEympeh4aBOfXl4eOyqyp9TvjTVEAUsr
6lyolQwqKrOSYi8y87nyskXPYGZMQoZ83YV0dW1wHqtJpKBTTbnvHA==
=SAkz
-----END PGP SIGNATURE-----
