-----BEGIN PGP SIGNED MESSAGE-----



- ------------------------------------------------------------------------------

                                  Event.M4
- ------------------------------------------------------------------------------

                               Event Compiler

{:evt2idx}
{ropen m4event.dat,ret}              open event data file for read
{wopen m4event.idx}
{writ Event Index File: Compiled %_dat% at %_tim%}
{writ}
{writ ^(:top^)}
{setv repeat,getevt,1500}          get up to 100 events, 15 lines each
{call repeat}
{writ ^(setv even,%even%^)}
{writ ^(return^)}
{wclos}
{call clev}
{return}

 {:getevt}                         get event info from data file line-by-line
 {read %eline}                     read line
 {inst %eline,=}                   find `='
 {comp %_pos,0}                    not there?
 {ifco blocks}                     if so, it's a remark
  {setv pos,%_pos}                 else, put charpos in POS
  {decr pos}                       decrement to get last right-of-varname char
  {subs var,1,%pos,%eline}         extract variable name
  {subs val,%pos,30,%eline}        now get value for variable
  {subs val,3,30,%val}             right trunc first two chars
  {inst %val,*}                    is `*' in Var?
  {comp %_pos,1}                   if postion 1
  {ifco valisrem}                  value is remark
  {subs var,1,4,%var}              shorten var to 1st 4 chars
  {setv %%var%%,%val}              contents of val->var as variable
  {setv vnam,%var%%even%}          Var%EventNumber->VNAM
  {setv %%vnam%%,%val}             Val->Vnam(which is Var%EventNumber)
  {writ ^(setv %vnam%,%val%^)}
  {return}

    {:valisrem}                    value is nul or * so treat as REMark
    {setv val}                     clear val
    {return}


- ------------------------------------------------------------------------------

 Convert time of day to minutes

 Input vars: TIMEIN (00:00 - 23:59) must be in 24-hour format, with 2-digits

 Output var: GRABLOCK = 15-minute time block (1-96) for graphics display
             TIMEMINS = actual time in minutes

 Grablock (15m)
 1:00:00 - 1:14:59  block 1
 1:15:00 - 1:29:59  block 2
 1:30:00 - 1:44:59  block 3
 1:45:00 - 1:59:59  block 4


Event Data File: 07/13/94


{:blocks}
{call timeblock}
{:blocks1}
{setv time%even,%timemins}              current time
{setv minblk%even,%minblock}            minute block
{setv grablk%even,%grablock}            graphic block
{comp even,0}
{ifco ,stoevent}
{return}

{:timeblock}           name variable with 24h time, get minutes back
{setv timevar,star%even}
{call 24h2min}
{setv timevar,dura%even}
{call 24h2min}
{setv timevar,late%even}
{call 24h2min}
{setv timevar,buff%even}
{call 24h2min}
{call otherblocks}
{return}

 {:24h2min}
 {comp %%timevar%%}
 {ifco rit}
 {setv-s intime,%timevar}
 {subs hrx,1,2,%intime}
 {subs mnx,4,2,%intime}
 {mult hrx,60}
 {setv intime,%hrx}
 {incr intime,%mnx}
 {setv %%timevar%%,%intime}
 {comp even,0}
 {ifco-c ,wrist}
 {setv intime}
 {setv hrx}
 {setv mnx}
 {setv timevar}
 {return}

{:wrist}
{writ ^(setv %timevar%,%intime%^)}
{return}

{:stoevent}
{writ ^(setv time%even%,%timemeins%^)}
{writ ^(setv minblk%even%,%minblock%^)}
{writ ^(setv grablk%even%,%grablock%^)}
{return}

 {:otherblocks}
 {setv-s grablock,star%even}
 {divi grablock,15}
 {incr grablock}
 {setv minblock,star%even}
 {incr minblock}
 {return}

- ------------------------------------------------------------------------------
                      Current Timeblock Information
- ------------------------------------------------------------------------------
cycbuf=estimated time it takes for bbs to recycle when online user's time runs
       out inside bbs. if any of these mins aren't used by system, phone isn't
       answered for those mins, whereupon event is executed.
tim=time in mins to pass to dobbs.bat via explode.M4, minus cyclebuffer (cycbuf)
pendtime=time in minutes until next pending event
penderr=dos errorlevel for next pending event
pendlog=description of next pending event, for log
penday=for graphic event display. Prints `today' if event is in current
       24 hour time block. Otherwise, prints `tomorrow'
pendblk24=for graphic event display. Identifies which 15-minute timeblock in
          in which event falls.
pendarry=event number of pending event. Also array number for this events info

- -------------------------------------------------------------------------
{:nf6}
{:eventinfo}                           get timeblock info
{call thistime}                        get this time
{call thisday}                         get julian day
{comp opmode,0}
{ifco-e ,mailer}
{setv eventrak,%from0ad%.TRK}          set event trak filename to Julian Day
{call evt0}                            establish default event
{call top,m4event.idx}                 load event data
{ifex-c %eventrak%,,maketrak}          check for existence of tracking file
{call readtrak}                        if none, make new one
{call today?}                          check & sort today's events
{call chekpend}                        check events and act if it's time
{call clev}
{return}

{:mailer}                operating mode is mailer or door
{setv even0,0}
{setv acti0,yes}
{setv logt0,Mailer Defined}
{setv days0,MTWRFSS}
{setv dura0,0}
{setv late0,0}
{setv buff0,0}
{setv sque0}
{setv erro0}
{setv type0}
{setv file0}
{setv labe0}
{setv even,0}
{setv txp,0}
{setv star0,%tim}        mins til next event
{setv etm,1440}          midnight today
{decr etm,%curtime}      mins til midnight from now
{comp star0,%etm}        are mins-til-event bigger than mins til midnight?
{ifco-gc nxtday,thday}   if so,next day else this day
{call otherblocks}       get graphical block information
{call blocks1}           and assign to array
{setv star0,%tim}        reset star0 to real time
{setv timeleft,%star0}   put in timeleft
{call setpend}           set pending event info
{setv pndblk24,%grablk0} but reform pndblk24 for display to caller
{return}

{:nxtday}              star0 happens not-today
{setv when,Tomorrow}
{decr star0,%etm}      take mins til midnight from m-til-event to get m-to-event from modnight
{comp star0,1440}      does event happen before midnight tomorrow?
{ifco-g >24h}          if not, locate what time it starts on that day, else, locate what time it starts tomorrow
{return}

 {:>24h}   locate what time event starts on day far in future
 {setv when,Later this week}
 {divi star0,1440}        find days til execution
 {setv star0,%_rem}       but take remainder to get minute of that day
 {return}

{:thday}              since event happens today, find real time of its execution
{setv when,today}
{incr star0,%curtime} add current time to mins til event to get minut event executes
{return}

- ---------------------------

 {:readtrak}                   read event tracking file
 {setv nextday,%from0ad}       determine name of trk file for tomorrow
 {incr nextday}
 {ifex-c %nextday%.trk,warndate,} if it exists, warn sysop
 {rclos}                       close old files
 {ropen %eventrak%}            open tracking file
 {read %donevts%}              read data line
 {rclos}                       close
 {return}

 {:warndate}       warn sysop that date may be off
 {setv logtxt,Error: System date not right}
 {call getime}
 {return}

 {:maketrak}                                    new event tracking file
 {setv phase,DEF}
 {call nvram}                                   write settings to NVRAM
 {setv logtxt,Creating Event-Tracking File}
 {call getime}                                  log
 {setv oldtrak,%from0ad%}
 {decr oldtrak}
 {setv oldtrak,%oldtrak%.TRK}
 {exec del %oldtrak}
 {wopen %eventrak%}                             open trak file
 {setv donevts,0 }
 {setv repeat,asmtrak,%even%}                   for each evt, assemble 2bytes
 {call repeat}
 {writ %donevts%}                               write assmebled string
 {wclos}                                        close
 {return}

  {:asmtrak}                        assemble Event tracking data string
  {setv donevts,%donevts%%timecount% }     append 2-byte seg to string
  {return}

  {:nvram}  write to modem's nvram
  {comp nvram}
  {ifco rit}
  {setv logtxt,Writing to NVRAM}
  {setv initstring,%nvram%}
  {call getime}
  {call init}
  {return}


- --------------------------------------------------------------------------
           Check today's events for next-event-to-execute
- --------------------------------------------------------------------------

{:today?}                              Check & sort today's events
{setv repeat,pending,%even}            calculate time-til-events
{call repeat}                          repeat this for all events
{return}

{:thistime}                    get var: CURTIME
{setv curtime,%_24h%:%_min%}
{subs hrx,1,2,%curtime}
{subs mnx,4,2,%curtime}
{mult hrx,60}
{setv curtime,%hrx}
{incr curtime,%mnx}
{setv gfxnow,%curtime}
{divi gfxnow,15}
{incr gfxnow}
{return}

 {:evt0}                      event zero is last event to be executed
 {setv when,Today}
 {setv Even0,0}
 {setv Acti0,Yes}
 {setv Logt0,Default Event}
 {setv Days0,MTWRFSS}
 {setv Star0,23:59}
 setv Star0,00:00}
 {setv Dura0,00:01}
 {setv Late0,23:59}
 {setv Buff0,}
 {setv Sque0,}
 {setv Erro0,}
 setv Type0,INT}
 {setv Type0,DEF}
 {setv File0,M4EVENT.M4}
 {setv Labe0,MIDNIGHT}
 {setv Even,0}
 {call blocks}
 {setv txp,0}
 {setv timeleft,%star0}
 {decr timeleft,%curtime}
 {call setpend}
 {return}

 {:midnight}            synchronize to 10s after midnight
 {setv cursec,60}
 {decr cursec,%_sec}
 {incr cursec,10}
 {pause %cursec}
 {return}

 {:pending}                     sort events for pending or late
 {setv txp,%timecount}
 {call activ?}                  first, see if event's active....etc.
 {return}

 {:activ?}                      Is event active?
 {setv-s active,acti%txp}       eliminate inactive events
 {comp active,yes}              if inactive
 {ifco-c exe2day?}              check if exed today
 {return}

  {:exe2day?}                    Is event to be executed today?
  {setv day%txp,Today}           assume day-of-execution as today
  {setv-s do2day,days%txp}       put days array into do2day
  {subs dwn,%_dwn%,1,%do2day}    see if event is to be executed today
  {comp dwn,-}                   check for "-"
  {ifco-c ,exeyet?}              if not today, return
  {return}

   {:exeyet?}                     Was event executed already?
   {setv-s evttime,star%txp}      get 24h evt time
   {setv lattime,%evttime}        set late zone for this evt to evttime
   {setv-s lateadd,late%txp}      store late zone time in temp var
   {incr lattime,%lateadd}        add to event start time to get late start time
   {setv testev,%txp%}           have we run event already?
   {inst donevts,%testev%}        check event string
   {comp %_pos,0}                 not there?
   {ifco-c pastart?}              if run already, add 24h to start, else intact
   {return}

    {:pastart?}                    Start-time passed?
    {comp evttime,%curtime}          compare event time with current time
    {ifco-lc pastlate?,earliest?}  if event's time passed, check late start time
    {return}

     {:earliest?}               Earlier than event on pending stack?
     {setv timeleft,%evttime}   put time of evt in mins -> timeleft
     {decr timeleft,%curtime}     subtract cur time in mins to get minutes til
     {comp timeleft,%pendtime}  compare pending exe time to smallest one found
     {ifco-g rit}               if greater, check if late
     {call setpend}             since smallest, store on pending register
     {return}

     {:pastlate?}               Has late-time passed?
     {comp lattime,%curtime}      late start time passed?
     {ifco-l rit}               if passed, return
     {setv timeleft,0}          otherwise, execute in zero mins
     {call setpend}             set pending evt info to late event
     {return}

- ----------------------------------------------------------------------------

 {:writevt}  get unexe'd event number, and write it as done to event file
 {inst donevts,%pendarry% }     find unexecuted instance
 {setv pos,%_pos}               put in pos
 {comp pos,0}                   if not there
 {ifco rit}                     return (Xevent)
 {leng %pendarry%}              get length of number
 {setv len,%_len}               put in len
 {incr len}                     add one for bit-flag
 {setv rofevt,%pos}             set right-of-event to pos in string
 {incr rofevt,%len}             add length to get real right-of-event pos
 {setv lofevt,%pos}                             get left-of-event pos
 {decr lofevt}                                  make it one left of pos
 {subs prefevt,1,%lofevt,%donevts}              get prefix of event string
 {subs suffevt,%rofevt,240,%donevts}            get suffix of event string
 {setv marktevent,%pendarry%}                  establish unexe'd evt as exe'd
 {setv donevts,%prefevt%%marktevent%%suffevt%}   reform event string
 {wopen %eventrak%}                              open trak file
 {writ %donevts}                                 write data string
 {wclos}                                         close
 {return}

  Events: 12 3 4 56 7

  {:setpend}                     set pending event variables
  {setv pendarry,%txp}           mark the arraynum that is closest
  {setv pendtime,%timeleft}      minutes till execution
  {setv-s pndblk24,grablk%txp}   and block pos in 24hr map
  {setv-s penday,day%txp}        and day-of-execution info
  {setv-s penderr,erro%txp}      get errorlevel of pending event
  {setv-s pendlog,logt%txp}      get logtxt for pending event
  {setv-s penddays,days%txp}     get days-of-execution
  {setv-s penddura,dura%txp}     get duration of event
  {setv-s pendlate,late%txp}     get late execution overtime
  {setv-s pendsque,sque%txp}     get squeeze-event status
  {setv-s pendtype,type%txp}     get type of event
  {setv-s pendfile,file%txp}     get file-to-load
  {setv-s pendlabe,labe%txp}     get label-to-goto
  {return}

  {:chekpend}                   check pending event info, and prepare system
  {comp pendtime,%cycbuf}       is pending mins > 5m buffer?
  {ifco-g ,startbuf}            if so, we can subtract w/o error; else we're already in pre-event cycle buffer, so run buffer
  {setv pendtemp,%pendtime}     so, put min-til-evt in TEMPTIME
  {decr pendtemp,%cycbuf}       subtract 5m cycle time
  {setv tim,%pendtemp}          set time-til-pending cycle buffer
  {call changwfc}               change wfc so it exits before cycbuf
  {return}

    {:startbuf}
    {setv phase,EVT}
    {setv tim,%pendtime}       store time-til-cycle buffer for this event
    {decr tim,%cycbuf}         so user gets rejected at begin of cycle buffer
    {setv pendtemp,%pendtime}  pass time left to temp var
    {elapse}                   reset elapsed timer
    {setv logtxt,Starting pre-event time buffer (#%pendarry%,%pendtime%m)}
    {call getime}              log
    {call hangup}              hangup phone
    {call offhook}             and take offhook
    {setv ela,%_ela}           set ELA var
    {instr ela,:}              find colon
    {setv pos,%_pos}           find POSition
    {decr pos}                 bring back 1 pos to left
    {subs ela,1,%pos,%ela}     get minutes only
    {setv resetime,%_ela}      note time passed for above functions
    {comp pendtemp,%resetime}  compare time left with time passed for functs
    {ifco-gc minusreset}       if greater, subtract time used by functs
    {call evtype}              perform event
    {return}

     {:minusreset}             subtract cycle buffer modem function execution time from temporary pending event time
     {decr pendtemp,%resetime} modify pre-event buffer time
     {mult pendtemp,60}        convert it to seconds
     {pause %pendtemp}         wait those seconds before running event
     {return}

     {:evtype}
     {call writevt}
     {setv logtxt,%Donevts%}
     {call getime}
     {inst %pendtype,DEF}
     {comp %_pos,0}
     {ifco ,exidef}
     {inst %pendtype,ERL}
     {comp %_pos,0}
     {ifco ,exiterr}
     {inst %pendtype,DOS}
     {comp %_pos,0}
     {ifco ,exitdos}
     {inst %pendtype,INT}
     {comp %_pos,0}
     {ifco ,exintern}
     {return}

     {:exiterr}                     exit with errorlevel
     {setv logtxt,%pendlog% [ERL:%penderr%]}
     {call getime}                  log
     {call logbot}
     {exit %penderr}

     {:exitdos}
     {setv logtxt,%pendlog% [DOS:%pendfile%]}
     {call getime}
     {exec-s %pendfile%}
     {call begin,commo.mac}
     {return}

     {:exintern}
     {setv logtxt,%pendlog% [INT:%pendfile%,%pendlabe%]}
     {call getime}
     {setv disptform,n}
     {call %pendlabe%,%pendfile%}
     {call begin,commo.mac}
     {return}

     {:exidef} default event
     {setv logtxt,Default Event}
     {setv phase,DEF}
     {call getime}
     {call midnight}
     {call maketrak}
     {return}

  {:changwfc}                    make wfc init sooner if near event
  {call clev}                    clear event info
  {setv wfcwait,999}             set max wfc wait time
  {mult pendtemp,60}             convert minutes til event (-cycle buffer) to seconds
  {divi pendtemp,%wfcwait}       see how many times max wfc wait goes in
  {comp pendtemp,0}              if result is zero,
  {ifco ,rit}                    use remainder for wfc wait time
  {setv wfcwait,%_rem}           else return, keeping 999s default
  {return}

- -----------------------------------------------------------------------------
                     Find Julian days as best we can
- -----------------------------------------------------------------------------

 {:thisday}                finds this day from 0AD
 {setv month,%_mon}
 {setv day,%_day}
 {setv year,%_yea}
 {call dconvert}
 {setv linmin,%from0ad}
 {mult linmin,1440}
 {incr linmin,%curtime}
 {return}

 {:dconvert}                       convert mm/dd/yy format to DDDD days
 {setv centesimal,19}
 {setv calltoday,y}                CALLTODAY=Y
 {setv inmonth,%month}
 {setv inday,%day}
 {setv inyear,%year}
 {call 0ad}                        convert today's date to days
 {return}

{:0ad}       Find num days since Jan 1, 0ad

 Input: inmonth,inday,inyear,incentury
 Output: FROM0AD (day number since 0 AD)

{setv early}
{call cent}
{call months}
{call total}
{return}

{:cent}                       days from 0ad-last complete year
{setv century,%centesimal}    # centesimals (19)
{setv lastyear,%century}      get last century
{mult lastyear,100}           get real years passed rounded to century
{incr lastyear,%inyear}       add years this century
{decr lastyear,1}             subtract one, to get last complete year
{setv leap0ad,%lastyear}      normal leaps since 0ad
{divi leap0ad,4}              by /4 method
{incr leap0ad}                add one for 0ad
{setv centesly,%lastyear}     CENTESLY=centesimal leap years (to be eliminated)
{divi centesly,400}           /400
{incr centesly}               add one for 0ad
{decr leap0ad,%centesly}      subtract false leap years from total for real
{setv todate,%lastyear}       get total days since 0ad, no account for leaps
{mult todate,365}             get days
{incr todate,%leap0ad}        add real leap years
{return}

{:months}                       months this year to days
{call monthset}                 set month values
{call prevmont}                 get days in last completed month
{return}

{:total}                        total all
{setv from0ad,%inday}           add days-this-month
{incr from0ad,%dazinyear}       add this years cume days
{incr from0ad,%todate}          add days from 0ad-end of last year
{return}

 determine cumulative days for each month in THIS year (m1-m12)

 {:monthset}                      MM is running total
 {setv mm,31}                     jan=31   Jan has 31 days
 {setv m1,%mm}                    jan=m1   put running total in m1 (jan)
 {call febset}                    find length of feb this year
 {incr mm,%feb}                   feb=28 or 29
 {setv m2,%mm}                    feb=m2
 {incr mm,31}                     mar=31
 {setv m3,%mm}                    mar=m3
 {incr mm,30}                     apr=30
 {setv m4,%mm}                    apr=m4
 {incr mm,31}                     may=31
 {setv m5,%mm}                    may=m5
 {incr mm,30}                     jun=30
 {setv m6,%mm}                    jun=m6
 {incr mm,31}                     jul=31
 {setv m7,%mm}                    jul=m7
 {incr mm,31}                     aug=31
 {setv m8,%mm}                    aug=m8
 {incr mm,30}                     sep=30
 {setv m9,%mm}                    sep=m9
 {incr mm,31}                     oct=31
 {setv m10,%mm}                   oct=m10
 {incr mm,30}                     nov=30
 {setv m11,%mm}                   nov=m11
 {incr mm,31}                     dec=31
 {setv m12,%mm}                   dec=m12
 {return}

                 determine leap-state of february

  {:febset}                     set febrary (28 or 29) for this year
  {setv lyears,%inyear}         store year to leapyear
  {divi lyears,4}               determine leap-ness by dividing by 4
  {comp %_rem,0}                if divisible, leapyear
  {ifco-ce leapy,commony}       set feb to reflect leap-ness
  {setv centl,%centesimal}      get current century   (20th)
  {divi centl,400}              divide it by 400
  {comp %_rem,0}                if centesimal year, override current leap state
  {ifco-ce ,rit}                if not, return
  {setv feb,28}                 else, set to 28
  {return}

        determine leap-state of centisimal year if we're in one

   Pope Gregory VIII said unless
   centuries ending in 00 are
   divisible by 400, then they
   aren't leap years. So, whatever
   this result is, overrides any leap
   year state in a centesimal year

    {:leapy}     it's a leap year
    {setv feb,29}
    {return}

    {:commony}   it's a common year
    {setv feb,28}
    {return}

 {:prevmont}                   find previous month for cume days
 {comp inmonth,1}              is it month #1?
 {ifco-e itsjan}               if so, it's january so prev month is #12
  {setv prevmon,%inmonth}       get this month
  {decr prevmon}                decrement
  {setv-s dazinyear,m%prevmon}  find cume days-in-year through last month
  {return}

  {:itsjan}                    it's january
  {setv prevmon,12}            so set previous month to december
  {setv dazinyear,0}           since so, there have been no cume days this year but in Jan
  {return}

- -----------------------------------------------------------------------------
                        End Day/Date Coversion
- -----------------------------------------------------------------------------

{:clev}                    clear event info
{setv repeat,clev1,10}
{call repeat}
{setv var}
{setv val}
{setv vnam}
{setv pos}
{setv txp}
{return}

{:clev1}
{setv-s even%timecount}
{setv-s acti%timecount}
{setv-s logt%timecount}
{setv-s days%timecount}
{setv-s star%timecount}
{setv-s dura%timecount}
{setv-s late%timecount}
{setv-s erro%timecount}
{setv-s file%timecount}
{setv-s buff%timecount}
{setv-s labe%timecount}
{setv-s minblk%timecount}
{setv-s grablk%timecount}
{return}

-----BEGIN PGP SIGNATURE-----
Version: 2.6.2

iQEVAwUBLxtkTx1uLkXXbMBBAQGbxwf+NfrSLkM2AmxGaJOYUD55cyHpszVU1EVq
N9UL8YF3F1Q9F2ku6nfZx3sZ0omrlag8p+YTbbxXuC9hSdNjifV5Nwygje1dcjRp
ISTgYYj2ZH+0lkv5IbwZWCDVLWnHc0ePoMTVCgohrpr0NwE6wLuir3YwQs1aKk12
BNNpnTeMnfSH9TQT6JAyDi93B38iMS8mfFri4w7xETrVV0f8keeVLzqys5jYiilq
l2pRwcZDkOLjQUgh9t/lP8NEmDtEqxaGyf8d4lgfQ/OUPUJWYQTrSyojPKVzyVsy
A38pEVHqsRgpGR3kyUKeqUt140LI2TbuiZ4Grzy15LoMzq6B8rjI7w==
=o2P9
-----END PGP SIGNATURE-----
