/* REXX */

/* ZERO.CMD - deletes zero byte files in the outbound subdirectories */
/* version 1.1 - 14 April, 1994 by Elliott Goodman */

/* check whether RxFuncs are loaded. If not, load them. */

if RxFuncQuery('SysLoadFuncs') then
do
	call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
	call SysLoadFuncs
end

/* set up directories needed */

area.1 = 'd:\lora\outbound'
area.2 = 'd:\lora\outbound.051'
area.3 = 'd:\lora\OUTBOUND.04E'
area.4 = 'd:\lora\outbound\00660527.PNT'
area.5 = 'd:\lora\outbound.051\013B0001.PNT'

/* now cycle thru each directory */

do i = 1 to 5
	newdir = area.i
	call directory newdir
	pattern = newdir||'\'
	pattern = translate(pattern)	/* move to uppercase */
	call SysFileTree '*', 'tfile', 'F'
	if tfile.0 = 0 then do		/* no files present */
		iterate			/* do next directory */
		end
	do k = 1 to tfile.0
	parse upper var tfile.k . . size attrib name
	if size = 0 then do
		parse var name (pattern) dstuff '.' extn
		if extn = 'ILO' | extn = 'CLO' | extn = 'DLO' | extn = 'FLO' | extn = 'BSY' then
			iterate
		parse upper var name (pattern) fname
		dummy = SysFileDelete(fname) 
		end
	end
end
