/* INET.CMD - REXX program to move Internet Mail from the
Netmail directory to the Internet directory. Skips mail addressed to me.

Maybe it's a little kludgy but it works. Hey, whaddya want for free?
ver. 1.0 - 14 January, 1995 by Elliott Goodman, 1:102/1319 
*/

/* check whether RxFuncs are loaded. If not, load them. */

if RxFuncQuery('SysLoadFuncs') then
do
   call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   call SysLoadFuncs
end

path.1 = 'd:\lora\msg\net'		/* set up directories */
path.2 = '\lora\msg\inet'
path.3 = '\temp'

/* Move to Netmail area */
call directory path.1

/* use SysFileTree here to check for MSG files */
   call SysFileTree path.1||'\*.MSG', msg_file, 'F'

   do i = 1 to msg_file.0          /* cycle thru MSG files */

/* get info on each file in the area */
   parse var msg_file.i,
         file_date,
         file_time,
         file_size,
         file_attr,
         file_name

/* remove trailing space */
     file_name = strip( file_name )

areaname = path.1||'\'

/* remove drive/subdir info from filename */
     parse var file_name (areaname) file_name

/* convert to caps, just in case */
     file_name = translate( file_name )

/* read in first line (actually, the whole message) */
    first_line = linein(file_name)

/* close the file so we can move it, if necessary */
    call lineout(file_name)

/* truncate to 80 characters */
    first_line = left(first_line, 80)

/* uppercase for easy comparison */
    first_line = translate(first_line)

/* change nul characters and periods to spaces so we can
search by words */
    first_line = translate(first_line, '  ', x2c('00')||'.')

/* look for messages addressed to or from me; skip if found */
    if wordpos('ELLIOTT', first_line) = 0 then do

/* otherwise, it's to someone else. Move it to temp directory */
        'move ' file_name path.3
        end /* if wordpos */
    end /* cycling thru msg files */

/* change to temp directory */
'cd ' path.3

/* pick a number high enough so as not to overwrite any
existing messages in the Internet area */
new_msg_number = 400

/* use SysFileTree here to identify moved msg files */
   call SysFileTree 'd:'||path.3||'\*.MSG', msg_file, 'F'

   do i = 1 to msg_file.0 /* cycle thru the moved messages */

   parse var msg_file.i,
         file_date,
         file_time,
         file_size,
         file_attr,
         file_name
     file_name = strip( file_name )
     areaname = 'd:'||path.3||'\'
     parse var file_name (areaname) file_name
     file_name = translate( file_name )

/* rename (renumber) the moved MSG files */ 
    'ren ' file_name new_msg_number||'.MSG'
    new_msg_number = new_msg_number + 1

    end /* renumbering moved MSG files */

/* build file list again to get new xxx.MSG names */
   call SysFileTree 'd:'||path.3||'\*.MSG', msg_file, 'F'

   do i = 1 to msg_file.0
   parse var msg_file.i,
         file_date,
         file_time,
         file_size,
         file_attr,
         file_name
     file_name = strip( file_name )
     areaname = 'd:'||path.3||'\'
     parse var file_name (areaname) file_name                          
     file_name = translate( file_name )                                 

/* now move to Internet Mail area */
    'move ' file_name path.2
    end /* cycling thru renamed MSG's */

/* finally, use LMSG to force renumbering and indexing */
'cd \lora'
'lmsgb4 -ir -xqspg'

exit
