/* Door Tracking REXX cmd file by Elliott Goodman
Version 1.31, 14 Feb, 1995. 1:102/1319

Modify as needed. Please note: you may have to adjust
the directories you are in when calling this. It's set up
for my system (of course).

*/

/* trace ?a */

phrase = 'External'		/* Specific phrases to look for */
phrase2 = 'Returned'
phrase3 ='D:\LORA\LORD1.BAT'
phrase4 ='D:\LORA\PLANET1.BAT'
phrase5 ='D:\LORA\DOORS\EZELS.BAT'
phrase6 = 'Write'
phrase7 = 'Connect FAX'
phrase8 = 'Calls=1,'
phrase9 = 'System call'

count = 0			/* count of times door is entered */
lord = 0
planet = 0
ezels = 0
ice = 0
fax_count = 0
Sys_Txt = ' No System Calls??'
BBS_calls = 0

max_time = (24 * 3600)	/* 24:00 if someone should span the day */
total_time = 0			/* total time in doors */

/* save_file = 'd:\lora\lang\doors.txt' */
total_hours = 0
total_minutes = 0
total_seconds = 0

say "Door Trakker by Elliott Goodman"
say "Version 1.31, February 14, 1995"
say ''

in_name = 'lora.log'            /* set up work names */                  

do until lines(in_name) = 0             /* read in each line */          
  work_line = linein(in_name)           /* current line to examine */    
  j = wordpos(phrase, work_line)      /* look for the phrase */        
  if j \= 0 then do                     /* phrase found */               
      next_line = linein(in_name)	/* get next line */
      k = wordpos(phrase2, next_line)
      if k \= 0 then do

/* Okay, work_line has 'External' in it and next_line has 'Returned' in it.
Therefore, a user has gone to a door and returned. Now, let's parse the lines */

        count = count + 1		/* increment count */

/* find out which door was run */

	n = wordpos(phrase3, work_line)	/* Test for Legend */
	  if n \= 0 then do
	    lord = lord + 1
	    end

	n = wordpos(phrase4, work_line)	/* Test for Planets */
	  if n \= 0 then do
	    planet = planet + 1
	    end

	n = wordpos(phrase5, work_line)	/* Test for EZ-Els */
	  if n \= 0 then do
	    ezels = ezels + 1
	    end

	
/* these lines get the time the event occurred */
        parse var work_line ':' start_time junk
        parse var next_line ':' end_time junk

/* these lines parse the time into hours/minutes/seconds */
        parse var start_time shour ':' smin ':' ssec
        parse var end_time ehour ':' emin ':' esec

/* calculate total seconds */
        stotal = (3600 * shour) + (60 * smin) + ssec
        etotal = (3600 * ehour) + (60 * emin) + esec

/* if start time > end time, user has spanned midnight - adjust */
        if stotal > etotal then
          this_time = (max_time - stotal) + etotal
        else
          this_time = etotal - stotal

        total_time = total_time + this_time

        end /* k \= */
      k = wordpos(phrase6, next_line)
      if k \= 0 then do
        ice = ice + 1
        count = count + 1
      end /* if k \=0 */

    end       /* end if j \= */

    else do

      j = wordpos(phrase7, work_line)
      if j \= 0 then
      do
        fax_count = fax_count + 1
        end /* if j \= 0 */

      j = wordpos(phrase8, work_line)
      if j \= 0 then
      do
           parse upper var work_line . . first_name last_name 'OFF-LINE.' dummy
           say "New caller: "first_name last_name
           end /* j \= 0 */

       j = wordpos(phrase9, work_line)
       if j \= 0 then
       do
           parse var work_line . . Sys_Txt
           BBS_calls = BBS_calls + 1
           end

       end  /* else do */

end             /* end do until */

call lineout in_name                    /* close files */                

say "BBS Calls:" BBS_calls || ", High" || Sys_Txt 
say " "

/* calculate hours and minutes */
if total_time > 3600 then do
  total_hours = total_time % 3600
  total_time = total_time // 3600
  end

if total_time > 60 then do
  total_minutes = total_time % 60
  total_time = total_time // 60
  end

total_seconds = total_time

say "Total times in doors today =" count
say "LORD =" lord "Planets =" planet
say "EZ-Echo Searcher =" ezels
say "Hours:" total_hours||", Minutes:" total_minutes
say "Ice Edit wrote" ice "messages."
say "Faxes received: " fax_count
say ''                          
say 'Press any key to exit....' 
                                
parse pull stuff                

exit
