/*
  C source for Winsock Chess
  
  Revision 1994-03-15
  Modified by Donald Munro for use as a 2 player chess game over a 
  WINSOCK layer on a TCP (or other WinSock supporting) network.
  Source code and make files for MS Visual C/C++ V1.00/1.50.
  February/March 1994
  All GNU copyright and distribution conditions as described below and in the
  file COPYING also apply to WinSock Chess.
  This module is adapted from GNU Chess.
    
  C source for GNU CHESS

  Revision: 1990-09-30
  Modified by Daryl Baker for use in MS WINDOWS environment
 
  Copyright (C) 1986, 1987, 1988, 1989, 1990 Free Software Foundation, Inc.
  Copyright (c) 1988, 1989, 1990  John Stanback

  This file is part of CHESS.

  CHESS is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY.  No author or distributor accepts responsibility to anyone for
  the consequences of using it or for whether it serves any particular
  purpose or works at all, unless he says so in writing.  Refer to the CHESS
  General Public License for full details.

  Everyone is granted permission to copy, modify and redistribute CHESS, but
  only under the conditions described in the CHESS General Public License.
  A copy of this license is supposed to have been given to you along with
  CHESS so you can know your rights and responsibilities.  It should be in a
  file named COPYING.  Among other things, the copyright notice and this
  notice must be preserved on all copies.
*/

#define NOATOM                /*Minimize windows.h processing*/
#define NOCLIPBOARD
#define NOCREATESTRUCT
#define NOFONT
#define NOREGION
#define NOSOUND
#define NOWH
#define NOKANJI

#define STRICT 
#include <windows.h>         
#include <windowsx.h>
#include <commdlg.h>
#include <string.h>
#include <time.h>
#include <ddeml.h>

#include "winsock.h"
#include "gnuchess.h"
#include "defs.h"
#include "chess.h"
#include "saveopen.h"
#include "color.h"
#include "resource.h"

// Message Cracker for socket message
// void OnWsConnect(HWND hwnd, SOCKET socket, WORD wEvent, WORD wError)
#define HANDLE_WM_SOCKET(hwnd, wParam, lParam, fn) \
    (fn)((hwnd), (SOCKET)(wParam), (WORD)(WSAGETSELECTEVENT(lParam)), \
                   (WORD)(WSAGETSELECTERROR(lParam)))
                   
DWORD clrBackGround;       /* rgb structures for various colors */
DWORD clrBlackSquare;
DWORD clrWhiteSquare;
DWORD clrBlackPiece;
DWORD clrWhitePiece;
DWORD clrText;

static HBRUSH hBrushBackGround;

short boarddraw[64];       /* Display copies of the board */
short colordraw[64];       /* Needed because while computer is calculating*/
                           /* moves it updates board and color thus you can*/
                           /* not repaint the screen accuratly */

struct PIECEBITMAP pieces[7];

HINSTANCE hInst;              /* current instance */

char szAppName[] = "WSChess";

extern char mvstr[4][6];
int coords = 1;

static int FirstSq = -1;         /* Flag is a square is selected */
static int GotFirst = FALSE;
static int EditActive = FALSE;   
int User_Move = TRUE;    
int xchar, ychar;
static HMENU hMainMenu;

HWND hwndHostDlg=NULL;
DWORD idDdeServInst,idDdeClntInst;
WORD wComType=IDC_SOCKETS,wPacketSize;
BOOL bConnected=FALSE,bHost=FALSE,bMoveReady=FALSE,bWaiting=FALSE;
BOOL (*Initialise)(void);
BOOL (*ConnectHost)(void);
BOOL (*ConnectClient)(void);
void (*GetOpponentsMove)(WORD);
void (*SendMove)(WORD);
BOOL (*IsCommand)(LPSTR);
void (*LoadGame)(void);
void (*StartGame)(void);
void (*SetTime)(int);
HSZ hszServName,hszTopic,hszServNameCl,hszTopicCl,hszItem,hszGet;
HCONV hconvHost,hconvClient;
HWND hwndMain,hwndStatus;
MoveInfo moveinfo;
char szSockDesc[45];

void OnSocketMessage(HWND , SOCKET , WORD , WORD );

void EnableMenuItems(void)
//------------------------
{ HMENU hmenuMain;
  
  hmenuMain = GetMenu(hwndMain);
  if ( (bConnected) && (User_Move) )
   { EnableMenuItem(hmenuMain,MSG_CHESS_NEW,MF_ENABLED | MF_BYCOMMAND);
     EnableMenuItem(hmenuMain,MSG_CHESS_EDIT,MF_ENABLED | MF_BYCOMMAND);
     EnableMenuItem(hmenuMain,MSG_CHESS_GET,MF_ENABLED | MF_BYCOMMAND);
     EnableMenuItem(hmenuMain,IDM_TIMECONTROL,MF_ENABLED | MF_BYCOMMAND);
   }  
  else   
   { EnableMenuItem(hmenuMain,MSG_CHESS_NEW,MF_GRAYED | MF_BYCOMMAND);
     EnableMenuItem(hmenuMain,MSG_CHESS_EDIT,MF_GRAYED | MF_BYCOMMAND);
     EnableMenuItem(hmenuMain,MSG_CHESS_GET,MF_GRAYED | MF_BYCOMMAND);
     EnableMenuItem(hmenuMain,IDM_TIMECONTROL,MF_GRAYED | MF_BYCOMMAND);
   }
  if (bConnected)
   { EnableMenuItem(hmenuMain,IDM_DISCONNECT,MF_ENABLED | MF_BYCOMMAND);  
     EnableMenuItem(hmenuMain,IDM_PROTOCOL,MF_GRAYED | MF_BYCOMMAND);  
     EnableMenuItem(hmenuMain,IDM_HOST,MF_GRAYED | MF_BYCOMMAND);  
     EnableMenuItem(hmenuMain,IDM_CLIENT,MF_GRAYED | MF_BYCOMMAND);  
   }
  else
   { EnableMenuItem(hmenuMain,IDM_DISCONNECT,MF_GRAYED | MF_BYCOMMAND);  
     EnableMenuItem(hmenuMain,IDM_PROTOCOL,MF_ENABLED | MF_BYCOMMAND);  
     EnableMenuItem(hmenuMain,IDM_HOST,MF_ENABLED | MF_BYCOMMAND);  
     EnableMenuItem(hmenuMain,IDM_CLIENT,MF_ENABLED | MF_BYCOMMAND);  
   }  
}   

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, 
                  LPSTR lpCmdLine,int nCmdShow)
//--------------------------------------------------------------                  
{
    HWND hWnd;
    MSG msg;
    POINT pt;

    lpCmdLine ++;

    if (!hPrevInstance)
       if (!ChessInit(hInstance)) return (NULL);

    hInst = hInstance;          /* Saves the current instance        */

    QueryBoardSize (&pt);

    /* Create the main window.  It will be autosized in WM_CREATE message */
    hWnd = CreateWindow(szAppName,  szAppName,
        WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
         CW_USEDEFAULT, CW_USEDEFAULT,
         CW_USEDEFAULT, CW_USEDEFAULT,
         NULL,  NULL,   hInstance,  NULL);

    if (!hWnd)  return (NULL);
    hwndMain = hWnd;
    ShowWindow(hWnd, nCmdShow);          

   /* Initialize chess */
   if (init_main ( hWnd ) ) {
      SMessageBox (hWnd, IDS_INITERROR,IDS_CHESS);
      FreeGlobals ();
      return (NULL);
   }

   UpdateWindow(hWnd);          
   EnableMenuItems();

   player = opponent;

   while (GetMessage(&msg, NULL, NULL, NULL)) {
       TranslateMessage(&msg);     
       DispatchMessage(&msg);
    }

    return (msg.wParam);   
}


void CreateStatusBar(HWND hWnd,HINSTANCE hInst,short ychar)
//---------------------------------------------------------
{ RECT rectWinRect;
  int ny;
  
  GetClientRect(hWnd, &rectWinRect);                      
  ny = rectWinRect.bottom - (15 + ychar);
  hwndStatus = CreateWindow("STATBR",NULL,WS_CHILD | WS_VISIBLE,
                            0,ny,rectWinRect.right,rectWinRect.bottom - ny,
                            hWnd,(HMENU)5000,hInst,NULL);
  ShowWindow(hwndStatus,SW_SHOW);                          
}
  
// Handle WM_CREATE message
BOOL OnCreate(HWND hWnd,CREATESTRUCT FAR *lpCreateStruct)
//-------------------------------------------------------
{ int i; 
  HDC hDC;
  TEXTMETRIC tm;
  POINT point;

  hwndMain = hWnd;
  GetStartupColors();
  hBrushBackGround = CreateSolidBrush ( clrBackGround );

  for ( i=pawn; i<pawn+6; i++ ) 
    pieces[i].piece = LoadBitmap (hInst, MAKEINTRESOURCE(PAWNBASE+i));
  for ( i=pawn; i<pawn+6; i++ ) 
    pieces[i].mask = LoadBitmap (hInst, MAKEINTRESOURCE(PAWNBASE+6+i));
  for ( i=pawn; i<pawn+6; i++ ) 
    pieces[i].outline = LoadBitmap (hInst, MAKEINTRESOURCE(PAWNBASE+12+i));

  hDC = GetDC (hWnd);
  GetTextMetrics ( hDC, &tm);
  xchar = tm.tmMaxCharWidth;
  ychar = tm.tmHeight+tm.tmExternalLeading;

  /*Autosize main window */
  QueryBoardSize (&point);            
  SetWindowPos( hWnd, hWnd, 0,0,
                point.x+GetSystemMetrics(SM_CXFRAME)*2+50,
                point.y+GetSystemMetrics(SM_CYFRAME)*2+GetSystemMetrics(SM_CYMENU)+
                GetSystemMetrics(SM_CYCAPTION) + 2*ychar,
                SWP_NOMOVE | SWP_NOZORDER);

  ReleaseDC ( hWnd, hDC);

  InitHitTest ();
  hComputerMove = CreateWindow ("Static",NULL,
                        WS_CHILD | SS_LEFT | WS_VISIBLE,
                        375,10 ,10*xchar,ychar,
                        hWnd, (HMENU)1003, hInst, NULL);
  CreateStatusBar(hWnd,hInst,ychar);
  SetWindowText(hWnd,"Winsock Chess (Not Connected)");
  GetOpponentsMove = GetOpponentsMoveWS;
  SendMove         = SendMoveWS;
  LoadGame         = GetGameWS;
  IsCommand        = IsCommandWS;
  StartGame        = NewGameWS;
  SetTime          = SetTimeWS;
  wPacketSize = 0;
  return TRUE;
}

void FreeBitmaps(void)
//--------------------
{ register int i;

  for ( i=pawn; i<pawn+6; i++ ) 
    DeleteObject(pieces[i].piece);
  for ( i=pawn; i<pawn+6; i++ ) 
    DeleteObject(pieces[i].mask);
  for ( i=pawn; i<pawn+6; i++ ) 
    DeleteObject(pieces[i].outline);
}    

void FreeWindows(void)
//--------------------
{  
  DestroyWindow(hComputerMove);
  DestroyWindow(hwndStatus);
}  

void Disconnect(void)
//-------------------
{ if (! bConnected) return;
  switch (wComType)
   { case IDC_DDE :
        DisconnectDDE();
        NewGame(hwndMain);  
        break;
     case IDC_SOCKETS :
        DisconnectWS();
        NewGame(hwndMain);  
        break;    
   }      
  bConnected = FALSE; 
}
        
// Handle WM_DESTROY message
BOOL OnDestroy(HWND hWnd)
//-----------------------
{ Disconnect();
  DeleteObject (hBrushBackGround);
  Hittest_Destructor ();
  FreeGlobals ();
  FreeBitmaps();
  FreeWindows();
  SaveColors();
  PostQuitMessage(0);
  return TRUE;
}  

//Handle WM_PAINT message
BOOL OnPaint(HWND hWnd)
//---------------------
{ POINT pt; 
  RECT rect;  
  HDC hDC;
  PAINTSTRUCT ps;
  
  if ( FirstSq != -1 )         /*Properly repaint hilighted square*/
   { QuerySqOrigin ( FirstSq%8, FirstSq/8, &pt);
     rect.left = pt.x; rect.right=pt.x+48;
     rect.top = pt.y-48; rect.bottom = pt.y;
     InvalidateRect (hWnd, &rect, FALSE);
   }

  hDC = BeginPaint ( hWnd, &ps);
  Draw_Board (hDC, flag.reverse, clrBlackSquare, clrWhiteSquare );
  if ( coords ) 
    DrawCoords (hDC, flag.reverse, clrBackGround, clrText);
  DrawAllPieces (hDC, flag.reverse, boarddraw, colordraw, 
                 clrBlackPiece, clrWhitePiece );
  RedrawStatusBar();
  EndPaint ( hWnd, &ps);

  if ( FirstSq != -1 ) 
     HiliteSquare ( hWnd, FirstSq);
  return TRUE;
}  

//Handle WM_CTLCOLOR message
HBRUSH OnCtlColor(HWND hWnd, HDC hdc, HWND hwndChild, int type)
//-------------------------------------------------------------
{ POINT point;
  
  if ( type == CTLCOLOR_STATIC) 
   { UnrealizeObject ( hBrushBackGround );
     SetBkColor(hdc, clrBackGround);
     SetBkMode(hdc, TRANSPARENT);
     SetTextColor (hdc, clrText);
     point.x = point.y = 0;
     ClientToScreen ( hWnd, &point);
     SetBrushOrg(hdc, point.x, point.y);
     return hBrushBackGround;
   } 
  else
     return NULL;
}

// Handle WM_ERASEBKGND message
BOOL OnEraseBkgnd(HWND hWnd, HDC hdc)
//-----------------------------------
{ RECT rect;

  UnrealizeObject ( hBrushBackGround);
  GetClientRect ( hWnd, &rect);
  FillRect (hdc, &rect, hBrushBackGround);
  return TRUE;
}

// Handle WM_INITMENUPOPUP message
void OnInitMenuPopup(HWND hWnd,HMENU hMenu, int item, BOOL bSystemMenu)
//---------------------------------------------------------------------
{ if ( !EditActive ) 
    Init_Menus (hWnd, hMenu, item);
}

// Handle WM_LBUTTONDOWN message
void OnLButtonDown(HWND hWnd,BOOL bDoubleClick,int x,int y,UINT keyFlags)
//----------------------------------------------------------------------
{ int Hit;
  
  if (! User_Move) return;
  if (! bConnected) return;
  Hit = HitTest (x, y);

  if ( Hit == -1 )
   { if ( FirstSq != -1) 
      { UnHiliteSquare ( hWnd, FirstSq);
        GotFirst = FALSE;
        FirstSq = -1;
      }
     return;
   }

  if ( GotFirst ) 
   { UnHiliteSquare( hWnd, FirstSq);
     GotFirst = FALSE;
     if ( EditActive == TRUE) 
       PostMessage ( hWnd, MSG_EDITBOARD,(WPARAM)FirstSq,(LPARAM)Hit);      
     else 
       if ( User_Move == TRUE) 
         PostMessage ( hWnd, MSG_USER_ENTERED_MOVE, (WPARAM)FirstSq,
                       (LPARAM)Hit),
     FirstSq = -1;
   } 
  else 
    { GotFirst = TRUE;
      FirstSq = Hit;
      HiliteSquare ( hWnd, Hit);
    }
  return;
}

void OnCommand(HWND hWnd,int id,HWND hwndCtl,UINT wcodeNotify)
//-----------------------------------------------------------
{ char szFileName[256];
         
  switch (id) 
    { case MSG_CHESS_QUIT:
        DestroyWindow ( hWnd);
        break;

      case MSG_CHESS_NEW:
        (*StartGame)();
        break;

      case MSG_CHESS_ABOUT:
        DialogBox(hInst,MAKEINTRESOURCE(AboutBox),hWnd,About);
        break;
        
      case MSG_CHESS_REVIEW:
        ReviewDialog ( hWnd, hInst );
        break;

      case MSG_CHESS_REVERSE:
        flag.reverse = !flag.reverse;
        UpdateDisplay(hWnd,0,0,1,0);
        break;
      
      case MSG_CHESS_SAVE :
        if (GetFileName(szFileName,OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT,
                        MSG_CHESS_SAVE))
          SaveGame(hwndMain,szFileName);               
        break;
      
      case MSG_CHESS_GET :
        (*LoadGame)();
        break;
      
      case MSG_CHESS_LIST :
         if (GetFileName(szFileName,OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT,
                        MSG_CHESS_LIST))
            ListGame(hWnd,szFileName);
         break; 
      
      case MSG_CHESS_HASH:
        flag.hash = !flag.hash;
         break;

      case MSG_CHESS_BEEP:
        flag.beep = !flag.beep;
        break;

      case MSG_CHESS_COORD:
        coords = !coords;
        UpdateDisplay(hWnd,0,0,1,0);
        break;

      case MSG_CHESS_ABORT:
        flag.timeout = true;
        flag.bothsides = false;
        EnableMenuItem ( GetMenu(hWnd), MENU_ID_ABORT, MF_GRAYED | MF_BYCOMMAND | MF_GRAYED | MF_BYCOMMAND | MF_BYPOSITION );
        DrawMenuBar ( hWnd );
        break;

      case IDM_BACKGROUND:
        if (ColorDialog ( hWnd, id) ) 
          { InvalidateRect (hWnd, NULL, TRUE);
            DeleteObject (hBrushBackGround);
            hBrushBackGround = CreateSolidBrush ( clrBackGround );
            
            InvalidateRect (hComputerMove, NULL, TRUE);
          }
        break;

      case IDM_BLACKSQUARE:
        if (ColorDialog ( hWnd, id) ) 
          InvalidateRect (hWnd, NULL, TRUE);
        break;

      case IDM_WHITESQUARE:
        if (ColorDialog ( hWnd, id) ) 
           InvalidateRect (hWnd, NULL, TRUE);
        break;
        
      case IDM_BLACKPIECE:
        if (ColorDialog ( hWnd, id) ) 
           InvalidateRect (hWnd, NULL, TRUE);
        break;

      case IDM_WHITEPIECE:
        if (ColorDialog ( hWnd, id) ) 
           InvalidateRect (hWnd, NULL, TRUE);
        break;

      case IDM_TEXT:
        if ( ColorDialog (hWnd, id) ) 
          { InvalidateRect (hWnd, NULL, TRUE);
            InvalidateRect (hComputerMove, NULL, TRUE);
          }
        break;

      case IDM_DEFAULT:
        SetStandardColors ();
        InvalidateRect (hWnd, NULL, TRUE);
        DeleteObject (hBrushBackGround);
        hBrushBackGround = CreateSolidBrush ( clrBackGround );

        InvalidateRect (hComputerMove, NULL, TRUE);
        RedrawStatusBar();
        break;

      case IDM_TIMECONTROL:
        (*SetTime)(id);    
        RedrawStatusBar();
        break;
        
      case IDM_PROTOCOL :
        DialogBox(hInst,MAKEINTRESOURCE(IDD_PROTOCOL),hWnd,ProtocolDlg);
        break;  
      
      case IDM_HOST :
        switch (wComType)
          { case IDC_DDE :
              DialogBox(hInst,MAKEINTRESOURCE(IDD_HOSTDDE),hWnd,HostDlgDDE);
              break;
            case IDC_SOCKETS :
              DialogBox(hInst,MAKEINTRESOURCE(IDD_HOSTWS),hWnd,HostDlgWS);
              break;
          }    
        RedrawStatusBar();  
        break;  
        
      case IDM_CLIENT :
        switch (wComType)
          { case IDC_DDE :
              DialogBox(hInst,MAKEINTRESOURCE(IDD_CONNDDE),hWnd,ConnDdeDlg);
              break;
            case IDC_SOCKETS :
              DialogBox(hInst,MAKEINTRESOURCE(IDD_CONNWS),hWnd,ConnWSDlg);
              break;    
          }    
        RedrawStatusBar();  
        break;  
          
      case IDM_DISCONNECT :
        Disconnect();
        RedrawStatusBar();
        break;  
        
      case IDM_HELP :
        WinHelp(hWnd,".\\WSCHESS.HLP",HELP_CONTENTS,0L);
        break;
    }
}        

void swap(short *col1,short *col2)
//------------------------------
{ short tmp;

  tmp = *col1;
  *col1 = *col2;
  *col2 = tmp;
}
  
LRESULT CALLBACK ChessWndProc( HWND hWnd, UINT message, WPARAM wParam, 
                               LPARAM lParam)
//--------------------------------------------------------------------                               
{  char str[80];
   unsigned short mv;
   int Square,First,algbr_flag,temp;

   switch (message) 
   { case WM_CREATE: 
          return HANDLE_WM_CREATE(hWnd,wParam,lParam,OnCreate);

     case WM_DESTROY:  
          return HANDLE_WM_DESTROY(hWnd,wParam,lParam,OnDestroy);

      case WM_PAINT:
          return HANDLE_WM_PAINT(hWnd,wParam,lParam,OnPaint);

      case WM_CTLCOLOR:  
          return HANDLE_WM_CTLCOLOR(hWnd,wParam,lParam,OnCtlColor);

      case WM_ERASEBKGND:
          return HANDLE_WM_ERASEBKGND(hWnd,wParam,lParam,OnEraseBkgnd);

      case WM_INITMENUPOPUP:
          return HANDLE_WM_INITMENUPOPUP(hWnd,wParam,lParam,OnInitMenuPopup);         

      case WM_LBUTTONDOWN:
          return HANDLE_WM_LBUTTONDOWN(hWnd,wParam,lParam,OnLButtonDown);
      
      case WM_COMMAND :
          return HANDLE_WM_COMMAND(hWnd,wParam,lParam,OnCommand);
      
      case WM_SOCKET :
          HANDLE_WM_SOCKET(hWnd,wParam,lParam,OnSocketMessage);
          return 0;
          
      case MSG_EDITBOARD:
      {
         int Square, First;

         if ( flag.reverse ) {
            First = 63 - wParam;
            Square  = 63 - (int)lParam;
         } else {
            First = wParam;
            Square  = (int)lParam;
         }
         
         board[Square] = board[First];
         color[Square] = color[First];

         board[First] = no_piece;
         color[First] = neutral;

         UpdateDisplay (hWnd, First, Square, false, false);
      }
         break;

      case MSG_USER_MOVE:
            RedrawStatusBar();
            EnableMenuItems();
            ft = 0;
            player = opponent;
         break;

      case MSG_USER_ENTERED_MOVE:
      {  User_Move = FALSE;
         player = opponent;

         First = wParam;
         Square  = (int)lParam;
         
         if (flag.reverse)
           { First = 63 - wParam;
             Square  = 63 - (int)lParam;
           } 
         
         /* Logic to allow selection for pawn promotion */
         if ( (board[First] == pawn) &&( (Square <8) || (Square>55)) ) {
            algbr_flag = promote + PromoteDialog (hWnd, hInst);
         } else algbr_flag = 0;
         algbr ( First, Square, algbr_flag);

         lstrcpy(str,mvstr[0]);
         
         temp = VerifyMove ( hWnd, str, 0, &mv);
         
         if ( temp == TRUE) 
         {  ElapsedTime (1);     
            strcpy(moveinfo.szMove,str); 
            strcat(moveinfo.szMove,"\r\n");
            (*SendMove)(7);
            PostMessage ( hWnd, MSG_COMPUTER_MOVE, NULL, (LPARAM)NULL);
         } 
         else 
         { User_Move = TRUE;
           PostMessage ( hWnd, MSG_USER_MOVE, NULL, (LPARAM)NULL);
         }  
      }
        break;

      case MSG_COMPUTER_MOVE:
         EnableMenuItems();
         RedrawStatusBar();
         if ( !(flag.quit || flag.mate || flag.force) )
          { User_Move = FALSE;            
            if (! bWaiting)
             (*GetOpponentsMove)(7);
            else
             { bWaiting = FALSE;  
               swap(&opponent,&computer);
               player = opponent;
               strncpy(str,moveinfo.szMove,5); str[5] = 0; 
               if (str[4] == '\r') str[4] = 0;
               if (! ((*IsCommand)(str)))
                 { temp = VerifyMove ( hWnd, str, 0, &mv);
                   if ( flag.beep ) MessageBeep (0);
                   swap(&opponent,&computer);
                   User_Move = TRUE;
                   OutputMove(hWnd);
                   PostMessage (hWnd, MSG_USER_MOVE, NULL,NULL);
                 } 
               else
                 { swap(&opponent,&computer);
                   if (!User_Move)
                     PostMessage ( hWnd, MSG_COMPUTER_MOVE, NULL, (LPARAM)NULL);
                   else  
                     PostMessage ( hWnd, MSG_USER_MOVE, NULL, (LPARAM)NULL);
                 }  
             }  
          }         
         break;

      default:   
         return (DefWindowProc(hWnd, message, wParam, lParam));
    }
    return (NULL);
}
