/***********************************************************************
**
** WHISTORY.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** All teh functionality for the history list object.  All 
** encapsulated here.
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
#include "stdafx.h"
#include "newssup.h"

long            seed;

static long xrand(void)
{
	seed = (seed * 16807) & 0x7FFFFFFFL;
	return (seed);
}

/*----------------------------- hash a key -----------------------------------*/
static long hash_key(long s, const char *key)
{
	long            hash_num;
	int             i;

	hash_num = 0;
	seed = s;

	for (i = 0; i < (int)strlen(key); i++) {
		hash_num += xrand() * (key[i] + 0xFF00);
	}

	hash_num = hash_num & 0x7FFFFFFFL;
	if (hash_num == 0)
		hash_num++;

	return (hash_num);
}


/*----------------------------- hash the message id -------------------------*/
static long HashMsgId(const char *msg_id)
{

	return (hash_key(hash_key(26l, msg_id), msg_id));
}
                 

/*----------------------- open hist file for writing ------------------------*/
CHistoryList::CHistoryList( const char * FileName )
{

	/*
	 * This routine opens the history file for writing, positioned after
	 * the last record.
	 */
              
    Ok = FALSE; 
    hlist = hlistend = NULL;
    hist = new CStdioFile();
     
	if ( !hist->Open( FileName , CFile::modeReadWrite | CFile::typeBinary ) )
	{
		hist->Open( FileName , CFile::modeCreate | CFile::modeReadWrite | CFile::typeBinary );
	}        
	/* set a large disk transfer buffer */
	for (size_t bufsize = (size_t) 32768U;
		 setvbuf(hist->m_pStream, NULL, _IOFBF, bufsize) != 0 && bufsize > 512;
	 	 bufsize /= 2)
			; // <-!!!! Missing Null expression CRCS 23/11/94
	LoadHistoryList( 0 );
	Ok = TRUE;
}


/*---------------------------- close hist file ---------------------------*/
CHistoryList::~CHistoryList()
{
	/*
	 * This routine closes the history file
	 */
	FreeHistList();
	delete hist;
	hist = NULL;
}


/*---------------------------- add record to list ------------------------*/
int CHistoryList::AddToHistList(const char *p, int ct, long where)
{

	/*
	 * This routine adds a single entry to the history list in memory. It returns 1 if store is exhausted, else zero.
	 */

	if (hlist == NULL) {
		hlist = new HIST_LIST;
		hlistend = hlist;
	}
	else {
		hlistend->next = new HIST_LIST;
		hlistend = hlistend->next;
	}

	hlistend->mid = HashMsgId(p);
	hlistend->ngroups = ct;
	hlistend->offset = where;
	hlistend->next = NULL;


	return 0;
}

/*---------------------------- add record to file -----------------------*/
void CHistoryList::AddHistRecord(const char *msg_id, const char * ng,  CActiveList * List)
{

	/*
	 * This routine adds a record to the history files.  It is passed the
	 * message id, and the newsgroup list.  The newsgroup list is unwound,
	 * and the article numbers are added to the record.
	 * 
	 * We assume that this routine is called after the article has been
	 * posted, so that the article counters are correct.
	 */
	
	CActive * a;
	char           *p;
	static char     buf[ NEWS_BUF_LEN + 1];
	static char 	buf2[ NEWS_BUF_LEN + 1];
	int             Count = 0;

	CTime TimeNow = CTime::GetCurrentTime();
	/* count the newsgroups */

	strcpy(buf, ng);
	p = strtok(buf, " \t,\n\r");

	while (p != NULL) {
		Count++;
		p = strtok(NULL, " \t,\n\r");
	}

	strcpy(buf, ng);
	p = strtok(buf, " \t,\n\r");

	if ((p != NULL) && (strlen(msg_id) > 0)) {

		hist->SeekToEnd();
		
		AddToHistList(msg_id, Count, hist->GetPosition() );
                                                      
		wsprintf( buf2, "%s %09ld ", msg_id, TimeNow.GetTime());
		hist->WriteString(  buf2 );

		while (p != NULL) {
			a = List->FindGroup(p );
			wsprintf( buf2, "%s %08ld  ", a->GetGroup(), a->GetHiNum() );
			hist->WriteString( buf2 );
			p = strtok(NULL, " \t,\n\r");
		}
		hist->WriteString( "\n" );
		hist->Flush();
	}
}


/*--------------------- read history file into ram -------------------------*/
void CHistoryList::LoadHistoryList(int all)
{

	/*
	 * This routine opens and reads the history file, building and index
	 * 
	 * Load this after active and ng files.  Set HIST_MEM_LIMIT in defs.h
	 * to ensure there is enough memory left
	 */

	char           *msg_id, *p;
	int             ct, ans = 0;
	long            Where;
	char	       *Buf = new char[ NEWS_BUF_LEN + 1 ];
	
	Where = 0L;
	
	while ( hist->ReadString(Buf, NEWS_BUF_LEN)) {

		msg_id = strtok(Buf, " \t\n\r");
		if( msg_id == NULL )
			continue;
			
		/* skip the next entry */
		p = strtok(NULL, " \t\n\r");

		/* now count the newsgroups */
		ct = 0;

		p = strtok(NULL, " \t\n\r");
		while (p != NULL) {
			ct++;
			p = strtok(NULL, " \t,\n\r");
			p = strtok(NULL, " \t,\n\r");
		}

		if ((all == 0) || (ct > 1))
			ans = AddToHistList(msg_id, ct, Where);

		if (ans)
			break;

		Where = hist->GetPosition();
	}
                         
	delete [] Buf;                         
	return;
}

/*------------------------- release the history list ----------------------*/
void CHistoryList::FreeHistList(void)
{

	/*
	 * Close the history file and free the memory list
	 */

	HIST_LIST      *h;

	while (hlist != NULL) {
		h = hlist->next;
		delete hlist;
		hlist = h;
	}
}

/*-------------------------- find history entry -----------------------------*/
HIST_LIST  * CHistoryList::FindMsgId(const char *msg_id)
{

	/*
	 * Look up the history list and return the entry for the req'd msg id
	 * or NULL if not found. ASSUMES global file 'hist' is open. If it
	 * isn't this routine always returns NULL.
	 */

	static char     buf[ NEWS_BUF_LEN + 1];			  /* THIS MUST BE STATIC !!! */
	HIST_LIST      *h;
	char           *p;
	long            hashed_id;

	hashed_id = HashMsgId(msg_id);

	for (h = hlist; h != NULL; h = h->next) {
		if (h->mid == hashed_id) {
			/* Look up this entry in the file */
			hist->Seek( h->offset, CFile::begin );
			if (hist->ReadString(buf, NEWS_BUF_LEN )) {

				/*
				 * Compare the target msg id with the one on the file.
				 * If they are different then there must be a
				 * hash collision so we must continue searching.
				 */

				p = strtok(buf, " \t\n\r");
				if (stricmp(p, msg_id) == 0)
					return (h);
			}
		}
	}

	return (NULL);
}                      
