/***********************************************************************
**
** CANIBMP.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
** It is the implementation of the CAnimatedBitmap class.
** This class responsible for animating itself in a particular
** location
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
///////////////////////////////////////////////////////////////////////
// smtpsock.h
// Declaration of the SMTP style socket
// This handles most of the interaction with the nntp server.
#ifndef _SMTPSOCK_H
#define _SMTPSOCK_H

#ifndef _CSOCKET_H
#include "csocket.h"
#endif
#ifndef _MESSAGE_H
#include "message.h"
#endif

// classes needed in this file
class CSmtpDlg;
// classes defined in this file
class CSmtpSocket;
class CSmtpSocketList;

// A wrapper for lists of sockets
class CSmtpSocketList : public CPtrList
{
  public:
  	CSmtpSocketList() : CPtrList() {;}
  	~CSmtpSocketList() {;}
  	POSITION AddTail( CSmtpSocket * p ) { return CPtrList::AddTail( (void *) p ); }
  	CSmtpSocket * GetHead() {return (CSmtpSocket *)CPtrList::GetHead(); }
  	CSmtpSocket * RemoveHead() { return (CSmtpSocket *)CPtrList::RemoveHead(); }
  	POSITION Find( CSmtpSocket * p ) { return CPtrList::Find( (void *)p ); }
  	CSmtpSocket * GetAt( POSITION p ) { return (CSmtpSocket *)CPtrList::GetAt( p ); } 
};

//////////////////////////////////////////////////////////////////////////
// This class (derived from a line buf socket) handles all the work
// in downloading a batch of news from a server.  It updates
// the parent dialog by sending a message with the LParam pointing
// to an CNntpInfo structure.
//  

#define SmtpLineBufSize  1024

class CSmtpSocket : public CLineSocket
{
  protected:
  	enum smtpStates {
  		INIT,        
  		TRYHOST,
  		TRYGATEWAY,
  		CONNECTED,
  		HELO,
		INACTIVE,
		MAILFROM,	
		RCPTTO,
		DATA,
		WAITOKSEND,
		SENDBODY,
		QUIT
	};

  public:
	CSmtpSocket( tcLogger * Log , CSmtpDlg * pParent , CMailMessage * Msg , 
							int Rbs = 1024 , int Wbs = 8192 );
	// Large default write buffer since there's going to be a lot puking into
	// this socket
    ~CSmtpSocket();
  	void ConnectGateway();
	BOOL IsSuccess() { return m_Message->IsOkToDelete(); }
  protected:
    // The overridden read and write functions
    virtual void lineRead();
    virtual void dataWritten();
    virtual void Connected(int error);
	virtual void Timeout();		
  private: 
  	// The private functions for parsing
  	void SmtpParse( const char * Str );
  	void CloseSession();
	// The constants
	// The data                           
	CSmtpDlg * m_Parent;
    smtpStates m_State; 
    CMailMessage * m_Message;
    CString m_LocalHostName;
    BOOL m_LinesToSend;
    BOOL m_Error;                      
    BOOL m_Batch;
    char * m_LineBuf;
    CString m_RemoteHost;
};
    


#endif
