/***********************************************************************
**
** CANIBMP.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
** It is the implementation of the CAnimatedBitmap class.
** This class responsible for animating itself in a particular
** location
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
// smtpdlg.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CSmtpDlg dialog

#ifndef _SMTPDLG_H
#define _SMTPDLG_H

#ifndef _CLIDLG_H
#include "clidlg.h"
#endif
#ifndef _MESSAGE_H
#include "message.h"
#endif                                     
#ifndef _SMTPSOCK_H
#include "smtpsock.h"
#endif

// Classes defined in this file
class CSmtpDlg;

class CSmtpDlg : public CClientDlg
{
// Construction
public:
	CSmtpDlg();	// standard constructor
	~CSmtpDlg();           
	virtual BOOL Create( CWnd * pParent );	

	BOOL IsConnected() { return m_Connected; }
	virtual void Trace( int Level , const char * Str );
	virtual void Trace( int Level , UINT nId ) { CClientDlg::Trace( Level , nId ); }
	virtual void Kick();
	virtual void Abort();
	virtual void Connected( int Error , tcSocket * Sock );
	virtual void Closed( int Error , tcSocket * Sock );
	virtual void Timeout( tcSocket * Sock );
// Dialog Data
	//{{AFX_DATA(CSmtpDlg)
	enum { IDD = IDD_SMTPCLIDLG };
	CStatic	m_Sending;
	CStatic	m_MailSent;
	CStatic	m_MailQueued;
	CStatic	m_MailFailed;
	CStatic	m_MailIcon;
	CListBox	m_ListBox;
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	// Generated message map functions
	//{{AFX_MSG(CSmtpDlg)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
    afx_msg LRESULT OnSockClose( WPARAM, LPARAM );
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()   

private:                         
	void CreateMessageList();
	void UpdateDisplay();
	void DoMessage();

	void KillSocket( CSmtpSocket * Sock );
  	// The sockets
  	CSmtpSocketList m_SockList;
  	tcLogger * m_Log;
  	CMailMessageList * m_MsgList;
  	BOOL	m_Connected;
	int		m_TotalSent;  	
};
#endif
