/***********************************************************************
**
** NNTPDLG.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
**
** The NNTP Window Class.  All the display and update for a
** nntp window.  Currently done as a toolbar window but
** could be a free floating MDI child.  But then it might
** be hard to get the cool 3d look....
**
** V1.0 - Initial Revision 01-Sep-94
** V1.1 - Fixed bug in the creation of the nntp socket where
**        it was using the local time rather than GMT
*/
// nntpdlg.cpp : implementation file
//

#include "stdafx.h"
#include "windis.h"
#include "utility.h"
#include "csocket.h"
#include "nntpsock.h"
#include "nntpdlg.h"
#include "timedlg.h"
#include "canibmp.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


static CNntpInfo LastInfo;

/////////////////////////////////////////////////////////////////////////////
// CNntpDlg dialog

CNntpDlg::CNntpDlg()
	: CClientDlg()
{
	//{{AFX_DATA_INIT(CNntpDlg)
	//}}AFX_DATA_INIT
	// Initialise our socket data
	m_Sock = NULL;         
	m_Log = AllocateLogger( "nntp" );
	SetKickTime( gConfig->GetNewsKickSeconds() );
	m_HistoryList = new CNNTPHistoryList();
}

CNntpDlg::~CNntpDlg()
{                         
	delete m_HistoryList;
	delete m_Sock;
	delete m_Log;
}
               
BOOL CNntpDlg::Create( CWnd * pParent )
{
	return CClientDlg::Create( IDD , pParent );
}
               
void CNntpDlg::DoDataExchange(CDataExchange* pDX)
{
	CClientDlg::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNntpDlg)
	DDX_Control(pDX, IDC_NEWSICON, m_NewsIcon);
	DDX_Control(pDX, IDC_DUPLICATES, m_Duplicates);
	DDX_Control(pDX, IDC_SPEED, m_Speed);
	DDX_Control(pDX, IDC_MESSAGES, m_Messages);
	DDX_Control(pDX, IDC_GROUPS, m_Groups);
	DDX_Control(pDX, IDC_NNTPLIST, m_ListBox);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CNntpDlg, CClientDlg)
	//{{AFX_MSG_MAP(CNntpDlg)
	ON_WM_CREATE()
	ON_MESSAGE( WM_SOCK_CLOSE, OnSockClose )
	ON_WM_DRAWITEM()
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNntpDlg message handlers

int CNntpDlg::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CClientDlg::OnCreate(lpCreateStruct) == -1)
		return -1;
	AfxGetApp()->DoWaitCursor( 1 );
	m_HistoryList->Init();         
	AfxGetApp()->DoWaitCursor( 0 );
	return 0;
}

// This generally kicks off the whole shebang.
void CNntpDlg::Kick()
{       
	ASSERT_VALID( this );
	CTime StartTime;               
	CString TimeHost;            
	
	// Ensure we don't get a kick
	ClearKickTime();
	// Let's get the time first
	// This will get removed on the stack.
	if( gConfig->GetTimeUseNews() )
		TimeHost = gConfig->GetNewsServer();
	else
		TimeHost = gConfig->GetTimeServer();

	AfxGetApp()->DoWaitCursor( 1 );				
	CTimeDlg TimeDlg( FALSE , TimeHost ,  this ); // we want the dialog to close
	if( TimeDlg.DoModal() == IDOK )
		StartTime = TimeDlg.GetTime();
	else
	{
	                                  
		time_t t;
		time( &t );
		StartTime = t;
	}	                         
	AfxGetApp()->DoWaitCursor( 0 );
	if( m_Sock != NULL )
	{
		Trace( 0 , IDS_TRACE_ALREADY_CONNECTED );
	}
	else
	{
		Trace( 0 , IDS_TRACE_CONNECTING );
		// Here we go.    
		// set the static info variable to be invalid so we get
		// an update
		LastInfo.ArticlesGot = LastInfo.GroupsGot = 
			LastInfo.Duplicates = LastInfo.Unavailable = 0xFFFF;
		CNntpInfo BlankInfo;
		Info( &BlankInfo );
					
		CreateSocket();
		
		if( m_Sock->Init(m_HistoryList , StartTime ) )
		{
			int rc = m_Sock->Connect( gConfig->GetNewsServer() , 119 );
			if ( rc != 0 )
			{
				SocketError( m_Sock , rc );
				KillSocket( m_Sock );
			}             
			else
				m_Sock->SetTimeout( TIMEOUT_CONNECT , TO_CONNECTING );
		}
		else
		{
				::MsgBox( MB_OK | MB_ICONSTOP , IDS_MSG_LOAD_NNTP_SETUP );
				KillSocket(m_Sock);
		}		
		// And the rest is all handled by the socket
	}
}		

void CNntpDlg::Abort()
{                                          
	Close( 0 , m_Sock );
}

// The Socket Handlers
void CNntpDlg::Trace( int Level , const char * p)
{                                 
	ASSERT( p );
	if( Level > gConfig->GetNntpTrace() )
		return;
		
	// Dump the information into the dialog
	int rc;
	if ( ( rc = m_ListBox.AddString( p ) ) == LB_ERRSPACE )
	{
		// Empty the list box now
		m_ListBox.ResetContent();
		m_ListBox.AddString( "Emptied Listbox" );
		rc = m_ListBox.AddString( p );
	}        
	m_ListBox.SetTopIndex( rc - 1); // Maybe this could be done better
}                                                                     

/*                       
  	UINT		ArticlesToGet; 	// How many articles are there to get
  	UINT		ArticlesGot;   	// How many have we got so far
  	UINT		Duplicates;		// How many duplicate articles
  	UINT		Unavailable;	// How many were unavailable
  	DWORD		ArticleBytes;	// How many bytes?
  	DWORD		CurrentBytes;	// How much in the current article?
  	DWORD 		TotalBytes;		// All the stuff received
  	UINT		GroupsGot;		// How many groups have we got so far
  	UINT		NewGroupsGot;	// How many new groups have we got
  	time_t		SessionStart;
  	time_t		NewsStart;
*/                       
void CNntpDlg::Info( CNntpInfo * Info)
{                 
	// A static buffer (for optimisation)
	// Dump the information into the dialog
	char Buffer[ 32 ]; // big enough for what I want to do
	char * Fmt = "%u/%u";
	// Groups                            
	if( LastInfo.GroupsGot != Info->GroupsGot ||
		LastInfo.NewGroupsGot != Info->NewGroupsGot )
	{
		wsprintf( Buffer , Fmt , Info->GroupsGot , Info->NewGroupsGot );
		m_Groups.SetWindowText( Buffer );
	}
	// Articles
	if( LastInfo.ArticlesGot != Info->ArticlesGot ||
		LastInfo.ArticlesToGet != Info->ArticlesToGet )
	{
		wsprintf( Buffer , Fmt , Info->ArticlesGot , Info->ArticlesToGet );
		m_Messages.SetWindowText( Buffer );
	}
	// Duplicates
	if( LastInfo.Duplicates != Info->Duplicates ||
		LastInfo.Unavailable != Info->Unavailable )
	{
		wsprintf( Buffer , Fmt , Info->Duplicates, Info->Unavailable );
		m_Duplicates.SetWindowText( Buffer ); 
	}
	// Do the speed // This is always different
	time_t Now = time(NULL);
	time_t ArticleTime = Now - Info->NewsStart;
	time_t TotalTime = Now - Info->SessionStart;
	if( ArticleTime != 0 && TotalTime != 0 )
	{
		long ArtSpeed = Info->ArticleBytes / (Now - Info->NewsStart ) ; // bytes per second
		long AllSpeed = Info->TotalBytes / (Now - Info->SessionStart ) ;   // bytes per second
		wsprintf( Buffer , "%lu/%lu" , ArtSpeed , AllSpeed );
	}
	else
		strcpy( Buffer , "na/na" );
		
	m_Speed.SetWindowText( Buffer );           
	memcpy( &LastInfo , Info , sizeof( LastInfo ) );
}
                  
// Handle the connect message                     
void CNntpDlg::Connected(int Error , tcSocket * Sock)
{           
	m_Sock->ClrTimeout();
	if( Error == 0 )
	{        
		Trace(0 , IDS_TRACE_CONNECTED );
	}
	else
	{
		Close( Error , Sock );
	}		
}

void CNntpDlg::Closed( int Error , tcSocket * Sock )
{
	Trace( 0 , IDS_TRACE_SOCKET_CLOSED_BY_SERVER  );
	Close( Error , Sock );
}

LRESULT CNntpDlg::OnSockClose(WPARAM Error , LPARAM lParam)
{       
	CNntpSocket * Sock = (CNntpSocket *)lParam;   
	if( Error != 0 )
	{
		SocketError( Sock , Error );
	}
	KillSocket( Sock );                           
	Trace( 0 , IDS_TRACE_CLOSED_CONNECTION );
	// Reset the kick time
	SetKickTime( gConfig->GetNewsKickSeconds() );
	return 0;
}

void CNntpDlg::Timeout(tcSocket * Sock )
{       
	// Ignore error            
	Trace( 0 , TimeoutGetId( Sock ) );
	Close( 0 , Sock );
}

		
// Debugging support
#ifdef _DEBUG
void CNntpDlg::AssertValid() const
{
	CClientDlg::AssertValid();                          
}

void CNntpDlg::Dump(CDumpContext& dc) const
{
	CClientDlg::Dump(dc);
}

#endif //_DEBUG


void CNntpDlg::OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct)
{
	// TODO: Add your message handler code here and/or call default
	CClientDlg::OnDrawItem(nIDCtl, lpDrawItemStruct);
}

// A utility function to create all the socket stuff
void CNntpDlg::CreateSocket()
{
	ASSERT( m_Sock == NULL );
	m_Sock = new CNntpSocket( m_Log , this );
	SetIcon( &m_NewsIcon );
	return;
}

// A utility function to close all the sockets stuff
// Only one socket so the parameter is useless
void CNntpDlg::KillSocket(tcSocket *)
{
	if( m_Sock != NULL )
	{                             
		m_Sock->ClrTimeout();
		m_Sock->Close();       
		delete m_Sock;
	}
	m_Sock = NULL;
	ClearIcon();
	RedrawWindow(); 
	return;
}                                       

void CNntpDlg::OnLButtonDown(UINT nFlags, CPoint point)
{
	// Check to see if this is in the client rectangle of
	// the icon.  If so then this is a kick.
	CRect IcoRect;
	m_NewsIcon.GetWindowRect( IcoRect );
	ClientToScreen( &point );
	if( IcoRect.PtInRect( point ) )
	{
		if( IsConnected() )
			Abort();
		else
			Kick();
	}
	else
		CClientDlg::OnLButtonDown(nFlags, point);
}

/////////////////////////////////////////////////////////////////////////////
// The history list functions
CNNTPHistoryList::CNNTPHistoryList()
{
}

CNNTPHistoryList::~CNNTPHistoryList()
{
	m_HistoryFile.Close();
}

BOOL CNNTPHistoryList::Init()
{
	char Buffer[ 256 ];                  
	m_HistoryName = GetNewsHistoryName();
	// Let's try opening the history file               
	if( !OpenOrCreate( m_HistoryFile, m_HistoryName , CFile::modeReadWrite | CFile::typeText ) )
	{
		// Now we're in the shit
		::MsgBox( MB_OK | MB_ICONSTOP , IDS_MSG_COULDNT_CREATE_HISTORY );
		return FALSE;
	}   
	else                           
	{
		// Read the history file        
		m_HistoryFile.SeekToBegin();
		while( m_HistoryFile.ReadString( Buffer , 255 ) )
		{
			if( strlen( Buffer ) < 4 ) // This is just crap really
				continue;
			// Probably need some status here
			// Nuke the cr;
			Buffer[ strlen( Buffer ) - 1 ] = '\0';
			m_GotArticles.SetAt( Buffer , NULL );
		}
		// We're going to need the history file later so 
		// seek to the end of it 
		m_HistoryFile.SeekToEnd();
	}
	return TRUE;
}	

void CNNTPHistoryList::AddHistoryEntry( const char * Str )
{
	// Add to the list
	m_GotArticles.SetAt( Str , NULL );
	m_HistoryFile.WriteString( Str );
	m_HistoryFile.WriteString( "\n" );
}
