/***********************************************************************
**
** MAINFRM.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
**
** The CMainFrame Class is implemented here.
** Most of the code is user interface stuff so it's PCoded to make
** it smaller.  Most of the handlers just send the messages
** through to the client windows.  The create method is
** pretty baroque but its based on some code from the MCF
** sources.
**
** There's also some wierdo stuff about menus so that the
** you can have a dynamic menu using MFC.  You want to be
** able to add the finger people at the end of the menu.
** 
** Finally, there's the background unbatching hook in here.
** 
** V1.0 - Initial Revision 01-Sep-94
**
*/
// mainfrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include <ctl3d.h>
#include "windis.h"
#include "utility.h"
#include "csocket.h"
#include "nntpdlg.h"                  
#include "timedlg.h"                      
#include "servdlg.h"
#include "smtpdlg.h"
#include "prefdlg.h"
#include "wunbatch.h"
#include "finwnd.h"
#include "mainfrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


// This is a cludge but I can't think of anything better here
// What happens if the number of menu items after ID_FINGER_DEFAULT
// is more than 100?  Who knows.
#define ID_FINGER_BASE  (ID_FINGER_DEFAULT + 100)
#define ID_FINGER_LAST  (ID_FINGER_DEFAULT + 107)

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_TIMER()
	ON_WM_CLOSE()
	ON_COMMAND(ID_VIEW_MAILCLIENT, OnViewMailclient)
	ON_COMMAND(ID_VIEW_NEWSCLIENT, OnViewNewsclient)
	ON_COMMAND(ID_VIEW_POP3CLIENT, OnViewPop3client)
	ON_UPDATE_COMMAND_UI(ID_VIEW_MAILCLIENT, OnUpdateViewMailclient)
	ON_UPDATE_COMMAND_UI(ID_VIEW_NEWSCLIENT, OnUpdateViewNewsclient)
	ON_UPDATE_COMMAND_UI(ID_VIEW_POP3CLIENT, OnUpdateViewPop3client)
	ON_COMMAND(ID_KICK_ALL, OnKickAll)
	ON_COMMAND(ID_KICK_MAIL, OnKickMail)
	ON_COMMAND(ID_KICK_NEWS, OnKickNews)
	ON_COMMAND(ID_KICK_POP3, OnKickPop3)
	ON_COMMAND(ID_KICK_TIME, OnKickTime)
	ON_UPDATE_COMMAND_UI(ID_KICK_ALL, OnUpdateKickAll)
	ON_UPDATE_COMMAND_UI(ID_KICK_MAIL, OnUpdateKickMail)
	ON_UPDATE_COMMAND_UI(ID_KICK_NEWS, OnUpdateKickNews)
	ON_UPDATE_COMMAND_UI(ID_KICK_POP3, OnUpdateKickPop3)
	ON_UPDATE_COMMAND_UI(ID_KICK_TIME, OnUpdateKickTime)
	ON_COMMAND(ID_FILE_DIALUP, OnFileDialup)
	ON_UPDATE_COMMAND_UI(ID_FILE_DIALUP, OnUpdateFileDialup)
	ON_COMMAND(ID_FILE_PREFERENCES, OnFilePreferences)
	ON_COMMAND(ID_FILE_SETUP, OnFileSetup)
	ON_COMMAND(ID_VIEW_SMTPSERVER, OnViewSmtpserver)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SMTPSERVER, OnUpdateViewSmtpserver)
	ON_COMMAND(ID_KICK_SMTPSERVER, OnKickServ)
	ON_UPDATE_COMMAND_UI(ID_KICK_SMTPSERVER, OnUpdateKickServ)
	ON_WM_INITMENUPOPUP()
	ON_COMMAND(ID_SERVICES_UNBATCH, OnServicesUnbatch)
	ON_UPDATE_COMMAND_UI(ID_SERVICES_UNBATCH, OnUpdateServicesUnbatch)
	ON_WM_SYSCOLORCHANGE()
	ON_COMMAND(ID_FINGER_DEFAULT, OnFingerDefault)
	ON_UPDATE_COMMAND_UI(ID_FINGER_DEFAULT, OnUpdateFingerDefault)
	ON_COMMAND(ID_FINGER_OTHER, OnFingerOther)
	ON_COMMAND(ID_FILE_SAVE_WINDOW, OnFileSaveWindow)
	ON_COMMAND(ID_SERVICES_REINDEXNEWS, OnServicesReindexnews)
	ON_UPDATE_COMMAND_UI(ID_SERVICES_REINDEXNEWS, OnUpdateServicesReindexnews)
	ON_COMMAND(ID_SERVICES_SORTGROUPLIST, OnServicesSortgrouplist)
	ON_UPDATE_COMMAND_UI(ID_SERVICES_SORTGROUPLIST, OnUpdateServicesSortgrouplist)
	ON_COMMAND(ID_FINGER_SETFONT, OnFingerSetfont)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// arrays of IDs used to initialize control bars

// toolbar buttons - IDs are command buttons
static UINT BASED_CODE buttons[] =
{
	// same order as in the bitmap 'toolbar.bmp'
	ID_FILE_SETUP,
	ID_FILE_PREFERENCES,
		ID_SEPARATOR,
	ID_EDIT_CUT,
	ID_EDIT_COPY,
	ID_EDIT_PASTE,
		ID_SEPARATOR,
	ID_FILE_PRINT,
	ID_APP_ABOUT,
	ID_CONTEXT_HELP,   
		ID_SEPARATOR,
	ID_KICK_NEWS,
	ID_KICK_MAIL,
	ID_KICK_SMTPSERVER,
	ID_KICK_TIME,
	ID_KICK_ALL,
		ID_SEPARATOR,
	ID_FINGER_DEFAULT
};

static UINT BASED_CODE indicators[] =
{
	ID_SEPARATOR,			// status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	m_Reindexer = NULL;
	m_Unbatcher = NULL;
}             

CMainFrame::~CMainFrame()
{
}

// We override PreCreateWindow to specify a different window class (WNDCLASS),
//   one with a different background and without the CS_VREDRAW/CS_HREDRAW
//   style so all the frame window's control bars will not be repainted
//   when the window is resized.
BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	ASSERT(cs.lpszClass == NULL);       // must not be specified
	cs.lpszClass = AfxRegisterWndClass(CS_DBLCLKS,
		AfxGetApp()->LoadStandardCursor(IDC_ARROW), (HBRUSH)(COLOR_WINDOW+1),
		AfxGetApp()->LoadIcon(IDR_MAINFRAME));
	return TRUE;
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
			
	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadBitmap(IDR_MAINFRAME) ||
		!m_wndToolBar.SetButtons(buttons,
		  sizeof(buttons)/sizeof(UINT)))
	{
		ASSERT( FALSE );
		return -1;		// fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		ASSERT( FALSE );
		return -1;		// fail to create
	}
                        

	m_NntpDlg.Create( this );
	if( gConfig->GetViewNews() )
		m_NntpDlg.ShowWindow( SW_SHOW );
	m_SmtpDlg.Create( this );
	if( gConfig->GetViewSmtp() )
		m_SmtpDlg.ShowWindow( SW_SHOW );
	m_ServDlg.Create( this );
	if( gConfig->GetViewServ() )
		m_ServDlg.ShowWindow( SW_SHOW );
	// the default PostNcDestroy handler will delete this object when destroyed

	// Create the timer to kick the windows
	if( SetTimer( IDT_TICK_TIMER , TICK_TIMER * 1000 , NULL ) == 0)
		::MsgBox( MB_OK | MB_ICONHAND , IDS_MSG_COUNTDOWN );
	// Set the window title too.        
	CString Title = SystemWindowTitle;
	if( gConfig->GetSocketLogging() )
		Title = Title + " Socket Logging is on";
	SetWindowText( Title );
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();                          
	m_NntpDlg.AssertValid();
	m_SmtpDlg.AssertValid();
	m_ServDlg.AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
	m_NntpDlg.Dump(dc);
	m_SmtpDlg.Dump(dc);
	m_ServDlg.Dump(dc);
}

#endif //_DEBUG

void CMainFrame::DrawProgress()
{
	m_NntpDlg.DrawProgress();
	m_SmtpDlg.DrawProgress();
	m_ServDlg.DrawProgress();
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

// This one is Time Critical
void CMainFrame::OnTimer(UINT nIDEvent)
{
	// What we do here is call each of the child window's kick
	// timer function and let them deal with the results of
	// the timer timing out
	ASSERT( nIDEvent == IDT_TICK_TIMER );
	m_NntpDlg.KickCountdown();
	m_SmtpDlg.KickCountdown();
	m_ServDlg.KickCountdown();
	
	// Finally, call the sockets' timeout tick function
	::TimeoutDoTick();
}

void CMainFrame::OnViewMailclient()                                  
{
	m_SmtpDlg.ShowWindow((m_SmtpDlg.GetStyle() & WS_VISIBLE) == 0);
	RecalcLayout();
}

void CMainFrame::OnViewNewsclient()
{
	m_NntpDlg.ShowWindow((m_NntpDlg.GetStyle() & WS_VISIBLE) == 0);
	RecalcLayout();
}

void CMainFrame::OnViewPop3client()
{                 
	::MsgBox( MB_OK | MB_ICONINFORMATION ,
			  IDS_MSG_NOT_IMPLEMENTED );
}

void CMainFrame::OnViewSmtpserver()
{
	m_ServDlg.ShowWindow((m_ServDlg.GetStyle() & WS_VISIBLE) == 0);
	RecalcLayout();
}

void CMainFrame::OnUpdateViewMailclient(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck((m_SmtpDlg.GetStyle() & WS_VISIBLE) != 0);
}

void CMainFrame::OnUpdateViewNewsclient(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck((m_NntpDlg.GetStyle() & WS_VISIBLE) != 0);
}

void CMainFrame::OnUpdateViewPop3client(CCmdUI* )
{
}

void CMainFrame::OnUpdateViewSmtpserver(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck((m_ServDlg.GetStyle() & WS_VISIBLE) != 0);
	
}

void CMainFrame::OnKickAll()
{
	if( !m_ServDlg.IsConnected() ) OnKickServ();
	if( !m_SmtpDlg.IsConnected() ) OnKickMail();	
	if( !m_NntpDlg.IsConnected() ) OnKickNews();
}

void CMainFrame::OnKickMail()
{               
	ASSERT( m_SmtpDlg.IsVisible() );
		
	if( m_SmtpDlg.IsConnected() )
	{
		if( ::MsgBox( MB_OKCANCEL | MB_ICONQUESTION ,
					  IDP_MAINFRM_CANCEL_SESSION ) == IDOK )
			m_SmtpDlg.Abort();
	}
	else
		m_SmtpDlg.Kick();	
}

void CMainFrame::OnKickNews()
{                        
	ASSERT( m_NntpDlg.IsVisible() );
		                  
	if( m_NntpDlg.IsConnected() )
	{
		if( ::MsgBox( MB_OKCANCEL | MB_ICONQUESTION ,
					  IDP_MAINFRM_CANCEL_SESSION ) == IDOK )
			m_NntpDlg.Abort();
	}
	else
		m_NntpDlg.Kick();	
}
void CMainFrame::OnKickServ()
{
	// TODO: Add your command handler code here
	ASSERT( m_ServDlg.IsVisible() );
	if( m_ServDlg.IsConnected() )
		m_ServDlg.Abort();	
	else
		m_ServDlg.Kick();
}

void CMainFrame::OnKickPop3()
{                
	AfxCheckMemory();
}

void CMainFrame::OnKickTime()
{
	// TODO: Add your command handler code here
	CTimeDlg TimeDlg( TRUE , gConfig->GetTimeServer() , this );
	TimeDlg.DoModal();
	// System time and everything is set in the dialog.
}

void CMainFrame::OnUpdateKickAll(CCmdUI*)
{
	// This doesn't need anything
}

void CMainFrame::OnUpdateKickMail(CCmdUI* pCmdUI)
{
	pCmdUI->Enable( m_SmtpDlg.IsVisible() );
	pCmdUI->SetCheck(m_SmtpDlg.IsConnected());
}

void CMainFrame::OnUpdateKickNews(CCmdUI* pCmdUI)
{
	pCmdUI->Enable( m_NntpDlg.IsVisible() );
	pCmdUI->SetCheck(m_NntpDlg.IsConnected());
}

void CMainFrame::OnUpdateKickServ(CCmdUI* pCmdUI)
{
	pCmdUI->Enable( m_ServDlg.IsVisible() );
	pCmdUI->SetCheck(m_ServDlg.IsConnected());
}

void CMainFrame::OnUpdateKickPop3(CCmdUI* )
{
}

void CMainFrame::OnUpdateKickTime(CCmdUI* )
{
}

void CMainFrame::OnFileDialup()
{
	// TODO: Add your command handler code here
	::MsgBox( MB_OK | MB_ICONINFORMATION ,
			  IDS_MSG_NOT_IMPLEMENTED );
}

void CMainFrame::OnUpdateFileDialup(CCmdUI* )
{
	// TODO: Add your command update UI handler code here
}

void CMainFrame::OnFilePreferences()
{
	CPrefDlg PrefDlg;
	if( PrefDlg.DoModal() )
		// Probably recalculate the layout based on
		// the preferences info.
		return; 	
}

void CMainFrame::OnFileSetup()
{
	// TODO: Add your command handler code here
	CSetupDlg SetupDlg;
	if( SetupDlg.DoModal() )
		// EMK do something brill;
		return;
}


void CMainFrame::OnInitMenuPopup(CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu)
{
	CMDIFrameWnd::OnInitMenuPopup(pPopupMenu, nIndex, bSysMenu);
	// Now add the finger inputs
	if( nIndex == 4 )                   
	{
		// This is our guy for fingering	
		CStringArray StrArray;
		gConfig->GetFingerNames( StrArray );
		for( UINT i = ID_FINGER_BASE ; i < ID_FINGER_LAST  ; i++ )
		{
			// Remove anything if it exists
			pPopupMenu->RemoveMenu( i , MF_BYCOMMAND ); 
			if( i - ID_FINGER_BASE > StrArray.GetSize() )
				continue;                                             
			CString Text = StrArray[ (int)(i - ID_FINGER_BASE) ];
			if( Text != FreeFingerStr)
			{
				pPopupMenu->AppendMenu( MF_STRING , i , Text );
			}
		}
	}
}

// Overridden OnCommand function to handle the finger menu
BOOL CMainFrame::OnCommand( WPARAM wParam , LPARAM lParam )
{
	if( wParam < ID_FINGER_BASE ||
		wParam > ID_FINGER_LAST )
		return CMDIFrameWnd::OnCommand( wParam , lParam );
	// Now just create a window
	// Get the text from the menu? 
	CMenu * Menu = GetMenu();
	char Buffer[ 128 ];
	Menu->GetMenuString( wParam , Buffer , 127 , MF_BYCOMMAND );
	// Remove any ampersand that might be in it.
	char * p = Buffer;
	char * q = p;
	while( *p )
	{
		if( *p == '&' )
			p++;
		else
		*q++=*p++;
	}
	*q = *p;  // Terminate string
	CFingerWnd *pFingerWnd = new CFingerWnd;
	return pFingerWnd->Create(Buffer,
      	 WS_CHILD | WS_VISIBLE | WS_OVERLAPPEDWINDOW, rectDefault, this);
	// the default PostNcDestroy handler will delete this object when destroyed
}
	
void CMainFrame::OnServicesUnbatch()
{
	// Create a CWnd Object to pass to the dialog as it's parent                      
	// Check the memory
	m_Unbatcher = new CUnbatcher();                        
	if( gConfig->GetBackgroundUnbatch() )
	{
		if( m_Unbatcher->Init() )
			return;
			// Unbatching is done in the _DoBackground routine
	}
	else
	{
		// we just want to do it all now
		if( m_Unbatcher->Init() )
		// Just keep calling the routine
		while( m_Unbatcher->UnbatchOne() )
				;

	}
	// If we get here, we want to delete the unbatcher
	delete m_Unbatcher;            
	m_Unbatcher = NULL;
}

void CMainFrame::OnUpdateServicesUnbatch(CCmdUI* pCmdUI)
{                      
	BOOL Enable;
	if( m_NntpDlg.IsConnected() )
		Enable = FALSE;
	else
		Enable = m_Unbatcher == NULL && m_Reindexer == NULL;
		
	pCmdUI->Enable( Enable );
}



void CMainFrame::OnServicesReindexnews()
{
	m_Reindexer = new CReindexer;
	m_Reindexer->Reindex();
	delete m_Reindexer;
	m_Reindexer = NULL;
}

void CMainFrame::OnUpdateServicesReindexnews(CCmdUI* pCmdUI)
{
	BOOL Enable;
	if( m_NntpDlg.IsConnected() )
		Enable = FALSE;
	else
		Enable = m_Unbatcher == NULL && m_Reindexer == NULL;
		
	pCmdUI->Enable( Enable );
}

void CMainFrame::OnSysColorChange()
{
	CMDIFrameWnd::OnSysColorChange();
	Ctl3dColorChange();
}

void CMainFrame::OnFingerDefault()
{
	CFingerWnd *pFingerWnd = new CFingerWnd;
	pFingerWnd->Create(gConfig->GetFingerDefault(),
      	 WS_CHILD | WS_VISIBLE | WS_OVERLAPPEDWINDOW, rectDefault, this);
	// the default PostNcDestroy handler will delete this object when destroyed

}

void CMainFrame::OnUpdateFingerDefault(CCmdUI* pCmdUI)
{
	if( gConfig->GetFingerDefault() == FreeFingerStr )
		pCmdUI->Enable( FALSE );
	else
		pCmdUI->Enable( TRUE );
}

void CMainFrame::OnFingerOther()
{
	// Create the finger new dialog (which will do just fine).
	CFingerNewDlg Dlg(this);
	if ( Dlg.DoModal() == IDOK )
	{
		CFingerWnd *pFingerWnd = new CFingerWnd;
		pFingerWnd->Create((const char *)Dlg.m_FingerNewEdit,
      		 WS_CHILD | WS_VISIBLE | WS_OVERLAPPEDWINDOW, rectDefault, this);
    }
	// the default PostNcDestroy handler will delete this object when destroyed
}

// Choose a font for the finger windows.
void CMainFrame::OnFingerSetfont()
{                                       
   // get current font description
   	LOGFONT lf;      
   	gConfig->GetFingerFont( &lf );
	if (lf.lfHeight == 0) // Not set
	   ::GetObject(GetStockObject(SYSTEM_FONT), sizeof(LOGFONT), &lf);

	CFontDialog dlg(&lf, CF_SCREENFONTS|CF_INITTOLOGFONTSTRUCT);
	if (dlg.DoModal() == IDOK)
	{                               
		// Set the font in the config file
		gConfig->SetFingerFont( &lf );
		// Now notify all the windows to redraw.
	}
}

/////////////////////////////////////////////////////////////////////////////
// Stuff to allow the main frame to do background processing using
// the winapps OnIdle tick
void CMainFrame::_DoBackground()
{
	if( m_Unbatcher != NULL )
	{
		if( !m_Unbatcher->UnbatchOne() )
		{
			// Last one
			delete m_Unbatcher;
			m_Unbatcher = NULL;
		}
		return;
	}
}
	
/////////////////////////////////////////////////////////////////////////////
// Helpers for saving/restoring window state

static char BASED_CODE szSection[] = "Settings";
static char BASED_CODE szWindowPos[] = "WindowPos";
static char szFormat[] = "%u,%u,%d,%d,%d,%d,%d,%d,%d,%d";

static BOOL PASCAL NEAR ReadWindowPlacement(LPWINDOWPLACEMENT pwp)
{
	CString strBuffer = AfxGetApp()->GetProfileString(szSection, szWindowPos);
	if (strBuffer.IsEmpty())
		return FALSE;

	WINDOWPLACEMENT wp;
	int nRead = sscanf(strBuffer, szFormat,
		&wp.flags, &wp.showCmd,
		&wp.ptMinPosition.x, &wp.ptMinPosition.y,
		&wp.ptMaxPosition.x, &wp.ptMaxPosition.y,
		&wp.rcNormalPosition.left, &wp.rcNormalPosition.top,
		&wp.rcNormalPosition.right, &wp.rcNormalPosition.bottom);

	if (nRead != 10)
		return FALSE;

	wp.length = sizeof wp;
	*pwp = wp;
	return TRUE;
}

static void PASCAL NEAR WriteWindowPlacement(LPWINDOWPLACEMENT pwp)
	// write a window placement to settings section of app's ini file
{
	char szBuffer[sizeof("-32767")*8 + sizeof("65535")*2];

	sprintf(szBuffer, szFormat,
		pwp->flags, pwp->showCmd,
		pwp->ptMinPosition.x, pwp->ptMinPosition.y,
		pwp->ptMaxPosition.x, pwp->ptMaxPosition.y,
		pwp->rcNormalPosition.left, pwp->rcNormalPosition.top,
		pwp->rcNormalPosition.right, pwp->rcNormalPosition.bottom);

	AfxGetApp()->WriteProfileString(szSection, szWindowPos, szBuffer);
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnFileSaveWindow()
{
	// Save the position of the window
	WINDOWPLACEMENT wp;
	wp.length = sizeof wp;
	if (GetWindowPlacement(&wp))
	{
		wp.flags = 0;
		if (IsZoomed())
			wp.flags |= WPF_RESTORETOMAXIMIZED;
		// and write it to the .INI file
		WriteWindowPlacement(&wp);
	}
	
}


void CMainFrame::InitialShowWindow(UINT nCmdShow)
{
	WINDOWPLACEMENT wp;
	if (!ReadWindowPlacement(&wp))
	{
		ShowWindow(nCmdShow);
		return;
	}
	if (nCmdShow != SW_SHOWNORMAL)
		wp.showCmd = nCmdShow;
	SetWindowPlacement(&wp);
	ShowWindow(wp.showCmd);
}

// When the main frame closes, we abort all the pending transations
// on each of the main clients
void CMainFrame::OnClose()
{
	// before it is destroyed, save the position of the window
	WINDOWPLACEMENT wp;
	wp.length = sizeof wp;
	if (GetWindowPlacement(&wp))
	{
		wp.flags = 0;
		if (IsZoomed())
			wp.flags |= WPF_RESTORETOMAXIMIZED;
		// and write it to the .INI file
		WriteWindowPlacement(&wp);
	}

	m_NntpDlg.Abort();
	m_ServDlg.Abort();
	m_SmtpDlg.Abort();
	// And kill the timers
	KillTimer( IDT_TICK_TIMER );              
	
	// Check for the existance of a batch file.
	// If it exists then ask if the user wants to unbatch it.    
	if( FileExist( GetNewsBatchFileName() ) )
	{        
		int rc = IDOK;                            
		if( !gConfig->GetUnbatchOnExit() )
			// Ask the user if they want unbatching done
			rc = ::MsgBox( MB_ICONQUESTION | MB_OKCANCEL , IDS_UNBATCH_ON_EXIT );
		if( rc == IDOK && m_Unbatcher == NULL )
		{        
			CUnbatcher * Unbatcher = new CUnbatcher();                        
			// we just want to do it all now
			if( Unbatcher->Init() )
			// Just keep calling the routine
				while( Unbatcher->UnbatchOne() ) 
					;
			// If we get here, we want to delete the unbatcher
			delete Unbatcher;            
		}
	}                
	if( m_Unbatcher != NULL )
	{
		if( IDCANCEL == ::MsgBox( MB_ICONSTOP | MB_OKCANCEL , IDS_UNBATCHING_ARE_YOU_SURE ) )
			// Don't close the frame.
			return;
	}
	CMDIFrameWnd::OnClose();
}

void CMainFrame::OnServicesSortgrouplist()
{
	CGroupSorter Sorter;
	if( Sorter.Init() )
	{
		Sorter.SortGroups();
	}
	// Memory reclaimed on exit
}

void CMainFrame::OnUpdateServicesSortgrouplist(CCmdUI* pCmdUI)
{
	// Well, if the nntp stuff is connected, we don't want to do this.
	pCmdUI->Enable( !m_NntpDlg.IsConnected() );
}
    

