// ----------------------------------------------------------------------------
// Mdulo include para SIXBRW.LIB
// (c) 1,994 Juan Miguel Sosso - Todos los derechos reservados
// ----------------------------------------------------------------------------

#xcommand DEFINE BROWSE [ <BrowseDef,...> ] ;
       => ;
          BROWSE [ <BrowseDef> ]

#xcommand BROWSE <oBrw> ;
          [ FROM <nTop>, <nLeft> TO <nBottom>, <nRight> ] ;
          [ SIZE <nAlto>, <nAncho> ] ;
          [ TITLE <cTitle> ] ;
          [ HEADSEP <cHeadSep> ] ;
          [ COLSEP <cColSep> ] ;
          [ FOOTSEP <cFootSep> ] ;
          [ ALIAS <cAlias> ] ;
          [ COLOR <cColors> ] ;
          [ <lWrap:WRAP> ] ;
       => ;
         <oBrw> := _BrwStartDef( <nTop>, <nLeft>, <nBottom>, <nRight>, <nAlto>, ;
                   <nAncho>, <cHeadSep>, <cColSep>, <cFootSep>, <(cAlias)>, ;
                   <cColors>, <cTitle>, <.lWrap.> )

#xcommand COLUMN [<cTitle>] DATA <bData> ;
                          [ FOOT <cFooter> ] ;
                          [ COLOR <cColor> ] ;
                          [ <lCenter: CENTER> ] ;
                          [ <lLock: LOCK> ] ;
       => ;
         _BrwAddItem( <(cTitle)>, <{bData}>, <cFooter>, <cColor>, <.lLock.>, ;
                      <.lCenter.> )

#xcommand ON KEY <nKey> DO <bAction> ;
       => ;
         _BrwAddKey( <nKey>, <{bAction}> )

#xcommand ON DBLCLICK DO <bAction> ;
       => ;
         _BrwSetDblClick( <{bAction}> )

#xcommand ENDBROWSE ;
       => ;
         _BrwEndDef()

#xcommand END BROWSE ;
       => ;
         _BrwEndDef()

#xcommand ACTIVATE BROWSE <oBrw>;
          [ TITLE <cTitle> ] ;
          [ MENUBAR <oMenuBar> ] ;
          [ ON IDLE <uAction> ] ;
          [ ACTION <bAction> ] ;
       => ;
         _BrwActivate( <oBrw>, <(cTitle)>, <oMenuBar>, <{uAction}>, <{bAction}> )

// ----------------------------------------------------------------------------
/// Quitar esto para SPTOOLS

#command DEFINE WINDOW <oWnd> ;
         [ FROM <nTop>, <nLeft> TO <nBottom>, <nRight> ] ;
         [ SIZE <nAlto>, <nAncho> ] ;
         [ TITLE <cTitle> ] ;
         [ COLOR <cColor> ] ;
      => ;
         <oWnd> := TWindow():New( <nTop>, <nLeft>, <nBottom>, <nRight>, ;
                   <nAlto>, <nAncho>, <cTitle>, nil, <cColor> ) ;;

#command ACTIVATE WINDOW <oWnd> ;
      => ;
         <oWnd>:Display()

#command DEACTIVATE WINDOW <oWnd>;
      => ;
         <oWnd>:Hide()

// ----------------------------------------------------------------------------

#xcommand DEFAULT <uVar1> := <uVal1> ;
               [, <uVarN> := <uValN> ] ;
       => ;
          <uVar1> := If( <uVar1> == nil, <uVal1>, <uVar1> ) ;;
          [ <uVarN> := If( <uVarN> == nil, <uValN>, <uVarN> ); ]

#xcommand SET DEFAULT ACTION TO <uAction> ;
       => ;
          SetDefAction( <{uAction}> )

// ----------------------------------------------------------------------------

#define C_KEYS     1
#define C_DBLCLICK 2
#define C_ACTION   3
#define C_TITLE    4
#define C_WRAP     5
#define C_DIFUP    6
#define C_DIFDN    7

// ----------------------------------------------------------------------------
