\ Eight Queens Problem, by Jerry Levan,  from Forth Dimensions II/1 page 6

\ NOTE: DEFINE CONSTANT IBM-COMPAT TO BE FALSE IF NOT IBM COMPATIBLE
	
\ DEFINE THE CONSTANT PRINTIT TO BE FALSE IF NO PRINTING OF RESULTS
\ IS DESIRED (FASTER FOR BENCHMARKING)

\ DEFINE THE CONSTANT VID-DELAY TO BE TRUE IF SCREEN IS SNOWY

128 MSDOS
FIND PRINTIT [IF] DROP [ELSE] TRUE CONSTANT PRINTIT [THEN]
FIND IBM-COMPAT [IF] DROP [ELSE] TRUE CONSTANT IBM-COMPAT [THEN]

IBM-COMPAT [IF] INCLUDE DISPLAY1 [THEN]

8  ARRAY A
16 ARRAY B
16 ARRAY C
8  ARRAY X

H:  FILLARRAY  ( address cells -- , fill with 1's )
    0 DO  -1 OVER !  CELL+ LOOP  DROP ;

0 A  8 FILLARRAY  
0 B 16 FILLARRAY  
0 C 16 FILLARRAY
0 X  8 FILLARRAY

2 1 IN/OUT
: SAFE  DUP A @ IF SWAP 2DUP - 7 + C @ IF + B @ EXIT THEN THEN
     2DROP 0 ;

2 0 IN/OUT
: MARK  SWAP  2DUP 2DUP - 7 + C OFF
   + B OFF   DROP  A OFF ; 

2 0 IN/OUT
: UNMARK  SWAP  2DUP 2DUP - 7 + C ON
   + B ON  DROP  A ON ;

VARIABLE TRIES
PRINTIT [IF]
0 0 IN/OUT
: PRINTSOL  ." found on try " TRIES @ 6 .R   ." : "
  8 0 DO  I X @ 1+ 5 .R LOOP  CR ;
[THEN]

1 0 IN/OUT
: TRY  8 0 DO  1 TRIES +! 
        DUP I SAFE IF DUP I MARK I OVER X !  DUP 7 <
         IF DUP 1+ TRY ( recurse )
            PRINTIT [IF] ELSE PRINTSOL [THEN]  THEN
       DUP I UNMARK THEN  LOOP  DROP ;

: MAIN IBM-COMPAT [IF] SETUP-VID  [THEN]
       0 TRIES ! ." Starting..." CR 0 TRY
      ." Done!"  CR
      IBM-COMPAT [IF] UNSETUP-VID [THEN] ;


IBM-COMPAT [IF] INCLUDE DISPLAY2 [THEN]
INCLUDE FORTHLIB
END

